/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.nontermination;

import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.NonTerminationArgument;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GeometricNonTerminationArgument
extends NonTerminationArgument
implements Serializable {
    private static final long serialVersionUID = 4606815082909883553L;
    private final Map<IProgramVar, Rational> mStateInit;
    private final Map<IProgramVar, Rational> mStateHonda;
    private final List<Map<IProgramVar, Rational>> mGEVs;
    private final List<Rational> mLambdas;
    private final List<Rational> mNus;

    public GeometricNonTerminationArgument(Map<IProgramVar, Rational> state_init, Map<IProgramVar, Rational> state_honda, List<Map<IProgramVar, Rational>> gevs, List<Rational> lambdas, List<Rational> nus) {
        assert (state_init != null);
        this.mStateInit = state_init;
        assert (state_honda != null);
        this.mStateHonda = state_honda;
        assert (gevs != null);
        this.mGEVs = gevs;
        assert (lambdas != null);
        this.mLambdas = lambdas;
        assert (nus != null);
        this.mNus = nus;
        assert (this.mGEVs.size() == lambdas.size());
        assert (this.mGEVs.size() == nus.size() + 1 || this.mGEVs.isEmpty());
    }

    public GeometricNonTerminationArgument join(GeometricNonTerminationArgument other) {
        for (IProgramVar rankVar : this.mStateInit.keySet()) {
            if (other.mStateInit.containsKey(rankVar)) assert (this.mStateInit.get(rankVar).equals((Object)other.mStateInit.get(rankVar)));
        }
        for (IProgramVar rankVar : this.mStateHonda.keySet()) {
            if (other.mStateHonda.containsKey(rankVar)) assert (this.mStateHonda.get(rankVar).equals((Object)other.mStateHonda.get(rankVar)));
        }
        HashMap<IProgramVar, Rational> stateInit = new HashMap<IProgramVar, Rational>();
        HashMap<IProgramVar, Rational> stateHonda = new HashMap<IProgramVar, Rational>();
        ArrayList<Map<IProgramVar, Rational>> gevs = new ArrayList<Map<IProgramVar, Rational>>();
        ArrayList<Rational> lambdas = new ArrayList<Rational>();
        ArrayList<Rational> nus = new ArrayList<Rational>();
        stateInit.putAll(this.mStateInit);
        stateInit.putAll(other.mStateInit);
        stateHonda.putAll(this.mStateHonda);
        stateHonda.putAll(other.mStateHonda);
        gevs.addAll(this.mGEVs);
        gevs.addAll(other.mGEVs);
        lambdas.addAll(this.mLambdas);
        lambdas.addAll(other.mLambdas);
        nus.addAll(this.mNus);
        if (!this.mGEVs.isEmpty() && !other.mGEVs.isEmpty()) {
            nus.add(Rational.ZERO);
        }
        nus.addAll(other.mNus);
        return new GeometricNonTerminationArgument(stateInit, stateHonda, gevs, lambdas, nus);
    }

    public Map<IProgramVar, Rational> getStateInit() {
        return Collections.unmodifiableMap(this.mStateInit);
    }

    public Map<IProgramVar, Rational> getStateHonda() {
        return Collections.unmodifiableMap(this.mStateHonda);
    }

    public int getNumberOfGEVs() {
        return this.mGEVs.size();
    }

    public List<Map<IProgramVar, Rational>> getGEVs() {
        ArrayList<Map<IProgramVar, Rational>> gevs = new ArrayList<Map<IProgramVar, Rational>>();
        for (Map<IProgramVar, Rational> gev : this.mGEVs) {
            gevs.add(Collections.unmodifiableMap(gev));
        }
        return Collections.unmodifiableList(gevs);
    }

    public List<Rational> getLambdas() {
        return Collections.unmodifiableList(this.mLambdas);
    }

    public List<Rational> getNus() {
        return Collections.unmodifiableList(this.mNus);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Non-Termination argument consisting of: ");
        sb.append("Initial state: ");
        sb.append(this.mStateInit);
        sb.append(" Honda state: ");
        sb.append(this.mStateHonda);
        sb.append(" Generalized eigenvectors: ");
        sb.append(this.mGEVs);
        sb.append(" Lambdas: ");
        sb.append(this.mLambdas);
        sb.append(" Nus: ");
        sb.append(this.mNus);
        return sb.toString();
    }
}

