/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.nontermination;

import de.uni_freiburg.informatik.ultimate.lassoranker.AnalysisType;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.INonTerminationAnalysisSettings;
import java.io.Serializable;

public class NonTerminationAnalysisSettings
implements Serializable,
INonTerminationAnalysisSettings {
    private static final long serialVersionUID = 4249624228131593458L;
    private final AnalysisType mAnalysis;
    private final boolean mAllowBounded;
    private final int mNumberOfGevs;
    private final boolean mNilpotentComponents;

    public NonTerminationAnalysisSettings(INonTerminationAnalysisSettings other) {
        this.mAnalysis = other.getAnalysis();
        this.mAllowBounded = other.isAllowBounded();
        this.mNumberOfGevs = other.getNumberOfGevs();
        this.mNilpotentComponents = other.isNilpotentComponents();
    }

    public void checkSanity() {
        assert (this.mNumberOfGevs >= 0);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Nontermination analysis: ");
        sb.append((Object)this.mAnalysis);
        sb.append(" Allow bounded executions: ");
        sb.append(this.mAllowBounded);
        sb.append(" Number of generalized eigenvectors: ");
        sb.append(this.mNumberOfGevs);
        sb.append(" Nilpotent components: ");
        sb.append(this.mNilpotentComponents);
        return sb.toString();
    }

    @Override
    public AnalysisType getAnalysis() {
        return this.mAnalysis;
    }

    @Override
    public boolean isAllowBounded() {
        return this.mAllowBounded;
    }

    @Override
    public int getNumberOfGevs() {
        return this.mNumberOfGevs;
    }

    @Override
    public boolean isNilpotentComponents() {
        return this.mNilpotentComponents;
    }
}

