/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.nontermination;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.lassoranker.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lassoranker.AnalysisType;
import de.uni_freiburg.informatik.ultimate.lassoranker.ArgumentSynthesizer;
import de.uni_freiburg.informatik.ultimate.lassoranker.ILassoRankerPreferences;
import de.uni_freiburg.informatik.ultimate.lassoranker.Lasso;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearTransition;
import de.uni_freiburg.informatik.ultimate.lassoranker.ModelExtractionUtils;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.GeometricNonTerminationArgument;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.NonTerminationAnalysisSettings;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.SMTPrettyPrinter;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SolverBuilder;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.DebugMessage;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class NonTerminationArgumentSynthesizer
extends ArgumentSynthesizer {
    private static final String PREFIX_INIT = "init_";
    private static final String PREFIX_HONDA = "honda_";
    private static final String PREFIX_GE_VECTOR = "gev_";
    private static final String PREFIX_AUX = "aux_";
    private static final String PREFIX_EVALUE = "lambda";
    private static final String PREFIX_NIL_POTENT = "nu";
    public static long sAuxCounter = 0L;
    private final boolean mIntegerMode;
    private final AnalysisType mAnalysisType;
    private final NonTerminationAnalysisSettings mSettings;
    private final Sort mSort;
    private GeometricNonTerminationArgument mArgument = null;
    private Script.LBool mIsSat;

    public NonTerminationArgumentSynthesizer(Lasso lasso, ILassoRankerPreferences preferences, NonTerminationAnalysisSettings settings, IUltimateServiceProvider services) throws IOException {
        super(lasso, preferences, "nonterminationTemplate", services);
        this.mSettings = new NonTerminationAnalysisSettings(settings);
        this.mLogger.info((Object)settings.toString());
        boolean bl = this.mIntegerMode = lasso.getStem().containsIntegers() || lasso.getLoop().containsIntegers();
        if (!this.mIntegerMode) {
            this.mAnalysisType = this.mSettings.getAnalysis();
            if (this.mAnalysisType.isLinear()) {
                this.mScript.setLogic(Logics.QF_LRA);
            } else {
                this.mScript.setLogic(Logics.QF_NRA);
            }
            this.mSort = SmtSortUtils.getRealSort((Script)this.mScript);
        } else {
            this.mLogger.info((Object)"Using integer mode.");
            this.mAnalysisType = this.mSettings.getAnalysis();
            if (this.mSettings.getAnalysis().isLinear()) {
                this.mScript.setLogic(Logics.QF_LIA);
            } else {
                this.mScript.setLogic(Logics.QF_NIA);
            }
            this.mSort = SmtSortUtils.getIntSort((Script)this.mScript);
        }
        assert (!this.mAnalysisType.isDisabled());
    }

    @Override
    protected Script constructScript(ILassoRankerPreferences preferences, String constraintsName) {
        SolverBuilder.SolverMode solverMode = preferences.isAnnotateTerms() ? SolverBuilder.SolverMode.External_ModelsAndUnsatCoreMode : SolverBuilder.SolverMode.External_ModelsMode;
        SolverBuilder.SolverSettings settings = preferences.getSolverConstructionSettings(solverMode, String.valueOf(preferences.getBaseNameOfDumpedScript()) + "+" + constraintsName);
        return SolverBuilder.buildAndInitializeSolver((IUltimateServiceProvider)this.mServices, (SolverBuilder.SolverSettings)settings, (String)"NonTerminationArgumentSynthesis solver ");
    }

    @Override
    protected Script.LBool doSynthesis() {
        List<Term> nus;
        assert (this.mSettings.getNumberOfGevs() >= 0);
        String sort = this.mIntegerMode ? "Int" : "Real";
        LinkedHashMap<IProgramVar, Term> vars_init = new LinkedHashMap<IProgramVar, Term>();
        LinkedHashMap<IProgramVar, Term> vars_honda = new LinkedHashMap<IProgramVar, Term>();
        ArrayList<Map<IProgramVar, Term>> vars_gevs = new ArrayList<Map<IProgramVar, Term>>(this.mSettings.getNumberOfGevs());
        ArrayList<Term> lambdas = new ArrayList<Term>(this.mSettings.getNumberOfGevs());
        for (IProgramVar var : this.mLasso.getAllRankVars()) {
            String name = SmtUtils.removeSmtQuoteCharacters((String)var.toString());
            vars_init.put(var, this.newConstant(PREFIX_INIT + name, sort));
            vars_honda.put(var, this.newConstant(PREFIX_HONDA + name, sort));
        }
        int i = 0;
        while (i < this.mSettings.getNumberOfGevs()) {
            LinkedHashMap<IProgramVar, Term> vars_gev = new LinkedHashMap<IProgramVar, Term>();
            for (IProgramVar var : this.mLasso.getAllRankVars()) {
                String name = SmtUtils.removeSmtQuoteCharacters((String)var.toString());
                vars_gev.put(var, this.newConstant(PREFIX_GE_VECTOR + name + i, sort));
            }
            vars_gevs.add(vars_gev);
            lambdas.add(this.newConstant(PREFIX_EVALUE + i, sort));
            ++i;
        }
        if (this.mSettings.getNumberOfGevs() > 0) {
            nus = new ArrayList(this.mSettings.getNumberOfGevs() - 1);
            int i2 = 0;
            while (i2 < this.mSettings.getNumberOfGevs() - 1) {
                nus.add(this.newConstant(PREFIX_NIL_POTENT + i2, sort));
                ++i2;
            }
        } else {
            nus = Collections.emptyList();
        }
        Term constraints = this.generateConstraints(vars_init, vars_honda, vars_gevs, lambdas, nus);
        this.mLogger.debug((Object)new DebugMessage("{0}", new Object[]{new SMTPrettyPrinter(constraints)}));
        this.mScript.assertTerm(constraints);
        this.mIsSat = this.mScript.checkSat();
        if (this.mIsSat == Script.LBool.SAT) {
            this.mArgument = this.extractArgument(vars_init, vars_honda, vars_gevs, lambdas, nus);
        } else if (this.mIsSat == Script.LBool.UNKNOWN) {
            this.mScript.echo(new QuotedObject("Warning solver responded UNKNOWN to the check-sat above"));
        }
        return this.mIsSat;
    }

    /*
     * WARNING - void declaration
     */
    public Term generateConstraints(Map<IProgramVar, Term> vars_init, Map<IProgramVar, Term> vars_honda, List<Map<IProgramVar, Term>> vars_gevs, List<Term> lambdas, List<Term> nus) {
        int i;
        void var17_24;
        List<Object> nu_guesses;
        List<Object> lambda_guesses;
        Term one;
        Term zero;
        this.mSettings.checkSanity();
        assert (this.mSettings.getNumberOfGevs() >= 0);
        assert (vars_gevs.size() == this.mSettings.getNumberOfGevs());
        assert (lambdas.size() == this.mSettings.getNumberOfGevs());
        int numvars = vars_gevs.isEmpty() ? 0 : vars_gevs.get(0).size();
        assert (numvars >= 0);
        Collection<IProgramVar> rankVars = this.mLasso.getAllRankVars();
        if (!this.mIntegerMode) {
            zero = this.mScript.decimal("0");
            one = this.mScript.decimal("1");
        } else {
            zero = this.mScript.numeral("0");
            one = this.mScript.numeral("1");
        }
        if (this.mAnalysisType == AnalysisType.NONLINEAR) {
            lambda_guesses = Collections.singletonList(null);
            nu_guesses = Collections.singletonList(null);
        } else {
            ArrayList<Term> l = new ArrayList<Term>();
            l.add(zero);
            l.add(one);
            nu_guesses = Collections.unmodifiableList(l);
            if (this.mAnalysisType == AnalysisType.LINEAR) {
                lambda_guesses = Collections.singletonList(one);
            } else if (this.mAnalysisType == AnalysisType.LINEAR_WITH_GUESSES) {
                Rational[] eigenvalues = this.mLasso.guessEigenvalues(false);
                lambda_guesses = new ArrayList<Object>(eigenvalues.length);
                int i2 = 0;
                while (i2 < eigenvalues.length) {
                    assert (!eigenvalues[i2].isNegative());
                    if (!this.mIntegerMode || eigenvalues[i2].isIntegral()) {
                        lambda_guesses.add(eigenvalues[i2].toTerm(this.mSort));
                    }
                    ++i2;
                }
            } else {
                assert (false);
                lambda_guesses = Collections.emptyList();
            }
        }
        Term t1 = this.mScript.term("true", new Term[0]);
        if (!this.mLasso.getStem().isTrue()) {
            LinearTransition stem = this.mLasso.getStem();
            ArrayList<Term> disjunction = new ArrayList<Term>(stem.getNumPolyhedra());
            for (List<LinearInequality> list : stem.getPolyhedra()) {
                disjunction.add(this.generateConstraint(stem, list, vars_init, vars_honda, false));
            }
            t1 = SmtUtils.or((Script)this.mScript, (Term[])disjunction.toArray(new Term[disjunction.size()]));
        }
        LinkedHashMap<IProgramVar, Term> vars_end_plus_gevs = new LinkedHashMap<IProgramVar, Term>();
        vars_end_plus_gevs.putAll(vars_honda);
        for (IProgramVar rkVar : rankVars) {
            Term[] summands = new Term[this.mSettings.getNumberOfGevs() + 1];
            summands[0] = vars_honda.get(rkVar);
            int i3 = 0;
            while (i3 < this.mSettings.getNumberOfGevs()) {
                summands[i3 + 1] = vars_gevs.get(i3).get(rkVar);
                ++i3;
            }
            Term sum = summands.length == 1 ? summands[0] : this.mScript.term("+", summands);
            vars_end_plus_gevs.put(rkVar, sum);
        }
        ArrayList vars_gevs_next = new ArrayList(this.mSettings.getNumberOfGevs());
        boolean bl = false;
        while (var17_24 < this.mSettings.getNumberOfGevs()) {
            ArrayList vars_gevs_next_i = new ArrayList(lambda_guesses.size());
            vars_gevs_next.add(vars_gevs_next_i);
            int j = 0;
            while (j < lambda_guesses.size()) {
                int k = 0;
                while (k < nu_guesses.size()) {
                    Term nu_guess;
                    Term lambda_guess = (Term)lambda_guesses.get(j);
                    if (lambda_guess == null) {
                        lambda_guess = lambdas.get((int)var17_24);
                    }
                    if ((nu_guess = (Term)nu_guesses.get(k)) == null && var17_24 < this.mSettings.getNumberOfGevs() - 1) {
                        nu_guess = nus.get((int)var17_24);
                    }
                    LinkedHashMap<IProgramVar, Term> gev_next = new LinkedHashMap<IProgramVar, Term>();
                    vars_gevs_next_i.add(gev_next);
                    for (IProgramVar rkVar : rankVars) {
                        if (this.mSettings.isNilpotentComponents() && var17_24 < this.mSettings.getNumberOfGevs() - 1) {
                            gev_next.put(rkVar, this.mScript.term("+", new Term[]{this.mScript.term("*", new Term[]{vars_gevs.get((int)var17_24).get(rkVar), lambda_guess}), this.mScript.term("*", new Term[]{vars_gevs.get((int)(var17_24 + true)).get(rkVar), nu_guess})}));
                            continue;
                        }
                        gev_next.put(rkVar, this.mScript.term("*", new Term[]{vars_gevs.get((int)var17_24).get(rkVar), lambda_guess}));
                    }
                    ++k;
                }
                ++j;
            }
            ++var17_24;
        }
        LinearTransition linearTransition = this.mLasso.getLoop();
        ArrayList<Term> disjunction = new ArrayList<Term>(linearTransition.getNumPolyhedra());
        for (List<LinearInequality> polyhedron : linearTransition.getPolyhedra()) {
            Term t_honda = this.generateConstraint(linearTransition, polyhedron, vars_honda, vars_end_plus_gevs, false);
            Term[] conjuction = new Term[this.mSettings.getNumberOfGevs() + 1];
            int i5 = 0;
            while (i5 < this.mSettings.getNumberOfGevs()) {
                Term[] inner_disjunction = new Term[lambda_guesses.size()];
                int j = 0;
                while (j < lambda_guesses.size()) {
                    Term lambda_guess = (Term)lambda_guesses.get(j);
                    Term t_gev = this.generateConstraint(linearTransition, polyhedron, vars_gevs.get(i5), (Map)((List)vars_gevs_next.get(i5)).get(j), true);
                    Term fix_lambda = lambda_guess == null ? this.mScript.term("true", new Term[0]) : this.mScript.term("=", new Term[]{lambdas.get(i5), lambda_guess});
                    inner_disjunction[j] = SmtUtils.and((Script)this.mScript, (Term[])new Term[]{t_gev, fix_lambda});
                    ++j;
                }
                conjuction[i5] = SmtUtils.or((Script)this.mScript, (Term[])inner_disjunction);
                ++i5;
            }
            conjuction[this.mSettings.getNumberOfGevs()] = t_honda;
            disjunction.add(SmtUtils.and((Script)this.mScript, (Term[])conjuction));
        }
        Term t2 = SmtUtils.or((Script)this.mScript, (Term[])disjunction.toArray(new Term[disjunction.size()]));
        ArrayList<Term> arrayList = new ArrayList<Term>(2 * this.mSettings.getNumberOfGevs());
        if (this.mSettings.isNilpotentComponents()) {
            i = 0;
            while (i < this.mSettings.getNumberOfGevs() - 1) {
                Term nu = nus.get(i);
                arrayList.add(SmtUtils.or((Script)this.mScript, (Term[])new Term[]{this.mScript.term("=", new Term[]{nu, zero}), this.mScript.term("=", new Term[]{nu, one})}));
                ++i;
            }
        } else {
            i = 0;
            while (i < this.mSettings.getNumberOfGevs() - 1) {
                Term nu = nus.get(i);
                arrayList.add(this.mScript.term("=", new Term[]{nu, zero}));
                ++i;
            }
        }
        if (this.mSettings.isAllowBounded()) {
            i = 0;
            while (i < this.mSettings.getNumberOfGevs()) {
                arrayList.add(this.mScript.term(">=", new Term[]{lambdas.get(i), zero}));
                ++i;
            }
        } else {
            disjunction = new ArrayList<Term>(this.mSettings.getNumberOfGevs() * numvars);
            int i6 = 0;
            while (i6 < this.mSettings.getNumberOfGevs()) {
                for (Term t : vars_gevs.get(i6).values()) {
                    disjunction.add(this.mScript.term("<>", new Term[]{t, zero}));
                }
                arrayList.add(this.mScript.term(">=", new Term[]{lambdas.get(i6), one}));
                ++i6;
            }
            arrayList.add(SmtUtils.or((Script)this.mScript, (Term[])disjunction.toArray(new Term[disjunction.size()])));
        }
        Term t3 = SmtUtils.and((Script)this.mScript, (Term[])arrayList.toArray(new Term[arrayList.size()]));
        this.mLogger.debug((Object)new DebugMessage("{0}", new Object[]{new SMTPrettyPrinter(t1)}));
        this.mLogger.debug((Object)new DebugMessage("{0}", new Object[]{new SMTPrettyPrinter(t2)}));
        this.mLogger.debug((Object)new DebugMessage("{0}", new Object[]{new SMTPrettyPrinter(t3)}));
        return this.mScript.term("and", new Term[]{t1, t2, t3});
    }

    private Term generateConstraint(LinearTransition transition, List<LinearInequality> polyhedron, Map<IProgramVar, Term> varsIn, Map<IProgramVar, Term> varsOut, boolean rays) {
        LinkedHashMap<Term, Term> auxVars = new LinkedHashMap<Term, Term>();
        ArrayList<Term> conjunction = new ArrayList<Term>(polyhedron.size());
        for (LinearInequality ieq : polyhedron) {
            AffineTerm a;
            ArrayList<Term> summands = new ArrayList<Term>();
            LinkedHashSet<Term> added_vars = new LinkedHashSet<Term>();
            for (Map.Entry<IProgramVar, TermVariable> entry : transition.getOutVars().entrySet()) {
                if (!varsOut.containsKey(entry.getKey())) continue;
                a = ieq.getCoefficient((Term)entry.getValue());
                summands.add(this.mScript.term("*", new Term[]{varsOut.get(entry.getKey()), this.mIntegerMode ? a.asIntTerm(this.mScript) : a.asRealTerm(this.mScript)}));
                added_vars.add((Term)entry.getValue());
            }
            for (Map.Entry<IProgramVar, TermVariable> entry : transition.getInVars().entrySet()) {
                if (added_vars.contains(entry.getValue())) {
                    conjunction.add(this.mScript.term("=", new Term[]{varsIn.get(entry.getKey()), varsOut.get(entry.getKey())}));
                    continue;
                }
                a = ieq.getCoefficient((Term)entry.getValue());
                summands.add(this.mScript.term("*", new Term[]{varsIn.get(entry.getKey()), this.mIntegerMode ? a.asIntTerm(this.mScript) : a.asRealTerm(this.mScript)}));
                added_vars.add((Term)entry.getValue());
            }
            LinkedHashSet<Term> all_vars = new LinkedHashSet<Term>(ieq.getVariables());
            all_vars.removeAll(added_vars);
            for (Term var : all_vars) {
                Term v;
                if (auxVars.containsKey(var)) {
                    v = (Term)auxVars.get(var);
                } else {
                    v = this.newConstant(PREFIX_AUX + sAuxCounter, this.mIntegerMode ? "Int" : "Real");
                    auxVars.put(var, v);
                }
                AffineTerm a2 = ieq.getCoefficient(var);
                summands.add(this.mScript.term("*", new Term[]{v, this.mIntegerMode ? a2.asIntTerm(this.mScript) : a2.asRealTerm(this.mScript)}));
                ++sAuxCounter;
            }
            if (!rays) {
                AffineTerm a3 = ieq.getConstant();
                summands.add(this.mIntegerMode ? a3.asIntTerm(this.mScript) : a3.asRealTerm(this.mScript));
            }
            conjunction.add(this.mScript.term(rays ? ">=" : ieq.getInequalitySymbol(), new Term[]{SmtUtils.sum((Script)this.mScript, (Sort)this.mSort, (Term[])summands.toArray(new Term[summands.size()])), this.mIntegerMode ? SmtUtils.constructIntValue((Script)this.mScript, (BigInteger)BigInteger.ZERO) : this.mScript.decimal("0")}));
        }
        return SmtUtils.and((Script)this.mScript, (Term[])conjunction.toArray(new Term[conjunction.size()]));
    }

    private Map<IProgramVar, Rational> extractState(Map<IProgramVar, Term> vars) throws SMTLIBException, UnsupportedOperationException, TermException {
        if (vars.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<Term, Rational> val = ModelExtractionUtils.getValuation(this.mScript, vars.values());
        LinkedHashMap<IProgramVar, Rational> state = new LinkedHashMap<IProgramVar, Rational>();
        for (Map.Entry<IProgramVar, Term> entry : vars.entrySet()) {
            assert (val.containsKey(entry.getValue()));
            state.put(entry.getKey(), val.get(entry.getValue()));
        }
        return state;
    }

    private GeometricNonTerminationArgument extractArgument(Map<IProgramVar, Term> vars_init, Map<IProgramVar, Term> vars_honda, List<Map<IProgramVar, Term>> vars_gevs, List<Term> var_lambdas, List<Term> var_nus) {
        try {
            Map<IProgramVar, Rational> state0 = this.extractState(vars_init);
            Map<IProgramVar, Rational> state1 = this.extractState(vars_honda);
            ArrayList<Map<IProgramVar, Rational>> gevs = new ArrayList<Map<IProgramVar, Rational>>(this.mSettings.getNumberOfGevs());
            Map lambda_val = !var_lambdas.isEmpty() ? this.mScript.getValue(var_lambdas.toArray(new Term[var_lambdas.size()])) : Collections.emptyMap();
            Map nu_val = !var_nus.isEmpty() ? this.mScript.getValue(var_nus.toArray(new Term[var_nus.size()])) : Collections.emptyMap();
            ArrayList<Rational> lambdas = new ArrayList<Rational>(this.mSettings.getNumberOfGevs());
            ArrayList<Rational> nus = new ArrayList<Rational>();
            int i = 0;
            while (i < this.mSettings.getNumberOfGevs()) {
                gevs.add(this.extractState(vars_gevs.get(i)));
                lambdas.add(ModelExtractionUtils.const2Rational((Term)lambda_val.get(var_lambdas.get(i))));
                if (i < this.mSettings.getNumberOfGevs() - 1) {
                    nus.add(ModelExtractionUtils.const2Rational((Term)nu_val.get(var_nus.get(i))));
                }
                ++i;
            }
            boolean has_stem = !this.mLasso.getStem().isTrue();
            return new GeometricNonTerminationArgument(has_stem ? state0 : state1, state1, gevs, lambdas, nus);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (TermException termException) {}
        return null;
    }

    public GeometricNonTerminationArgument getArgument() {
        assert (this.synthesisSuccessful());
        return this.mArgument;
    }
}

