/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.LassoPreprocessor;
import de.uni_freiburg.informatik.ultimate.lassoranker.variables.LassoPartitioneer;
import de.uni_freiburg.informatik.ultimate.lassoranker.variables.LassoUnderConstruction;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import java.util.Collection;

public class LassoPartitioneerPreprocessor
extends LassoPreprocessor {
    public static final String s_Description = "LassoPartitioneer";
    private final IUltimateServiceProvider mServices;
    private final ManagedScript mMgdScript;
    private final SmtUtils.XnfConversionTechnique mXnfConversionTechnique;

    public LassoPartitioneerPreprocessor(ManagedScript script, IUltimateServiceProvider services, SmtUtils.XnfConversionTechnique xnfConversionTechniqe) {
        this.mServices = services;
        this.mMgdScript = script;
        this.mXnfConversionTechnique = xnfConversionTechniqe;
    }

    @Override
    public Collection<LassoUnderConstruction> process(LassoUnderConstruction lasso) throws TermException {
        LassoPartitioneer lp = new LassoPartitioneer(this.mServices, this.mMgdScript, lasso, this.mXnfConversionTechnique);
        return lp.getNewLassos();
    }

    @Override
    public String getDescription() {
        return s_Description;
    }

    @Override
    public String getName() {
        return LassoPartitioneer.class.getSimpleName();
    }
}

