/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.LassoPreprocessor;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.RewriteArrays2;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays.EqualitySupportingInvariantAnalysis;
import de.uni_freiburg.informatik.ultimate.lassoranker.variables.LassoUnderConstruction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.EqualityAnalysisResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination.MapEliminationSettings;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination.MapEliminator;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class MapEliminationLassoPreprocessor
extends LassoPreprocessor {
    private static final String DESCRIPTION = "Removes maps (arrays and UFs) by introducing new variables for each relevant argument";
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final ManagedScript mManagedScript;
    private final IIcfgSymbolTable mSymbolTable;
    private final ReplacementVarFactory mReplacementVarFactory;
    private final UnmodifiableTransFormula mOriginalStem;
    private final UnmodifiableTransFormula mOriginalLoop;
    private final Set<IProgramNonOldVar> mModifiableGlobalsAtHonda;
    private final Set<Term> mArrayIndexSupportingInvariants;
    private final MapEliminationSettings mSettings;

    public MapEliminationLassoPreprocessor(IUltimateServiceProvider services, ManagedScript managedScript, IIcfgSymbolTable symbolTable, ReplacementVarFactory replacementVarFactory, UnmodifiableTransFormula originalStem, UnmodifiableTransFormula originalLoop, Set<IProgramNonOldVar> modifiableGlobalsAtHonda, Set<Term> arrayIndexSupportingInvariants, MapEliminationSettings settings) {
        this.mServices = services;
        this.mLogger = this.mServices.getLoggingService().getLogger("Library-LassoRanker");
        this.mManagedScript = managedScript;
        this.mSymbolTable = symbolTable;
        this.mReplacementVarFactory = replacementVarFactory;
        this.mOriginalStem = originalStem;
        this.mOriginalLoop = originalLoop;
        this.mModifiableGlobalsAtHonda = modifiableGlobalsAtHonda;
        this.mArrayIndexSupportingInvariants = arrayIndexSupportingInvariants;
        this.mSettings = settings;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public Collection<LassoUnderConstruction> process(LassoUnderConstruction lasso) throws TermException {
        MapEliminator elim = new MapEliminator(this.mServices, this.mLogger, this.mManagedScript, this.mSymbolTable, this.mReplacementVarFactory, Arrays.asList(lasso.getStem(), lasso.getLoop()), this.mSettings);
        EqualityAnalysisResult equalityAnalysisStem = new EqualityAnalysisResult(elim.getDoubletons());
        EqualitySupportingInvariantAnalysis esia = new EqualitySupportingInvariantAnalysis(elim.getDoubletons(), this.mSymbolTable, this.mManagedScript, this.mOriginalStem, this.mOriginalLoop, this.mModifiableGlobalsAtHonda);
        EqualityAnalysisResult equalityAnalysisLoop = esia.getEqualityAnalysisResult();
        this.mArrayIndexSupportingInvariants.addAll(equalityAnalysisLoop.constructListOfEqualities(this.mManagedScript.getScript()));
        this.mArrayIndexSupportingInvariants.addAll(equalityAnalysisLoop.constructListOfNotEquals(this.mManagedScript.getScript()));
        ModifiableTransFormula newStem = elim.eliminateMaps(lasso.getStem(), equalityAnalysisStem, equalityAnalysisLoop);
        ModifiableTransFormula newLoop = elim.eliminateMaps(lasso.getLoop(), equalityAnalysisLoop, equalityAnalysisLoop);
        LassoUnderConstruction newLasso = new LassoUnderConstruction(newStem, newLoop);
        assert (RewriteArrays2.checkStemImplication(this.mServices, this.mLogger, lasso, newLasso, this.mSymbolTable, this.mManagedScript)) : "result of RewriteArrays too strong";
        return Collections.singleton(newLasso);
    }
}

