/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.LassoPreprocessor;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays.ArrayCellRepVarConstructor;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays.ArrayCellReplacementVarInformation;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays.EqualitySupportingInvariantAnalysis;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays.TransFormulaLRWithArrayCells;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays.TransFormulaLRWithArrayInformation;
import de.uni_freiburg.informatik.ultimate.lassoranker.variables.LassoUnderConstruction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.EqualityAnalysisResult;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.Doubleton;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class RewriteArrays2
extends LassoPreprocessor {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private final SmtUtils.XnfConversionTechnique mXnfConversionTechnique;
    public static final boolean ADDITIONAL_CHECKS_IF_ASSERTIONS_ENABLED = true;
    public static final String DESCRIPTION = "Removes arrays by introducing new variables for each relevant array cell";
    static final String AUX_ARRAY = "auxArray";
    private final ManagedScript mScript;
    private final UnmodifiableTransFormula mOriginalStem;
    private final UnmodifiableTransFormula mOriginalLoop;
    private final Set<Term> mArrayIndexSupportingInvariants;
    private final Set<IProgramNonOldVar> mModifiableGlobalsAtHonda;
    private final ReplacementVarFactory mReplacementVarFactory;
    private final ManagedScript mFreshTermVariableConstructor;
    private final IIcfgSymbolTable mBoogie2Smt;
    private final boolean mOverapproximateByOmmitingDisjointIndices;

    public RewriteArrays2(boolean overapproximateByOmmitingDisjointIndices, UnmodifiableTransFormula originalStem, UnmodifiableTransFormula originalLoop, Set<IProgramNonOldVar> modifiableGlobalsAtHonda, IUltimateServiceProvider services, Set<Term> arrayIndexSupportingInvariants, IIcfgSymbolTable boogie2smt, ManagedScript mgdScript, ReplacementVarFactory ReplacementVarFactory2, SmtUtils.SimplificationTechnique simplificationTechnique, SmtUtils.XnfConversionTechnique xnfConversionTechnique) {
        this.mServices = services;
        this.mLogger = this.mServices.getLoggingService().getLogger("Library-LassoRanker");
        this.mSimplificationTechnique = simplificationTechnique;
        this.mXnfConversionTechnique = xnfConversionTechnique;
        this.mOriginalStem = originalStem;
        this.mOriginalLoop = originalLoop;
        this.mModifiableGlobalsAtHonda = modifiableGlobalsAtHonda;
        this.mArrayIndexSupportingInvariants = arrayIndexSupportingInvariants;
        this.mOverapproximateByOmmitingDisjointIndices = overapproximateByOmmitingDisjointIndices;
        this.mBoogie2Smt = boogie2smt;
        this.mScript = mgdScript;
        this.mReplacementVarFactory = ReplacementVarFactory2;
        this.mFreshTermVariableConstructor = this.mScript;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public Collection<LassoUnderConstruction> process(LassoUnderConstruction lasso) throws TermException {
        TransFormulaLRWithArrayInformation stemTfwai = new TransFormulaLRWithArrayInformation(this.mServices, lasso.getStem(), this.mReplacementVarFactory, this.mScript, this.mBoogie2Smt, null, this.mSimplificationTechnique, this.mXnfConversionTechnique);
        TransFormulaLRWithArrayInformation loopTfwai = new TransFormulaLRWithArrayInformation(this.mServices, lasso.getLoop(), this.mReplacementVarFactory, this.mScript, this.mBoogie2Smt, stemTfwai, this.mSimplificationTechnique, this.mXnfConversionTechnique);
        ArrayCellRepVarConstructor acrvc = new ArrayCellRepVarConstructor(this.mReplacementVarFactory, this.mScript.getScript(), stemTfwai, loopTfwai);
        EqualitySupportingInvariantAnalysis isia = new EqualitySupportingInvariantAnalysis(this.computeDoubletons(acrvc), this.mBoogie2Smt, this.mScript, this.mOriginalStem, this.mOriginalLoop, this.mModifiableGlobalsAtHonda);
        EqualityAnalysisResult equalityAnalysisAtHonda = isia.getEqualityAnalysisResult();
        this.mArrayIndexSupportingInvariants.addAll(equalityAnalysisAtHonda.constructListOfEqualities(this.mScript.getScript()));
        this.mArrayIndexSupportingInvariants.addAll(equalityAnalysisAtHonda.constructListOfNotEquals(this.mScript.getScript()));
        TransFormulaLRWithArrayCells stem = new TransFormulaLRWithArrayCells(this.mServices, this.mReplacementVarFactory, this.mScript, stemTfwai, equalityAnalysisAtHonda, this.mBoogie2Smt, null, true, true, this.mSimplificationTechnique, this.mXnfConversionTechnique);
        TransFormulaLRWithArrayCells loop = new TransFormulaLRWithArrayCells(this.mServices, this.mReplacementVarFactory, this.mScript, loopTfwai, equalityAnalysisAtHonda, this.mBoogie2Smt, acrvc, true, false, this.mSimplificationTechnique, this.mXnfConversionTechnique);
        LassoUnderConstruction newLasso = new LassoUnderConstruction(stem.getResult(), loop.getResult());
        assert (RewriteArrays2.checkStemImplication(this.mServices, this.mLogger, lasso, newLasso, this.mBoogie2Smt, this.mScript)) : "result of RewriteArrays too strong";
        return Collections.singleton(newLasso);
    }

    private Set<Doubleton<Term>> computeDoubletons(ArrayCellRepVarConstructor arrayCellRepVarConstructor) {
        NestedMap2<TermVariable, ArrayIndex, ArrayCellReplacementVarInformation> array2index2repVar = arrayCellRepVarConstructor.getArrayRepresentative2IndexRepresentative2ReplacementVar();
        LinkedHashSet<Doubleton<Term>> result = new LinkedHashSet<Doubleton<Term>>();
        for (TermVariable array : array2index2repVar.keySet()) {
            Set allIndices = array2index2repVar.get((Object)array).keySet();
            ArrayIndex[] allIndicesArr = allIndices.toArray(new ArrayIndex[allIndices.size()]);
            int i = 0;
            while (i < allIndicesArr.length) {
                int j = i + 1;
                while (j < allIndicesArr.length) {
                    ArrayIndex fstIndex = allIndicesArr[i];
                    ArrayIndex sndIndex = allIndicesArr[j];
                    assert (fstIndex.size() == sndIndex.size());
                    int k = 0;
                    while (k < fstIndex.size()) {
                        Doubleton doubleton = new Doubleton((Object)((Term)fstIndex.get(k)), (Object)((Term)sndIndex.get(k)));
                        result.add((Doubleton<Term>)doubleton);
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return result;
    }

    public static boolean checkStemImplication(IUltimateServiceProvider services, ILogger logger, LassoUnderConstruction oldLasso, LassoUnderConstruction newLasso, IIcfgSymbolTable boogie2smt, ManagedScript script) {
        Script.LBool implies = ModifiableTransFormulaUtils.implies((IUltimateServiceProvider)services, (ILogger)logger, (ModifiableTransFormula)oldLasso.getStem(), (ModifiableTransFormula)newLasso.getStem(), (ManagedScript)script, (IIcfgSymbolTable)boogie2smt);
        if (implies != Script.LBool.SAT && implies != Script.LBool.UNSAT) {
            logger.warn((Object)("result of RewriteArrays check is " + implies));
        }
        assert (implies != Script.LBool.SAT) : "result of RewriteArrays too strong";
        return implies != Script.LBool.SAT;
    }
}

