/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TransitionPreprocessor;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.LassoPreprocessor;
import de.uni_freiburg.informatik.ultimate.lassoranker.variables.LassoUnderConstruction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import java.util.Collection;
import java.util.Collections;

public class StemAndLoopPreprocessor
extends LassoPreprocessor {
    private final ManagedScript mMgdScript;
    private final TransitionPreprocessor mTransitionPreprocessor;

    public StemAndLoopPreprocessor(ManagedScript mgdScript, TransitionPreprocessor transitionPreProcessor) {
        this.mMgdScript = mgdScript;
        this.mTransitionPreprocessor = transitionPreProcessor;
    }

    @Override
    public String getDescription() {
        return this.mTransitionPreprocessor.getDescription();
    }

    @Override
    public String getName() {
        return this.mTransitionPreprocessor.getClass().getSimpleName();
    }

    @Override
    public Collection<LassoUnderConstruction> process(LassoUnderConstruction lasso) throws TermException {
        ModifiableTransFormula newStem = this.mTransitionPreprocessor.process(this.mMgdScript, lasso.getStem());
        assert (this.mTransitionPreprocessor.checkSoundness(this.mMgdScript.getScript(), lasso.getStem(), newStem)) : "Soundness check failed for preprocessor " + this.getClass().getSimpleName();
        ModifiableTransFormula newLoop = this.mTransitionPreprocessor.process(this.mMgdScript, lasso.getLoop());
        LassoUnderConstruction newLasso = new LassoUnderConstruction(newStem, newLoop);
        assert (this.mTransitionPreprocessor.checkSoundness(this.mMgdScript.getScript(), lasso.getLoop(), newLoop)) : "Soundness check failed for preprocessor " + this.getClass().getSimpleName();
        return Collections.singleton(newLasso);
    }
}

