/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.IReplacementVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.HashMap;
import java.util.Map;

public class ArrayCellReplacementVarInformation {
    private final TermVariable mArrayInstance;
    private final TermVariable mArrayRepresentative;
    private final ArrayIndex mIndex;
    private final ArrayIndex mIndexRepresentative;
    private final VarType mVarType;
    private final ModifiableTransFormula mTransFormulaLR;
    private IReplacementVarOrConst mReplacementVar;

    public ArrayCellReplacementVarInformation(TermVariable arrayInstance, TermVariable arrayRepresentative, ArrayIndex index, ArrayIndex indexRepresentative, VarType varType, ModifiableTransFormula transFormulaLR) {
        this.mArrayInstance = arrayInstance;
        this.mArrayRepresentative = arrayRepresentative;
        this.mIndex = index;
        this.mIndexRepresentative = indexRepresentative;
        this.mVarType = varType;
        this.mTransFormulaLR = transFormulaLR;
    }

    public TermVariable getArrayInstance() {
        return this.mArrayInstance;
    }

    public TermVariable getArrayRepresentative() {
        return this.mArrayRepresentative;
    }

    public ArrayIndex getIndex() {
        return this.mIndex;
    }

    public ArrayIndex getIndexRepresentative() {
        return this.mIndexRepresentative;
    }

    public VarType getVarType() {
        return this.mVarType;
    }

    public IReplacementVarOrConst getReplacementVar() {
        return this.mReplacementVar;
    }

    public void setReplacementVar(IReplacementVarOrConst replacementVar) {
        this.mReplacementVar = replacementVar;
    }

    public Map<TermVariable, IProgramVar> termVariableToRankVarMappingForIndex() {
        HashMap<TermVariable, IProgramVar> result = new HashMap<TermVariable, IProgramVar>();
        for (Term entry : this.mIndex) {
            TermVariable[] termVariableArray = entry.getFreeVars();
            int n = termVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                TermVariable tv = termVariableArray[n2];
                IProgramVar inVar = (IProgramVar)this.mTransFormulaLR.getInVarsReverseMapping().get(tv);
                if (inVar != null) {
                    result.put(tv, inVar);
                } else {
                    IProgramVar outVar = (IProgramVar)this.mTransFormulaLR.getOutVarsReverseMapping().get(tv);
                    if (outVar != null) {
                        result.put(tv, outVar);
                    } else {
                        throw new AssertionError((Object)"must be an auxVar!?! rare case, not yet implemented");
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    public IProgramVar getArrayRankVar() {
        IProgramVar result = (IProgramVar)this.mTransFormulaLR.getInVarsReverseMapping().get(this.mArrayInstance);
        if (result == null) {
            result = (IProgramVar)this.mTransFormulaLR.getOutVarsReverseMapping().get(this.mArrayInstance);
        }
        if (result == null) {
            throw new AssertionError((Object)"unknown array cell");
        }
        return result;
    }

    public static enum VarType {
        InVar,
        OutVar;

    }
}

