/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays.ArrayCellReplacementVarInformation;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays.TransFormulaLRWithArrayCells;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays.TransFormulaLRWithArrayInformation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.IReplacementVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.IReplacementVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSort;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CellVariableBuilder {
    private final Map<TermVariable, Map<ArrayIndex, TermVariable>> mArrayInstance2Index2CellVariable;
    private final Map<Term, Map<ArrayIndex, IReplacementVarOrConst>> mArray2Index2RepVar;
    private final Set<TermVariable> mAuxVars = new HashSet<TermVariable>();
    private final ModifiableTransFormula mTransFormula;
    private final TransFormulaLRWithArrayInformation tflrwai;
    private final TransFormulaLRWithArrayCells tflrwac;
    private final ReplacementVarFactory mReplacementVarFactory;
    private final ILogger mLogger;
    private final HashRelation<Term, ArrayIndex> mFirstGeneration2Indices;
    private final NestedMap2<TermVariable, ArrayIndex, ArrayCellReplacementVarInformation> mArrayCellInVars;
    private final NestedMap2<TermVariable, ArrayIndex, ArrayCellReplacementVarInformation> mArrayCellOutVars;

    public CellVariableBuilder(ModifiableTransFormula tf, TransFormulaLRWithArrayCells tflrwac, ReplacementVarFactory replacementVarFactory, ILogger logger, HashRelation<Term, ArrayIndex> firstGeneration2Indices, NestedMap2<TermVariable, ArrayIndex, ArrayCellReplacementVarInformation> arrayCellInVars, NestedMap2<TermVariable, ArrayIndex, ArrayCellReplacementVarInformation> arrayCellOutVars) {
        this.mReplacementVarFactory = replacementVarFactory;
        this.mLogger = logger;
        this.mTransFormula = tf;
        this.mFirstGeneration2Indices = firstGeneration2Indices;
        this.tflrwac = tflrwac;
        this.tflrwai = tflrwac.getTransFormulaLRWithArrayInformation();
        this.mArrayInstance2Index2CellVariable = new HashMap<TermVariable, Map<ArrayIndex, TermVariable>>();
        this.mArray2Index2RepVar = new HashMap<Term, Map<ArrayIndex, IReplacementVarOrConst>>();
        this.mArrayCellInVars = arrayCellInVars;
        this.mArrayCellOutVars = arrayCellOutVars;
        this.dotSomething();
    }

    private String getArrayCellName(TermVariable array, List<Term> index) {
        return "arrayCell_" + SmtUtils.removeSmtQuoteCharacters((String)array.toString()) + SmtUtils.removeSmtQuoteCharacters((String)index.toString());
    }

    public void dotSomething() {
        for (TermVariable firstGeneration : this.tflrwai.getArrayFirstGeneration2Instances().getDomain()) {
            for (TermVariable instance : this.tflrwai.getArrayFirstGeneration2Instances().getImage((Object)firstGeneration)) {
                Set indicesOfFirstGeneration;
                Map<ArrayIndex, TermVariable> index2ArrayCellTv = this.mArrayInstance2Index2CellVariable.get(instance);
                if (index2ArrayCellTv == null) {
                    index2ArrayCellTv = new HashMap<ArrayIndex, TermVariable>();
                    this.mArrayInstance2Index2CellVariable.put(instance, index2ArrayCellTv);
                }
                if ((indicesOfFirstGeneration = this.mFirstGeneration2Indices.getImage((Object)firstGeneration)) == null) {
                    this.mLogger.info((Object)("Array " + firstGeneration + " is never accessed"));
                    continue;
                }
                for (ArrayIndex index : indicesOfFirstGeneration) {
                    TermVariable tv = index2ArrayCellTv.get(index);
                    if (tv == null) {
                        tv = this.constructTermVariable(instance, (List<Term>)index);
                        index2ArrayCellTv.put(index, tv);
                    }
                    boolean isInVarCell = this.isInVarCell(instance, (List<Term>)index);
                    boolean isOutVarCell = this.isOutVarCell(instance, (List<Term>)index);
                    if (isInVarCell || isOutVarCell) {
                        IReplacementVar rv;
                        IReplacementVarOrConst varOrConst;
                        TermVariable arrayRepresentative = (TermVariable)ModifiableTransFormulaUtils.getDefinition((ModifiableTransFormula)this.mTransFormula, (TermVariable)instance);
                        ArrayIndex indexRepresentative = this.tflrwac.getOrConstructIndexRepresentative(index);
                        if (isInVarCell) {
                            varOrConst = ((ArrayCellReplacementVarInformation)this.mArrayCellInVars.get((Object)arrayRepresentative, (Object)indexRepresentative)).getReplacementVar();
                            if (varOrConst instanceof ReplacementConst) {
                                throw new UnsupportedOperationException("not yet implemented");
                            }
                            if (varOrConst instanceof IReplacementVar) {
                                rv = (IReplacementVar)varOrConst;
                                TermVariable inVar = (TermVariable)this.mTransFormula.getInVars().get(rv);
                                if (inVar == null) {
                                    this.mTransFormula.addInVar((IProgramVar)rv, tv);
                                } else {
                                    this.addToAuxVars(tv);
                                }
                            } else {
                                throw new AssertionError((Object)("illegal type " + varOrConst.getClass()));
                            }
                        }
                        if (!isOutVarCell) continue;
                        varOrConst = ((ArrayCellReplacementVarInformation)this.mArrayCellOutVars.get((Object)arrayRepresentative, (Object)indexRepresentative)).getReplacementVar();
                        if (varOrConst instanceof ReplacementConst) {
                            throw new UnsupportedOperationException("not yet implemented");
                        }
                        if (varOrConst instanceof IReplacementVar) {
                            rv = (IReplacementVar)varOrConst;
                            TermVariable outVar = (TermVariable)this.mTransFormula.getOutVars().get(rv);
                            if (outVar == null) {
                                this.mTransFormula.addOutVar((IProgramVar)rv, tv);
                                continue;
                            }
                            this.addToAuxVars(tv);
                            continue;
                        }
                        throw new AssertionError((Object)("illegal type " + varOrConst.getClass()));
                    }
                    this.addToAuxVars(tv);
                }
            }
        }
    }

    private void addToAuxVars(TermVariable tv) {
        this.mAuxVars.add(tv);
    }

    private TermVariable constructTermVariable(TermVariable instance, List<Term> index) {
        Sort arraySort = instance.getSort();
        assert (arraySort.isArraySort());
        MultiDimensionalSort mdias = new MultiDimensionalSort(arraySort);
        assert (mdias.getDimension() == index.size());
        Sort valueSort = mdias.getArrayValueSort();
        String name = this.getArrayCellName(instance, index);
        TermVariable tv = this.mReplacementVarFactory.getOrConstructAuxVar(name, valueSort);
        return tv;
    }

    private boolean isInVarCell(TermVariable arrayInstance, List<Term> index) {
        if (ModifiableTransFormulaUtils.isInVar((TermVariable)arrayInstance, (ModifiableTransFormula)this.mTransFormula)) {
            return ModifiableTransFormulaUtils.allVariablesAreInVars(index, (ModifiableTransFormula)this.mTransFormula);
        }
        return false;
    }

    private boolean isOutVarCell(TermVariable arrayInstance, List<Term> index) {
        if (ModifiableTransFormulaUtils.isOutVar((TermVariable)arrayInstance, (ModifiableTransFormula)this.mTransFormula)) {
            return ModifiableTransFormulaUtils.allVariablesAreOutVars(index, (ModifiableTransFormula)this.mTransFormula);
        }
        return false;
    }

    public Map<TermVariable, Map<ArrayIndex, TermVariable>> getArrayInstance2Index2CellVariable() {
        return this.mArrayInstance2Index2CellVariable;
    }

    public Set<TermVariable> getAuxVars() {
        return this.mAuxVars;
    }
}

