/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.EqualityAnalysisResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermVarsProc;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.Doubleton;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class EqualitySupportingInvariantAnalysis {
    private final Set<Doubleton<Term>> mAllDoubletons;
    private final ManagedScript mScript;
    private final IIcfgSymbolTable mSymbolTable;
    private final Set<Doubleton<Term>> mDistinctDoubletons = new HashSet<Doubleton<Term>>();
    private final Set<Doubleton<Term>> mEqualDoubletons = new HashSet<Doubleton<Term>>();
    private final Set<Doubleton<Term>> mUnknownDoubletons = new HashSet<Doubleton<Term>>();
    private final UnmodifiableTransFormula mOriginalStem;
    private final UnmodifiableTransFormula mOriginalLoop;
    private final Set<IProgramNonOldVar> mModifiableGlobalsAtStart;
    private final Set<IProgramNonOldVar> mModifiableGlobalsAtHonda;

    public EqualitySupportingInvariantAnalysis(Set<Doubleton<Term>> doubletons, IIcfgSymbolTable symbolTable, ManagedScript mgdScript, UnmodifiableTransFormula originalStem, UnmodifiableTransFormula originalLoop, Set<IProgramNonOldVar> modifiableGlobalsAtHonda) {
        this.mSymbolTable = symbolTable;
        this.mScript = mgdScript;
        this.mOriginalStem = originalStem;
        this.mOriginalLoop = originalLoop;
        this.mModifiableGlobalsAtStart = Collections.emptySet();
        this.mModifiableGlobalsAtHonda = modifiableGlobalsAtHonda;
        this.mAllDoubletons = doubletons;
        this.mScript.getScript().echo(new QuotedObject("starting equality analysis for array indices of a lasso"));
        for (Doubleton<Term> doubleton : this.mAllDoubletons) {
            boolean equalityIsInvariant = this.isInVariant(doubleton, true);
            if (equalityIsInvariant) {
                this.addEqualDoubleton(doubleton);
                continue;
            }
            boolean notEqualIsInvariant = this.isInVariant(doubleton, false);
            if (notEqualIsInvariant) {
                this.addDistinctDoubleton(doubleton);
                continue;
            }
            this.addUnknownDoubleton(doubleton);
        }
        this.mScript.getScript().echo(new QuotedObject("finished equality analysis for array indices of a lasso"));
    }

    private void addDistinctDoubleton(Doubleton<Term> doubleton) {
        this.mDistinctDoubletons.add(doubleton);
    }

    private void addEqualDoubleton(Doubleton<Term> doubleton) {
        this.mEqualDoubletons.add(doubleton);
    }

    private void addUnknownDoubleton(Doubleton<Term> doubleton) {
        this.mUnknownDoubletons.add(doubleton);
    }

    private boolean isInVariant(Doubleton<Term> definingDoubleton, boolean checkEquals) {
        Term invariantCandidateTerm = checkEquals ? EqualityAnalysisResult.equalTerm((Script)this.mScript.getScript(), definingDoubleton) : EqualityAnalysisResult.notEqualTerm((Script)this.mScript.getScript(), definingDoubleton);
        TermVarsProc tvp = TermVarsProc.computeTermVarsProc((Term)invariantCandidateTerm, (ManagedScript)this.mScript, (IIcfgSymbolTable)this.mSymbolTable);
        BasicPredicate invariantCandidate = new BasicPredicate(0, tvp.getProcedures(), tvp.getFormula(), tvp.getVars(), tvp.getClosedFormula());
        Set emptyVarSet = Collections.emptySet();
        BasicPredicate truePredicate = new BasicPredicate(0, new String[0], this.mScript.getScript().term("true", new Term[0]), emptyVarSet, this.mScript.getScript().term("true", new Term[0]));
        Script.LBool impliedByStem = PredicateUtils.isInductiveHelper((Script)this.mScript.getScript(), (IPredicate)truePredicate, (IPredicate)invariantCandidate, (UnmodifiableTransFormula)this.mOriginalStem, this.mModifiableGlobalsAtStart, this.mModifiableGlobalsAtHonda);
        if (impliedByStem == Script.LBool.UNSAT) {
            Script.LBool invariantOfLoop = PredicateUtils.isInductiveHelper((Script)this.mScript.getScript(), (IPredicate)invariantCandidate, (IPredicate)invariantCandidate, (UnmodifiableTransFormula)this.mOriginalLoop, this.mModifiableGlobalsAtHonda, this.mModifiableGlobalsAtHonda);
            return invariantOfLoop == Script.LBool.UNSAT;
        }
        return false;
    }

    public EqualityAnalysisResult getEqualityAnalysisResult() {
        return new EqualityAnalysisResult(Collections.unmodifiableSet(this.mEqualDoubletons), Collections.unmodifiableSet(this.mDistinctDoubletons), Collections.unmodifiableSet(this.mUnknownDoubletons));
    }
}

