/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.IndexAnalysisResult;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayEquality;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayUpdate;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EquivalentCells {
    private final Script mScript;
    private final UnionFind<TermVariable> mUnionFind;
    private final Map<TermVariable, TermVariable> mRepresentative;
    private final Term mInOutEqauality;
    private final ModifiableTransFormula mTransFormula;
    private final Map<TermVariable, Map<ArrayIndex, TermVariable>> mArrayInstance2Index2CellVariable;
    private final IndexAnalysisResult mIndexAnalyzer;

    public EquivalentCells(Script script, ModifiableTransFormula tf, List<ArrayEquality> arrayEqualities, List<ArrayUpdate> arrayUpdates, IndexAnalysisResult indexAnalyzer, Map<TermVariable, Map<ArrayIndex, TermVariable>> arrayInstance2Index2CellVariable) {
        this.mScript = script;
        this.mTransFormula = tf;
        this.mIndexAnalyzer = indexAnalyzer;
        this.mArrayInstance2Index2CellVariable = arrayInstance2Index2CellVariable;
        this.mUnionFind = new UnionFind();
        this.addArrayIndexConstraints(this.mUnionFind);
        this.addArrayEqualityConstraints(this.mUnionFind, arrayEqualities);
        this.addArrayUpdateConstraints(this.mUnionFind, arrayUpdates);
        this.mRepresentative = this.computeRepresentatives(this.mUnionFind);
        this.mInOutEqauality = this.computeInOutEqualities(this.mUnionFind);
    }

    private void addArrayUpdateConstraints(UnionFind<TermVariable> uf, List<ArrayUpdate> arrayUpdates) {
        for (ArrayUpdate au : arrayUpdates) {
            ArrayIndex updateIndex = au.getIndex();
            Map<ArrayIndex, TermVariable> newInstance2Index2CellVariable = this.mArrayInstance2Index2CellVariable.get(au.getNewArray());
            Map<ArrayIndex, TermVariable> oldInstance2Index2CellVariable = this.mArrayInstance2Index2CellVariable.get(au.getOldArray());
            for (ArrayIndex index : newInstance2Index2CellVariable.keySet()) {
                TermVariable newCellVariable = newInstance2Index2CellVariable.get(index);
                TermVariable oldCellVariable = oldInstance2Index2CellVariable.get(index);
                EqualityStatus indexEquality = this.mIndexAnalyzer.isEqual((List)index, (List)updateIndex);
                switch (indexEquality) {
                    case EQUAL: {
                        break;
                    }
                    case NOT_EQUAL: {
                        uf.union((Object)newCellVariable, (Object)oldCellVariable);
                        break;
                    }
                }
            }
        }
    }

    private void addArrayIndexConstraints(UnionFind<TermVariable> uf) {
        for (Map.Entry<TermVariable, Map<ArrayIndex, TermVariable>> entry : this.mArrayInstance2Index2CellVariable.entrySet()) {
            Map<ArrayIndex, TermVariable> indices2values = entry.getValue();
            List[] indices = new List[indices2values.size()];
            TermVariable[] values = new TermVariable[indices2values.size()];
            int offset = 0;
            for (Map.Entry<ArrayIndex, TermVariable> index2value : indices2values.entrySet()) {
                TermVariable value;
                indices[offset] = (List)index2value.getKey();
                values[offset] = value = index2value.getValue();
                uf.makeEquivalenceClass((Object)value);
                ++offset;
            }
            int i = 0;
            while (i < indices2values.size()) {
                int j = 0;
                while (j < i) {
                    List index1 = indices[i];
                    List index2 = indices[j];
                    if (this.mIndexAnalyzer.isEqual(index1, index2) == EqualityStatus.EQUAL) {
                        TermVariable value1 = values[i];
                        TermVariable value2 = values[j];
                        uf.union((Object)value1, (Object)value2);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void addArrayEqualityConstraints(UnionFind<TermVariable> uf, List<ArrayEquality> arrayEqualities) {
        for (ArrayEquality ae : arrayEqualities) {
            Map<ArrayIndex, TermVariable> lhsInstance2Index2CellVariable = this.mArrayInstance2Index2CellVariable.get(ae.getLhsTermVariable());
            Map<ArrayIndex, TermVariable> rhsInstance2Index2CellVariable = this.mArrayInstance2Index2CellVariable.get(ae.getRhsTermVariable());
            if (lhsInstance2Index2CellVariable == null) {
                // empty if block
            }
            for (List list : lhsInstance2Index2CellVariable.keySet()) {
                TermVariable lhsCellVariable = lhsInstance2Index2CellVariable.get(list);
                assert (lhsCellVariable != null) : "no cell variable for " + list;
                TermVariable rhsCellVariable = rhsInstance2Index2CellVariable.get(list);
                assert (rhsCellVariable != null) : "no cell variable for " + list;
                uf.union((Object)lhsCellVariable, (Object)rhsCellVariable);
            }
        }
    }

    private Term computeInOutEqualities(UnionFind<TermVariable> unionFind) {
        ArrayList<Term> conjuncts = new ArrayList<Term>();
        for (TermVariable representative : unionFind.getAllRepresentatives()) {
            ArrayList<TermVariable> equalInOutVars = new ArrayList<TermVariable>();
            for (TermVariable member : unionFind.getEquivalenceClassMembers((Object)representative)) {
                if (!ModifiableTransFormulaUtils.isInVar((TermVariable)member, (ModifiableTransFormula)this.mTransFormula) && !ModifiableTransFormulaUtils.isOutVar((TermVariable)member, (ModifiableTransFormula)this.mTransFormula)) continue;
                equalInOutVars.add(member);
            }
            if (equalInOutVars.size() <= 1) continue;
            Term equality = this.mScript.term("=", equalInOutVars.toArray(new Term[equalInOutVars.size()]));
            Term binarized = SmtUtils.binarize((Script)this.mScript, (ApplicationTerm)((ApplicationTerm)equality));
            conjuncts.add(binarized);
        }
        return SmtUtils.and((Script)this.mScript, (Term[])conjuncts.toArray(new Term[conjuncts.size()]));
    }

    private Map<TermVariable, TermVariable> computeRepresentatives(UnionFind<TermVariable> uf) {
        HashMap<TermVariable, TermVariable> result = new HashMap<TermVariable, TermVariable>();
        for (TermVariable ufRepresentative : uf.getAllRepresentatives()) {
            TermVariable inoutRepresentative = this.computeInOutRepresentative(uf, ufRepresentative);
            result.put(ufRepresentative, inoutRepresentative);
        }
        return result;
    }

    private TermVariable computeInOutRepresentative(UnionFind<TermVariable> uf, TermVariable ufRepresentative) {
        ImmutableSet eq = uf.getEquivalenceClassMembers((Object)ufRepresentative);
        for (TermVariable member : eq) {
            if (!ModifiableTransFormulaUtils.isInVar((TermVariable)member, (ModifiableTransFormula)this.mTransFormula) && !ModifiableTransFormulaUtils.isOutVar((TermVariable)member, (ModifiableTransFormula)this.mTransFormula)) continue;
            return member;
        }
        return ufRepresentative;
    }

    public Term getInOutEqauality() {
        return this.mInOutEqauality;
    }

    public TermVariable getInOutRepresentative(TermVariable arrayCell) {
        TermVariable ufRepresentative = (TermVariable)this.mUnionFind.find((Object)arrayCell);
        return this.mRepresentative.get(ufRepresentative);
    }
}

