/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.PureSubstitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayUpdate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalStore;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.MultiElementCounter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SingleUpdateNormalFormTransformer {
    static final String s_AuxArray = "auxArray";
    private final List<ArrayUpdate> mArrayUpdates;
    private List<Term> mRemainderTerms;
    private Map<Term, Term> mStore2TermVariable;
    private final Script mScript;
    private final FreshAuxVarGenerator mFreshAuxVarGenerator;

    public SingleUpdateNormalFormTransformer(Term input, Script script, FreshAuxVarGenerator freshAuxVarGenerator) {
        this.mScript = script;
        this.mFreshAuxVarGenerator = freshAuxVarGenerator;
        this.mArrayUpdates = new ArrayList<ArrayUpdate>();
        Term[] conjuncts = SmtUtils.getConjuncts((Term)input);
        ArrayUpdate.ArrayUpdateExtractor aue = new ArrayUpdate.ArrayUpdateExtractor(false, true, conjuncts);
        this.mRemainderTerms = aue.getRemainingTerms();
        this.mArrayUpdates.addAll(aue.getArrayUpdates());
        this.mStore2TermVariable = aue.getStore2TermVariable();
        while (true) {
            if (!this.mStore2TermVariable.isEmpty()) {
                this.processNewArrayUpdates();
                continue;
            }
            MultiDimensionalStore mdStore = this.extractStore(this.mArrayUpdates, this.mRemainderTerms);
            if (mdStore == null) break;
            this.processNewStore(mdStore);
        }
        assert (this.mStore2TermVariable.isEmpty());
    }

    private void processNewStore(MultiDimensionalStore mdStore) {
        Term oldArray = mdStore.getArray();
        TermVariable auxArray = this.mFreshAuxVarGenerator.constructFreshCopy(oldArray);
        assert (this.mStore2TermVariable.isEmpty());
        this.mStore2TermVariable = Collections.singletonMap(mdStore.getStoreTerm(), auxArray);
        Term newUpdate = this.mScript.term("=", new Term[]{auxArray, mdStore.getStoreTerm()});
        ArrayUpdate.ArrayUpdateExtractor aue = new ArrayUpdate.ArrayUpdateExtractor(false, true, new Term[]{newUpdate});
        assert (aue.getArrayUpdates().size() == 1);
        this.mArrayUpdates.add((ArrayUpdate)aue.getArrayUpdates().get(0));
    }

    private MultiDimensionalStore extractStore(List<ArrayUpdate> arrayUpdates, List<Term> remainderTerms) {
        List mdStores;
        for (ArrayUpdate au : arrayUpdates) {
            for (Term entry : au.getIndex()) {
                List mdStores2 = MultiDimensionalStore.extractArrayStoresDeep((Term)entry);
                if (!mdStores2.isEmpty()) {
                    throw new AssertionError((Object)"not yet implemented");
                }
            }
            mdStores = MultiDimensionalStore.extractArrayStoresDeep((Term)au.getValue());
            if (!mdStores.isEmpty()) {
                throw new AssertionError((Object)"not yet implemented");
            }
        }
        for (Term term : remainderTerms) {
            mdStores = MultiDimensionalStore.extractArrayStoresDeep((Term)term);
            if (mdStores.isEmpty()) continue;
            return (MultiDimensionalStore)mdStores.get(0);
        }
        return null;
    }

    private void processNewArrayUpdates() {
        PureSubstitution subst = new PureSubstitution(this.mScript, this.mStore2TermVariable);
        for (ArrayUpdate au : this.mArrayUpdates) {
            for (Term entry : au.getIndex()) {
                Term newEntry = subst.transform(entry);
                if (newEntry != entry) {
                    throw new AssertionError((Object)"not yet implemented");
                }
            }
            Term newValue = subst.transform(au.getValue());
            if (newValue != au.getValue()) {
                throw new AssertionError((Object)"not yet implemented");
            }
        }
        ArrayList<Term> newRemainderTerms = new ArrayList<Term>();
        HashMap<Term, Term> newStore2TermVariable = new HashMap<Term, Term>();
        for (Term term : this.mRemainderTerms) {
            Term newTerm = subst.transform(term);
            ArrayUpdate.ArrayUpdateExtractor aue = new ArrayUpdate.ArrayUpdateExtractor(false, true, new Term[]{newTerm});
            assert (aue.getArrayUpdates().size() == 0 || aue.getArrayUpdates().size() == 1);
            if (aue.getArrayUpdates().isEmpty()) {
                newRemainderTerms.add(newTerm);
                continue;
            }
            this.mArrayUpdates.addAll(aue.getArrayUpdates());
            newStore2TermVariable.putAll(aue.getStore2TermVariable());
        }
        this.mRemainderTerms = newRemainderTerms;
        this.mStore2TermVariable = newStore2TermVariable;
    }

    private MultiDimensionalStore getNonUpdateStore(Term term) {
        Term[] conjuncts = SmtUtils.getConjuncts((Term)term);
        ArrayUpdate.ArrayUpdateExtractor aue = new ArrayUpdate.ArrayUpdateExtractor(false, true, conjuncts);
        Term remainder = SmtUtils.and((Script)this.mScript, (Term[])aue.getRemainingTerms().toArray(new Term[0]));
        remainder = new PureSubstitution(this.mScript, aue.getStore2TermVariable()).transform(remainder);
        List mdStores = MultiDimensionalStore.extractArrayStoresDeep((Term)remainder);
        if (mdStores.isEmpty()) {
            return null;
        }
        return (MultiDimensionalStore)mdStores.get(0);
    }

    public List<ArrayUpdate> getArrayUpdates() {
        return Collections.unmodifiableList(this.mArrayUpdates);
    }

    public Term getRemainderTerm() {
        return SmtUtils.and((Script)this.mScript, (Term[])this.mRemainderTerms.toArray(new Term[this.mRemainderTerms.size()]));
    }

    public Set<TermVariable> getAuxVars() {
        return this.mFreshAuxVarGenerator.getAuxVars();
    }

    public static class FreshAuxVarGenerator {
        private final Map<TermVariable, Term> mFreshCopyToOriginal = new HashMap<TermVariable, Term>();
        private final MultiElementCounter<Term> mFreshCopyCounter = new MultiElementCounter();
        private final ReplacementVarFactory mReplacementVarFactory;

        public FreshAuxVarGenerator(ReplacementVarFactory replacementVarFactory) {
            this.mReplacementVarFactory = replacementVarFactory;
        }

        TermVariable constructFreshCopy(Term term) {
            Term original = this.mFreshCopyToOriginal.get(term);
            if (original == null) {
                original = term;
            }
            Integer numberOfFreshCopy = this.mFreshCopyCounter.increment((Object)original);
            String nameOfFreshCopy = String.valueOf(SmtUtils.removeSmtQuoteCharacters((String)original.toString())) + SingleUpdateNormalFormTransformer.s_AuxArray + numberOfFreshCopy;
            TermVariable freshCopy = this.mReplacementVarFactory.getOrConstructAuxVar(nameOfFreshCopy, term.getSort());
            this.mFreshCopyToOriginal.put(freshCopy, original);
            return freshCopy;
        }

        public Set<TermVariable> getAuxVars() {
            return this.mFreshCopyToOriginal.keySet();
        }
    }
}

