/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays.ArrayCellRepVarConstructor;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays.ArrayCellReplacementVarInformation;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays.CellVariableBuilder;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays.EquivalentCells;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays.TransFormulaLRWithArrayInformation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.EqualityAnalysisResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.IndexAnalysisResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.IndexAnalyzer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ApplicationTermFinder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.PureSubstitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayUpdate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TransFormulaLRWithArrayCells {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private final SmtUtils.XnfConversionTechnique mXnfConversionTechnique;
    static final String s_AuxArray = "auxArray";
    private final ManagedScript mScript;
    private final NestedMap2<TermVariable, ArrayIndex, ArrayCellReplacementVarInformation> mForeignReplacementVars = new NestedMap2();
    private final HashRelation<TermVariable, ArrayIndex> mForeignIndices = new HashRelation();
    private final TransFormulaLRWithArrayInformation tflrwai;
    private final ModifiableTransFormula mResult;
    private final ReplacementVarFactory mReplacementVarFactory;
    private final Map<TermVariable, Map<ArrayIndex, TermVariable>> mArrayInstance2Index2CellVariable;
    private final EquivalentCells[] mEquivalentCells;
    private final boolean mOverapproximateByOmmitingDisjointIndices;
    private final HashRelation<Term, ArrayIndex> mFirstGeneration2Indices;
    private final IndexAnalysisResult mIndexAnalysisResult;
    private final NestedMap2<TermVariable, ArrayIndex, ArrayCellReplacementVarInformation> mArrayCellInVars;
    private NestedMap2<TermVariable, ArrayIndex, ArrayCellReplacementVarInformation> mArrayCellOutVars;
    private final Map<List<Term>, ArrayIndex> mIndexInstance2IndexRepresentative = new HashMap<List<Term>, ArrayIndex>();
    private final boolean mConsiderOnlyIndicesThatOccurInFormula = true;
    private final Set<TermVariable> mVariablesThatOccurInFormula;

    private Set<TermVariable> computeVarsThatOccurInFormula() {
        HashSet<TermVariable> varsInFormula = new HashSet<TermVariable>();
        varsInFormula.addAll(Arrays.asList(this.tflrwai.getTransFormulaLR().getFormula().getFreeVars()));
        varsInFormula.addAll(Arrays.asList(SmtUtils.and((Script)this.mScript.getScript(), (Collection)this.mIndexAnalysisResult.constructListOfEqualities(this.mScript.getScript())).getFreeVars()));
        if (!this.mOverapproximateByOmmitingDisjointIndices) {
            varsInFormula.addAll(Arrays.asList(SmtUtils.and((Script)this.mScript.getScript(), (Collection)this.mIndexAnalysisResult.constructListOfNotEquals(this.mScript.getScript())).getFreeVars()));
        }
        return varsInFormula;
    }

    public TransFormulaLRWithArrayCells(IUltimateServiceProvider services, ReplacementVarFactory replacementVarFactory, ManagedScript script, TransFormulaLRWithArrayInformation tflrwai, EqualityAnalysisResult equalityAnalysisAtHonda, IIcfgSymbolTable boogie2smt, ArrayCellRepVarConstructor acrvc, boolean moverapproximateByOmmitingDisjointIndices, boolean isStem, SmtUtils.SimplificationTechnique simplificationTechnique, SmtUtils.XnfConversionTechnique xnfConversionTechnique) {
        EqualityAnalysisResult invariantEqualitiesBefore;
        this.mServices = services;
        this.mLogger = this.mServices.getLoggingService().getLogger("Library-LassoRanker");
        this.mSimplificationTechnique = simplificationTechnique;
        this.mXnfConversionTechnique = xnfConversionTechnique;
        this.mOverapproximateByOmmitingDisjointIndices = moverapproximateByOmmitingDisjointIndices;
        this.tflrwai = tflrwai;
        this.mScript = script;
        this.mReplacementVarFactory = replacementVarFactory;
        if (!this.tflrwai.containsArrays()) {
            this.mResult = this.tflrwai.getTransFormulaLR();
            this.mVariablesThatOccurInFormula = null;
            this.mEquivalentCells = null;
            this.mArrayInstance2Index2CellVariable = null;
            this.mFirstGeneration2Indices = null;
            this.mIndexAnalysisResult = null;
            this.mArrayCellInVars = null;
            return;
        }
        this.mResult = new ModifiableTransFormula(tflrwai.getTransFormulaLR());
        this.mFirstGeneration2Indices = new HashRelation();
        this.mFirstGeneration2Indices.addAll(tflrwai.getArrayFirstGeneration2Indices());
        this.mArrayCellInVars = new NestedMap2();
        this.mArrayCellInVars.addAll(tflrwai.getArrayCellInVars());
        this.mArrayCellInVars.addAll(this.mForeignReplacementVars);
        this.mArrayCellOutVars = new NestedMap2();
        this.mArrayCellOutVars.addAll(tflrwai.getArrayCellOutVars());
        this.mArrayCellOutVars.addAll(this.mForeignReplacementVars);
        this.doSomething();
        if (isStem) {
            Set emptySet = Collections.emptySet();
            invariantEqualitiesBefore = new EqualityAnalysisResult(emptySet, emptySet, emptySet);
        } else {
            invariantEqualitiesBefore = equalityAnalysisAtHonda;
        }
        EqualityAnalysisResult invariantEqualitiesAfter = equalityAnalysisAtHonda;
        IndexAnalyzer ia = new IndexAnalyzer(this.mResult.getFormula(), this.mFirstGeneration2Indices, boogie2smt, this.mResult, invariantEqualitiesBefore, invariantEqualitiesAfter, this.mLogger, script);
        this.mIndexAnalysisResult = ia.getResult();
        CellVariableBuilder cvb = new CellVariableBuilder(this.mResult, this, replacementVarFactory, this.mLogger, this.mFirstGeneration2Indices, this.mArrayCellInVars, this.mArrayCellOutVars);
        this.mVariablesThatOccurInFormula = this.computeVarsThatOccurInFormula();
        this.mArrayInstance2Index2CellVariable = cvb.getArrayInstance2Index2CellVariable();
        this.mEquivalentCells = new EquivalentCells[tflrwai.numberOfDisjuncts()];
        int i = 0;
        while (i < tflrwai.numberOfDisjuncts()) {
            this.mEquivalentCells[i] = new EquivalentCells(this.mScript.getScript(), this.mResult, tflrwai.getArrayEqualities().get(i), tflrwai.getArrayUpdates().get(i), this.mIndexAnalysisResult, this.mArrayInstance2Index2CellVariable);
            ++i;
        }
        PureSubstitution[] mSelect2CellVariable = new PureSubstitution[tflrwai.numberOfDisjuncts()];
        int i2 = 0;
        while (i2 < tflrwai.numberOfDisjuncts()) {
            mSelect2CellVariable[i2] = this.constructIndex2CellVariableSubstitution(this.mEquivalentCells[i2], i2);
            ++i2;
        }
        Term[] arrayEqualityConstraints = new Term[tflrwai.numberOfDisjuncts()];
        int i3 = 0;
        while (i3 < tflrwai.numberOfDisjuncts()) {
            arrayEqualityConstraints[i3] = this.mEquivalentCells[i3].getInOutEqauality();
            ++i3;
        }
        Term[] indexValueConstraints = new Term[tflrwai.numberOfDisjuncts()];
        int i4 = 0;
        while (i4 < tflrwai.numberOfDisjuncts()) {
            indexValueConstraints[i4] = this.buildIndexValueConstraints(mSelect2CellVariable[i4], this.mEquivalentCells[i4]);
            ++i4;
        }
        Term[] arrayUpdateConstraints = new Term[tflrwai.numberOfDisjuncts()];
        int i5 = 0;
        while (i5 < tflrwai.numberOfDisjuncts()) {
            arrayUpdateConstraints[i5] = this.buildArrayUpdateConstraints(tflrwai.getArrayUpdates().get(i5), mSelect2CellVariable[i5], this.mEquivalentCells[i5]);
            ++i5;
        }
        Term[] disjunctsWithUpdateConstraints = new Term[tflrwai.numberOfDisjuncts()];
        int i6 = 0;
        while (i6 < disjunctsWithUpdateConstraints.length) {
            Term[] conjuncts;
            Term removedSelect = mSelect2CellVariable[i6].transform(tflrwai.getSunnf()[i6]);
            if (this.mOverapproximateByOmmitingDisjointIndices) {
                conjuncts = new Term[5];
            } else {
                conjuncts = new Term[6];
                conjuncts[5] = SmtUtils.and((Script)this.mScript.getScript(), (Collection)this.mIndexAnalysisResult.constructListOfNotEquals(this.mScript.getScript()));
            }
            conjuncts[0] = removedSelect;
            conjuncts[1] = indexValueConstraints[i6];
            conjuncts[2] = arrayUpdateConstraints[i6];
            conjuncts[3] = arrayEqualityConstraints[i6];
            conjuncts[4] = mSelect2CellVariable[i6].transform(SmtUtils.and((Script)this.mScript.getScript(), (Collection)this.mIndexAnalysisResult.constructListOfEqualities(this.mScript.getScript())));
            disjunctsWithUpdateConstraints[i6] = mSelect2CellVariable[i6].transform(SmtUtils.and((Script)this.mScript.getScript(), (Term[])conjuncts));
            ++i6;
        }
        Term resultDisjuntion = SmtUtils.or((Script)this.mScript.getScript(), (Term[])disjunctsWithUpdateConstraints);
        HashSet<TermVariable> auxVars = new HashSet<TermVariable>(cvb.getAuxVars());
        Term result = PartialQuantifierElimination.elim((ManagedScript)this.mScript, (int)0, auxVars, (Term)resultDisjuntion, (IUltimateServiceProvider)this.mServices, (ILogger)this.mLogger, (SmtUtils.SimplificationTechnique)this.mSimplificationTechnique, (SmtUtils.XnfConversionTechnique)this.mXnfConversionTechnique);
        assert (SmtUtils.isArrayFree((Term)result)) : "Result contains still arrays!";
        result = SmtUtils.simplify((ManagedScript)this.mScript, (Term)result, (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)this.mSimplificationTechnique);
        this.removeArrayInOutVars();
        this.mResult.setFormula(result);
        this.mResult.addAuxVars(auxVars);
    }

    private void removeArrayInOutVars() {
        ArrayList<IProgramVar> toRemove = new ArrayList<IProgramVar>();
        toRemove.addAll(this.filterArrays(this.mResult.getInVars().keySet()));
        for (IProgramVar rv : toRemove) {
            this.mResult.removeInVar(rv);
        }
        toRemove = new ArrayList();
        toRemove.addAll(this.filterArrays(this.mResult.getOutVars().keySet()));
        for (IProgramVar rv : toRemove) {
            this.mResult.removeOutVar(rv);
        }
    }

    private Collection<IProgramVar> filterArrays(Set<IProgramVar> keySet) {
        ArrayList<IProgramVar> result = new ArrayList<IProgramVar>();
        for (IProgramVar rv : keySet) {
            Sort sort = ReplacementVarUtils.getDefinition((IProgramVar)rv).getSort();
            if (!sort.isArraySort()) continue;
            result.add(rv);
        }
        return result;
    }

    public ArrayIndex getOrConstructIndexRepresentative(ArrayIndex indexInstance) {
        ArrayIndex indexRepresentative = this.mIndexInstance2IndexRepresentative.get(indexInstance);
        if (indexRepresentative == null) {
            indexRepresentative = new ArrayIndex(ModifiableTransFormulaUtils.translateTermVariablesToDefinitions((ManagedScript)this.mScript, (ModifiableTransFormula)this.mResult, (List)indexInstance));
            this.mIndexInstance2IndexRepresentative.put((List<Term>)indexInstance, indexRepresentative);
        }
        return indexRepresentative;
    }

    public TransFormulaLRWithArrayInformation getTransFormulaLRWithArrayInformation() {
        return this.tflrwai;
    }

    public void doSomething() {
        for (Triple triple : this.mForeignReplacementVars.entrySet()) {
            ArrayCellReplacementVarInformation acrvi = (ArrayCellReplacementVarInformation)triple.getThird();
            assert (acrvi.getArrayRepresentative().equals(triple.getFirst()));
            assert (acrvi.getIndexRepresentative().equals(triple.getSecond()));
            Collection<IProgramVar> rankVarsOccurringInIndex = acrvi.termVariableToRankVarMappingForIndex().values();
            for (IProgramVar rv : rankVarsOccurringInIndex) {
                if (this.rankVarOccursInThisTransformula(rv, this.mResult)) continue;
                this.addRankVar(rv);
                throw new AssertionError((Object)"case may not occur any more");
            }
            TermVariable translatedArray = (TermVariable)this.tflrwai.getTransFormulaLR().getInVars().get(acrvi.getArrayRankVar());
            ArrayIndex translatedIndex = this.translateIndex(acrvi.getIndex(), acrvi.termVariableToRankVarMappingForIndex());
            this.mFirstGeneration2Indices.addPair((Object)translatedArray, (Object)translatedIndex);
        }
    }

    private ArrayIndex translateIndex(ArrayIndex index, Map<TermVariable, IProgramVar> termVariableToRankVarMappingForIndex) {
        ArrayList<Term> translatedIndex = new ArrayList<Term>();
        for (Term entry : index) {
            Term translatedEntry = this.translateIndexEntry(entry, termVariableToRankVarMappingForIndex);
            translatedIndex.add(translatedEntry);
        }
        return new ArrayIndex(translatedIndex);
    }

    private Term translateIndexEntry(Term entry, Map<TermVariable, IProgramVar> termVariableToRankVarMappingForIndex) {
        HashMap<TermVariable, TermVariable> substitutionMapping = new HashMap<TermVariable, TermVariable>();
        TermVariable[] termVariableArray = entry.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable originalTv = termVariableArray[n2];
            IProgramVar rv = termVariableToRankVarMappingForIndex.get(originalTv);
            TermVariable newTv = (TermVariable)this.mResult.getInVars().get(rv);
            substitutionMapping.put(originalTv, newTv);
            ++n2;
        }
        Term renamedEntry = Substitution.apply((ManagedScript)this.mScript, substitutionMapping, (Term)entry);
        return renamedEntry;
    }

    private void addRankVar(IProgramVar rv) {
        String name = SmtUtils.removeSmtQuoteCharacters((String)(String.valueOf(rv.getGloballyUniqueId()) + "_InOut"));
        Sort sort = ReplacementVarUtils.getDefinition((IProgramVar)rv).getSort();
        TermVariable tv = this.mReplacementVarFactory.getOrConstructAuxVar(name, sort);
        this.mResult.addInVar(rv, tv);
        this.mResult.addOutVar(rv, tv);
    }

    private boolean rankVarOccursInThisTransformula(IProgramVar rv, ModifiableTransFormula transFormulaLR) {
        Term inVar = (Term)transFormulaLR.getInVars().get(rv);
        Term outVar = (Term)transFormulaLR.getOutVars().get(rv);
        if (inVar == null && outVar == null) {
            return false;
        }
        if (inVar != null && outVar != null) {
            return true;
        }
        throw new AssertionError((Object)(rv + " occurs only as inVar or only as outVar"));
    }

    private boolean arrayOccursInThisTransFormulaAsInvar(TermVariable array) {
        return this.tflrwai.getArrayCellInVars().keySet().contains(array);
    }

    private boolean arrayCellOccursInThisTransFormula(TermVariable array, List<Term> index) {
        return this.tflrwai.getArrayCellInVars().get((Object)array).containsKey(index);
    }

    private Term buildArrayEqualityConstraints(TermVariable oldArray, TermVariable newArray) {
        Map<ArrayIndex, TermVariable> newInstance2Index2CellVariable = this.mArrayInstance2Index2CellVariable.get(newArray);
        Map<ArrayIndex, TermVariable> oldInstance2Index2CellVariable = this.mArrayInstance2Index2CellVariable.get(oldArray);
        if (newInstance2Index2CellVariable == null && oldInstance2Index2CellVariable == null) {
            return this.mScript.getScript().term("true", new Term[0]);
        }
        Term[] conjuncts = new Term[newInstance2Index2CellVariable.keySet().size()];
        int offset = 0;
        for (List list : newInstance2Index2CellVariable.keySet()) {
            Term newCellVariable = (Term)newInstance2Index2CellVariable.get(list);
            Term oldCellVariable = (Term)oldInstance2Index2CellVariable.get(list);
            conjuncts[offset] = SmtUtils.binaryEquality((Script)this.mScript.getScript(), (Term)oldCellVariable, (Term)newCellVariable);
            ++offset;
        }
        return SmtUtils.and((Script)this.mScript.getScript(), (Term[])conjuncts);
    }

    private Term buildArrayUpdateConstraints(List<ArrayUpdate> arrayUpdates, PureSubstitution select2CellVariable, EquivalentCells equivalentCells) {
        Term[] conjuncts = new Term[arrayUpdates.size()];
        int offset = 0;
        for (ArrayUpdate au : arrayUpdates) {
            conjuncts[offset] = this.buildArrayUpdateConstraints(au.getNewArray(), (TermVariable)au.getOldArray(), au.getIndex(), au.getValue(), select2CellVariable, equivalentCells);
            ++offset;
        }
        Term result = SmtUtils.and((Script)this.mScript.getScript(), (Term[])conjuncts);
        assert (new ApplicationTermFinder("select", true).findMatchingSubterms(result).isEmpty()) : "contains select terms";
        return result;
    }

    private Term buildArrayUpdateConstraints(TermVariable newArray, TermVariable oldArray, ArrayIndex updateIndex, Term data, PureSubstitution select2CellVariable, EquivalentCells equivalentCells) {
        data = select2CellVariable.transform(data);
        Map<ArrayIndex, TermVariable> newInstance2Index2CellVariable = this.mArrayInstance2Index2CellVariable.get(newArray);
        Map<ArrayIndex, TermVariable> oldInstance2Index2CellVariable = this.mArrayInstance2Index2CellVariable.get(oldArray);
        newInstance2Index2CellVariable = this.filterNonOccurring(newInstance2Index2CellVariable);
        oldInstance2Index2CellVariable = this.filterNonOccurring(oldInstance2Index2CellVariable);
        Term[] conjuncts = new Term[newInstance2Index2CellVariable.keySet().size()];
        int offset = 0;
        for (ArrayIndex index : newInstance2Index2CellVariable.keySet()) {
            TermVariable newCellVariable = newInstance2Index2CellVariable.get(index);
            newCellVariable = equivalentCells.getInOutRepresentative(newCellVariable);
            TermVariable oldCellVariable = oldInstance2Index2CellVariable.get(index);
            oldCellVariable = equivalentCells.getInOutRepresentative(oldCellVariable);
            Term indexIsUpdateIndex = this.pairwiseEqualityExploitDoubletons(index, updateIndex, select2CellVariable);
            Term newDataIsUpdateData = SmtUtils.binaryEquality((Script)this.mScript.getScript(), (Term)newCellVariable, (Term)data);
            Term newDateIsOldData = SmtUtils.binaryEquality((Script)this.mScript.getScript(), (Term)newCellVariable, (Term)oldCellVariable);
            Term indexIsNotUpdateIndex = SmtUtils.not((Script)this.mScript.getScript(), (Term)indexIsUpdateIndex);
            Term indexIsUpdateIndexImpliesUpdateData = SmtUtils.or((Script)this.mScript.getScript(), (Term[])new Term[]{indexIsNotUpdateIndex, newDataIsUpdateData});
            Term indexIsNotUpdateIndexImpliesOldData = SmtUtils.or((Script)this.mScript.getScript(), (Term[])new Term[]{indexIsUpdateIndex, newDateIsOldData});
            conjuncts[offset] = SmtUtils.and((Script)this.mScript.getScript(), (Term[])new Term[]{indexIsUpdateIndexImpliesUpdateData, indexIsNotUpdateIndexImpliesOldData});
            ++offset;
        }
        return SmtUtils.and((Script)this.mScript.getScript(), (Term[])conjuncts);
    }

    private Map<ArrayIndex, TermVariable> filterNonOccurring(Map<ArrayIndex, TermVariable> newInstance2Index2CellVariable) {
        HashMap<ArrayIndex, TermVariable> result = new HashMap<ArrayIndex, TermVariable>();
        for (Map.Entry<ArrayIndex, TermVariable> entry : newInstance2Index2CellVariable.entrySet()) {
            if (!entry.getKey().freeVarsAreSubset(this.mVariablesThatOccurInFormula)) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private Term buildIndexValueConstraints(PureSubstitution select2CellVariable, EquivalentCells equivalentCells) {
        Term[] conjuncts = new Term[this.mArrayInstance2Index2CellVariable.size()];
        int offset = 0;
        for (Map.Entry<TermVariable, Map<ArrayIndex, TermVariable>> entry : this.mArrayInstance2Index2CellVariable.entrySet()) {
            Map<ArrayIndex, TermVariable> indices2values = entry.getValue();
            indices2values = this.filterNonOccurring(indices2values);
            conjuncts[offset] = this.buildIndexValueConstraints(indices2values, select2CellVariable, equivalentCells);
            ++offset;
        }
        return SmtUtils.and((Script)this.mScript.getScript(), (Term[])conjuncts);
    }

    private Term buildIndexValueConstraints(Map<ArrayIndex, TermVariable> indices2values, PureSubstitution select2CellVariable, EquivalentCells equivalentCells) {
        ArrayIndex[] indices = new ArrayIndex[indices2values.size()];
        TermVariable[] values = new TermVariable[indices2values.size()];
        int offset = 0;
        for (Map.Entry<ArrayIndex, TermVariable> index2value : indices2values.entrySet()) {
            indices[offset] = index2value.getKey();
            values[offset] = index2value.getValue();
            ++offset;
        }
        int numberOfPairs = indices2values.size() * (indices2values.size() - 1) / 2;
        Term[] conjuncts = new Term[numberOfPairs];
        int k = 0;
        int i = 0;
        while (i < indices2values.size()) {
            int j = 0;
            while (j < i) {
                ArrayIndex index1 = indices[i];
                ArrayIndex index2 = indices[j];
                TermVariable value1 = values[i];
                TermVariable value2 = values[j];
                TermVariable value1Representative = equivalentCells.getInOutRepresentative(value1);
                TermVariable value2Representative = equivalentCells.getInOutRepresentative(value2);
                conjuncts[k] = this.indexEqualityImpliesValueEquality(index1, index2, (Term)value1Representative, (Term)value2Representative, select2CellVariable);
                ++k;
                ++j;
            }
            ++i;
        }
        Term result = SmtUtils.and((Script)this.mScript.getScript(), (Term[])conjuncts);
        return result;
    }

    private Term indexEqualityImpliesValueEquality(ArrayIndex index1, ArrayIndex index2, Term value1, Term value2, PureSubstitution select2CellVariable) {
        Term indexEquality = this.pairwiseEqualityExploitDoubletons(index1, index2, select2CellVariable);
        Term valueEquality = SmtUtils.binaryEquality((Script)this.mScript.getScript(), (Term)value1, (Term)value2);
        return SmtUtils.or((Script)this.mScript.getScript(), (Term[])new Term[]{SmtUtils.not((Script)this.mScript.getScript(), (Term)indexEquality), valueEquality});
    }

    Term pairwiseEqualityExploitDoubletons(ArrayIndex index1, ArrayIndex index2, PureSubstitution select2CellVariable) {
        assert (index1.size() == index2.size());
        Term[] conjuncts = new Term[index1.size()];
        int i = 0;
        while (i < index1.size()) {
            Term snd;
            Term fst = index1.get(i);
            if (fst == (snd = index2.get(i)) || this.mIndexAnalysisResult.isEqualDoubleton(fst, snd)) {
                conjuncts[i] = this.mScript.getScript().term("true", new Term[0]);
            } else if (this.mIndexAnalysisResult.isDistinctDoubleton(fst, snd)) {
                conjuncts[i] = this.mScript.getScript().term("false", new Term[0]);
            } else if (this.mIndexAnalysisResult.isUnknownDoubleton(fst, snd) || this.mIndexAnalysisResult.isIgnoredDoubleton(fst, snd)) {
                Term fstSubst = select2CellVariable.transform(fst);
                Term sndSubst = select2CellVariable.transform(snd);
                conjuncts[i] = SmtUtils.binaryEquality((Script)this.mScript.getScript(), (Term)fstSubst, (Term)sndSubst);
            } else {
                throw new AssertionError((Object)"unknown doubleton");
            }
            ++i;
        }
        return SmtUtils.and((Script)this.mScript.getScript(), (Term[])conjuncts);
    }

    private PureSubstitution constructIndex2CellVariableSubstitution(EquivalentCells ec, int i) {
        TermVariable inOutRepresentative;
        TermVariable cellVariable;
        HashMap<Term, TermVariable> substitutionMapping = new HashMap<Term, TermVariable>();
        for (MultiDimensionalSelect ar : this.tflrwai.getArrayReads().get(i)) {
            cellVariable = this.mArrayInstance2Index2CellVariable.get(ar.getArray()).get(ar.getIndex());
            inOutRepresentative = ec.getInOutRepresentative(cellVariable);
            assert (inOutRepresentative != null);
            substitutionMapping.put(ar.getSelectTerm(), inOutRepresentative);
        }
        for (MultiDimensionalSelect ar : this.tflrwai.getAdditionalArrayReads()) {
            cellVariable = this.mArrayInstance2Index2CellVariable.get(ar.getArray()).get(ar.getIndex());
            inOutRepresentative = ec.getInOutRepresentative(cellVariable);
            assert (inOutRepresentative != null);
            substitutionMapping.put(ar.getSelectTerm(), inOutRepresentative);
        }
        return new PureSubstitution(this.mScript.getScript(), substitutionMapping);
    }

    public ModifiableTransFormula getResult() {
        return this.mResult;
    }
}

