/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays.ArrayCellReplacementVarInformation;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays.SingleUpdateNormalFormTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayEquality;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayUpdate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TransFormulaLRWithArrayInformation {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private final SmtUtils.XnfConversionTechnique mXnfConversionTechnique;
    private final boolean mContainsArrays;
    static final String s_AuxArray = "auxArray";
    private final ManagedScript mScript;
    private HashRelation<Term, ArrayIndex> mArrayFirstGeneration2Indices;
    private final HashRelation<TermVariable, TermVariable> mArrayFirstGeneration2Instances;
    private final Map<ArrayIndex, ArrayIndex> mIndexInstance2IndexRepresentative = new HashMap<ArrayIndex, ArrayIndex>();
    private final List<List<ArrayUpdate>> mArrayUpdates;
    private final List<List<MultiDimensionalSelect>> mArrayReads;
    private final List<MultiDimensionalSelect> mAdditionalArrayReads = new ArrayList<MultiDimensionalSelect>();
    private final ArrayGenealogy[] mArrayGenealogy;
    private final Term[] sunnf;
    private final List<List<ArrayEquality>> mArrayEqualities;
    private final ModifiableTransFormula mTransFormulaLR;
    private final ReplacementVarFactory mReplacementVarFactory;
    private final NestedMap2<TermVariable, ArrayIndex, ArrayCellReplacementVarInformation> mArrayCellInVars = new NestedMap2();
    private final NestedMap2<TermVariable, ArrayIndex, ArrayCellReplacementVarInformation> mArrayCellOutVars = new NestedMap2();
    private Map<Term, Term> mInVars2OutVars;
    private Map<Term, Term> mOutVars2InVars;

    public TransFormulaLRWithArrayInformation(IUltimateServiceProvider services, ModifiableTransFormula transFormulaLR, ReplacementVarFactory replacementVarFactory, ManagedScript script, IIcfgSymbolTable boogie2smt, TransFormulaLRWithArrayInformation stem, SmtUtils.SimplificationTechnique simplificationTechnique, SmtUtils.XnfConversionTechnique xnfConversionTechnique) {
        this.mServices = services;
        this.mLogger = this.mServices.getLoggingService().getLogger("Library-LassoRanker");
        this.mSimplificationTechnique = simplificationTechnique;
        this.mXnfConversionTechnique = xnfConversionTechnique;
        this.mTransFormulaLR = transFormulaLR;
        this.mScript = script;
        this.mReplacementVarFactory = replacementVarFactory;
        if (!SmtUtils.containsArrayVariables((Term[])new Term[]{this.mTransFormulaLR.getFormula()})) {
            this.mContainsArrays = false;
            this.sunnf = null;
            this.mArrayUpdates = null;
            this.mArrayReads = null;
            this.mArrayEqualities = null;
            this.mArrayGenealogy = null;
            this.mArrayFirstGeneration2Instances = null;
        } else {
            this.mContainsArrays = true;
            Term term = SmtUtils.simplify((ManagedScript)this.mScript, (Term)this.mTransFormulaLR.getFormula(), (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)simplificationTechnique);
            Term dnf = SmtUtils.toDnf((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, (Term)term, (SmtUtils.XnfConversionTechnique)xnfConversionTechnique);
            dnf = SmtUtils.simplify((ManagedScript)this.mScript, (Term)dnf, (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)simplificationTechnique);
            Term[] disjuncts = SmtUtils.getDisjuncts((Term)dnf);
            this.sunnf = new Term[disjuncts.length];
            this.mArrayUpdates = new ArrayList<List<ArrayUpdate>>(disjuncts.length);
            this.mArrayReads = new ArrayList<List<MultiDimensionalSelect>>(disjuncts.length);
            this.mArrayEqualities = new ArrayList<List<ArrayEquality>>(disjuncts.length);
            this.mArrayGenealogy = new ArrayGenealogy[disjuncts.length];
            SingleUpdateNormalFormTransformer.FreshAuxVarGenerator favg = new SingleUpdateNormalFormTransformer.FreshAuxVarGenerator(this.mReplacementVarFactory);
            SingleUpdateNormalFormTransformer[] sunfts = new SingleUpdateNormalFormTransformer[disjuncts.length];
            int i = 0;
            while (i < disjuncts.length) {
                Term[] conjuncts = SmtUtils.getConjuncts((Term)disjuncts[i]);
                ArrayEquality.ArrayEqualityExtractor aee = new ArrayEquality.ArrayEqualityExtractor(conjuncts);
                this.mArrayEqualities.add(aee.getArrayEqualities());
                sunfts[i] = new SingleUpdateNormalFormTransformer(SmtUtils.and((Script)this.mScript.getScript(), (Term[])aee.getRemainingTerms().toArray(new Term[0])), this.mScript.getScript(), favg);
                this.mArrayUpdates.add(sunfts[i].getArrayUpdates());
                this.sunnf[i] = sunfts[i].getRemainderTerm();
                this.mArrayReads.add(this.extractArrayReads(sunfts[i].getArrayUpdates(), sunfts[i].getRemainderTerm()));
                this.mArrayGenealogy[i] = new ArrayGenealogy(this.mTransFormulaLR, this.mArrayEqualities.get(i), this.mArrayUpdates.get(i), this.mArrayReads.get(i));
                ++i;
            }
            assert (this.checkSunftranformation(services, this.mLogger, this.mScript, boogie2smt, this.mArrayEqualities, sunfts)) : "error in sunftransformation";
            this.constructSubstitutions();
            HashRelation<TermVariable, ArrayIndex> foreignIndices = stem == null ? null : this.computeForeignIndices(stem);
            new IndexCollector(this.mTransFormulaLR, foreignIndices);
            this.mArrayFirstGeneration2Instances = this.computeArrayFirstGeneration2Instances();
            this.computeInVarAndOutVarArrayCells();
        }
    }

    private boolean checkSunftranformation(IUltimateServiceProvider services, ILogger logger, ManagedScript ftvc, IIcfgSymbolTable boogie2smt, List<List<ArrayEquality>> arrayEqualities, SingleUpdateNormalFormTransformer[] sunfts) {
        ModifiableTransFormula afterSunft = TransFormulaLRWithArrayInformation.constructTransFormulaLRWInSunf(services, this.mXnfConversionTechnique, this.mSimplificationTechnique, logger, ftvc, this.mReplacementVarFactory, this.mScript.getScript(), this.mTransFormulaLR, arrayEqualities, sunfts);
        Script.LBool notStronger = ModifiableTransFormulaUtils.implies((IUltimateServiceProvider)this.mServices, (ILogger)this.mLogger, (ModifiableTransFormula)this.mTransFormulaLR, (ModifiableTransFormula)afterSunft, (ManagedScript)this.mScript, (IIcfgSymbolTable)boogie2smt);
        if (notStronger != Script.LBool.SAT && notStronger != Script.LBool.UNSAT) {
            logger.warn((Object)("result of sunf transformation notStronger check is " + notStronger));
        }
        assert (notStronger != Script.LBool.SAT) : "result of sunf transformation too strong";
        Script.LBool notWeaker = ModifiableTransFormulaUtils.implies((IUltimateServiceProvider)this.mServices, (ILogger)this.mLogger, (ModifiableTransFormula)afterSunft, (ModifiableTransFormula)this.mTransFormulaLR, (ManagedScript)this.mScript, (IIcfgSymbolTable)boogie2smt);
        if (notWeaker != Script.LBool.SAT && notWeaker != Script.LBool.UNSAT) {
            logger.warn((Object)("result of sunf transformation notWeaker check is " + notWeaker));
        }
        assert (notWeaker != Script.LBool.SAT) : "result of sunf transformation too weak";
        return notStronger != Script.LBool.SAT && notWeaker != Script.LBool.SAT;
    }

    private HashRelation<TermVariable, ArrayIndex> computeForeignIndices(TransFormulaLRWithArrayInformation stem) {
        HashRelation arrayInVar2ForeignIndices = new HashRelation();
        for (Triple triple : stem.getArrayCellOutVars().entrySet()) {
            ArrayCellReplacementVarInformation acrvi = (ArrayCellReplacementVarInformation)triple.getThird();
            IProgramVar arrayRv = acrvi.getArrayRankVar();
            TermVariable arrayInVar = (TermVariable)this.mTransFormulaLR.getInVars().get(arrayRv);
            if (arrayInVar == null) continue;
            ArrayIndex foreignIndex = this.computeForeignIndex(arrayRv, acrvi.getIndex(), acrvi.termVariableToRankVarMappingForIndex());
            assert (ModifiableTransFormulaUtils.allVariablesAreInVars((List)foreignIndex, (ModifiableTransFormula)this.mTransFormulaLR));
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("Adding foreign index " + foreignIndex + " for array " + arrayInVar));
            }
            arrayInVar2ForeignIndices.addPair((Object)arrayInVar, (Object)foreignIndex);
        }
        return arrayInVar2ForeignIndices;
    }

    private ArrayIndex computeForeignIndex(IProgramVar arrayRv, ArrayIndex index, Map<TermVariable, IProgramVar> termVariableToRankVarMappingForIndex) {
        HashMap<Term, TermVariable> substitutionMapping = new HashMap<Term, TermVariable>();
        for (Map.Entry<TermVariable, IProgramVar> foreigntv2rv : termVariableToRankVarMappingForIndex.entrySet()) {
            if (!this.mTransFormulaLR.getInVars().containsKey(foreigntv2rv.getValue())) {
                this.addForeignInVarAndOutVar(foreigntv2rv.getValue());
            }
            TermVariable ourInVar = (TermVariable)this.mTransFormulaLR.getInVars().get(foreigntv2rv.getValue());
            substitutionMapping.put((Term)foreigntv2rv.getKey(), ourInVar);
        }
        ArrayIndex foreignIndex = index.applySubstitution(this.mScript, substitutionMapping);
        return foreignIndex;
    }

    private void addForeignInVarAndOutVar(IProgramVar value) {
        String name = String.valueOf(value.getGloballyUniqueId()) + "_ForeignInOutVar";
        Sort sort = ReplacementVarUtils.getDefinition((IProgramVar)value).getSort();
        TermVariable inOutVar = this.mScript.constructFreshTermVariable(name, sort);
        assert (!this.mTransFormulaLR.getInVars().containsKey(value));
        this.mTransFormulaLR.addInVar(value, inOutVar);
        assert (!this.mTransFormulaLR.getOutVars().containsKey(value));
        this.mTransFormulaLR.addOutVar(value, inOutVar);
    }

    public boolean containsArrays() {
        return this.mContainsArrays;
    }

    private HashRelation<TermVariable, TermVariable> computeArrayFirstGeneration2Instances() {
        HashRelation result = new HashRelation();
        int i = 0;
        while (i < this.numberOfDisjuncts()) {
            for (TermVariable instance : this.mArrayGenealogy[i].getInstances()) {
                TermVariable firstGeneration = this.mArrayGenealogy[i].getProgenitor(instance);
                result.addPair((Object)firstGeneration, (Object)instance);
            }
            ++i;
        }
        return result;
    }

    public HashRelation<Term, ArrayIndex> getArrayFirstGeneration2Indices() {
        return this.mArrayFirstGeneration2Indices;
    }

    public HashRelation<TermVariable, TermVariable> getArrayFirstGeneration2Instances() {
        return this.mArrayFirstGeneration2Instances;
    }

    public List<List<ArrayUpdate>> getArrayUpdates() {
        return this.mArrayUpdates;
    }

    public List<List<MultiDimensionalSelect>> getArrayReads() {
        return this.mArrayReads;
    }

    public List<MultiDimensionalSelect> getAdditionalArrayReads() {
        return this.mAdditionalArrayReads;
    }

    public List<List<ArrayEquality>> getArrayEqualities() {
        return this.mArrayEqualities;
    }

    public int numberOfDisjuncts() {
        return this.sunnf.length;
    }

    public Term[] getSunnf() {
        return this.sunnf;
    }

    public ModifiableTransFormula getTransFormulaLR() {
        return this.mTransFormulaLR;
    }

    public ArrayIndex getOrConstructIndexRepresentative(ArrayIndex indexInstance) {
        ArrayIndex indexRepresentative = this.mIndexInstance2IndexRepresentative.get(indexInstance);
        if (indexRepresentative == null) {
            indexRepresentative = new ArrayIndex(ModifiableTransFormulaUtils.translateTermVariablesToDefinitions((ManagedScript)this.mScript, (ModifiableTransFormula)this.mTransFormulaLR, (List)indexInstance));
            this.mIndexInstance2IndexRepresentative.put(indexInstance, indexRepresentative);
        }
        return indexRepresentative;
    }

    private List<MultiDimensionalSelect> extractArrayReads(List<ArrayUpdate> arrayUpdates, Term remainderTerm) {
        ArrayList<MultiDimensionalSelect> result = new ArrayList<MultiDimensionalSelect>();
        for (ArrayUpdate au : arrayUpdates) {
            for (Term indexEntry : au.getIndex()) {
                result.addAll(MultiDimensionalSelect.extractSelectDeep((Term)indexEntry, (boolean)true));
            }
            result.addAll(MultiDimensionalSelect.extractSelectDeep((Term)au.getValue(), (boolean)true));
        }
        result.addAll(MultiDimensionalSelect.extractSelectDeep((Term)remainderTerm, (boolean)true));
        return result;
    }

    private void constructSubstitutions() {
        HashMap<Term, Term> in2outMapping = new HashMap<Term, Term>();
        HashMap<Term, Term> out2inMapping = new HashMap<Term, Term>();
        for (IProgramVar rv : this.mTransFormulaLR.getInVars().keySet()) {
            Term inVar = (Term)this.mTransFormulaLR.getInVars().get(rv);
            assert (inVar != null);
            Term outVar = (Term)this.mTransFormulaLR.getOutVars().get(rv);
            assert (outVar != null);
            in2outMapping.put(inVar, outVar);
            out2inMapping.put(outVar, inVar);
        }
        this.mInVars2OutVars = in2outMapping;
        this.mOutVars2InVars = out2inMapping;
    }

    public void computeInVarAndOutVarArrayCells() {
        for (TermVariable firstGeneration : this.getArrayFirstGeneration2Instances().getDomain()) {
            for (TermVariable instance : this.getArrayFirstGeneration2Instances().getImage((Object)firstGeneration)) {
                Set indicesOfAllGenerations = this.getArrayFirstGeneration2Indices().getImage((Object)firstGeneration);
                if (indicesOfAllGenerations == null) {
                    this.mLogger.info((Object)("Array " + firstGeneration + " is never accessed"));
                    continue;
                }
                for (ArrayIndex index : indicesOfAllGenerations) {
                    boolean requiresRepVar = this.requiresRepVar(instance, index);
                    if (!requiresRepVar) continue;
                    TermVariable arrayRepresentative = (TermVariable)ModifiableTransFormulaUtils.getDefinition((ModifiableTransFormula)this.mTransFormulaLR, (TermVariable)instance);
                    ArrayIndex indexRepresentative = this.getOrConstructIndexRepresentative(index);
                    TermVariable inVarInstance = this.computeInVarInstance(instance);
                    assert (this.getTransFormulaLR().getInVarsReverseMapping().containsKey(inVarInstance));
                    ArrayIndex inVarIndex = this.computeInVarIndex(index);
                    assert (ModifiableTransFormulaUtils.allVariablesAreInVars((List)inVarIndex, (ModifiableTransFormula)this.getTransFormulaLR()));
                    ArrayCellReplacementVarInformation acrvi = new ArrayCellReplacementVarInformation(inVarInstance, arrayRepresentative, inVarIndex, indexRepresentative, ArrayCellReplacementVarInformation.VarType.InVar, this.getTransFormulaLR());
                    this.mArrayCellInVars.put((Object)arrayRepresentative, (Object)indexRepresentative, (Object)acrvi);
                    TermVariable outVarInstance = this.computeOutVarInstance(instance);
                    assert (this.getTransFormulaLR().getOutVarsReverseMapping().containsKey(outVarInstance));
                    ArrayIndex outVarIndex = this.computeOutVarIndex(index);
                    assert (ModifiableTransFormulaUtils.allVariablesAreOutVars((List)outVarIndex, (ModifiableTransFormula)this.getTransFormulaLR()));
                    acrvi = new ArrayCellReplacementVarInformation(outVarInstance, arrayRepresentative, outVarIndex, indexRepresentative, ArrayCellReplacementVarInformation.VarType.OutVar, this.getTransFormulaLR());
                    this.mArrayCellOutVars.put((Object)arrayRepresentative, (Object)indexRepresentative, (Object)acrvi);
                }
            }
        }
    }

    private ArrayIndex computeInVarIndex(ArrayIndex index) {
        return index.applySubstitution(this.mScript, this.mOutVars2InVars);
    }

    private ArrayIndex computeOutVarIndex(ArrayIndex index) {
        return index.applySubstitution(this.mScript, this.mInVars2OutVars);
    }

    private TermVariable computeInVarInstance(TermVariable arrayInstance) {
        TermVariable result = (TermVariable)this.mOutVars2InVars.get(arrayInstance);
        return result;
    }

    private TermVariable computeOutVarInstance(TermVariable arrayInstance) {
        TermVariable result = (TermVariable)this.mInVars2OutVars.get(arrayInstance);
        return result;
    }

    public NestedMap2<TermVariable, ArrayIndex, ArrayCellReplacementVarInformation> getArrayCellInVars() {
        return this.mArrayCellInVars;
    }

    public NestedMap2<TermVariable, ArrayIndex, ArrayCellReplacementVarInformation> getArrayCellOutVars() {
        return this.mArrayCellOutVars;
    }

    public boolean requiresRepVar(TermVariable arrayInstance, ArrayIndex index) {
        if (this.getTransFormulaLR().getOutVarsReverseMapping().keySet().contains(arrayInstance) || this.getTransFormulaLR().getInVarsReverseMapping().keySet().contains(arrayInstance)) {
            return ModifiableTransFormulaUtils.allVariablesAreVisible((List)index, (ModifiableTransFormula)this.getTransFormulaLR());
        }
        return false;
    }

    public boolean isInVarCell(TermVariable arrayInstance, ArrayIndex index) {
        if (ModifiableTransFormulaUtils.isInVar((TermVariable)arrayInstance, (ModifiableTransFormula)this.getTransFormulaLR())) {
            return ModifiableTransFormulaUtils.allVariablesAreInVars((List)index, (ModifiableTransFormula)this.getTransFormulaLR());
        }
        return false;
    }

    public boolean isOutVarCell(TermVariable arrayInstance, ArrayIndex index) {
        if (ModifiableTransFormulaUtils.isOutVar((TermVariable)arrayInstance, (ModifiableTransFormula)this.getTransFormulaLR())) {
            return ModifiableTransFormulaUtils.allVariablesAreOutVars((List)index, (ModifiableTransFormula)this.getTransFormulaLR());
        }
        return false;
    }

    private static ModifiableTransFormula constructTransFormulaLRWInSunf(IUltimateServiceProvider services, SmtUtils.XnfConversionTechnique xnfConversionTechnique, SmtUtils.SimplificationTechnique simplificationTechnique, ILogger logger, ManagedScript ftvc, ReplacementVarFactory repVarFactory, Script script, ModifiableTransFormula tf, List<List<ArrayEquality>> arrayEqualities, SingleUpdateNormalFormTransformer ... sunfts) {
        ModifiableTransFormula result = new ModifiableTransFormula(tf);
        ArrayList<Term> disjuncts = new ArrayList<Term>();
        assert (arrayEqualities.size() == sunfts.length);
        int i = 0;
        while (i < sunfts.length) {
            ArrayList<Term> conjuncts = new ArrayList<Term>();
            for (ArrayUpdate au : sunfts[i].getArrayUpdates()) {
                conjuncts.add(au.getArrayUpdateTerm());
            }
            for (ArrayEquality ae : arrayEqualities.get(i)) {
                conjuncts.add(ae.getOriginalTerm());
            }
            conjuncts.add(sunfts[i].getRemainderTerm());
            Term disjunct = SmtUtils.and((Script)script, conjuncts);
            HashSet<TermVariable> auxVars = new HashSet<TermVariable>(sunfts[i].getAuxVars());
            disjunct = PartialQuantifierElimination.elim((ManagedScript)ftvc, (int)0, auxVars, (Term)disjunct, (IUltimateServiceProvider)services, (ILogger)logger, (SmtUtils.SimplificationTechnique)simplificationTechnique, (SmtUtils.XnfConversionTechnique)xnfConversionTechnique);
            disjuncts.add(disjunct);
            result.addAuxVars(auxVars);
            ++i;
        }
        Term resultTerm = SmtUtils.or((Script)script, disjuncts);
        result.setFormula(resultTerm);
        return result;
    }

    private class ArrayGenealogy {
        Map<ArrayGeneration, ArrayGeneration> mGeneration2OriginalGeneration = new HashMap<ArrayGeneration, ArrayGeneration>();
        Map<TermVariable, TermVariable> mInstance2Representative = new HashMap<TermVariable, TermVariable>();
        Map<ArrayGeneration, ArrayGeneration> mParentGeneration = new HashMap<ArrayGeneration, ArrayGeneration>();
        Map<TermVariable, ArrayGeneration> mArray2Generation = new HashMap<TermVariable, ArrayGeneration>();
        List<ArrayGeneration> mArrayGenerations = new ArrayList<ArrayGeneration>();
        private final ModifiableTransFormula mTransFormula;

        private ArrayGeneration getOrConstructArrayGeneration(TermVariable array) {
            ArrayGeneration ag = this.mArray2Generation.get(array);
            if (ag == null) {
                ag = new ArrayGeneration(this.mTransFormula, array);
                this.mArrayGenerations.add(ag);
            }
            return ag;
        }

        ArrayGenealogy(ModifiableTransFormula tf, List<ArrayEquality> arrayEqualities, List<ArrayUpdate> arrayUpdates, List<MultiDimensionalSelect> arrayReads) {
            this.mTransFormula = tf;
            UnionFind uf = new UnionFind();
            for (ArrayEquality ae : arrayEqualities) {
                TermVariable rhsRepresentative;
                TermVariable lhs = ae.getLhsTermVariable();
                TermVariable rhs = ae.getRhsTermVariable();
                TermVariable lhsRepresentative = (TermVariable)uf.find((Object)lhs);
                if (lhsRepresentative == null) {
                    uf.makeEquivalenceClass((Object)lhs);
                    lhsRepresentative = lhs;
                }
                if ((rhsRepresentative = (TermVariable)uf.find((Object)rhs)) == null) {
                    uf.makeEquivalenceClass((Object)rhs);
                    rhsRepresentative = rhs;
                }
                uf.union((Object)lhsRepresentative, (Object)rhsRepresentative);
            }
            for (TermVariable representative : uf.getAllRepresentatives()) {
                ArrayGeneration ag = this.getOrConstructArrayGeneration(representative);
                for (TermVariable array : uf.getEquivalenceClassMembers((Object)representative)) {
                    if (array == representative) continue;
                    ag.add(array);
                }
            }
            for (ArrayUpdate au : arrayUpdates) {
                ArrayGeneration newGeneration;
                ArrayGeneration oldGeneration = this.getOrConstructArrayGeneration((TermVariable)au.getOldArray());
                if (oldGeneration == (newGeneration = this.getOrConstructArrayGeneration(au.getNewArray()))) {
                    TransFormulaLRWithArrayInformation.this.mLogger.warn((Object)"self update, this is not tested very well ");
                    continue;
                }
                this.putParentGeneration(newGeneration, oldGeneration);
            }
            for (ArrayGeneration ag : this.mArrayGenerations) {
                ArrayGeneration fg = this.getFirstGeneration(ag);
                this.putInstance2FirstGeneration(ag, fg);
            }
            for (MultiDimensionalSelect ar : arrayReads) {
                this.determineRepresentative((TermVariable)ar.getArray());
            }
            for (ArrayEquality ae : arrayEqualities) {
                this.determineRepresentative(ae.getLhsTermVariable());
                this.determineRepresentative(ae.getRhsTermVariable());
            }
            for (ArrayUpdate au : arrayUpdates) {
                this.determineRepresentative(au.getNewArray());
                this.determineRepresentative((TermVariable)au.getOldArray());
            }
        }

        private void determineRepresentative(TermVariable array) {
            if (this.mInstance2Representative.containsKey(array)) {
                return;
            }
            ArrayGeneration ag = this.mArray2Generation.get(array);
            if (ag == null) {
                this.mInstance2Representative.put(array, array);
            } else {
                ArrayGeneration fg = this.mGeneration2OriginalGeneration.get(ag);
                assert (fg != null) : "no original generation!";
                TermVariable representative = fg.getRepresentative();
                if (ModifiableTransFormulaUtils.isInVar((TermVariable)representative, (ModifiableTransFormula)this.mTransFormula)) {
                    this.mInstance2Representative.put(array, representative);
                } else {
                    throw new AssertionError((Object)"no invar");
                }
            }
        }

        private void putParentGeneration(ArrayGeneration child, ArrayGeneration parent) {
            assert (child != null);
            assert (parent != null);
            assert (child != parent);
            assert (child.toString() != null);
            assert (parent.toString() != null);
            this.mParentGeneration.put(child, parent);
        }

        private void putInstance2FirstGeneration(ArrayGeneration child, ArrayGeneration progenitor) {
            assert (child != null);
            assert (progenitor != null);
            assert (child.toString() != null);
            assert (progenitor.toString() != null);
            this.mGeneration2OriginalGeneration.put(child, progenitor);
        }

        private ArrayGeneration getFirstGeneration(ArrayGeneration ag) {
            ArrayGeneration parent = this.mParentGeneration.get(ag);
            if (parent == null) {
                return ag;
            }
            return this.getFirstGeneration(parent);
        }

        public TermVariable getProgenitor(TermVariable tv) {
            return this.mInstance2Representative.get(tv);
        }

        public Set<TermVariable> getInstances() {
            return this.mInstance2Representative.keySet();
        }

        private class ArrayGeneration {
            private final Set<TermVariable> mArrays = new HashSet<TermVariable>();
            private TermVariable mRepresentative;
            private final ModifiableTransFormula mTransFormula;

            public ArrayGeneration(ModifiableTransFormula tf, TermVariable array) {
                this.mTransFormula = tf;
                this.add(array);
            }

            public TermVariable getRepresentative() {
                if (this.mRepresentative == null) {
                    this.determineRepresentative();
                }
                return this.mRepresentative;
            }

            private void determineRepresentative() {
                for (TermVariable array : this.mArrays) {
                    if (!ModifiableTransFormulaUtils.isInVar((TermVariable)array, (ModifiableTransFormula)this.mTransFormula)) continue;
                    this.mRepresentative = array;
                    return;
                }
                this.mRepresentative = this.mArrays.iterator().next();
            }

            public void add(TermVariable array) {
                ArrayGenealogy.this.mArray2Generation.put(array, this);
                if (this.mRepresentative != null) {
                    throw new AssertionError((Object)"has already representative, cannot modify");
                }
                this.mArrays.add(array);
            }

            public String toString() {
                return "ArrayGeneration [Arrays=" + this.mArrays + ", Representative=" + this.mRepresentative + "]";
            }
        }
    }

    private class IndexCollector {
        private final ModifiableTransFormula mTransFormula;

        public IndexCollector(ModifiableTransFormula tf, HashRelation<TermVariable, ArrayIndex> foreignIndices) {
            this.mTransFormula = tf;
            TransFormulaLRWithArrayInformation.this.mArrayFirstGeneration2Indices = new HashRelation();
            int i = 0;
            while (i < TransFormulaLRWithArrayInformation.this.sunnf.length) {
                ArrayIndex index;
                TermVariable firstGeneration;
                for (ArrayUpdate au : (List)TransFormulaLRWithArrayInformation.this.mArrayUpdates.get(i)) {
                    firstGeneration = TransFormulaLRWithArrayInformation.this.mArrayGenealogy[i].getProgenitor((TermVariable)au.getOldArray());
                    index = au.getIndex();
                    this.addFirstGenerationIndexPair(firstGeneration, index);
                }
                for (MultiDimensionalSelect ar : (List)TransFormulaLRWithArrayInformation.this.mArrayReads.get(i)) {
                    firstGeneration = TransFormulaLRWithArrayInformation.this.mArrayGenealogy[i].getProgenitor((TermVariable)ar.getArray());
                    index = ar.getIndex();
                    this.addFirstGenerationIndexPair(firstGeneration, index);
                }
                ++i;
            }
            if (foreignIndices != null) {
                for (TermVariable arrayInVar : foreignIndices.getDomain()) {
                    TermVariable firstGenerationArray = null;
                    ArrayGenealogy[] arrayGenealogyArray = TransFormulaLRWithArrayInformation.this.mArrayGenealogy;
                    int n = arrayGenealogyArray.length;
                    int index = 0;
                    while (index < n) {
                        ArrayGenealogy ag = arrayGenealogyArray[index];
                        firstGenerationArray = ag.getProgenitor(arrayInVar);
                        if (firstGenerationArray != null) break;
                        ++index;
                    }
                    if (firstGenerationArray == null) {
                        TransFormulaLRWithArrayInformation.this.mLogger.warn((Object)(arrayInVar + " has no progenitor"));
                    }
                    Set foreignIndicesForInVar = foreignIndices.getImage((Object)arrayInVar);
                    for (ArrayIndex foreignIndex : foreignIndicesForInVar) {
                        this.addFirstGenerationIndexPair(firstGenerationArray, foreignIndex);
                    }
                }
            }
        }

        private boolean occursInArrayEqualities(TermVariable arrayInstance) {
            for (List equalitiesOfDisjunct : TransFormulaLRWithArrayInformation.this.mArrayEqualities) {
                for (ArrayEquality ae : equalitiesOfDisjunct) {
                    if (ae.getLhsTermVariable() == arrayInstance) {
                        return true;
                    }
                    if (ae.getRhsTermVariable() != arrayInstance) continue;
                    return true;
                }
            }
            return false;
        }

        private void addFirstGenerationIndexPair(TermVariable firstGeneration, ArrayIndex index) {
            TransFormulaLRWithArrayInformation.this.mArrayFirstGeneration2Indices.addPair((Object)firstGeneration, (Object)index);
            if (TransFormulaLRWithArrayInformation.this.mTransFormulaLR.getInVarsReverseMapping().containsKey(firstGeneration)) {
                Function<Term, Term> subst;
                if (ModifiableTransFormulaUtils.allVariablesAreInVars((List)index, (ModifiableTransFormula)TransFormulaLRWithArrayInformation.this.getTransFormulaLR())) {
                    subst = x -> Substitution.apply((ManagedScript)TransFormulaLRWithArrayInformation.this.mScript, (Map)TransFormulaLRWithArrayInformation.this.mInVars2OutVars, (Term)x);
                    ArrayIndex inReplacedByOut = new ArrayIndex(index.stream().map(subst).collect(Collectors.toList()));
                    TransFormulaLRWithArrayInformation.this.mArrayFirstGeneration2Indices.addPair((Object)firstGeneration, (Object)inReplacedByOut);
                    TransFormulaLRWithArrayInformation.this.mAdditionalArrayReads.addAll(this.extractArrayReads((List<Term>)inReplacedByOut));
                }
                if (ModifiableTransFormulaUtils.allVariablesAreOutVars((List)index, (ModifiableTransFormula)TransFormulaLRWithArrayInformation.this.getTransFormulaLR())) {
                    subst = x -> Substitution.apply((ManagedScript)TransFormulaLRWithArrayInformation.this.mScript, (Map)TransFormulaLRWithArrayInformation.this.mOutVars2InVars, (Term)x);
                    ArrayIndex outReplacedByIn = new ArrayIndex(index.stream().map(subst).collect(Collectors.toList()));
                    TransFormulaLRWithArrayInformation.this.mArrayFirstGeneration2Indices.addPair((Object)firstGeneration, (Object)outReplacedByIn);
                    TransFormulaLRWithArrayInformation.this.mAdditionalArrayReads.addAll(this.extractArrayReads((List<Term>)outReplacedByIn));
                }
            }
        }

        private boolean allVariablesOccurInFormula(ArrayIndex index, ModifiableTransFormula transFormulaLR) {
            HashSet<TermVariable> varsInTransFormula = new HashSet<TermVariable>(Arrays.asList(transFormulaLR.getFormula().getFreeVars()));
            for (Term term : index) {
                TermVariable[] termVariableArray = term.getFreeVars();
                int n = termVariableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TermVariable tv = termVariableArray[n2];
                    if (!varsInTransFormula.contains(tv)) {
                        return false;
                    }
                    ++n2;
                }
            }
            return true;
        }

        private List<MultiDimensionalSelect> extractArrayReads(List<Term> terms) {
            ArrayList<MultiDimensionalSelect> result = new ArrayList<MultiDimensionalSelect>();
            for (Term term : terms) {
                result.addAll(MultiDimensionalSelect.extractSelectDeep((Term)term, (boolean)true));
            }
            return result;
        }
    }
}

