/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class AffineFunction
implements Serializable {
    private static final long serialVersionUID = -3142354398708751882L;
    protected final Map<IProgramVar, BigInteger> mCoefficients = new LinkedHashMap<IProgramVar, BigInteger>();
    protected BigInteger mConstant = BigInteger.ZERO;

    public boolean isConstant() {
        return this.mCoefficients.isEmpty();
    }

    public BigInteger getConstant() {
        return this.mConstant;
    }

    public void setConstant(BigInteger c) {
        this.mConstant = c;
    }

    public Set<IProgramVar> getVariables() {
        return this.mCoefficients.keySet();
    }

    public BigInteger get(IProgramVar var) {
        return this.mCoefficients.get(var);
    }

    public void put(IProgramVar var, BigInteger coeff) {
        if (coeff.equals(BigInteger.ZERO)) {
            this.mCoefficients.remove(var);
        } else {
            this.mCoefficients.put(var, coeff);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<IProgramVar, BigInteger> entry : this.mCoefficients.entrySet()) {
            if (!first) {
                sb.append(entry.getValue().compareTo(BigInteger.ZERO) < 0 ? " - " : " + ");
            } else if (entry.getValue().compareTo(BigInteger.ZERO) < 0) {
                sb.append("-");
            }
            sb.append(entry.getValue().abs());
            sb.append("*");
            sb.append(entry.getKey());
            first = false;
        }
        if (!this.mConstant.equals(BigInteger.ZERO) || first) {
            if (!first) {
                sb.append(this.mConstant.compareTo(BigInteger.ZERO) < 0 ? " - " : " + ");
                sb.append(this.mConstant.abs());
            } else {
                sb.append(this.mConstant);
            }
        }
        return sb.toString();
    }

    private static Term constructSummand(Script script, Term t, BigInteger coefficient) {
        if (coefficient.equals(BigInteger.ONE)) {
            return t;
        }
        return script.term("*", new Term[]{SmtUtils.constructIntValue((Script)script, (BigInteger)coefficient), t});
    }

    public Term asTerm(Script script) throws SMTLIBException {
        ArrayList<Term> summands = new ArrayList<Term>();
        for (Map.Entry<IProgramVar, BigInteger> entry : this.mCoefficients.entrySet()) {
            Term definition = ReplacementVarUtils.getDefinition((IProgramVar)entry.getKey());
            summands.add(AffineFunction.constructSummand(script, definition, entry.getValue()));
        }
        if (!this.mConstant.equals(BigInteger.ZERO)) {
            summands.add(SmtUtils.constructIntValue((Script)script, (BigInteger)this.mConstant));
        }
        return SmtUtils.sum((Script)script, (Sort)SmtSortUtils.getRealSort((Script)script), (Term[])summands.toArray(new Term[summands.size()]));
    }

    public Rational evaluate(Map<IProgramVar, Rational> assignment) {
        Rational r = Rational.ZERO;
        for (Map.Entry<IProgramVar, BigInteger> entry : this.mCoefficients.entrySet()) {
            Rational val = assignment.get(entry.getKey());
            if (val == null) {
                val = Rational.ZERO;
            }
            r.add(val.mul(entry.getValue()));
        }
        r.add(Rational.valueOf((BigInteger)this.mConstant, (BigInteger)BigInteger.ONE));
        return r;
    }
}

