/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination;

import de.uni_freiburg.informatik.ultimate.lassoranker.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class AffineFunctionGenerator
implements Serializable {
    private static final long serialVersionUID = 4376363192635730213L;
    private final Term mConstant;
    private final Map<IProgramVar, Term> mCoefficients;

    private static String constName(String prefix) {
        return String.valueOf(prefix) + "c";
    }

    private static String coeffName(String prefix, IProgramVar var) {
        return String.valueOf(prefix) + "_" + SmtUtils.removeSmtQuoteCharacters((String)var.getGloballyUniqueId());
    }

    private AffineFunctionGenerator(Term constant, Map<IProgramVar, Term> coefficients) {
        this.mConstant = constant;
        this.mCoefficients = coefficients;
    }

    public AffineFunctionGenerator(Script script, Collection<IProgramVar> variables, String prefix) {
        this.mConstant = SmtUtils.buildNewConstant((Script)script, (String)AffineFunctionGenerator.constName(prefix), (String)"Real");
        this.mCoefficients = new LinkedHashMap<IProgramVar, Term>();
        for (IProgramVar var : variables) {
            this.mCoefficients.put(var, (Term)SmtUtils.buildNewConstant((Script)script, (String)AffineFunctionGenerator.coeffName(prefix, var), (String)"Real"));
        }
    }

    public AffineFunctionGenerator(Script script, Collection<IProgramVar> variables, String prefix, boolean withoutCoefficients) {
        assert (withoutCoefficients) : "This constructor is called only if the program variables shouldn't have any coefficients whichneed to be determined";
        this.mConstant = SmtUtils.buildNewConstant((Script)script, (String)AffineFunctionGenerator.constName(prefix), (String)"Real");
        this.mCoefficients = new LinkedHashMap<IProgramVar, Term>();
        for (IProgramVar var : variables) {
            this.mCoefficients.put(var, SmtUtils.constructIntValue((Script)script, (BigInteger)BigInteger.ONE));
        }
    }

    public LinearInequality generate(Map<IProgramVar, ? extends Term> vars) {
        LinearInequality li = new LinearInequality();
        li.add(new AffineTerm(this.mConstant, Rational.ONE));
        for (Map.Entry<IProgramVar, ? extends Term> entry : vars.entrySet()) {
            if (!this.mCoefficients.containsKey(entry.getKey())) continue;
            li.add(entry.getValue(), new AffineTerm(this.mCoefficients.get(entry.getKey()), Rational.ONE));
        }
        return li;
    }

    public LinearInequality generate(Map<IProgramVar, ? extends Term> vars, Map<IProgramVar, AffineTerm> programVars2NumericalCoefficients, Map<Term, AffineTerm> auxVarsToNumericalCoefficients) {
        LinearInequality li = new LinearInequality();
        for (Map.Entry<IProgramVar, ? extends Term> entry : vars.entrySet()) {
            li.add(entry.getValue(), programVars2NumericalCoefficients.get(entry.getKey()));
        }
        for (Map.Entry<Object, Object> entry : auxVarsToNumericalCoefficients.entrySet()) {
            li.add((Term)entry.getKey(), (AffineTerm)entry.getValue());
        }
        return li;
    }

    public Term getCoefficient(IProgramVar var) {
        return this.mCoefficients.get(var);
    }

    public Collection<Term> getCoefficients() {
        ArrayList<Term> vars = new ArrayList<Term>(this.mCoefficients.values());
        vars.add(this.mConstant);
        return vars;
    }

    public Rational getGcd(Map<Term, Rational> assignment) {
        Rational gcd = assignment.get(this.mConstant);
        for (Map.Entry<IProgramVar, Term> entry : this.mCoefficients.entrySet()) {
            gcd = gcd.gcd(assignment.get(entry.getValue()));
        }
        return gcd.abs();
    }

    public AffineFunction extractAffineFunction(Map<Term, Rational> assignment) {
        return this.extractAffineFunction(assignment, this.getGcd(assignment));
    }

    public AffineFunction extractAffineFunction(Map<Term, Rational> assignment, Rational gcd) {
        AffineFunction f = new AffineFunction();
        if (gcd.equals((Object)Rational.ZERO)) {
            Rational c = assignment.get(this.mConstant);
            assert (c.equals((Object)Rational.ZERO));
            for (Map.Entry<IProgramVar, Term> entry : this.mCoefficients.entrySet()) {
                c = assignment.get(entry.getValue());
                assert (c.equals((Object)Rational.ZERO));
                f.put(entry.getKey(), c.numerator());
            }
        } else {
            Rational c = assignment.get(this.mConstant).div(gcd);
            assert (c.denominator().equals(BigInteger.ONE));
            f.setConstant(c.numerator());
            for (Map.Entry<IProgramVar, Term> entry : this.mCoefficients.entrySet()) {
                c = assignment.get(entry.getValue()).div(gcd);
                assert (c.denominator().equals(BigInteger.ONE));
                f.put(entry.getKey(), c.numerator());
            }
        }
        return f;
    }

    public AffineFunctionGenerator getGeneratorWithNegatedCoefficients(Script script) {
        Term constant = script.term("-", new Term[]{this.mConstant});
        HashMap<IProgramVar, Term> coefficients = new HashMap<IProgramVar, Term>(this.mCoefficients.size());
        for (Map.Entry<IProgramVar, Term> entry : this.mCoefficients.entrySet()) {
            coefficients.put(entry.getKey(), script.term("-", new Term[]{entry.getValue()}));
        }
        return new AffineFunctionGenerator(constant, coefficients);
    }
}

