/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lassoranker.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lassoranker.AnalysisType;
import de.uni_freiburg.informatik.ultimate.lassoranker.InstanceCounting;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.SMTPrettyPrinter;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class MotzkinTransformation
extends InstanceCounting {
    private static final String MOTZKIN_PREFIX = "motzkin_";
    private final Script mScript;
    private final AnalysisType mAnalysisType;
    private boolean mAnnotateTerms;
    private final List<LinearInequality> mInequalities;
    private int mNumberSINeeded = 0;
    private boolean mTransformed = false;
    public String mAnnotation = null;
    private Term[] mCoefficients = null;
    private final Map<String, LinearInequality> mMotzkinCoefficients2LinearInequalities;
    private final IUltimateServiceProvider mServices;

    public MotzkinTransformation(IUltimateServiceProvider services, Script script, AnalysisType terminationAnalysis, boolean annotate) {
        this.mServices = services;
        this.mScript = script;
        this.mInequalities = new ArrayList<LinearInequality>();
        this.mAnnotateTerms = annotate;
        this.mAnalysisType = terminationAnalysis;
        this.mMotzkinCoefficients2LinearInequalities = new HashMap<String, LinearInequality>();
    }

    public int getNumberSINeeded() {
        return this.mNumberSINeeded;
    }

    public void setNumberSINeeded(int i) {
        assert (i >= 0);
        this.mNumberSINeeded = i;
    }

    public void addInequality(LinearInequality li) {
        this.mInequalities.add(li);
    }

    public void addInequalities(Collection<LinearInequality> l) {
        this.mInequalities.addAll(l);
    }

    private boolean needsMotzkinCoefficient(LinearInequality li) {
        if (this.mAnalysisType.isLinear()) {
            return li.allAffineTermsAreConstant();
        }
        if (this.mAnalysisType == AnalysisType.NONLINEAR) {
            return li.mMotzkinCoefficient != LinearInequality.PossibleMotzkinCoefficients.ONE;
        }
        assert (false);
        return true;
    }

    private void registerMotzkinCoefficients() {
        if (this.mCoefficients != null) {
            return;
        }
        int numcoefficients = this.mInequalities.size();
        this.mCoefficients = new Term[numcoefficients];
        int i = 0;
        while (i < numcoefficients) {
            LinearInequality li = this.mInequalities.get(i);
            if (this.needsMotzkinCoefficient(li)) {
                String motzkinCoefficientName = MOTZKIN_PREFIX + this.getInstanceNumber() + "_" + i;
                ApplicationTerm coefficient = SmtUtils.buildNewConstant((Script)this.mScript, (String)motzkinCoefficientName, (String)"Real");
                this.mCoefficients[i] = coefficient;
                this.mMotzkinCoefficients2LinearInequalities.put(motzkinCoefficientName, li);
            } else {
                this.mCoefficients[i] = this.mScript.decimal(BigDecimal.ONE);
            }
            ++i;
        }
    }

    public Map<String, LinearInequality> getMotzkinCoefficients2LinearInequalities() {
        return this.mMotzkinCoefficients2LinearInequalities;
    }

    private Term product(AffineTerm a, Term t) {
        if (a.isConstant() && a.getConstant().equals((Object)Rational.ONE)) {
            return t;
        }
        if (!a.isZero()) {
            return this.mScript.term("*", new Term[]{t, a.asRealTerm(this.mScript)});
        }
        return null;
    }

    private Term doTransform(Term[] coefficients, Collection<Term> vars) {
        Term s;
        LinearInequality li;
        int numcoefficients = coefficients.length;
        assert (numcoefficients == this.mInequalities.size());
        ArrayList<Term> conjunction = new ArrayList<Term>();
        for (Term var : vars) {
            ArrayList<Term> summands = new ArrayList<Term>();
            int i = 0;
            while (i < numcoefficients) {
                Term s2 = this.product(this.mInequalities.get(i).getCoefficient(var), coefficients[i]);
                if (s2 != null) {
                    summands.add(s2);
                }
                ++i;
            }
            Term sum = SmtUtils.sum((Script)this.mScript, (Sort)SmtSortUtils.getRealSort((Script)this.mScript), (Term[])summands.toArray(new Term[summands.size()]));
            conjunction.add(this.mScript.term("=", new Term[]{sum, this.mScript.decimal("0")}));
        }
        ArrayList<Term> summands = new ArrayList<Term>();
        int i = 0;
        while (i < numcoefficients) {
            li = this.mInequalities.get(i);
            s = this.product(li.getConstant(), coefficients[i]);
            if (s != null) {
                summands.add(s);
            }
            ++i;
        }
        Term sum = SmtUtils.sum((Script)this.mScript, (Sort)SmtSortUtils.getRealSort((Script)this.mScript), (Term[])summands.toArray(new Term[summands.size()]));
        conjunction.add(this.mScript.term("<=", new Term[]{sum, this.mScript.decimal("0")}));
        summands = new ArrayList();
        i = 0;
        while (i < numcoefficients) {
            li = this.mInequalities.get(i);
            s = this.product(li.getConstant(), coefficients[i]);
            if (!li.isStrict() && s != null) {
                summands.add(s);
            }
            ++i;
        }
        sum = SmtUtils.sum((Script)this.mScript, (Sort)SmtSortUtils.getRealSort((Script)this.mScript), (Term[])summands.toArray(new Term[summands.size()]));
        Term classical = this.mScript.term("<", new Term[]{sum, this.mScript.decimal("0")});
        summands = new ArrayList();
        int i2 = 0;
        while (i2 < numcoefficients) {
            LinearInequality li2 = this.mInequalities.get(i2);
            if (li2.isStrict()) {
                summands.add(coefficients[i2]);
            }
            ++i2;
        }
        Term nonClassical = this.mScript.term(">", new Term[]{SmtUtils.sum((Script)this.mScript, (Sort)SmtSortUtils.getRealSort((Script)this.mScript), (Term[])summands.toArray(new Term[summands.size()])), this.mScript.decimal("0")});
        conjunction.add(SmtUtils.or((Script)this.mScript, (Term[])new Term[]{classical, nonClassical}));
        return SmtUtils.and((Script)this.mScript, (Term[])conjunction.toArray(new Term[conjunction.size()]));
    }

    /*
     * Unable to fully structure code
     */
    public Term transform(Rational[] motzkinGuesses) {
        block22: {
            block19: {
                block20: {
                    block21: {
                        this.mTransformed = true;
                        this.registerMotzkinCoefficients();
                        vars = new LinkedHashSet<Term>();
                        for (LinearInequality li : this.mInequalities) {
                            vars.addAll(li.getVariables());
                        }
                        conjunction = new ArrayList<Term>();
                        var7_7 = this.mCoefficients;
                        var6_8 = this.mCoefficients.length;
                        var5_10 = 0;
                        while (var5_10 < var6_8) {
                            coefficient = var7_7[var5_10];
                            if (coefficient != null) {
                                conjunction.add(this.mScript.term(">=", new Term[]{coefficient, this.mScript.decimal("0")}));
                            }
                            ++var5_10;
                        }
                        if (!this.mAnalysisType.isLinear()) break block19;
                        numfixedCoeffs = 0;
                        fixedIndices = new int[this.mCoefficients.length];
                        i = 0;
                        while (i < this.mInequalities.size()) {
                            li = this.mInequalities.get(i);
                            if (!this.needsMotzkinCoefficient(li) && li.mMotzkinCoefficient != LinearInequality.PossibleMotzkinCoefficients.ONE) {
                                fixedIndices[numfixedCoeffs] = i;
                                ++numfixedCoeffs;
                            }
                            ++i;
                        }
                        if (!MotzkinTransformation.$assertionsDisabled && numfixedCoeffs >= 31) {
                            throw new AssertionError((Object)"Too many fixed coefficients!");
                        }
                        fixedCoefficients = new Term[this.mCoefficients.length];
                        System.arraycopy(this.mCoefficients, 0, fixedCoefficients, 0, this.mCoefficients.length);
                        if (!this.mAnalysisType.wantsGuesses() || motzkinGuesses.length <= 0) break block20;
                        motzkinCoeffs = new Term[motzkinGuesses.length];
                        i = 0;
                        while (i < motzkinGuesses.length) {
                            motzkinCoeffs[i] = motzkinGuesses[i].toTerm(SmtSortUtils.getRealSort((Script)this.mScript));
                            ++i;
                        }
                        cases = new int[numfixedCoeffs];
                        disjunction = new ArrayList<Term>();
                        if (numfixedCoeffs != 0) ** GOTO lbl64
                        disjunction.add(this.doTransform(fixedCoefficients, vars));
                        break block21;
lbl-1000:
                        // 1 sources

                        {
                            if (!this.mServices.getProgressMonitorService().continueProcessing()) {
                                throw new ToolchainCanceledException(this.getClass(), "approximative transformation where we make " + motzkinGuesses.length + " guesses");
                            }
                            j = 0;
                            while (j < numfixedCoeffs) {
                                fixedCoefficients[fixedIndices[j]] = motzkinCoeffs[cases[j]];
                                ++j;
                            }
                            disjunction.add(this.doTransform(fixedCoefficients, vars));
                            i = 0;
                            while (i < numfixedCoeffs) {
                                v0 = i;
                                cases[v0] = cases[v0] + 1;
                                if (i >= numfixedCoeffs - 1 || cases[i] < motzkinGuesses.length) continue block4;
                                cases[i] = 0;
                                ++i;
                            }
lbl64:
                            // 3 sources

                            ** while (cases[numfixedCoeffs - 1] < motzkinGuesses.length)
                        }
                    }
                    conjunction.add(SmtUtils.or((Script)this.mScript, (Term[])disjunction.toArray(new Term[disjunction.size()])));
                    break block22;
                }
                zero = this.mScript.decimal("0");
                one = this.mScript.decimal("1");
                disjunction = new ArrayList<Term>();
                i = 0;
                while (i < 1 << numfixedCoeffs) {
                    if (!this.mServices.getProgressMonitorService().continueProcessing()) {
                        throw new ToolchainCanceledException(this.getClass(), "approximative transformation where we fixed " + (1 << numfixedCoeffs) + " coefficients");
                    }
                    j = 0;
                    while (j < numfixedCoeffs) {
                        fixedCoefficients[fixedIndices[j]] = (i & 1 << j) == 0 ? zero : one;
                        ++j;
                    }
                    disjunction.add(this.doTransform(fixedCoefficients, vars));
                    ++i;
                }
                conjunction.add(SmtUtils.or((Script)this.mScript, (Term[])disjunction.toArray(new Term[disjunction.size()])));
                break block22;
            }
            if (this.mAnalysisType == AnalysisType.NONLINEAR) {
                conjunction.add(this.doTransform(this.mCoefficients, vars));
                i = 0;
                while (i < this.mInequalities.size()) {
                    li = this.mInequalities.get(i);
                    if (li.mMotzkinCoefficient == LinearInequality.PossibleMotzkinCoefficients.ZERO_AND_ONE) {
                        conjunction.add(SmtUtils.or((Script)this.mScript, (Term[])new Term[]{this.mScript.term("=", new Term[]{this.mCoefficients[i], this.mScript.decimal("0")}), this.mScript.term("=", new Term[]{this.mCoefficients[i], this.mScript.decimal("1")})}));
                    }
                    ++i;
                }
            } else {
                throw new AssertionError((Object)("Illegal enum value " + (Object)this.mAnalysisType));
            }
        }
        t = SmtUtils.and((Script)this.mScript, (Term[])conjunction.toArray(new Term[conjunction.size()]));
        if (this.mAnnotateTerms && this.mAnnotation != null) {
            t = this.mScript.annotate(t, new Annotation[]{new Annotation(":named", (Object)this.mAnnotation.replace(" ", "_"))});
        }
        return t;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MotzkinApplication\n");
        if (this.mAnnotation != null) {
            sb.append("Annotation: ");
            sb.append(this.mAnnotation);
            sb.append("\n");
        }
        sb.append("Inequalities:");
        for (LinearInequality li : this.mInequalities) {
            sb.append("\n    ");
            sb.append(li);
        }
        if (this.mTransformed) {
            sb.append("\nConstraints:\n");
            boolean annotateTerms = this.mAnnotateTerms;
            this.mAnnotateTerms = false;
            sb.append(new SMTPrettyPrinter(this.transform(new Rational[0])));
            this.mAnnotateTerms = annotateTerms;
        }
        return sb.toString();
    }
}

