/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lassoranker.AnalysisType;
import de.uni_freiburg.informatik.ultimate.lassoranker.ILassoRankerPreferences;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearTransition;
import de.uni_freiburg.informatik.ultimate.lassoranker.SMTSolver;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.MotzkinTransformation;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

class StemOverapproximator {
    private final boolean mAnnotateTerms;
    private static final boolean s_less_efficient_and_more_complete = false;
    private static final boolean s_return_true_if_approximation_fails = false;
    private Script mScript;
    private final IUltimateServiceProvider mServices;

    public StemOverapproximator(ILassoRankerPreferences preferences, IUltimateServiceProvider services) throws IOException {
        this.mServices = services;
        this.mAnnotateTerms = preferences.isAnnotateTerms();
        this.mScript = SMTSolver.newScript(preferences, "SimplifySIs", services);
        this.mScript.setLogic(Logics.QF_LRA);
    }

    protected void finalize() throws Throwable {
        if (this.mScript != null) {
            this.mScript.exit();
            this.mScript = null;
        }
        super.finalize();
    }

    public LinearTransition overapproximate(LinearTransition stem) {
        if (stem.getNumPolyhedra() < 2) {
            return stem;
        }
        HashSet candidate_lis = new HashSet();
        candidate_lis.addAll(stem.getPolyhedra().get(0));
        candidate_lis.addAll(stem.getPolyhedra().get(1));
        ArrayList<LinearInequality> new_stem = new ArrayList<LinearInequality>();
        for (LinearInequality candidate_li : candidate_lis) {
            this.mScript.push(1);
            for (List<LinearInequality> polyhedron : stem.getPolyhedra()) {
                MotzkinTransformation motzkin = new MotzkinTransformation(this.mServices, this.mScript, AnalysisType.LINEAR, this.mAnnotateTerms);
                motzkin.addInequalities(polyhedron);
                LinearInequality li = new LinearInequality(candidate_li);
                li.negate();
                motzkin.addInequality(li);
                motzkin.mAnnotation = "stem implies candidate linear inequality";
                this.mScript.assertTerm(motzkin.transform(new Rational[0]));
            }
            if (this.mScript.checkSat().equals((Object)Script.LBool.SAT)) {
                new_stem.add(candidate_li);
            }
            this.mScript.pop(1);
        }
        if (new_stem.isEmpty()) {
            return stem;
        }
        return new LinearTransition(Collections.singletonList(new_stem), stem.getInVars(), stem.getOutVars());
    }
}

