/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination;

import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunction;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigInteger;

public class SupportingInvariant
extends AffineFunction {
    private static final long serialVersionUID = -8409937196513651751L;
    public boolean strict;

    public SupportingInvariant() {
    }

    public SupportingInvariant(AffineFunction f) {
        this.mCoefficients.putAll(f.mCoefficients);
        this.mConstant = f.mConstant;
    }

    public boolean isFalse() {
        if (!this.mCoefficients.isEmpty()) {
            return false;
        }
        int cmp = this.mConstant.compareTo(BigInteger.ZERO);
        return cmp <= 0 && this.strict || cmp < 0 && !this.strict;
    }

    public boolean isTrue() {
        if (!this.mCoefficients.isEmpty()) {
            return false;
        }
        int cmp = this.mConstant.compareTo(BigInteger.ZERO);
        return cmp > 0 && this.strict || cmp >= 0 && !this.strict;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(this.strict ? " > 0" : " >= 0");
        return sb.toString();
    }

    @Override
    public Term asTerm(Script script) throws SMTLIBException {
        Term t = super.asTerm(script);
        return script.term(this.strict ? ">" : ">=", new Term[]{t, SmtUtils.constructIntValue((Script)script, (BigInteger)BigInteger.ZERO)});
    }
}

