/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lassoranker.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lassoranker.AnalysisType;
import de.uni_freiburg.informatik.ultimate.lassoranker.ILassoRankerPreferences;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.SMTSolver;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.MotzkinTransformation;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.SupportingInvariant;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

class SupportingInvariantSimplifier {
    private final boolean mAnnotateTerms;
    private Script mScript;
    private final IUltimateServiceProvider mServices;

    public SupportingInvariantSimplifier(ILassoRankerPreferences preferences, IUltimateServiceProvider services) throws IOException {
        this.mServices = services;
        this.mAnnotateTerms = preferences.isAnnotateTerms();
        this.mScript = SMTSolver.newScript(preferences, "SimplifySIs", services);
        this.mScript.setLogic(Logics.QF_LRA);
    }

    protected void finalize() throws Throwable {
        if (this.mScript != null) {
            this.mScript.exit();
            this.mScript = null;
        }
        super.finalize();
    }

    private static LinearInequality SI2LI(SupportingInvariant si) {
        LinearInequality li = new LinearInequality();
        li.add(new AffineTerm(si.mConstant));
        for (Map.Entry entry : si.mCoefficients.entrySet()) {
            li.add(ReplacementVarUtils.getDefinition((IProgramVar)((IProgramVar)entry.getKey())), new AffineTerm((BigInteger)entry.getValue()));
        }
        li.setStrict(si.strict);
        return li;
    }

    public Collection<SupportingInvariant> simplify(Collection<SupportingInvariant> sis) {
        HashSet<SupportingInvariant> new_sis = new HashSet<SupportingInvariant>(sis);
        for (SupportingInvariant si : sis) {
            this.mScript.push(1);
            MotzkinTransformation motzkin = new MotzkinTransformation(this.mServices, this.mScript, AnalysisType.LINEAR, this.mAnnotateTerms);
            LinearInequality li = SupportingInvariantSimplifier.SI2LI(si);
            li.negate();
            motzkin.addInequality(li);
            for (SupportingInvariant si2 : new_sis) {
                if (si2 == si) continue;
                LinearInequality li2 = SupportingInvariantSimplifier.SI2LI(si2);
                motzkin.addInequality(li2);
            }
            motzkin.mAnnotation = "Simplifying supporting invariant";
            this.mScript.assertTerm(motzkin.transform(new Rational[0]));
            li.negate();
            if (this.mScript.checkSat().equals((Object)Script.LBool.SAT)) {
                new_sis.remove(si);
            }
            this.mScript.pop(1);
        }
        return new_sis;
    }
}

