/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination;

import de.uni_freiburg.informatik.ultimate.lassoranker.AnalysisType;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.ITerminationAnalysisSettings;
import java.io.Serializable;

public class TerminationAnalysisSettings
implements Serializable,
ITerminationAnalysisSettings {
    private static final long serialVersionUID = 9183092457990345360L;
    private final AnalysisType mAnalysis;
    private final int mNumStrictInvariants;
    private final int mNumNonStrictInvariants;
    private final boolean mNonDecreasingInvariants;
    private final boolean mSimplifyTerminationArgument;
    private final boolean mSimplifySupportingInvariants;
    private final boolean mOverapproximateStem;

    public TerminationAnalysisSettings(ITerminationAnalysisSettings other) {
        this.mAnalysis = other.getAnalysis();
        this.mNumStrictInvariants = other.getNumStrictInvariants();
        this.mNumNonStrictInvariants = other.getNumNonStrictInvariants();
        this.mNonDecreasingInvariants = other.isNonDecreasingInvariants();
        this.mSimplifyTerminationArgument = other.isSimplifyTerminationArgument();
        this.mSimplifySupportingInvariants = other.isSimplifySupportingInvariants();
        this.mOverapproximateStem = other.isOverapproximateStem();
        assert (this.checkSanity());
    }

    private boolean checkSanity() {
        return this.mNumStrictInvariants >= 0 && this.mNumNonStrictInvariants >= 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Termination analysis: ");
        sb.append((Object)this.mAnalysis);
        sb.append("Number of strict supporting invariants: ");
        sb.append(this.mNumStrictInvariants);
        sb.append("Number of non-strict supporting invariants: ");
        sb.append(this.mNumNonStrictInvariants);
        sb.append("Consider only non-deceasing supporting invariants: ");
        sb.append(this.mNonDecreasingInvariants);
        sb.append("Simplify termination arguments: ");
        sb.append(this.mSimplifyTerminationArgument);
        sb.append("Simplify supporting invariants: ");
        sb.append(this.mSimplifySupportingInvariants);
        sb.append("Overapproximate stem: ");
        sb.append(this.mOverapproximateStem);
        return sb.toString();
    }

    @Override
    public AnalysisType getAnalysis() {
        return this.mAnalysis;
    }

    @Override
    public int getNumStrictInvariants() {
        return this.mNumStrictInvariants;
    }

    @Override
    public int getNumNonStrictInvariants() {
        return this.mNumNonStrictInvariants;
    }

    @Override
    public boolean isNonDecreasingInvariants() {
        return this.mNonDecreasingInvariants;
    }

    @Override
    public boolean isSimplifyTerminationArgument() {
        return this.mSimplifyTerminationArgument;
    }

    @Override
    public boolean isSimplifySupportingInvariants() {
        return this.mSimplifySupportingInvariants;
    }

    @Override
    public boolean isOverapproximateStem() {
        return this.mOverapproximateStem;
    }
}

