/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination;

import de.uni_freiburg.informatik.ultimate.lassoranker.termination.SupportingInvariant;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class TerminationArgument
implements Serializable {
    private static final long serialVersionUID = 3480670605705583627L;
    private final RankingFunction mranking_function;
    private final Collection<SupportingInvariant> msupporting_invariants;
    private final Set<Term> mArrayIndexSupportingInvariants;

    public TerminationArgument(RankingFunction ranking_function, Collection<SupportingInvariant> supporting_invariants, Set<Term> arrayIndexSupportingInvariants) {
        assert (ranking_function != null);
        this.mranking_function = ranking_function;
        assert (supporting_invariants != null);
        this.msupporting_invariants = new ArrayList<SupportingInvariant>();
        for (SupportingInvariant si : supporting_invariants) {
            if (si.isTrue()) continue;
            this.msupporting_invariants.add(si);
        }
        this.mArrayIndexSupportingInvariants = arrayIndexSupportingInvariants;
    }

    public RankingFunction getRankingFunction() {
        return this.mranking_function;
    }

    public Collection<SupportingInvariant> getSupportingInvariants() {
        return Collections.unmodifiableCollection(this.msupporting_invariants);
    }

    public Collection<Term> getArrayIndexSupportingInvariants() {
        return Collections.unmodifiableCollection(this.mArrayIndexSupportingInvariants);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Termination argument consisting of:\n");
        sb.append("Ranking function ");
        sb.append(this.mranking_function);
        sb.append("\n");
        sb.append("Supporting invariants ");
        sb.append(this.msupporting_invariants);
        return sb.toString();
    }
}

