/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.lassoranker.AnalysisType;
import de.uni_freiburg.informatik.ultimate.lassoranker.ArgumentSynthesizer;
import de.uni_freiburg.informatik.ultimate.lassoranker.ILassoRankerPreferences;
import de.uni_freiburg.informatik.ultimate.lassoranker.Lasso;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearTransition;
import de.uni_freiburg.informatik.ultimate.lassoranker.ModelExtractionUtils;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.ITerminationAnalysisSettings;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.MotzkinTransformation;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.StemOverapproximator;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.SupportingInvariant;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.SupportingInvariantGenerator;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.SupportingInvariantSimplifier;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.TerminationAnalysisSettings;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.TerminationArgument;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.RankingTemplate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SolverBuilder;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TerminationArgumentSynthesizer
extends ArgumentSynthesizer {
    private TerminationAnalysisSettings mSettings;
    private final RankingTemplate mTemplate;
    private final Collection<SupportingInvariantGenerator> msi_generators;
    private int mnum_motzkin = 0;
    private RankingFunction mranking_function = null;
    private Collection<SupportingInvariant> mSupportingInvariants = null;
    private final Set<Term> mArrayIndexSupportingInvariants;

    public TerminationArgumentSynthesizer(Lasso lasso, RankingTemplate template, ILassoRankerPreferences preferences, TerminationAnalysisSettings settings, Set<Term> arrayIndexSupportingInvariants, IUltimateServiceProvider services) throws IOException {
        super(lasso, preferences, String.valueOf(template.getName()) + "Template", services);
        this.mSettings = settings;
        this.mLogger.info((Object)("Termination Analysis Settings: " + settings.toString()));
        assert (!this.mSettings.getAnalysis().isDisabled());
        if (this.mSettings.getNumStrictInvariants() == 0 && this.mSettings.getNumNonStrictInvariants() == 0) {
            this.mLogger.info((Object)"Generation of supporting invariants is disabled.");
        }
        if (this.mSettings.getAnalysis().isLinear()) {
            this.mScript.setLogic(Logics.QF_LRA);
        } else {
            this.mScript.setLogic(Logics.QF_NRA);
        }
        if (this.mSettings.getAnalysis() == AnalysisType.LINEAR && !settings.isNonDecreasingInvariants()) {
            this.mLogger.warn((Object)"Termination analysis type is 'Linear', hence invariants must be non-decreasing!");
        }
        this.mTemplate = template;
        this.msi_generators = new ArrayList<SupportingInvariantGenerator>();
        this.mSupportingInvariants = new ArrayList<SupportingInvariant>();
        this.mArrayIndexSupportingInvariants = arrayIndexSupportingInvariants;
    }

    @Override
    protected Script constructScript(ILassoRankerPreferences preferences, String constraintsName) {
        SolverBuilder.SolverMode solverMode = preferences.isAnnotateTerms() ? SolverBuilder.SolverMode.External_ModelsAndUnsatCoreMode : SolverBuilder.SolverMode.External_ModelsMode;
        SolverBuilder.SolverSettings settings = preferences.getSolverConstructionSettings(solverMode, String.valueOf(preferences.getBaseNameOfDumpedScript()) + "+" + constraintsName);
        return SolverBuilder.buildAndInitializeSolver((IUltimateServiceProvider)this.mServices, (SolverBuilder.SolverSettings)settings, (String)"TerminationArgumentSynthesis solver ");
    }

    public Collection<IProgramVar> getSIVars() {
        LinkedHashSet<IProgramVar> result = new LinkedHashSet<IProgramVar>(this.mLasso.getStem().getOutVars().keySet());
        result.retainAll(this.mLasso.getLoop().getInVars().keySet());
        return result;
    }

    public Collection<IProgramVar> getRankVars() {
        LinkedHashSet<IProgramVar> result = new LinkedHashSet<IProgramVar>(this.mLasso.getLoop().getOutVars().keySet());
        result.retainAll(this.mLasso.getLoop().getInVars().keySet());
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private Collection<Term> buildConstraints(LinearTransition stem, LinearTransition loop, RankingTemplate template, Collection<SupportingInvariantGenerator> si_generators) {
        LinearInequality li;
        Rational[] eigenvalue_guesses;
        ArrayList<Term> conj = new ArrayList<Term>();
        Collection<IProgramVar> siVars = this.getSIVars();
        List<List<LinearInequality>> templateConstraints = template.getConstraints(loop.getInVars(), loop.getOutVars());
        List<String> annotations = template.getAnnotations();
        assert (annotations.size() == templateConstraints.size());
        this.mLogger.info((Object)(String.valueOf(stem.getNumPolyhedra()) + " stem disjuncts"));
        this.mLogger.info((Object)(String.valueOf(loop.getNumPolyhedra()) + " loop disjuncts"));
        this.mLogger.info((Object)(String.valueOf(templateConstraints.size()) + " template conjuncts."));
        HashSet<LinearInequality> negated = new HashSet<LinearInequality>();
        for (List<LinearInequality> templateDisj : templateConstraints) {
            for (LinearInequality linearInequality : templateDisj) {
                if (negated.contains(linearInequality)) continue;
                linearInequality.negate();
                negated.add(linearInequality);
            }
        }
        if (this.mSettings.getAnalysis().wantsGuesses()) {
            eigenvalue_guesses = this.mLasso.guessEigenvalues(false);
            assert (eigenvalue_guesses.length >= 2);
        } else {
            eigenvalue_guesses = new Rational[]{};
        }
        int j = 0;
        for (List<LinearInequality> list : loop.getPolyhedra()) {
            ++j;
            int m = 0;
            while (m < templateConstraints.size()) {
                SupportingInvariantGenerator sig;
                MotzkinTransformation motzkin = new MotzkinTransformation(this.mServices, this.mScript, this.mSettings.getAnalysis(), this.mPreferences.isAnnotateTerms());
                motzkin.mAnnotation = String.valueOf(annotations.get(m)) + " " + j;
                motzkin.addInequalities(list);
                motzkin.addInequalities((Collection<LinearInequality>)templateConstraints.get(m));
                assert (this.mSettings.getNumStrictInvariants() >= 0);
                int i = 0;
                while (i < this.mSettings.getNumStrictInvariants()) {
                    sig = new SupportingInvariantGenerator(this.mScript, siVars, true);
                    si_generators.add(sig);
                    motzkin.addInequality(sig.generate(loop.getInVars()));
                    ++i;
                }
                assert (this.mSettings.getNumNonStrictInvariants() >= 0);
                i = 0;
                while (i < this.mSettings.getNumNonStrictInvariants()) {
                    sig = new SupportingInvariantGenerator(this.mScript, siVars, false);
                    si_generators.add(sig);
                    li = sig.generate(loop.getInVars());
                    li.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ONE;
                    motzkin.addInequality(li);
                    ++i;
                }
                this.mLogger.debug((Object)motzkin);
                conj.add(motzkin.transform(eigenvalue_guesses));
                ++m;
            }
        }
        this.mLogger.debug((Object)("Adding the constraints for " + si_generators.size() + " supporting invariants."));
        boolean bl = false;
        for (SupportingInvariantGenerator supportingInvariantGenerator : si_generators) {
            MotzkinTransformation motzkin;
            void var11_14;
            ++var11_14;
            j = 0;
            for (List<LinearInequality> stemConj : stem.getPolyhedra()) {
                motzkin = new MotzkinTransformation(this.mServices, this.mScript, this.mSettings.getAnalysis(), this.mPreferences.isAnnotateTerms());
                motzkin.mAnnotation = "invariant " + (int)var11_14 + " initiation " + ++j;
                motzkin.addInequalities(stemConj);
                li = supportingInvariantGenerator.generate(stem.getOutVars());
                li.negate();
                li.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ONE;
                motzkin.addInequality(li);
                conj.add(motzkin.transform(eigenvalue_guesses));
            }
            j = 0;
            for (List<LinearInequality> loopConj : loop.getPolyhedra()) {
                motzkin = new MotzkinTransformation(this.mServices, this.mScript, this.mSettings.getAnalysis(), this.mPreferences.isAnnotateTerms());
                motzkin.mAnnotation = "invariant " + (int)var11_14 + " consecution " + ++j;
                motzkin.addInequalities(loopConj);
                motzkin.addInequality(supportingInvariantGenerator.generate(loop.getInVars()));
                li = supportingInvariantGenerator.generate(loop.getOutVars());
                li.mMotzkinCoefficient = this.mSettings.isNonDecreasingInvariants() || this.mSettings.getAnalysis() == AnalysisType.LINEAR ? LinearInequality.PossibleMotzkinCoefficients.ZERO_AND_ONE : LinearInequality.PossibleMotzkinCoefficients.ANYTHING;
                li.negate();
                motzkin.addInequality(li);
                conj.add(motzkin.transform(eigenvalue_guesses));
            }
        }
        return conj;
    }

    @Override
    protected Script.LBool doSynthesis() throws SMTLIBException, TermException, IOException {
        this.mTemplate.init(this);
        if (this.mSettings.getAnalysis().isLinear() && this.mTemplate.getDegree() > 0) {
            this.mLogger.warn((Object)"Using a linear SMT query and a templates of degree > 0, hence this method is incomplete.");
        }
        Collection<IProgramVar> rankVars = this.getRankVars();
        Collection<IProgramVar> siVars = this.getSIVars();
        this.mLogger.info((Object)("Template has degree " + this.mTemplate.getDegree() + "."));
        this.mLogger.debug((Object)("Variables for ranking functions: " + rankVars));
        this.mLogger.debug((Object)("Variables for supporting invariants: " + siVars));
        LinearTransition stem = this.mLasso.getStem();
        LinearTransition loop = this.mLasso.getLoop();
        if (this.mLasso.getStem().isTrue()) {
            this.mLogger.info((Object)"There is no stem transition; disabling supporting invariant generation.");
            this.mSettings = new TerminationAnalysisSettings(new ITerminationAnalysisSettings(){

                @Override
                public AnalysisType getAnalysis() {
                    return TerminationArgumentSynthesizer.this.mSettings.getAnalysis();
                }

                @Override
                public int getNumStrictInvariants() {
                    return 0;
                }

                @Override
                public int getNumNonStrictInvariants() {
                    return 0;
                }

                @Override
                public boolean isNonDecreasingInvariants() {
                    return TerminationArgumentSynthesizer.this.mSettings.isNonDecreasingInvariants();
                }

                @Override
                public boolean isSimplifyTerminationArgument() {
                    return TerminationArgumentSynthesizer.this.mSettings.isSimplifyTerminationArgument();
                }

                @Override
                public boolean isSimplifySupportingInvariants() {
                    return TerminationArgumentSynthesizer.this.mSettings.isSimplifySupportingInvariants();
                }

                @Override
                public boolean isOverapproximateStem() {
                    return TerminationArgumentSynthesizer.this.mSettings.isOverapproximateStem();
                }
            });
        } else if (this.mSettings.isOverapproximateStem()) {
            this.mLogger.info((Object)"Overapproximating stem...");
            StemOverapproximator so = new StemOverapproximator(this.mPreferences, this.mServices);
            int stematoms = stem.getNumInequalities();
            stem = so.overapproximate(stem);
            this.mLogger.info((Object)("Reduced " + stematoms + " stem atoms to " + stem.getNumInequalities() + "."));
        }
        Collection<Term> constraints = this.buildConstraints(stem, loop, this.mTemplate, this.msi_generators);
        this.mnum_motzkin = constraints.size();
        this.mLogger.info((Object)("We have " + this.getNumMotzkin() + " Motzkin's Theorem applications."));
        this.mLogger.info((Object)("A total of " + this.getNumSIs() + " supporting invariants were added."));
        for (Term constraint : constraints) {
            this.mScript.assertTerm(constraint);
        }
        Script.LBool sat = this.mScript.checkSat();
        if (sat == Script.LBool.SAT) {
            Map<Term, Rational> val;
            ArrayList<Term> coefficients = new ArrayList<Term>();
            coefficients.addAll(this.mTemplate.getCoefficients());
            for (SupportingInvariantGenerator sig : this.msi_generators) {
                coefficients.addAll(sig.getCoefficients());
            }
            if (this.mSettings.isSimplifyTerminationArgument()) {
                this.mLogger.info((Object)"Found a termination argument, trying to simplify.");
                val = ModelExtractionUtils.getSimplifiedAssignment_TwoMode(this.mScript, coefficients, this.mLogger, this.mServices);
            } else {
                val = ModelExtractionUtils.getValuation(this.mScript, coefficients);
            }
            this.mranking_function = this.mTemplate.extractRankingFunction(val);
            for (SupportingInvariantGenerator sig : this.msi_generators) {
                this.mSupportingInvariants.add(sig.extractSupportingInvariant(val));
            }
            if (this.mSettings.isSimplifySupportingInvariants()) {
                SupportingInvariantSimplifier tas = new SupportingInvariantSimplifier(this.mPreferences, this.mServices);
                this.mLogger.info((Object)"Simplifying supporting invariants...");
                int before = this.mSupportingInvariants.size();
                this.mSupportingInvariants = tas.simplify(this.mSupportingInvariants);
                this.mLogger.info((Object)("Removed " + (before - this.mSupportingInvariants.size()) + " redundant supporting invariants from a total of " + before + "."));
            }
        } else if (sat == Script.LBool.UNKNOWN) {
            this.mScript.echo(new QuotedObject("Warning solver responded UNKNOWN to the check-sat above"));
        }
        return sat;
    }

    public int getNumSIs() {
        assert (this.msi_generators != null);
        return this.msi_generators.size();
    }

    public int getNumMotzkin() {
        return this.mnum_motzkin;
    }

    public TerminationArgument getArgument() {
        assert (this.synthesisSuccessful());
        return new TerminationArgument(this.mranking_function, this.mSupportingInvariants, this.mArrayIndexSupportingInvariants);
    }
}

