/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions;

import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.Ordinal;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class LexicographicRankingFunction
extends RankingFunction {
    private static final long serialVersionUID = -7426526617632086331L;
    private final RankingFunction[] mParts;

    public LexicographicRankingFunction(RankingFunction[] parts) {
        assert (parts.length >= 1);
        this.mParts = parts;
    }

    @Override
    public String getName() {
        return String.valueOf(this.mParts.length) + "-lex";
    }

    public RankingFunction[] getComponents() {
        return this.mParts;
    }

    @Override
    public Set<IProgramVar> getVariables() {
        LinkedHashSet<IProgramVar> vars = new LinkedHashSet<IProgramVar>();
        RankingFunction[] rankingFunctionArray = this.mParts;
        int n = this.mParts.length;
        int n2 = 0;
        while (n2 < n) {
            RankingFunction rf = rankingFunctionArray[n2];
            vars.addAll(rf.getVariables());
            ++n2;
        }
        return vars;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mParts.length);
        sb.append("-lexicographic ranking function:\n");
        sb.append("  f(");
        boolean first = true;
        for (IProgramVar var : this.getVariables()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(var.getGloballyUniqueId());
            first = false;
        }
        sb.append(") = <");
        int i = 0;
        while (i < this.mParts.length) {
            if (i > 0) {
                sb.append(",  ");
            }
            sb.append(this.mParts[i]);
            ++i;
        }
        sb.append(">");
        return sb.toString();
    }

    @Override
    public Term[] asLexTerm(Script script) throws SMTLIBException {
        ArrayList<Term> lex = new ArrayList<Term>();
        int i = 0;
        while (i < this.mParts.length) {
            Term[] lex_part = this.mParts[i].asLexTerm(script);
            int j = 0;
            while (j < lex_part.length) {
                lex.add(lex_part[j]);
                ++j;
            }
            ++i;
        }
        return lex.toArray(new Term[lex.size()]);
    }

    @Override
    public Ordinal evaluate(Map<IProgramVar, Rational> assignment) {
        Ordinal o = Ordinal.ZERO;
        return o;
    }

    @Override
    public Ordinal codomain() {
        return Ordinal.OMEGA;
    }
}

