/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions;

import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.Ordinal;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigInteger;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class MultiphaseRankingFunction
extends RankingFunction {
    private static final long serialVersionUID = 5376322220596462295L;
    private final AffineFunction[] mRanking;
    private final int mPhases;

    public MultiphaseRankingFunction(AffineFunction[] ranking) {
        this.mRanking = ranking;
        this.mPhases = ranking.length;
        assert (this.mPhases > 0);
    }

    @Override
    public String getName() {
        return String.valueOf(this.mRanking.length) + "-phase";
    }

    @Override
    public Set<IProgramVar> getVariables() {
        LinkedHashSet<IProgramVar> vars = new LinkedHashSet<IProgramVar>();
        AffineFunction[] affineFunctionArray = this.mRanking;
        int n = this.mRanking.length;
        int n2 = 0;
        while (n2 < n) {
            AffineFunction af = affineFunctionArray[n2];
            vars.addAll(af.getVariables());
            ++n2;
        }
        return vars;
    }

    public AffineFunction[] getComponents() {
        return this.mRanking;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mRanking.length);
        sb.append("-phase ranking function:\n");
        int i = 0;
        while (i < this.mPhases) {
            sb.append("  f" + i);
            sb.append(" = ");
            sb.append(this.mRanking[i]);
            if (i < this.mPhases - 1) {
                sb.append("\n");
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public Term[] asLexTerm(Script script) throws SMTLIBException {
        BigInteger n = BigInteger.ZERO;
        Term phase = SmtUtils.constructIntValue((Script)script, (BigInteger)n);
        Term value = this.mRanking[this.mRanking.length - 1].asTerm(script);
        int i = this.mRanking.length - 2;
        while (i >= 0) {
            n = n.add(BigInteger.ONE);
            Term f_term = this.mRanking[i].asTerm(script);
            Term cond = script.term(">", new Term[]{f_term, SmtUtils.constructIntValue((Script)script, (BigInteger)BigInteger.ZERO)});
            phase = script.term("ite", new Term[]{cond, SmtUtils.constructIntValue((Script)script, (BigInteger)n), phase});
            value = script.term("ite", new Term[]{cond, f_term, value});
            --i;
        }
        return new Term[]{phase, value};
    }

    @Override
    public Ordinal evaluate(Map<IProgramVar, Rational> assignment) {
        Ordinal o = Ordinal.ZERO;
        int i = 0;
        while (i < this.mPhases) {
            Rational r = this.mRanking[i].evaluate(assignment);
            if (r.compareTo(Rational.ZERO) > 0) {
                return o.add(Ordinal.fromInteger(r.ceil().numerator()));
            }
            o = o.add(Ordinal.OMEGA);
            ++i;
        }
        assert (false);
        return o;
    }

    @Override
    public Ordinal codomain() {
        return Ordinal.fromInteger(BigInteger.valueOf(this.mPhases)).mult(Ordinal.OMEGA);
    }
}

