/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Ordinal
implements Comparable<Ordinal> {
    public static final Ordinal ZERO = new Ordinal(BigInteger.ZERO);
    public static final Ordinal ONE = new Ordinal(BigInteger.ONE);
    public static final Ordinal OMEGA = new Ordinal(ONE);
    private final List<Component> mcomponents;

    public static Ordinal fromInteger(BigInteger i) {
        if (!i.abs().equals(i)) {
            throw new IllegalArgumentException("There are no negative ordinals.");
        }
        if (i.equals(BigInteger.ZERO)) {
            return ZERO;
        }
        if (i.equals(BigInteger.ONE)) {
            return ONE;
        }
        return new Ordinal(i);
    }

    private Ordinal(BigInteger i) {
        assert (i.abs().equals(i));
        this.mcomponents = i.equals(BigInteger.ZERO) ? Collections.emptyList() : Collections.singletonList(new Component(i, ZERO));
    }

    private Ordinal(Ordinal exponent) {
        this.mcomponents = Collections.singletonList(new Component(BigInteger.ONE, exponent));
    }

    private Ordinal(List<Component> components) {
        this.mcomponents = Collections.unmodifiableList(components);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Ordinal) {
            Ordinal o = (Ordinal)obj;
            return this.compareTo(o) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(Ordinal o) {
        if (o.isZero()) {
            if (this.isZero()) {
                return 0;
            }
            return 1;
        }
        if (this.isZero()) {
            return -1;
        }
        int i = 0;
        while (i < this.mcomponents.size()) {
            Component c = this.mcomponents.get(i);
            if (i >= o.mcomponents.size()) {
                return 1;
            }
            Component co = o.mcomponents.get(i);
            int z = c.exponent.compareTo(co.exponent);
            if (z != 0) {
                return z;
            }
            z = c.base.compareTo(co.base);
            if (z != 0) {
                return z;
            }
            ++i;
        }
        if (this.mcomponents.size() < o.mcomponents.size()) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        return this.mcomponents.hashCode();
    }

    public boolean isZero() {
        return this.mcomponents.isEmpty();
    }

    public boolean isFinite() {
        return this.isZero() || this.mcomponents.size() == 1 && this.mcomponents.get((int)0).exponent.isZero();
    }

    public BigInteger toInteger() {
        if (!this.isFinite()) {
            return null;
        }
        if (this.isZero()) {
            return BigInteger.ZERO;
        }
        return this.mcomponents.get((int)(this.mcomponents.size() - 1)).base;
    }

    public boolean isLimit() {
        if (this.mcomponents.isEmpty()) {
            return false;
        }
        Component last = this.mcomponents.get(this.mcomponents.size() - 1);
        return !last.exponent.isZero();
    }

    public Ordinal add(Ordinal o) {
        if (this.isFinite() && o.isFinite()) {
            return new Ordinal(this.toInteger().add(o.toInteger()));
        }
        if (this.compareTo(o) < 0) {
            return o;
        }
        if (o.isZero()) {
            return this;
        }
        ArrayList<Component> result = new ArrayList<Component>();
        Ordinal oexp = o.mcomponents.get((int)0).exponent;
        Component last = null;
        for (Component c : this.mcomponents) {
            if (c.exponent.compareTo(oexp) > 0) {
                result.add(c);
                continue;
            }
            last = c;
            break;
        }
        if (last != null && last.exponent.compareTo(oexp) == 0) {
            result.add(new Component(last.base.add(o.mcomponents.get((int)0).base), oexp));
            int i = 1;
            while (i < o.mcomponents.size()) {
                result.add(o.mcomponents.get(i));
                ++i;
            }
        } else {
            result.addAll(o.mcomponents);
        }
        return new Ordinal(result);
    }

    public Ordinal mult(Ordinal o) {
        if (this.isZero()) {
            return ZERO;
        }
        ArrayList<Component> result = new ArrayList<Component>();
        Component c = this.mcomponents.get(0);
        BigInteger last = null;
        for (Component co : o.mcomponents) {
            if (co.exponent.isZero()) {
                last = co.base;
                break;
            }
            result.add(new Component(co.base, c.exponent.add(co.exponent)));
        }
        if (last != null) {
            result.add(new Component(c.base.multiply(last), c.exponent));
            int i = 1;
            while (i < this.mcomponents.size()) {
                result.add(this.mcomponents.get(i));
                ++i;
            }
        }
        return new Ordinal(result);
    }

    public String toString() {
        if (this.isZero()) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Component c : this.mcomponents) {
            if (!first) {
                sb.append(" + ");
            }
            sb.append(c);
            first = false;
        }
        return sb.toString();
    }

    public static void testcases() {
        assert (!ONE.isZero());
        assert (ONE.isFinite());
        assert (!ZERO.equals(ONE));
        assert (OMEGA.isLimit());
        assert (!OMEGA.isFinite());
        assert (!OMEGA.isZero());
        assert (OMEGA.add(ZERO).equals(OMEGA));
        assert (!OMEGA.add(ONE).equals(OMEGA));
        assert (ONE.add(OMEGA).equals(OMEGA));
        assert (OMEGA.mult(ONE).equals(OMEGA));
        assert (!OMEGA.mult(OMEGA).equals(OMEGA));
    }

    private class Component {
        final BigInteger base;
        final Ordinal exponent;

        Component(BigInteger base, Ordinal exponent) {
            assert (base.compareTo(BigInteger.ZERO) > 0);
            this.base = base;
            this.exponent = exponent;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.exponent.equals(ONE)) {
                sb.append("w");
            } else if (!this.exponent.isZero()) {
                String s = this.exponent.toString();
                sb.append("w^");
                if (s.contains(" ")) {
                    sb.append("(");
                    sb.append(s);
                    sb.append(")");
                } else {
                    sb.append(s);
                }
            }
            if (this.exponent.isZero()) {
                sb.append(this.base);
            } else if (!this.base.equals(BigInteger.ONE)) {
                sb.append(" * ");
                sb.append(this.base);
            }
            return sb.toString();
        }
    }
}

