/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions;

import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.Ordinal;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigInteger;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ParallelRankingFunction
extends RankingFunction {
    private static final long serialVersionUID = -8148235363885204843L;
    private final AffineFunction[] mranking;
    public final int size;

    public ParallelRankingFunction(AffineFunction[] ranking) {
        this.mranking = ranking;
        this.size = ranking.length;
        assert (this.size > 0);
    }

    @Override
    public String getName() {
        return String.valueOf(this.mranking.length) + "-parallel";
    }

    @Override
    public Set<IProgramVar> getVariables() {
        LinkedHashSet<IProgramVar> vars = new LinkedHashSet<IProgramVar>();
        AffineFunction[] affineFunctionArray = this.mranking;
        int n = this.mranking.length;
        int n2 = 0;
        while (n2 < n) {
            AffineFunction af = affineFunctionArray[n2];
            vars.addAll(af.getVariables());
            ++n2;
        }
        return vars;
    }

    public AffineFunction[] getComponents() {
        return this.mranking;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mranking.length);
        sb.append("-parallel ranking function:\n");
        sb.append("f = ");
        int i = 0;
        while (i < this.size) {
            if (i > 0) {
                sb.append(" + ");
            }
            sb.append("max{0, ");
            sb.append(this.mranking[i]);
            sb.append("}");
            ++i;
        }
        return sb.toString();
    }

    @Override
    public Term[] asLexTerm(Script script) throws SMTLIBException {
        Term zero = SmtUtils.constructIntValue((Script)script, (BigInteger)BigInteger.ZERO);
        Term[] summands = new Term[this.size];
        int i = 0;
        while (i < this.size) {
            Term f_term = this.mranking[i].asTerm(script);
            Term cond = script.term(">", new Term[]{f_term, zero});
            summands[i] = script.term("ite", new Term[]{cond, f_term, zero});
            ++i;
        }
        return new Term[]{script.term("+", summands)};
    }

    @Override
    public Ordinal evaluate(Map<IProgramVar, Rational> assignment) {
        Ordinal o = Ordinal.ZERO;
        int i = 0;
        while (i < this.size) {
            Rational r = this.mranking[i].evaluate(assignment);
            if (r.compareTo(Rational.ZERO) > 0) {
                o = o.add(Ordinal.fromInteger(r.ceil().numerator()));
            }
            ++i;
        }
        return o;
    }

    @Override
    public Ordinal codomain() {
        return Ordinal.OMEGA;
    }
}

