/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions;

import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.Ordinal;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigInteger;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class PiecewiseRankingFunction
extends RankingFunction {
    private static final long serialVersionUID = 1605612582853046558L;
    private final AffineFunction[] mranking;
    private final AffineFunction[] mpredicates;
    public final int pieces;

    public PiecewiseRankingFunction(AffineFunction[] ranking, AffineFunction[] predicates) {
        this.mranking = ranking;
        this.mpredicates = predicates;
        this.pieces = ranking.length;
        assert (this.pieces > 0);
        assert (this.pieces == predicates.length);
    }

    @Override
    public String getName() {
        return String.valueOf(this.mranking.length) + "-piece";
    }

    @Override
    public Set<IProgramVar> getVariables() {
        LinkedHashSet<IProgramVar> vars = new LinkedHashSet<IProgramVar>();
        AffineFunction[] affineFunctionArray = this.mranking;
        int n = this.mranking.length;
        int n2 = 0;
        while (n2 < n) {
            AffineFunction af = affineFunctionArray[n2];
            vars.addAll(af.getVariables());
            ++n2;
        }
        return vars;
    }

    public AffineFunction[] getRankingComponents() {
        return this.mranking;
    }

    public AffineFunction[] getPredicates() {
        return this.mpredicates;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mranking.length);
        sb.append("-piece ranking function:\n");
        sb.append("  f(");
        boolean first = true;
        for (IProgramVar var : this.getVariables()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(var.getGloballyUniqueId());
            first = false;
        }
        sb.append(") = {\n");
        int i = 0;
        while (i < this.pieces) {
            sb.append("    ");
            sb.append(this.mranking[i]);
            sb.append(",\tif ");
            sb.append(this.mpredicates[i]);
            sb.append(" >= 0");
            if (i < this.pieces - 1) {
                sb.append(",\n");
            } else {
                sb.append(".");
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public Term[] asLexTerm(Script script) throws SMTLIBException {
        Term value = SmtUtils.constructIntValue((Script)script, (BigInteger)BigInteger.ZERO);
        int i = this.mranking.length - 1;
        while (i >= 0) {
            AffineFunction af = this.mranking[i];
            AffineFunction gf = this.mpredicates[i];
            Term pred = script.term(">=", new Term[]{gf.asTerm(script), SmtUtils.constructIntValue((Script)script, (BigInteger)BigInteger.ZERO)});
            value = script.term("ite", new Term[]{pred, af.asTerm(script), value});
            --i;
        }
        return new Term[]{value};
    }

    @Override
    public Ordinal evaluate(Map<IProgramVar, Rational> assignment) {
        Rational r = Rational.ZERO;
        int i = 0;
        while (i < this.pieces) {
            Rational rnew;
            if (!this.mpredicates[i].evaluate(assignment).isNegative() && (rnew = this.mranking[i].evaluate(assignment)).compareTo(r) > 0) {
                r = rnew;
            }
            ++i;
        }
        return Ordinal.fromInteger(r.ceil().numerator());
    }

    @Override
    public Ordinal codomain() {
        return Ordinal.OMEGA;
    }
}

