/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates;

import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.LexicographicRankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.ComposableTemplate;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.TemplateComposition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ComposedLexicographicTemplate
extends ComposableTemplate {
    ComposableTemplate[] mParts;

    public ComposedLexicographicTemplate(ComposableTemplate[] parts) {
        assert (parts.length >= 1);
        this.mParts = parts;
    }

    @Override
    protected void init() {
        ComposableTemplate[] composableTemplateArray = this.mParts;
        int n = this.mParts.length;
        int n2 = 0;
        while (n2 < n) {
            ComposableTemplate t = composableTemplateArray[n2];
            t.init(this.mTAS);
            ++n2;
        }
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder();
        sb.append("lex(");
        boolean first = true;
        ComposableTemplate[] composableTemplateArray = this.mParts;
        int n = this.mParts.length;
        int n2 = 0;
        while (n2 < n) {
            ComposableTemplate t = composableTemplateArray[n2];
            if (!first) {
                sb.append(", ");
            }
            sb.append(t.getName());
            first = false;
            ++n2;
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public List<List<LinearInequality>> getConstraintsDec(Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars) {
        ArrayList constraints = new ArrayList();
        ArrayList<List<List<LinearInequality>>> disjunction = new ArrayList<List<List<LinearInequality>>>();
        ComposableTemplate[] composableTemplateArray = this.mParts;
        int n = this.mParts.length;
        int n2 = 0;
        while (n2 < n) {
            ComposableTemplate t = composableTemplateArray[n2];
            disjunction.add(t.getConstraintsDec(inVars, outVars));
            ++n2;
        }
        constraints.add(disjunction);
        int i = 0;
        while (i < this.mParts.length - 1) {
            ArrayList<List<List<LinearInequality>>> disjunction2 = new ArrayList<List<List<LinearInequality>>>();
            disjunction2.add(this.mParts[i].getConstraintsNonInc(inVars, outVars));
            int j = 0;
            while (j < i) {
                disjunction2.add(this.mParts[j].getConstraintsDec(inVars, outVars));
                ++j;
            }
            constraints.add(disjunction2);
            ++i;
        }
        List<List<LinearInequality>> cnf = TemplateComposition.distribute(constraints);
        TemplateComposition.resetMotzkin(cnf);
        return cnf;
    }

    @Override
    public List<List<LinearInequality>> getConstraintsNonInc(Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars) {
        ArrayList constraints = new ArrayList();
        int i = 0;
        while (i < this.mParts.length) {
            ArrayList<List<List<LinearInequality>>> disjunction = new ArrayList<List<List<LinearInequality>>>();
            disjunction.add(this.mParts[i].getConstraintsNonInc(inVars, outVars));
            int j = 0;
            while (j < i) {
                disjunction.add(this.mParts[j].getConstraintsDec(inVars, outVars));
                ++j;
            }
            constraints.add(disjunction);
            ++i;
        }
        List<List<LinearInequality>> cnf = TemplateComposition.distribute(constraints);
        TemplateComposition.resetMotzkin(cnf);
        return cnf;
    }

    @Override
    public List<List<LinearInequality>> getConstraintsBounded(Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars) {
        ArrayList constraints = new ArrayList();
        ComposableTemplate[] composableTemplateArray = this.mParts;
        int n = this.mParts.length;
        int n2 = 0;
        while (n2 < n) {
            ComposableTemplate t = composableTemplateArray[n2];
            constraints.add(Collections.singletonList(t.getConstraintsBounded(inVars, outVars)));
            ++n2;
        }
        List<List<LinearInequality>> cnf = TemplateComposition.distribute(constraints);
        TemplateComposition.resetMotzkin(cnf);
        return cnf;
    }

    private List<String> blankAnnotations(int size) {
        ArrayList<String> annotations = new ArrayList<String>(size);
        int i = 0;
        while (i < size) {
            annotations.add("");
            ++i;
        }
        return annotations;
    }

    @Override
    public List<String> getAnnotationsDec() {
        Map<IProgramVar, TermVariable> empty = Collections.emptyMap();
        return this.blankAnnotations(this.getConstraintsDec(empty, empty).size());
    }

    @Override
    public List<String> getAnnotationsNonInc() {
        Map<IProgramVar, TermVariable> empty = Collections.emptyMap();
        return this.blankAnnotations(this.getConstraintsNonInc(empty, empty).size());
    }

    @Override
    public List<String> getAnnotationsBounded() {
        Map<IProgramVar, TermVariable> empty = Collections.emptyMap();
        return this.blankAnnotations(this.getConstraintsBounded(empty, empty).size());
    }

    public String toString() {
        return "";
    }

    @Override
    public Collection<Term> getCoefficients() {
        ArrayList<Term> variables = new ArrayList<Term>();
        ComposableTemplate[] composableTemplateArray = this.mParts;
        int n = this.mParts.length;
        int n2 = 0;
        while (n2 < n) {
            ComposableTemplate t = composableTemplateArray[n2];
            variables.addAll(t.getCoefficients());
            ++n2;
        }
        return variables;
    }

    @Override
    public int getDegree() {
        Map<IProgramVar, TermVariable> empty = Collections.emptyMap();
        return TemplateComposition.computeDegree(this.getConstraintsBounded(empty, empty)) + TemplateComposition.computeDegree(this.getConstraintsDec(empty, empty));
    }

    @Override
    public RankingFunction extractRankingFunction(Map<Term, Rational> val) throws SMTLIBException {
        RankingFunction[] rfs = new RankingFunction[this.mParts.length];
        int i = 0;
        while (i < this.mParts.length) {
            rfs[i] = this.mParts[i].extractRankingFunction(val);
            ++i;
        }
        return new LexicographicRankingFunction(rfs);
    }
}

