/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates;

import de.uni_freiburg.informatik.ultimate.lassoranker.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunctionGenerator;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.LexicographicRankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.LinearRankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.RankingTemplate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class LexicographicTemplate
extends RankingTemplate {
    public final int size;
    private static final String s_name_delta = "delta";
    private static final String s_name_function = "rank";
    private final Term[] mdeltas;
    private final AffineFunctionGenerator[] mfgens;

    public LexicographicTemplate(int numlex) {
        assert (numlex > 1);
        this.size = numlex;
        this.mdeltas = new Term[this.size];
        this.mfgens = new AffineFunctionGenerator[this.size];
    }

    @Override
    protected void init() {
        int i = 0;
        while (i < this.size) {
            this.mdeltas[i] = this.newDelta(s_name_delta + i);
            this.mfgens[i] = new AffineFunctionGenerator(this.mScript, this.mVariables, s_name_function + i);
            ++i;
        }
    }

    @Override
    public String getName() {
        return String.valueOf(this.size) + "-lex";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.size);
        sb.append("-lex template:\n   ");
        int i = 0;
        while (i < this.size) {
            sb.append("delta_" + i + " > 0\n/\\ ");
            ++i;
        }
        i = 0;
        while (i < this.size) {
            sb.append("f_" + i + "(x) > 0\n/\\ ");
            ++i;
        }
        i = 0;
        while (i < this.size - 1) {
            sb.append("( f_" + i + "(x') <= f_" + i + "(x)");
            int j = i - 1;
            while (j >= 0) {
                sb.append(" \\/ f_" + j + "(x') < f_" + j + "(x) - delta_" + j);
                --j;
            }
            sb.append(" )\n/\\ ");
            ++i;
        }
        sb.append("( ");
        i = 0;
        while (i < this.size) {
            sb.append("f_" + i + "(x') < f_" + i + "(x) - delta_" + i);
            if (i < this.size - 1) {
                sb.append(" \\/ ");
            }
            ++i;
        }
        sb.append(" )");
        return sb.toString();
    }

    @Override
    public List<List<LinearInequality>> getConstraints(Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars) {
        LinearInequality li2;
        LinearInequality li;
        this.checkInitialized();
        ArrayList<List<LinearInequality>> conjunction = new ArrayList<List<LinearInequality>>();
        int i = 0;
        while (i < this.size) {
            LinearInequality li3 = this.mfgens[i].generate(inVars);
            li3.setStrict(true);
            li3.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ONE;
            conjunction.add(Collections.singletonList(li3));
            ++i;
        }
        i = 0;
        while (i < this.size - 1) {
            ArrayList<LinearInequality> disjunction = new ArrayList<LinearInequality>();
            li = this.mfgens[i].generate(inVars);
            li2 = this.mfgens[i].generate(outVars);
            li2.negate();
            li.add(li2);
            li.setStrict(false);
            li.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ZERO_AND_ONE;
            disjunction.add(li);
            int j = i - 1;
            while (j >= 0) {
                li = this.mfgens[j].generate(inVars);
                LinearInequality li3 = this.mfgens[j].generate(outVars);
                li3.negate();
                li.add(li3);
                AffineTerm a = new AffineTerm(this.mdeltas[j], Rational.MONE);
                li.add(a);
                li.setStrict(true);
                li.mMotzkinCoefficient = j == 0 ? LinearInequality.PossibleMotzkinCoefficients.ZERO_AND_ONE : LinearInequality.PossibleMotzkinCoefficients.ANYTHING;
                disjunction.add(li);
                --j;
            }
            conjunction.add(disjunction);
            ++i;
        }
        ArrayList<LinearInequality> disjunction = new ArrayList<LinearInequality>();
        int i2 = 0;
        while (i2 < this.size) {
            li = this.mfgens[i2].generate(inVars);
            li2 = this.mfgens[i2].generate(outVars);
            li2.negate();
            li.add(li2);
            AffineTerm a = new AffineTerm(this.mdeltas[i2], Rational.MONE);
            li.add(a);
            li.setStrict(true);
            li.mMotzkinCoefficient = i2 == 0 || i2 == this.size - 1 ? LinearInequality.PossibleMotzkinCoefficients.ZERO_AND_ONE : LinearInequality.PossibleMotzkinCoefficients.ANYTHING;
            disjunction.add(li);
            ++i2;
        }
        conjunction.add(disjunction);
        return conjunction;
    }

    @Override
    public Collection<Term> getCoefficients() {
        ArrayList<Term> list = new ArrayList<Term>();
        int i = 0;
        while (i < this.size) {
            list.addAll(this.mfgens[i].getCoefficients());
            list.add(this.mdeltas[i]);
            ++i;
        }
        return list;
    }

    @Override
    public RankingFunction extractRankingFunction(Map<Term, Rational> val) throws SMTLIBException {
        RankingFunction[] rfs = new RankingFunction[this.size];
        int i = 0;
        while (i < this.size) {
            AffineFunction af = this.mfgens[i].extractAffineFunction(val);
            rfs[i] = new LinearRankingFunction(af);
            ++i;
        }
        return new LexicographicRankingFunction(rfs);
    }

    @Override
    public List<String> getAnnotations() {
        ArrayList<String> annotations = new ArrayList<String>();
        int i = 0;
        while (i < this.size) {
            annotations.add("rank f" + i + " is bounded");
            ++i;
        }
        i = 0;
        while (i < this.size - 1) {
            annotations.add("rank f" + i + " is not increasing unless " + "a smaller index decreases");
            ++i;
        }
        annotations.add("at least one rank index decreases");
        return annotations;
    }

    @Override
    public int getDegree() {
        assert (this.size > 0);
        return this.size * (this.size - 1) / 2;
    }
}

