/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates;

import de.uni_freiburg.informatik.ultimate.lassoranker.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunctionGenerator;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.MultiphaseRankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.ComposableTemplate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MultiphaseTemplate
extends ComposableTemplate {
    public final int size;
    private static final String s_name_delta = "delta_";
    private static final String s_name_function = "rank_";
    private final Term[] mdeltas;
    private final AffineFunctionGenerator[] mfgens;

    public MultiphaseTemplate(int numphases) {
        assert (numphases > 1);
        this.size = numphases;
        this.mdeltas = new Term[this.size];
        this.mfgens = new AffineFunctionGenerator[this.size];
    }

    @Override
    protected void init() {
        int i = 0;
        while (i < this.size) {
            this.mdeltas[i] = this.newDelta(s_name_delta + this.getInstanceNumber() + "_" + i);
            this.mfgens[i] = new AffineFunctionGenerator(this.mScript, this.mVariables, s_name_function + this.getInstanceNumber() + "_" + i);
            ++i;
        }
    }

    @Override
    public String getName() {
        return String.valueOf(this.size) + "-phase";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.size);
        sb.append("-phase template:\n   ");
        int i = 0;
        while (i < this.size) {
            sb.append(s_name_delta + i + " > 0\n/\\ ");
            ++i;
        }
        sb.append("( ");
        i = 0;
        while (i < this.size) {
            if (i > 0) {
                sb.append(" \\/ ");
            }
            sb.append("f_" + i + "(x) > 0");
            ++i;
        }
        sb.append(" )\n");
        i = 0;
        while (i < this.size) {
            sb.append("/\\ ");
            sb.append(i > 0 ? "( " : "  ");
            sb.append("f_" + i + "(x') < f_" + i + "(x) - delta_" + i);
            if (i > 0) {
                sb.append(" \\/ f_" + (i - 1) + "(x) > 0 )");
            }
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    @Override
    public Collection<Term> getCoefficients() {
        ArrayList<Term> list = new ArrayList<Term>();
        int i = 0;
        while (i < this.size) {
            list.addAll(this.mfgens[i].getCoefficients());
            list.add(this.mdeltas[i]);
            ++i;
        }
        return list;
    }

    @Override
    public RankingFunction extractRankingFunction(Map<Term, Rational> val) throws SMTLIBException {
        AffineFunction[] fs = new AffineFunction[this.size];
        int i = 0;
        while (i < this.size) {
            fs[i] = this.mfgens[i].extractAffineFunction(val);
            ++i;
        }
        return new MultiphaseRankingFunction(fs);
    }

    @Override
    public int getDegree() {
        assert (this.size > 0);
        return this.size - 1;
    }

    @Override
    public List<List<LinearInequality>> getConstraintsDec(Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars) {
        ArrayList<List<LinearInequality>> conjunction = new ArrayList<List<LinearInequality>>();
        int i = 0;
        while (i < this.size) {
            ArrayList<LinearInequality> disjunction = new ArrayList<LinearInequality>();
            LinearInequality li = this.mfgens[i].generate(inVars);
            LinearInequality li2 = this.mfgens[i].generate(outVars);
            li2.negate();
            li.add(li2);
            AffineTerm a = new AffineTerm(this.mdeltas[i], Rational.MONE);
            li.add(a);
            li.setStrict(true);
            li.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ZERO_AND_ONE;
            disjunction.add(li);
            if (i > 0) {
                LinearInequality li3 = this.mfgens[i - 1].generate(inVars);
                li3.setStrict(true);
                li3.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ZERO_AND_ONE;
                disjunction.add(li3);
            }
            conjunction.add(disjunction);
            ++i;
        }
        return conjunction;
    }

    @Override
    public List<List<LinearInequality>> getConstraintsNonInc(Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars) {
        ArrayList<List<LinearInequality>> conjunction = new ArrayList<List<LinearInequality>>();
        int i = 0;
        while (i < this.size) {
            ArrayList<LinearInequality> disjunction = new ArrayList<LinearInequality>();
            LinearInequality li = this.mfgens[i].generate(inVars);
            LinearInequality li2 = this.mfgens[i].generate(outVars);
            li2.negate();
            li.add(li2);
            li.setStrict(false);
            li.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ZERO_AND_ONE;
            disjunction.add(li);
            if (i > 0) {
                LinearInequality li3 = this.mfgens[i - 1].generate(inVars);
                li3.setStrict(true);
                li3.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ZERO_AND_ONE;
                disjunction.add(li3);
            }
            conjunction.add(disjunction);
            ++i;
        }
        return conjunction;
    }

    @Override
    public List<List<LinearInequality>> getConstraintsBounded(Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars) {
        ArrayList<LinearInequality> disjunction = new ArrayList<LinearInequality>();
        int i = 0;
        while (i < this.size) {
            LinearInequality li = this.mfgens[i].generate(inVars);
            li.setStrict(true);
            li.mMotzkinCoefficient = i == 0 || i > 0 ? LinearInequality.PossibleMotzkinCoefficients.ZERO_AND_ONE : LinearInequality.PossibleMotzkinCoefficients.ANYTHING;
            disjunction.add(li);
            ++i;
        }
        return Collections.singletonList(disjunction);
    }

    @Override
    public List<String> getAnnotationsDec() {
        ArrayList<String> annotations = new ArrayList<String>();
        int i = 0;
        while (i < this.size) {
            annotations.add("rank f" + i + " is decreasing in phase " + i);
            ++i;
        }
        return annotations;
    }

    @Override
    public List<String> getAnnotationsNonInc() {
        ArrayList<String> annotations = new ArrayList<String>();
        int i = 0;
        while (i < this.size) {
            annotations.add("rank f" + i + " is nonincreasing in phase " + i);
            ++i;
        }
        return annotations;
    }

    @Override
    public List<String> getAnnotationsBounded() {
        return Collections.singletonList("one of the ranks is bounded");
    }
}

