/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates;

import de.uni_freiburg.informatik.ultimate.lassoranker.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunctionGenerator;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.NestedRankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.ComposableTemplate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class NestedTemplate
extends ComposableTemplate {
    public final int mSize;
    private static final String s_name_delta = "delta_";
    private static final String s_name_function = "rank_";
    private Term mdelta;
    private final AffineFunctionGenerator[] mfgens;

    public NestedTemplate(int functions) {
        assert (functions > 1);
        this.mSize = functions;
        this.mfgens = new AffineFunctionGenerator[this.mSize];
    }

    @Override
    protected void init() {
        this.mdelta = this.newDelta(s_name_delta + this.getInstanceNumber());
        int i = 0;
        while (i < this.mSize) {
            this.mfgens[i] = new AffineFunctionGenerator(this.mScript, this.mVariables, s_name_function + this.getInstanceNumber() + "_" + i);
            ++i;
        }
    }

    @Override
    public String getName() {
        return String.valueOf(this.mSize) + "-nested";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mSize);
        sb.append("-nested template:");
        sb.append("\n");
        sb.append("   ");
        sb.append("delta > 0");
        sb.append("\n");
        sb.append("/\\ f_0(x') < f_0(x) - delta");
        sb.append("\n");
        int i = 1;
        while (i < this.mSize) {
            sb.append("/\\ f_" + i + "(x') < f_" + i + "(x) + f_" + (i - 1) + "(x)");
            sb.append("\n");
            ++i;
        }
        int n = this.mSize - 1;
        sb.append("/\\ f_" + n + "(x) > 0");
        return sb.toString();
    }

    @Override
    public Collection<Term> getCoefficients() {
        ArrayList<Term> list = new ArrayList<Term>();
        list.add(this.mdelta);
        int i = 0;
        while (i < this.mSize) {
            list.addAll(this.mfgens[i].getCoefficients());
            ++i;
        }
        return list;
    }

    @Override
    public RankingFunction extractRankingFunction(Map<Term, Rational> val) throws SMTLIBException {
        Rational gcd = this.mfgens[0].getGcd(val);
        int i = 1;
        while (i < this.mSize) {
            gcd = gcd.gcd(this.mfgens[i].getGcd(val));
            ++i;
        }
        AffineFunction[] fs = new AffineFunction[this.mSize];
        int i2 = 0;
        while (i2 < this.mSize) {
            fs[i2] = this.mfgens[i2].extractAffineFunction(val, gcd);
            ++i2;
        }
        return new NestedRankingFunction(fs);
    }

    @Override
    public int getDegree() {
        return 0;
    }

    @Override
    public List<List<LinearInequality>> getConstraintsDec(Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars) {
        ArrayList<List<LinearInequality>> conjunction = new ArrayList<List<LinearInequality>>();
        LinearInequality li = this.mfgens[0].generate(inVars);
        LinearInequality li2 = this.mfgens[0].generate(outVars);
        li2.negate();
        li.add(li2);
        AffineTerm a = new AffineTerm(this.mdelta, Rational.MONE);
        li.add(a);
        li.setStrict(true);
        li.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ONE;
        conjunction.add(Collections.singletonList(li));
        int i = 1;
        while (i < this.mSize) {
            LinearInequality li3 = this.mfgens[i].generate(inVars);
            LinearInequality li22 = this.mfgens[i].generate(outVars);
            li22.negate();
            li3.add(li22);
            LinearInequality li32 = this.mfgens[i - 1].generate(inVars);
            li3.add(li32);
            li3.setStrict(true);
            li3.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ONE;
            conjunction.add(Collections.singletonList(li3));
            ++i;
        }
        return conjunction;
    }

    @Override
    public List<List<LinearInequality>> getConstraintsNonInc(Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars) {
        ArrayList<List<LinearInequality>> conjunction = new ArrayList<List<LinearInequality>>();
        int i = 0;
        while (i < this.mSize) {
            LinearInequality li = this.mfgens[i].generate(inVars);
            LinearInequality li2 = this.mfgens[i].generate(outVars);
            li2.negate();
            li.add(li2);
            li.setStrict(false);
            li.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ONE;
            conjunction.add(Collections.singletonList(li));
            ++i;
        }
        return conjunction;
    }

    @Override
    public List<List<LinearInequality>> getConstraintsBounded(Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars) {
        LinearInequality li = this.mfgens[this.mSize - 1].generate(inVars);
        li.setStrict(true);
        li.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ONE;
        return Collections.singletonList(Collections.singletonList(li));
    }

    @Override
    public List<String> getAnnotationsDec() {
        ArrayList<String> annotations = new ArrayList<String>();
        annotations.add("rank f_0 is decreasing");
        int i = 0;
        while (i < this.mSize - 1) {
            annotations.add("rank f_" + i + " is decreasing by at least -f_" + (i - 1));
            ++i;
        }
        return annotations;
    }

    @Override
    public List<String> getAnnotationsNonInc() {
        ArrayList<String> annotations = new ArrayList<String>();
        int i = 0;
        while (i < this.mSize) {
            annotations.add("rank f_" + i + " is nonincreasing");
            ++i;
        }
        return annotations;
    }

    @Override
    public List<String> getAnnotationsBounded() {
        return Collections.singletonList("rank f_" + (this.mSize - 1) + " is bounded");
    }
}

