/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates;

import de.uni_freiburg.informatik.ultimate.lassoranker.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunctionGenerator;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.ParallelRankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.RankingTemplate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ParallelTemplate
extends RankingTemplate {
    public final int size;
    private static final String s_name_delta = "delta";
    private static final String s_name_function = "rank";
    private final Term[] mdeltas;
    private final AffineFunctionGenerator[] mfgens;

    public ParallelTemplate(int numfunctions) {
        assert (numfunctions > 1);
        assert (numfunctions <= 30);
        assert (1 << numfunctions > 0);
        this.size = numfunctions;
        this.mdeltas = new Term[this.size];
        this.mfgens = new AffineFunctionGenerator[this.size];
    }

    @Override
    protected void init() {
        int i = 0;
        while (i < this.size) {
            this.mdeltas[i] = this.newDelta(s_name_delta + i);
            this.mfgens[i] = new AffineFunctionGenerator(this.mScript, this.mVariables, s_name_function + i);
            ++i;
        }
    }

    @Override
    public String getName() {
        return String.valueOf(this.size) + "-parallel";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.size);
        sb.append("-parallel template:\n   ");
        int i = 0;
        while (i < this.size) {
            if (i > 0) {
                sb.append("/\\ ");
            }
            sb.append("delta_" + i + " > 0\n");
            ++i;
        }
        i = 0;
        while (i < this.size) {
            sb.append("/\\ f_" + i + "(x') <= f_" + i + "(x)\n");
            ++i;
        }
        int k = 0;
        while (k < 1 << this.size) {
            sb.append("/\\ ( ");
            int i2 = 0;
            while (i2 < this.size) {
                if ((k & 1 << i2) == 0) {
                    sb.append("f_" + i2 + " > 0");
                } else {
                    sb.append("f_" + i2 + "(x') < f_" + i2 + "(x) - delta_" + i2);
                }
                if (i2 < this.size - 1) {
                    sb.append(" \\/ ");
                }
                ++i2;
            }
            sb.append(" )\n");
            ++k;
        }
        return sb.toString();
    }

    @Override
    public List<List<LinearInequality>> getConstraints(Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars) {
        this.checkInitialized();
        ArrayList<List<LinearInequality>> conjunction = new ArrayList<List<LinearInequality>>();
        int i = 0;
        while (i < this.size) {
            LinearInequality li = this.mfgens[i].generate(inVars);
            LinearInequality li2 = this.mfgens[i].generate(outVars);
            li2.negate();
            li.add(li2);
            li.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ONE;
            conjunction.add(Collections.singletonList(li));
            ++i;
        }
        int k = 0;
        while (k < 1 << this.size) {
            ArrayList<LinearInequality> disjunction = new ArrayList<LinearInequality>();
            int i2 = 0;
            while (i2 < this.size) {
                LinearInequality li;
                if ((k & 1 << i2) == 0) {
                    li = this.mfgens[i2].generate(inVars);
                    li.setStrict(true);
                    li.mMotzkinCoefficient = i2 == 0 ? LinearInequality.PossibleMotzkinCoefficients.ZERO_AND_ONE : LinearInequality.PossibleMotzkinCoefficients.ANYTHING;
                    disjunction.add(li);
                } else {
                    li = this.mfgens[i2].generate(inVars);
                    LinearInequality li2 = this.mfgens[i2].generate(outVars);
                    li2.negate();
                    li.add(li2);
                    AffineTerm a = new AffineTerm(this.mdeltas[i2], Rational.MONE);
                    li.add(a);
                    li.setStrict(true);
                    li.mMotzkinCoefficient = i2 == 0 ? LinearInequality.PossibleMotzkinCoefficients.ZERO_AND_ONE : LinearInequality.PossibleMotzkinCoefficients.ANYTHING;
                    disjunction.add(li);
                }
                ++i2;
            }
            conjunction.add(disjunction);
            ++k;
        }
        return conjunction;
    }

    @Override
    public Collection<Term> getCoefficients() {
        ArrayList<Term> list = new ArrayList<Term>();
        int i = 0;
        while (i < this.size) {
            list.addAll(this.mfgens[i].getCoefficients());
            list.add(this.mdeltas[i]);
            ++i;
        }
        return list;
    }

    @Override
    public RankingFunction extractRankingFunction(Map<Term, Rational> val) throws SMTLIBException {
        AffineFunction[] fs = new AffineFunction[this.size];
        int i = 0;
        while (i < this.size) {
            fs[i] = this.mfgens[i].extractAffineFunction(val);
            ++i;
        }
        return new ParallelRankingFunction(fs);
    }

    @Override
    public List<String> getAnnotations() {
        ArrayList<String> annotations = new ArrayList<String>();
        int i = 0;
        while (i < this.size) {
            annotations.add("rank f" + i + " is not increasing");
            ++i;
        }
        int k = 0;
        while (k < 1 << this.size) {
            StringBuilder sb = new StringBuilder();
            int i2 = 0;
            while (i2 < this.size) {
                if (i2 > 0) {
                    sb.append(" or ");
                }
                if ((k & 1 << i2) == 0) {
                    sb.append("rank f" + i2 + " is positive");
                } else {
                    sb.append("rank f" + i2 + " is decreasing");
                }
                ++i2;
            }
            annotations.add(sb.toString());
            ++k;
        }
        return annotations;
    }

    @Override
    public int getDegree() {
        assert (this.size > 0);
        return (1 << this.size) * (this.size - 1);
    }
}

