/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates;

import de.uni_freiburg.informatik.ultimate.lassoranker.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunctionGenerator;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.PiecewiseRankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.RankingTemplate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PiecewiseTemplate
extends RankingTemplate {
    public final int size;
    private static final String s_name_delta = "delta";
    private static final String s_name_function = "rank";
    private static final String s_name_pred = "pred";
    private Term mdelta;
    private final AffineFunctionGenerator[] mfgens;
    private final AffineFunctionGenerator[] mpgens;

    public PiecewiseTemplate(int numpieces) {
        assert (numpieces >= 2);
        this.size = numpieces;
        this.mfgens = new AffineFunctionGenerator[this.size];
        this.mpgens = new AffineFunctionGenerator[this.size];
    }

    @Override
    protected void init() {
        this.mdelta = this.newDelta(s_name_delta);
        int i = 0;
        while (i < this.size) {
            this.mfgens[i] = new AffineFunctionGenerator(this.mScript, this.mVariables, s_name_function + i);
            this.mpgens[i] = new AffineFunctionGenerator(this.mScript, this.mVariables, s_name_pred + i);
            ++i;
        }
    }

    @Override
    public String getName() {
        return String.valueOf(this.size) + "-piece";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.size);
        sb.append("-piece template:\n");
        sb.append("   delta > 0\n");
        int i = 0;
        while (i < this.size) {
            int j = 0;
            while (j < this.size) {
                sb.append("/\\ ( g_" + i + "(x) < 0 \\/ ");
                sb.append("g_" + j + "(x') < 0 \\/ ");
                sb.append("f_" + j + "(x') < f_" + i + "(x) - delta )\n");
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.size) {
            sb.append("/\\ f_" + i + "(x) > 0\n");
            ++i;
        }
        sb.append("/\\ ( ");
        i = 0;
        while (i < this.size) {
            sb.append("g_" + i + "(x) >= 0");
            if (i < this.size - 1) {
                sb.append(" \\/ ");
            }
            ++i;
        }
        sb.append(" )");
        return sb.toString();
    }

    @Override
    public List<List<LinearInequality>> getConstraints(Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars) {
        this.checkInitialized();
        ArrayList<List<LinearInequality>> conjunction = new ArrayList<List<LinearInequality>>();
        int i = 0;
        while (i < this.size) {
            int j = 0;
            while (j < this.size) {
                ArrayList<LinearInequality> disjunction = new ArrayList<LinearInequality>();
                LinearInequality li1 = this.mpgens[i].generate(inVars);
                li1.negate();
                li1.setStrict(true);
                li1.mMotzkinCoefficient = i == j ? LinearInequality.PossibleMotzkinCoefficients.ZERO_AND_ONE : LinearInequality.PossibleMotzkinCoefficients.ANYTHING;
                disjunction.add(li1);
                LinearInequality li2 = this.mpgens[j].generate(outVars);
                li2.negate();
                li2.setStrict(true);
                li2.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ANYTHING;
                disjunction.add(li2);
                LinearInequality li3 = this.mfgens[i].generate(inVars);
                LinearInequality li4 = this.mfgens[j].generate(outVars);
                li4.negate();
                li3.add(li4);
                AffineTerm a = new AffineTerm(this.mdelta, Rational.MONE);
                li3.add(a);
                li3.setStrict(true);
                li3.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ZERO_AND_ONE;
                disjunction.add(li3);
                conjunction.add(disjunction);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.size) {
            LinearInequality li = this.mfgens[i].generate(inVars);
            li.setStrict(true);
            li.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ONE;
            conjunction.add(Collections.singletonList(li));
            ++i;
        }
        ArrayList<LinearInequality> disjunction = new ArrayList<LinearInequality>();
        int i2 = 0;
        while (i2 < this.size) {
            LinearInequality li = this.mpgens[i2].generate(inVars);
            li.setStrict(false);
            li.mMotzkinCoefficient = i2 == 0 ? LinearInequality.PossibleMotzkinCoefficients.ZERO_AND_ONE : LinearInequality.PossibleMotzkinCoefficients.ANYTHING;
            disjunction.add(li);
            ++i2;
        }
        conjunction.add(disjunction);
        return conjunction;
    }

    @Override
    public Collection<Term> getCoefficients() {
        ArrayList<Term> list = new ArrayList<Term>();
        list.add(this.mdelta);
        int i = 0;
        while (i < this.size) {
            list.addAll(this.mfgens[i].getCoefficients());
            list.addAll(this.mpgens[i].getCoefficients());
            ++i;
        }
        return list;
    }

    @Override
    public RankingFunction extractRankingFunction(Map<Term, Rational> val) throws SMTLIBException {
        Rational gcd_f = this.mfgens[0].getGcd(val);
        int i = 1;
        while (i < this.size) {
            gcd_f = gcd_f.gcd(this.mfgens[i].getGcd(val));
            ++i;
        }
        AffineFunction[] fs = new AffineFunction[this.size];
        AffineFunction[] gs = new AffineFunction[this.size];
        int i2 = 0;
        while (i2 < this.size) {
            fs[i2] = this.mfgens[i2].extractAffineFunction(val, gcd_f);
            gs[i2] = this.mpgens[i2].extractAffineFunction(val);
            ++i2;
        }
        return new PiecewiseRankingFunction(fs, gs);
    }

    @Override
    public List<String> getAnnotations() {
        ArrayList<String> annotations = new ArrayList<String>();
        int i = 0;
        while (i < this.size) {
            int j = 0;
            while (j < this.size) {
                annotations.add("transition from piece " + i + " to piece " + j);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.size) {
            annotations.add("rank f" + i + " is bounded");
            ++i;
        }
        annotations.add("case split is exhaustive");
        return annotations;
    }

    @Override
    public int getDegree() {
        assert (this.size > 0);
        return 2 * this.size * this.size - 1;
    }
}

