/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates;

import de.uni_freiburg.informatik.ultimate.lassoranker.InstanceCounting;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.TerminationArgumentSynthesizer;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class RankingTemplate
extends InstanceCounting {
    public static final boolean RED_ATOMS = true;
    public static final boolean BLUE_ATOMS = true;
    protected Script mScript = null;
    protected TerminationArgumentSynthesizer mTAS = null;
    protected Collection<IProgramVar> mVariables = null;
    private boolean mInitialized = false;

    public final void init(TerminationArgumentSynthesizer tas) {
        this.mTAS = tas;
        this.mScript = tas.getScript();
        this.mVariables = tas.getRankVars();
        this.init();
        this.mInitialized = true;
    }

    protected abstract void init();

    protected void checkInitialized() {
        assert (this.mInitialized);
        assert (this.mTAS != null);
        assert (this.mVariables != null);
    }

    public abstract String getName();

    public abstract List<List<LinearInequality>> getConstraints(Map<IProgramVar, TermVariable> var1, Map<IProgramVar, TermVariable> var2);

    public abstract List<String> getAnnotations();

    public abstract Collection<Term> getCoefficients();

    public abstract int getDegree();

    public abstract RankingFunction extractRankingFunction(Map<Term, Rational> var1) throws SMTLIBException;

    protected Term newDelta(String name) {
        Term delta = this.mTAS.newConstant(name, "Real");
        Term t = this.mScript.term(">", new Term[]{delta, this.mScript.decimal("0")});
        this.mScript.assertTerm(t);
        return delta;
    }
}

