/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates;

import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import java.util.ArrayList;
import java.util.List;

public final class TemplateComposition {
    static <T> List<List<T>> distribute(List<List<List<List<T>>>> constraints) {
        ArrayList<List<T>> conjunction = new ArrayList<List<T>>();
        for (List<List<List<T>>> i : constraints) {
            int j;
            int[] f = new int[i.size()];
            int j2 = 0;
            while (j2 < f.length) {
                assert (!i.get(j2).isEmpty());
                f[j2] = 0;
                ++j2;
            }
            do {
                ArrayList disjuction = new ArrayList();
                j = 0;
                while (j < f.length) {
                    disjuction.addAll(i.get(j).get(f[j]));
                    ++j;
                }
                j = 0;
                while (j < f.length) {
                    int n = j;
                    f[n] = f[n] + 1;
                    if (f[j] < i.get(j).size()) break;
                    f[j] = 0;
                    ++j;
                }
                conjunction.add(disjuction);
            } while (j != f.length);
        }
        return conjunction;
    }

    static void resetMotzkin(List<List<LinearInequality>> constraints) {
        for (List<LinearInequality> disjunction : constraints) {
            for (LinearInequality li : disjunction) {
                li.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ANYTHING;
            }
        }
    }

    static int computeDegree(List<List<LinearInequality>> constraints) {
        int degree = 0;
        for (List<LinearInequality> disjunction : constraints) {
            for (LinearInequality li : disjunction) {
                if (li.mMotzkinCoefficient.isFixed()) continue;
                ++degree;
            }
        }
        return degree;
    }
}

