/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.variables;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.exceptions.TermIsNotAffineException;
import de.uni_freiburg.informatik.ultimate.lassoranker.exceptions.UnknownFunctionException;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.List;

public class InequalityConverter {
    private static LinearInequality convertAtom(ApplicationTerm term) throws TermException {
        LinearInequality res;
        if (term.getParameters().length != 2) {
            throw new TermIsNotAffineException("Unsupported number of parameters", (Term)term);
        }
        String fname = term.getFunction().getName();
        LinearInequality li1 = LinearInequality.fromTerm(term.getParameters()[0]);
        LinearInequality li2 = LinearInequality.fromTerm(term.getParameters()[1]);
        if (fname.equals(">=")) {
            li2.mult(Rational.MONE);
            res = li1;
            res.add(li2);
            res.setStrict(false);
        } else if (fname.equals("<=")) {
            li1.mult(Rational.MONE);
            res = li1;
            res.add(li2);
            res.setStrict(false);
        } else if (fname.equals(">")) {
            li2.mult(Rational.MONE);
            res = li1;
            res.add(li2);
            res.setStrict(true);
        } else if (fname.equals("<")) {
            res = li1;
            res.mult(Rational.MONE);
            res.add(li2);
            res.setStrict(true);
        } else {
            throw new TermIsNotAffineException("Expected an inequality.", (Term)term);
        }
        return res;
    }

    /*
     * Unable to fully structure code
     */
    public static List<LinearInequality> convert(Term term, NlaHandling nlaHandling) throws TermException {
        block8: {
            block9: {
                block7: {
                    terms = new ArrayList<LinearInequality>();
                    if (!(term instanceof ApplicationTerm)) ** GOTO lbl40
                    appt = (ApplicationTerm)term;
                    fname = appt.getFunction().getName();
                    if (!fname.equals("and")) break block7;
                    var8_5 = appt.getParameters();
                    var7_6 = var8_5.length;
                    var6_8 = 0;
                    while (var6_8 < var7_6) {
                        t = var8_5[var6_8];
                        terms.addAll(InequalityConverter.convert(t, nlaHandling));
                        ++var6_8;
                    }
                    break block8;
                }
                if (!fname.equals("true")) break block9;
                li = new LinearInequality();
                terms.add(li);
                break block8;
            }
            if (!fname.equals("=")) ** GOTO lbl34
            param0 = appt.getParameters()[0];
            param0sort = param0.getSort();
            if (param0sort.isNumericSort()) {
                converted = InequalityConverter.tryToConvertAtom(nlaHandling, appt);
                terms.add(converted);
            } else {
                if (SmtSortUtils.isBoolSort((Sort)param0sort)) {
                    throw new TermException("Term is not in DNF", term);
                }
                throw new TermException("Unknown sort in equality", term);
lbl34:
                // 1 sources

                if (fname.equals("<") || fname.equals(">") || fname.equals("<=") || fname.equals(">=")) {
                    converted = InequalityConverter.tryToConvertAtom(nlaHandling, appt);
                    terms.add(converted);
                } else {
                    throw new UnknownFunctionException(appt);
lbl40:
                    // 1 sources

                    if (term instanceof TermVariable) {
                        throw new TermException("Term is not in DNF", term);
                    }
                    throw new TermException("Expected application term", term);
                }
            }
        }
        return terms;
    }

    private static LinearInequality tryToConvertAtom(NlaHandling nlaHandling, ApplicationTerm appt) throws TermException, TermIsNotAffineException {
        LinearInequality converted;
        try {
            converted = InequalityConverter.convertAtom(appt);
        }
        catch (TermIsNotAffineException tinae) {
            if (tinae.getMessage().equals("Product with more than one non-constant factors found")) {
                switch (nlaHandling) {
                    case EXCEPTION: {
                        throw tinae;
                    }
                    case OVERAPPROXIMATE: {
                        converted = new LinearInequality();
                    }
                    case UNDERAPPROXIMATE: {
                        converted = LinearInequality.constructFalse();
                    }
                    default: {
                        throw new AssertionError((Object)"unknown case");
                    }
                }
            }
            throw tinae;
        }
        return converted;
    }

    public static enum NlaHandling {
        OVERAPPROXIMATE,
        UNDERAPPROXIMATE,
        EXCEPTION;

    }
}

