/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.variables;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.lassoranker.Lasso;
import de.uni_freiburg.informatik.ultimate.lassoranker.LassoAnalysis;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearTransition;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.LassoPreprocessor;
import de.uni_freiburg.informatik.ultimate.lassoranker.variables.InequalityConverter;
import de.uni_freiburg.informatik.ultimate.lassoranker.variables.LassoUnderConstruction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class LassoBuilder {
    private final ManagedScript mMgdScript;
    private final Collection<TermVariable> mtermVariables;
    private List<LassoUnderConstruction> mLassosUC;
    private Collection<Lasso> mLassos;
    private final ReplacementVarFactory mReplacementVarFactory;
    private LassoAnalysis.PreprocessingBenchmark mPreprocessingBenchmark;
    private final ILogger mLogger;
    private final InequalityConverter.NlaHandling mNlaHandling;

    public LassoBuilder(ILogger logger, CfgSmtToolkit csToolkit, UnmodifiableTransFormula stem, UnmodifiableTransFormula loop, InequalityConverter.NlaHandling nlaHandling) {
        this.mLogger = logger;
        this.mMgdScript = csToolkit.getManagedScript();
        this.mNlaHandling = nlaHandling;
        this.mtermVariables = new ArrayList<TermVariable>();
        this.mReplacementVarFactory = new ReplacementVarFactory(csToolkit, true);
        this.mLassosUC = new ArrayList<LassoUnderConstruction>();
        this.mLassosUC.add(new LassoUnderConstruction(ModifiableTransFormulaUtils.buildTransFormula((TransFormula)stem, (ReplacementVarFactory)this.mReplacementVarFactory, (ManagedScript)this.mMgdScript), ModifiableTransFormulaUtils.buildTransFormula((TransFormula)loop, (ReplacementVarFactory)this.mReplacementVarFactory, (ManagedScript)this.mMgdScript)));
    }

    public ReplacementVarFactory getReplacementVarFactory() {
        return this.mReplacementVarFactory;
    }

    public Collection<TermVariable> getGeneratedTermVariables() {
        return Collections.unmodifiableCollection(this.mtermVariables);
    }

    public List<LassoUnderConstruction> getLassosUC() {
        return this.mLassosUC;
    }

    public void applyPreprocessor(LassoPreprocessor preprocessor) throws TermException {
        ArrayList<LassoUnderConstruction> newLassos = new ArrayList<LassoUnderConstruction>();
        for (LassoUnderConstruction lasso : this.mLassosUC) {
            try {
                newLassos.addAll(preprocessor.process(lasso));
            }
            catch (ToolchainCanceledException tce) {
                String taskDescription = "applying " + preprocessor.getName() + " to lasso for termination ";
                tce.addRunningTaskInfo(new RunningTaskInfo(this.getClass(), taskDescription));
                throw tce;
            }
        }
        this.mLassosUC = newLassos;
    }

    public boolean isSane(String task) {
        boolean sane = true;
        for (LassoUnderConstruction luc : this.mLassosUC) {
            assert (sane &= luc.getStem().auxVarsDisjointFromInOutVars()) : "inconsistent lasso after " + task + ": auxVarsDisjointFromInOutVars";
            assert (sane &= luc.getStem().allAreInOutAux(luc.getStem().getFormula().getFreeVars()) == null) : "inconsistent lasso after " + task + ": allAreInOutAux";
            assert (sane &= luc.getLoop().auxVarsDisjointFromInOutVars()) : "inconsistent lasso after " + task + ": auxVarsDisjointFromInOutVars";
            assert (sane &= luc.getLoop().allAreInOutAux(luc.getLoop().getFormula().getFreeVars()) == null) : "inconsistent lasso after " + task + ": allAreInOutAux";
        }
        return sane;
    }

    public void constructPolyhedra() throws TermException {
        int n = this.mLassosUC.size();
        ArrayList<Lasso> lassos = new ArrayList<Lasso>(n);
        int i = 0;
        while (i < n) {
            ModifiableTransFormula stemTF = this.mLassosUC.get(i).getStem();
            ModifiableTransFormula loopTF = this.mLassosUC.get(i).getLoop();
            LinearTransition stem = LinearTransition.fromTransFormulaLR(stemTF, this.mNlaHandling);
            LinearTransition loop = LinearTransition.fromTransFormulaLR(loopTF, this.mNlaHandling);
            lassos.add(new Lasso(stem, loop));
            ++i;
        }
        this.mLassos = lassos;
    }

    public Collection<Lasso> getLassos() {
        return this.mLassos;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.mLassos == null) {
            sb.append("Preprocessing has not been completed.\n");
            sb.append("Current lassos:\n");
            for (LassoUnderConstruction luc : this.mLassosUC) {
                sb.append(luc);
                sb.append(System.lineSeparator());
            }
        } else {
            sb.append("Lassos:\n");
            for (Lasso lasso : this.mLassos) {
                sb.append(lasso);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static long computeMaxDagSize(List<LassoUnderConstruction> lassos) {
        if (lassos.isEmpty()) {
            return 0L;
        }
        long[] sizes = new long[lassos.size()];
        int i = 0;
        while (i < lassos.size()) {
            sizes[i] = lassos.get(i).getFormulaSize();
            ++i;
        }
        Arrays.sort(sizes);
        return sizes[lassos.size() - 1];
    }

    public long computeMaxDagSize() {
        return LassoBuilder.computeMaxDagSize(this.mLassosUC);
    }

    public void preprocess(LassoPreprocessor[] preProcessorsTermination, LassoPreprocessor[] preProcessorsNontermination) throws TermException {
        this.mPreprocessingBenchmark = new LassoAnalysis.PreprocessingBenchmark(this.computeMaxDagSize());
        LassoPreprocessor[] lassoPreprocessorArray = preProcessorsTermination;
        int n = preProcessorsTermination.length;
        int n2 = 0;
        while (n2 < n) {
            LassoPreprocessor preprocessor = lassoPreprocessorArray[n2];
            if (preprocessor != null) {
                this.mLogger.debug((Object)preprocessor.getDescription());
                this.applyPreprocessor(preprocessor);
                this.mPreprocessingBenchmark.addPreprocessingData(preprocessor.getDescription(), this.computeMaxDagSize());
                assert (this.isSane(preprocessor.getClass().getSimpleName())) : "lasso failed sanity check";
            }
            ++n2;
        }
    }

    public LassoAnalysis.PreprocessingBenchmark getPreprocessingBenchmark() {
        return this.mPreprocessingBenchmark;
    }
}

