/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.variables;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lassoranker.variables.LassoUnderConstruction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.NonTheorySymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LassoPartitioneer {
    private final IUltimateServiceProvider mServices;
    private final ManagedScript mMgdScript;
    private final LassoUnderConstruction mLasso;
    private final NestedMap2<Part, NonTheorySymbol<?>, ModifiableTransFormula> mSymbol2OriginalTF = new NestedMap2();
    private HashRelation<NonTheorySymbol<?>, Term> mSymbol2StemConjuncts;
    private HashSet<NonTheorySymbol<?>> mStemSymbolsWithoutConjuncts;
    private HashRelation<NonTheorySymbol<?>, Term> mSymbol2LoopConjuncts;
    private HashSet<NonTheorySymbol<?>> mLoopSymbolsWithoutConjuncts;
    private List<Term> mStemConjunctsWithoutSymbols;
    private List<Term> mLoopConjunctsWithoutSymbols;
    private final UnionFind<NonTheorySymbol<?>> mEquivalentSymbols = new UnionFind();
    private final Set<IProgramVar> mAllRankVars = new HashSet<IProgramVar>();
    private final List<LassoUnderConstruction> mNewLassos = new ArrayList<LassoUnderConstruction>();
    private final SmtUtils.XnfConversionTechnique mXnfConversionTechnique;

    public LassoPartitioneer(IUltimateServiceProvider services, ManagedScript mgdScript, LassoUnderConstruction lasso, SmtUtils.XnfConversionTechnique xnfConversionTechnique) {
        this.mServices = services;
        this.mMgdScript = mgdScript;
        this.mLasso = lasso;
        this.mXnfConversionTechnique = xnfConversionTechnique;
        this.doPartition();
    }

    public List<LassoUnderConstruction> getNewLassos() {
        return this.mNewLassos;
    }

    private void doPartition() {
        this.mSymbol2StemConjuncts = new HashRelation();
        this.mSymbol2LoopConjuncts = new HashRelation();
        this.mStemSymbolsWithoutConjuncts = new HashSet();
        this.mLoopSymbolsWithoutConjuncts = new HashSet();
        this.mStemConjunctsWithoutSymbols = new ArrayList<Term>();
        this.mLoopConjunctsWithoutSymbols = new ArrayList<Term>();
        this.extractSymbols(Part.STEM, this.mLasso.getStem(), this.mSymbol2StemConjuncts, this.mStemSymbolsWithoutConjuncts, this.mStemConjunctsWithoutSymbols);
        this.extractSymbols(Part.LOOP, this.mLasso.getLoop(), this.mSymbol2LoopConjuncts, this.mLoopSymbolsWithoutConjuncts, this.mLoopConjunctsWithoutSymbols);
        for (IProgramVar rv : this.mAllRankVars) {
            HashSet symbols = new HashSet();
            this.extractInVarAndOutVarSymbols(rv, symbols, this.mLasso.getStem());
            this.extractInVarAndOutVarSymbols(rv, symbols, this.mLasso.getLoop());
            this.announceEquivalence(symbols);
        }
        for (NonTheorySymbol equivalenceClassRepresentative : this.mEquivalentSymbols.getAllRepresentatives()) {
            ImmutableSet symbolEquivalenceClass = this.mEquivalentSymbols.getEquivalenceClassMembers((Object)equivalenceClassRepresentative);
            HashSet<Term> equivalentStemConjuncts = new HashSet<Term>();
            HashSet<Term> equivalentLoopConjuncts = new HashSet<Term>();
            HashSet equivalentStemSymbolsWithoutConjunct = new HashSet();
            HashSet equivalentLoopSymbolsWithoutConjunct = new HashSet();
            for (NonTheorySymbol tv : symbolEquivalenceClass) {
                if (this.mSymbol2StemConjuncts.getDomain().contains(tv)) {
                    equivalentStemConjuncts.addAll(this.mSymbol2StemConjuncts.getImage((Object)tv));
                    continue;
                }
                if (this.mStemSymbolsWithoutConjuncts.contains(tv)) {
                    equivalentStemSymbolsWithoutConjunct.add(tv);
                    continue;
                }
                if (this.mSymbol2LoopConjuncts.getDomain().contains(tv)) {
                    equivalentLoopConjuncts.addAll(this.mSymbol2LoopConjuncts.getImage((Object)tv));
                    continue;
                }
                if (this.mLoopSymbolsWithoutConjuncts.contains(tv)) {
                    equivalentLoopSymbolsWithoutConjunct.add(tv);
                    continue;
                }
                throw new AssertionError((Object)("unknown variable " + tv));
            }
            if (equivalentStemConjuncts.isEmpty() && equivalentStemSymbolsWithoutConjunct.isEmpty() && equivalentLoopConjuncts.isEmpty() && equivalentLoopSymbolsWithoutConjunct.isEmpty()) continue;
            ModifiableTransFormula stemTransformulaLR = this.constructTransFormulaLR(Part.STEM, equivalentStemConjuncts, equivalentStemSymbolsWithoutConjunct);
            ModifiableTransFormula loopTransformulaLR = this.constructTransFormulaLR(Part.LOOP, equivalentLoopConjuncts, equivalentLoopSymbolsWithoutConjunct);
            this.mNewLassos.add(new LassoUnderConstruction(stemTransformulaLR, loopTransformulaLR));
        }
        if (!this.emptyOrTrue(this.mStemConjunctsWithoutSymbols) || !this.emptyOrTrue(this.mLoopConjunctsWithoutSymbols)) {
            ModifiableTransFormula stemTransformulaLR = this.constructTransFormulaLR(Part.STEM, this.mStemConjunctsWithoutSymbols);
            ModifiableTransFormula loopTransformulaLR = this.constructTransFormulaLR(Part.LOOP, this.mLoopConjunctsWithoutSymbols);
            this.mNewLassos.add(new LassoUnderConstruction(stemTransformulaLR, loopTransformulaLR));
        }
    }

    private boolean emptyOrTrue(List<Term> terms) {
        if (terms.isEmpty()) {
            return true;
        }
        Term conjunction = SmtUtils.and((Script)this.mMgdScript.getScript(), terms);
        return conjunction.toString().equals("true");
    }

    private void extractInVarAndOutVarSymbols(IProgramVar rv, Set<NonTheorySymbol<?>> symbols, ModifiableTransFormula transFormulaLR) {
        Term outVar;
        Term inVar = (Term)transFormulaLR.getInVars().get(rv);
        if (inVar != null) {
            symbols.add(this.constructSymbol(inVar));
        }
        if ((outVar = (Term)transFormulaLR.getOutVars().get(rv)) != null) {
            symbols.add(this.constructSymbol(outVar));
        }
        assert (inVar == null == (outVar == null)) : "both or none";
    }

    private ModifiableTransFormula constructTransFormulaLR(Part part, Set<Term> equivalentConjuncts, Set<NonTheorySymbol<?>> equivalentVariablesWithoutConjunct) {
        Term formula = SmtUtils.and((Script)this.mMgdScript.getScript(), (Term[])equivalentConjuncts.toArray(new Term[equivalentConjuncts.size()]));
        ModifiableTransFormula transformulaLR = new ModifiableTransFormula(formula);
        for (NonTheorySymbol nonTheorySymbol : NonTheorySymbol.extractNonTheorySymbols((Term)formula)) {
            this.addInOuAuxVar(part, transformulaLR, nonTheorySymbol);
        }
        for (NonTheorySymbol nonTheorySymbol : equivalentVariablesWithoutConjunct) {
            this.addInOuAuxVar(part, transformulaLR, nonTheorySymbol);
        }
        return transformulaLR;
    }

    private ModifiableTransFormula constructTransFormulaLR(Part part, List<Term> conjunctsWithoutSymbols) {
        Term formula = SmtUtils.and((Script)this.mMgdScript.getScript(), (Term[])conjunctsWithoutSymbols.toArray(new Term[conjunctsWithoutSymbols.size()]));
        ModifiableTransFormula transformulaLR = new ModifiableTransFormula(formula);
        return transformulaLR;
    }

    private void addInOuAuxVar(Part part, ModifiableTransFormula transformulaLR, NonTheorySymbol<?> symbol) {
        boolean isConstant;
        TermVariable term;
        ModifiableTransFormula original = (ModifiableTransFormula)this.mSymbol2OriginalTF.get((Object)part, symbol);
        if (symbol instanceof NonTheorySymbol.Variable) {
            term = (TermVariable)symbol.getSymbol();
            isConstant = false;
        } else if (symbol instanceof NonTheorySymbol.Constant) {
            term = (TermVariable)symbol.getSymbol();
            isConstant = true;
        } else {
            throw new UnsupportedOperationException("function symbols not yet supported");
        }
        IProgramVar inVarRankVar = (IProgramVar)original.getInVarsReverseMapping().get(term);
        IProgramVar outVarRankVar = (IProgramVar)original.getOutVarsReverseMapping().get(term);
        boolean isAuxVar = original.getAuxVars().contains(term);
        assert (isConstant || !isAuxVar || inVarRankVar == null && outVarRankVar == null) : "auxVar may neither be inVar nor outVar";
        assert (isConstant || inVarRankVar != null || outVarRankVar != null || isAuxVar) : "neither inVar nor outVar may be auxVar";
        if (inVarRankVar != null) {
            transformulaLR.addInVar(inVarRankVar, term);
        }
        if (outVarRankVar != null) {
            transformulaLR.addOutVar(outVarRankVar, term);
        }
        if (isAuxVar) {
            TermVariable auxVarTv = term;
            transformulaLR.addAuxVars(Collections.singleton(auxVarTv));
        }
    }

    private HashRelation<NonTheorySymbol<?>, Term> extractSymbols(Part part, ModifiableTransFormula tf, HashRelation<NonTheorySymbol<?>, Term> symbol2Conjuncts, HashSet<NonTheorySymbol<?>> symbolsWithoutConjuncts, List<Term> conjunctsWithoutSymbols) {
        Term[] conjuncts;
        this.mAllRankVars.addAll(tf.getInVars().keySet());
        this.mAllRankVars.addAll(tf.getOutVars().keySet());
        Term cnf = SmtUtils.toCnf((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mMgdScript, (Term)tf.getFormula(), (SmtUtils.XnfConversionTechnique)this.mXnfConversionTechnique);
        Term[] termArray = conjuncts = SmtUtils.getConjuncts((Term)cnf);
        int n = conjuncts.length;
        int n2 = 0;
        while (n2 < n) {
            Term conjunct = termArray[n2];
            Set allSymbolsOfConjunct = NonTheorySymbol.extractNonTheorySymbols((Term)conjunct);
            if (allSymbolsOfConjunct.isEmpty()) {
                conjunctsWithoutSymbols.add(conjunct);
            } else {
                for (NonTheorySymbol symbol : allSymbolsOfConjunct) {
                    ModifiableTransFormula oldValue = (ModifiableTransFormula)this.mSymbol2OriginalTF.put((Object)part, (Object)symbol, (Object)tf);
                    assert (oldValue == null || oldValue == tf) : "may not be modified";
                    allSymbolsOfConjunct.add(symbol);
                    if (this.mEquivalentSymbols.find((Object)symbol) == null) {
                        this.mEquivalentSymbols.makeEquivalenceClass((Object)symbol);
                    }
                    symbol2Conjuncts.addPair((Object)symbol, (Object)conjunct);
                }
                this.announceEquivalence(allSymbolsOfConjunct);
            }
            ++n2;
        }
        for (Map.Entry entry : tf.getInVars().entrySet()) {
            this.addIfNotAlreadyAdded(part, symbolsWithoutConjuncts, tf, (Term)entry.getValue(), symbol2Conjuncts);
        }
        for (Map.Entry entry : tf.getOutVars().entrySet()) {
            this.addIfNotAlreadyAdded(part, symbolsWithoutConjuncts, tf, (Term)entry.getValue(), symbol2Conjuncts);
        }
        return symbol2Conjuncts;
    }

    private void addIfNotAlreadyAdded(Part part, HashSet<NonTheorySymbol<?>> symbolsWithoutConjuncts, ModifiableTransFormula tf, Term tvOrConstant, HashRelation<NonTheorySymbol<?>, Term> symbol2Conjuncts) {
        NonTheorySymbol<?> symbol = this.constructSymbol(tvOrConstant);
        if (!symbol2Conjuncts.getDomain().contains(symbol) && !symbolsWithoutConjuncts.contains(symbol)) {
            if (this.mEquivalentSymbols.find(symbol) == null) {
                this.mEquivalentSymbols.makeEquivalenceClass(symbol);
            }
            symbolsWithoutConjuncts.add(symbol);
            ModifiableTransFormula oldValue = (ModifiableTransFormula)this.mSymbol2OriginalTF.put((Object)part, symbol, (Object)tf);
            assert (oldValue == null || oldValue == tf) : "may not be modified";
        }
    }

    private NonTheorySymbol<?> constructSymbol(Term tvOrConstant) {
        if (tvOrConstant instanceof TermVariable) {
            return new NonTheorySymbol.Variable((TermVariable)tvOrConstant);
        }
        if (SmtUtils.isConstant((Term)tvOrConstant)) {
            return new NonTheorySymbol.Constant((ApplicationTerm)tvOrConstant);
        }
        throw new IllegalArgumentException();
    }

    private void announceEquivalence(Set<NonTheorySymbol<?>> allSymbolsOfConjunct) {
        NonTheorySymbol<?> last = null;
        for (NonTheorySymbol<?> symbol : allSymbolsOfConjunct) {
            if (last != null) {
                this.mEquivalentSymbols.union(symbol, last);
            }
            last = symbol;
        }
    }

    private static enum Part {
        STEM,
        LOOP;

    }
}

