/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDDomain;
import net.sf.javabdd.BDDFactory;
import net.sf.javabdd.BDDPairing;

public class RubiksCube {
    static BDDFactory bdd;
    static int n;
    static int k;

    public static void main(String[] args) {
        int k;
        int j;
        int k2;
        int k3;
        int i;
        bdd = BDDFactory.init(1000000, 100000);
        bdd.setMaxIncrease(250000);
        if (args.length > 0) {
            RubiksCube.k = Integer.parseInt(args[0]);
        }
        int[] sizes = new int[n * n * 6];
        Arrays.fill(sizes, 6);
        BDDDomain[] squares = bdd.extDomain(sizes);
        ArrayList perms = new ArrayList(12);
        int[] p1 = new int[54];
        for (i = 0; i < 4 * n; ++i) {
            p1[i] = k3 = (i + n) % (4 * n);
        }
        for (int j2 = 0; j2 < 4 * n - 4; ++j2) {
            p1[i] = k2 = 4 * n + (j2 + n - 1) % (4 * n - 4);
            ++i;
        }
        while (i < p1.length) {
            p1[i] = k3 = i;
            ++i;
        }
        RubiksCube.buildPerm(perms, p1);
        int[] p3 = new int[54];
        for (i = 0; i < 8 * n - 4; ++i) {
            p3[i] = k2 = i;
        }
        for (j = 0; j < 4 * n; ++j) {
            p3[i] = k = 8 * n - 4 + (j + n) % (4 * n);
            ++i;
        }
        for (j = 0; j < 4 * n - 4; ++j) {
            p3[i] = k = 12 * n - 4 + (j + n - 1) % (4 * n - 4);
            ++i;
        }
        while (i < p3.length) {
            p3[i] = k2 = i;
            ++i;
        }
        RubiksCube.buildPerm(perms, p3);
        int[] p5 = new int[]{2, 42, 22, 34, 4, 5, 6, 7, 8, 9, 10, 14, 3, 43, 23, 15, 16, 17, 18, 19, 0, 40, 20, 32, 24, 25, 26, 27, 28, 29, 30, 12, 11, 51, 31, 35, 36, 37, 38, 39, 1, 41, 21, 33, 44, 45, 46, 47, 48, 49, 50, 13, 52, 53};
        RubiksCube.buildPerm(perms, p5);
        int[] p7 = new int[]{0, 1, 16, 5, 45, 25, 36, 7, 8, 9, 10, 11, 12, 13, 6, 46, 26, 17, 18, 19, 20, 21, 14, 3, 43, 23, 34, 27, 28, 29, 30, 31, 32, 33, 2, 42, 22, 37, 38, 39, 40, 41, 15, 4, 44, 24, 35, 47, 48, 49, 50, 51, 52, 53};
        RubiksCube.buildPerm(perms, p7);
        int[] p9 = new int[]{0, 1, 2, 3, 4, 18, 8, 48, 28, 38, 10, 11, 12, 13, 14, 15, 9, 49, 29, 19, 20, 21, 22, 23, 24, 16, 6, 46, 26, 36, 30, 31, 32, 33, 34, 35, 5, 45, 25, 39, 40, 41, 42, 43, 44, 17, 7, 47, 27, 37, 50, 51, 52, 53};
        RubiksCube.buildPerm(perms, p9);
        int[] p11 = new int[]{32, 1, 2, 3, 4, 5, 6, 7, 12, 11, 51, 31, 20, 13, 14, 15, 16, 17, 0, 40, 38, 21, 22, 23, 24, 25, 26, 27, 18, 9, 49, 29, 28, 33, 34, 35, 36, 37, 8, 48, 39, 41, 42, 43, 44, 45, 46, 47, 19, 10, 50, 30, 52, 53};
        RubiksCube.buildPerm(perms, p11);
        int[] px = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53};
        BDD cube = RubiksCube.buildInitial();
        BDD allConfigs = cube.id();
        RubiksCube.addAll(RubiksCube.k, perms, allConfigs, cube);
        System.out.println("Number of distinct configurations after " + RubiksCube.k + " moves: " + allConfigs.satCount());
    }

    static void addAll(int depth, List perms, BDD allConfigs, BDD c) {
        if (depth <= 0) {
            return;
        }
        Iterator i = perms.iterator();
        while (i.hasNext()) {
            BDDPairing p = (BDDPairing)i.next();
            BDD c2 = c.replace(p);
            BDD r = c2.imp(allConfigs);
            if (!r.isOne()) {
                allConfigs.orWith(c2.id());
                RubiksCube.addAll(depth - 1, perms, allConfigs, c2);
            }
            r.free();
            c2.free();
        }
    }

    static BDD buildInitial() {
        BDD b = bdd.one();
        for (int k = 0; k < 4; ++k) {
            for (int i = 0; i < n; ++i) {
                b.andWith(bdd.getDomain(k * n + i).ithVar(k));
                b.andWith(bdd.getDomain((8 + k) * n - 4 + i).ithVar(k));
                b.andWith(bdd.getDomain((16 + k) * n - 8 + i).ithVar(k));
            }
        }
        for (int i = 0; i < 8; ++i) {
            b.andWith(bdd.getDomain(4 * n + i).ithVar(4L));
            b.andWith(bdd.getDomain(12 * n - 4 + i).ithVar(5L));
        }
        b.andWith(bdd.getDomain(n * n * 6 - 2).ithVar(4L));
        b.andWith(bdd.getDomain(n * n * 6 - 1).ithVar(5L));
        return b;
    }

    static void printCube(BDD b) {
        System.out.println(b.toStringWithDomains());
        RubiksCube.indent();
        RubiksCube.ps();
        RubiksCube.p(b, 20);
        RubiksCube.p(b, 21);
        RubiksCube.p(b, 22);
        RubiksCube.newLine();
        RubiksCube.indent();
        RubiksCube.ps();
        RubiksCube.p(b, 40);
        RubiksCube.p(b, 41);
        RubiksCube.p(b, 42);
        RubiksCube.newLine();
        RubiksCube.indent();
        RubiksCube.ps();
        RubiksCube.p(b, 0);
        RubiksCube.p(b, 1);
        RubiksCube.p(b, 2);
        RubiksCube.newLine();
        RubiksCube.p(b, 31);
        RubiksCube.p(b, 51);
        RubiksCube.p(b, 11);
        RubiksCube.ps();
        RubiksCube.p(b, 12);
        RubiksCube.p(b, 13);
        RubiksCube.p(b, 14);
        RubiksCube.ps();
        RubiksCube.p(b, 3);
        RubiksCube.p(b, 43);
        RubiksCube.p(b, 23);
        RubiksCube.newLine();
        RubiksCube.p(b, 30);
        RubiksCube.p(b, 50);
        RubiksCube.p(b, 10);
        RubiksCube.ps();
        RubiksCube.p(b, 19);
        RubiksCube.p(b, 52);
        RubiksCube.p(b, 15);
        RubiksCube.ps();
        RubiksCube.p(b, 4);
        RubiksCube.p(b, 44);
        RubiksCube.p(b, 24);
        RubiksCube.newLine();
        RubiksCube.p(b, 29);
        RubiksCube.p(b, 49);
        RubiksCube.p(b, 9);
        RubiksCube.ps();
        RubiksCube.p(b, 18);
        RubiksCube.p(b, 17);
        RubiksCube.p(b, 16);
        RubiksCube.ps();
        RubiksCube.p(b, 5);
        RubiksCube.p(b, 45);
        RubiksCube.p(b, 25);
        RubiksCube.newLine();
        RubiksCube.indent();
        RubiksCube.ps();
        RubiksCube.p(b, 8);
        RubiksCube.p(b, 7);
        RubiksCube.p(b, 6);
        RubiksCube.newLine();
        RubiksCube.indent();
        RubiksCube.ps();
        RubiksCube.p(b, 48);
        RubiksCube.p(b, 47);
        RubiksCube.p(b, 46);
        RubiksCube.newLine();
        RubiksCube.indent();
        RubiksCube.ps();
        RubiksCube.p(b, 28);
        RubiksCube.p(b, 27);
        RubiksCube.p(b, 26);
        RubiksCube.newLine();
        RubiksCube.newLine();
        RubiksCube.indent();
        RubiksCube.ps();
        RubiksCube.p(b, 32);
        RubiksCube.p(b, 33);
        RubiksCube.p(b, 34);
        RubiksCube.newLine();
        RubiksCube.indent();
        RubiksCube.ps();
        RubiksCube.p(b, 39);
        RubiksCube.p(b, 53);
        RubiksCube.p(b, 35);
        RubiksCube.newLine();
        RubiksCube.indent();
        RubiksCube.ps();
        RubiksCube.p(b, 38);
        RubiksCube.p(b, 37);
        RubiksCube.p(b, 36);
        RubiksCube.newLine();
    }

    static void ps() {
        System.out.print(' ');
    }

    static void indent() {
        for (int i = 0; i < n; ++i) {
            System.out.print("   ");
        }
    }

    static void newLine() {
        System.out.println();
    }

    static void p(BDD b, int d) {
        BDDDomain dom = bdd.getDomain(d);
        int v = b.scanVar(dom).intValue();
        String s = Integer.toString(v);
        s = "   ".substring(s.length()) + s;
        System.out.print(s);
    }

    static void checkPerm(int[] perm) {
        int[] p2 = new int[perm.length];
        System.arraycopy(perm, 0, p2, 0, p2.length);
        Arrays.sort(p2);
        for (int i = 0; i < p2.length; ++i) {
            if (p2[i] == i) continue;
            throw new InternalError(i + " != " + p2[i]);
        }
    }

    static void dumpPerm(int[] perm) {
        System.out.println("Permutation:");
        for (int i = 0; i < perm.length; ++i) {
            System.out.println(i + " -> " + perm[i]);
        }
        System.out.println();
    }

    static void buildPerm(Collection perms, int[] perm) {
        RubiksCube.checkPerm(perm);
        BDDDomain[] dorig = new BDDDomain[perm.length];
        for (int i = 0; i < dorig.length; ++i) {
            dorig[i] = bdd.getDomain(i);
        }
        BDDDomain[] dperm = new BDDDomain[perm.length];
        for (int i = 0; i < perm.length; ++i) {
            dperm[i] = bdd.getDomain(perm[i]);
        }
        BDDPairing pair = bdd.makePair();
        pair.set(dorig, dperm);
        perms.add(pair);
        pair = bdd.makePair();
        pair.set(dperm, dorig);
        perms.add(pair);
    }

    static {
        n = 3;
        k = 6;
    }
}

