/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javabdd;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.security.AccessControlException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDBitVector;
import net.sf.javabdd.BDDDomain;
import net.sf.javabdd.BDDException;
import net.sf.javabdd.BDDPairing;
import net.sf.javabdd.BuDDyFactory;
import net.sf.javabdd.CALFactory;
import net.sf.javabdd.CUDDFactory;
import net.sf.javabdd.JDDFactory;
import net.sf.javabdd.JFactory;
import net.sf.javabdd.MicroFactory;
import net.sf.javabdd.TestBDDFactory;
import net.sf.javabdd.TypedBDDFactory;

public abstract class BDDFactory {
    public static final BDDOp and = new BDDOp(0, "and");
    public static final BDDOp xor = new BDDOp(1, "xor");
    public static final BDDOp or = new BDDOp(2, "or");
    public static final BDDOp nand = new BDDOp(3, "nand");
    public static final BDDOp nor = new BDDOp(4, "nor");
    public static final BDDOp imp = new BDDOp(5, "imp");
    public static final BDDOp biimp = new BDDOp(6, "biimp");
    public static final BDDOp diff = new BDDOp(7, "diff");
    public static final BDDOp less = new BDDOp(8, "less");
    public static final BDDOp invimp = new BDDOp(9, "invimp");
    protected StringTokenizer tokenizer;
    public static final ReorderMethod REORDER_NONE = new ReorderMethod(0, "NONE");
    public static final ReorderMethod REORDER_WIN2 = new ReorderMethod(1, "WIN2");
    public static final ReorderMethod REORDER_WIN2ITE = new ReorderMethod(2, "WIN2ITE");
    public static final ReorderMethod REORDER_WIN3 = new ReorderMethod(5, "WIN3");
    public static final ReorderMethod REORDER_WIN3ITE = new ReorderMethod(6, "WIN3ITE");
    public static final ReorderMethod REORDER_SIFT = new ReorderMethod(3, "SIFT");
    public static final ReorderMethod REORDER_SIFTITE = new ReorderMethod(4, "SIFTITE");
    public static final ReorderMethod REORDER_RANDOM = new ReorderMethod(7, "RANDOM");
    protected GCStats gcstats = new GCStats();
    protected ReorderStats reorderstats = new ReorderStats();
    protected CacheStats cachestats = new CacheStats();
    protected BDDDomain[] domain;
    protected int fdvarnum;
    protected int firstbddvar;
    protected List gc_callbacks;
    protected List reorder_callbacks;
    protected List resize_callbacks;

    public static final String getProperty(String key, String def) {
        try {
            return System.getProperty(key, def);
        }
        catch (AccessControlException _) {
            return def;
        }
    }

    public static BDDFactory init(int nodenum, int cachesize) {
        String bddpackage = BDDFactory.getProperty("bdd", "buddy");
        return BDDFactory.init(bddpackage, nodenum, cachesize);
    }

    public static BDDFactory init(String bddpackage, int nodenum, int cachesize) {
        try {
            if (bddpackage.equals("buddy")) {
                return BuDDyFactory.init(nodenum, cachesize);
            }
            if (bddpackage.equals("cudd")) {
                return CUDDFactory.init(nodenum, cachesize);
            }
            if (bddpackage.equals("cal")) {
                return CALFactory.init(nodenum, cachesize);
            }
            if (bddpackage.equals("j") || bddpackage.equals("java")) {
                return JFactory.init(nodenum, cachesize);
            }
            if (bddpackage.equals("u") || bddpackage.equals("micro")) {
                return MicroFactory.init(nodenum, cachesize);
            }
            if (bddpackage.equals("jdd")) {
                return JDDFactory.init(nodenum, cachesize);
            }
            if (bddpackage.equals("test")) {
                return TestBDDFactory.init(nodenum, cachesize);
            }
            if (bddpackage.equals("typed")) {
                return TypedBDDFactory.init(nodenum, cachesize);
            }
        }
        catch (LinkageError e) {
            System.out.println("Could not load BDD package " + bddpackage + ": " + e.getLocalizedMessage());
        }
        try {
            Class<?> c = Class.forName(bddpackage);
            Method m = c.getMethod("init", Integer.TYPE, Integer.TYPE);
            return (BDDFactory)m.invoke(null, new Integer(nodenum), new Integer(cachesize));
        }
        catch (ClassNotFoundException _) {
        }
        catch (NoSuchMethodException _) {
        }
        catch (IllegalAccessException _) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return JFactory.init(nodenum, cachesize);
    }

    protected BDDFactory() {
        String s = this.getClass().toString();
    }

    public abstract BDD zero();

    public abstract BDD one();

    public BDD buildCube(int value, List variables) {
        BDD result = this.one();
        Iterator i = variables.iterator();
        int z = 0;
        while (i.hasNext()) {
            BDD var = (BDD)i.next();
            var = (value & 1) != 0 ? var.id() : var.not();
            result.andWith(var);
            ++z;
            value >>= 1;
        }
        return result;
    }

    public BDD buildCube(int value, int[] variables) {
        BDD result = this.one();
        int z = 0;
        while (z < variables.length) {
            BDD v = (value & 1) != 0 ? this.ithVar(variables[variables.length - z - 1]) : this.nithVar(variables[variables.length - z - 1]);
            result.andWith(v);
            ++z;
            value >>= 1;
        }
        return result;
    }

    public BDD makeSet(int[] varset) {
        BDD res = this.one();
        int varnum = varset.length;
        for (int v = varnum - 1; v >= 0; --v) {
            res.andWith(this.ithVar(varset[v]));
        }
        return res;
    }

    protected abstract void initialize(int var1, int var2);

    public abstract boolean isInitialized();

    public void reset() {
        int nodes = this.getNodeTableSize();
        int cache = this.getCacheSize();
        this.domain = null;
        this.fdvarnum = 0;
        this.firstbddvar = 0;
        this.done();
        this.initialize(nodes, cache);
    }

    public abstract void done();

    public abstract void setError(int var1);

    public abstract void clearError();

    public abstract int setMaxNodeNum(int var1);

    public abstract double setMinFreeNodes(double var1);

    public abstract int setMaxIncrease(int var1);

    public abstract double setIncreaseFactor(double var1);

    public abstract double setCacheRatio(double var1);

    public abstract int setNodeTableSize(int var1);

    public abstract int setCacheSize(int var1);

    public abstract int varNum();

    public abstract int setVarNum(int var1);

    public int extVarNum(int num) {
        int start = this.varNum();
        if (num < 0 || num > 0x3FFFFFFF) {
            throw new BDDException();
        }
        this.setVarNum(start + num);
        return start;
    }

    public abstract BDD ithVar(int var1);

    public abstract BDD nithVar(int var1);

    public abstract void printAll();

    public abstract void printTable(BDD var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BDD load(String filename) throws IOException {
        BDD bDD;
        block5: {
            BufferedReader r = null;
            try {
                BDD result;
                r = new BufferedReader(new FileReader(filename));
                bDD = result = this.load(r);
                Object var6_5 = null;
                if (r == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var6_6 = null;
                    if (r == null) break block6;
                    try {
                        r.close();
                    }
                    catch (IOException _) {}
                }
                throw throwable;
            }
            try {
                r.close();
            }
            catch (IOException _) {
                // empty catch block
            }
        }
        return bDD;
    }

    public BDD load(BufferedReader ifile) throws IOException {
        this.tokenizer = null;
        int lh_nodenum = Integer.parseInt(this.readNext(ifile));
        int vnum = Integer.parseInt(this.readNext(ifile));
        if (lh_nodenum == 0 && vnum == 0) {
            int r = Integer.parseInt(this.readNext(ifile));
            return r == 0 ? this.zero() : this.one();
        }
        int[] loadvar2level = new int[vnum];
        for (int n = 0; n < vnum; ++n) {
            loadvar2level[n] = Integer.parseInt(this.readNext(ifile));
        }
        if (vnum > this.varNum()) {
            this.setVarNum(vnum);
        }
        LoadHash[] lh_table = new LoadHash[lh_nodenum];
        for (int n = 0; n < lh_nodenum; ++n) {
            lh_table[n] = new LoadHash();
            lh_table[n].first = -1;
            lh_table[n].next = n + 1;
        }
        lh_table[lh_nodenum - 1].next = -1;
        int lh_freepos = 0;
        BDD root = null;
        for (int n = 0; n < lh_nodenum; ++n) {
            int key = Integer.parseInt(this.readNext(ifile));
            int var = Integer.parseInt(this.readNext(ifile));
            int lowi = Integer.parseInt(this.readNext(ifile));
            int highi = Integer.parseInt(this.readNext(ifile));
            BDD low = this.loadhash_get(lh_table, lh_nodenum, lowi);
            BDD high = this.loadhash_get(lh_table, lh_nodenum, highi);
            if (low == null || high == null || var < 0) {
                throw new BDDException("Incorrect file format");
            }
            BDD b = this.ithVar(var);
            root = b.ite(high, low);
            b.free();
            int hash = key % lh_nodenum;
            int pos = lh_freepos;
            lh_freepos = lh_table[pos].next;
            lh_table[pos].next = lh_table[hash].first;
            lh_table[hash].first = pos;
            lh_table[pos].key = key;
            lh_table[pos].data = root;
        }
        BDD tmproot = root.id();
        for (int n = 0; n < lh_nodenum; ++n) {
            lh_table[n].data.free();
        }
        lh_table = null;
        loadvar2level = null;
        return tmproot;
    }

    protected String readNext(BufferedReader ifile) throws IOException {
        while (this.tokenizer == null || !this.tokenizer.hasMoreTokens()) {
            String s = ifile.readLine();
            if (s == null) {
                throw new BDDException("Incorrect file format");
            }
            this.tokenizer = new StringTokenizer(s);
        }
        return this.tokenizer.nextToken();
    }

    protected BDD loadhash_get(LoadHash[] lh_table, int lh_nodenum, int key) {
        if (key < 0) {
            return null;
        }
        if (key == 0) {
            return this.zero();
        }
        if (key == 1) {
            return this.one();
        }
        int hash = lh_table[key % lh_nodenum].first;
        while (hash != -1 && lh_table[hash].key != key) {
            hash = lh_table[hash].next;
        }
        if (hash == -1) {
            return null;
        }
        return lh_table[hash].data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void save(String filename, BDD var) throws IOException {
        BufferedWriter is = null;
        try {
            is = new BufferedWriter(new FileWriter(filename));
            this.save(is, var);
            Object var5_4 = null;
            if (is == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException _) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            is.close();
            return;
        }
        catch (IOException _) {}
    }

    public void save(BufferedWriter out, BDD r) throws IOException {
        if (r.isOne() || r.isZero()) {
            out.write("0 0 " + (r.isOne() ? 1 : 0) + "\n");
            return;
        }
        out.write(r.nodeCount() + " " + this.varNum() + "\n");
        for (int x = 0; x < this.varNum(); ++x) {
            out.write(this.var2Level(x) + " ");
        }
        out.write("\n");
        HashMap visited = new HashMap();
        this.save_rec(out, visited, r);
        Iterator it = visited.keySet().iterator();
        while (it.hasNext()) {
            BDD b = (BDD)it.next();
            if (b == r) continue;
            b.free();
        }
    }

    protected int save_rec(BufferedWriter out, Map visited, BDD root) throws IOException {
        if (root.isZero()) {
            root.free();
            return 0;
        }
        if (root.isOne()) {
            root.free();
            return 1;
        }
        Integer i = (Integer)visited.get(root);
        if (i != null) {
            root.free();
            return i;
        }
        int v = visited.size() + 2;
        visited.put(root, new Integer(v));
        BDD l = root.low();
        int lo = this.save_rec(out, visited, l);
        BDD h = root.high();
        int hi = this.save_rec(out, visited, h);
        out.write(v + " ");
        out.write(root.var() + " ");
        out.write(lo + " ");
        out.write(hi + "\n");
        return v;
    }

    public abstract int level2Var(int var1);

    public abstract int var2Level(int var1);

    public abstract void reorder(ReorderMethod var1);

    public abstract void autoReorder(ReorderMethod var1);

    public abstract void autoReorder(ReorderMethod var1, int var2);

    public abstract ReorderMethod getReorderMethod();

    public abstract int getReorderTimes();

    public abstract void disableReorder();

    public abstract void enableReorder();

    public abstract int reorderVerbose(int var1);

    public abstract void setVarOrder(int[] var1);

    public abstract BDDPairing makePair();

    public BDDPairing makePair(int oldvar, int newvar) {
        BDDPairing p = this.makePair();
        p.set(oldvar, newvar);
        return p;
    }

    public BDDPairing makePair(int oldvar, BDD newvar) {
        BDDPairing p = this.makePair();
        p.set(oldvar, newvar);
        return p;
    }

    public BDDPairing makePair(BDDDomain oldvar, BDDDomain newvar) {
        BDDPairing p = this.makePair();
        p.set(oldvar, newvar);
        return p;
    }

    public abstract void swapVar(int var1, int var2);

    public abstract int duplicateVar(int var1);

    public abstract void addVarBlock(BDD var1, boolean var2);

    public abstract void addVarBlock(int var1, int var2, boolean var3);

    public abstract void varBlockAll();

    public abstract void clearVarBlocks();

    public abstract void printOrder();

    public abstract String getVersion();

    public abstract int nodeCount(Collection var1);

    public abstract int getNodeTableSize();

    public abstract int getNodeNum();

    public abstract int getCacheSize();

    public abstract int reorderGain();

    public abstract void printStat();

    public GCStats getGCStats() {
        return this.gcstats;
    }

    public ReorderStats getReorderStats() {
        return this.reorderstats;
    }

    public CacheStats getCacheStats() {
        return this.cachestats;
    }

    protected abstract BDDDomain createDomain(int var1, BigInteger var2);

    public BDDDomain extDomain(long domainSize) {
        return this.extDomain(BigInteger.valueOf(domainSize));
    }

    public BDDDomain extDomain(BigInteger domainSize) {
        return this.extDomain(new BigInteger[]{domainSize})[0];
    }

    public BDDDomain[] extDomain(int[] dom) {
        BigInteger[] a = new BigInteger[dom.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = BigInteger.valueOf(dom[i]);
        }
        return this.extDomain(a);
    }

    public BDDDomain[] extDomain(long[] dom) {
        BigInteger[] a = new BigInteger[dom.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = BigInteger.valueOf(dom[i]);
        }
        return this.extDomain(a);
    }

    public BDDDomain[] extDomain(BigInteger[] domainSizes) {
        int n;
        int offset = this.fdvarnum;
        int extravars = 0;
        int num = domainSizes.length;
        if (this.domain == null) {
            this.domain = new BDDDomain[num];
        } else if (this.fdvarnum + num > this.domain.length) {
            int fdvaralloc = this.domain.length + Math.max(num, this.domain.length);
            BDDDomain[] d2 = new BDDDomain[fdvaralloc];
            System.arraycopy(this.domain, 0, d2, 0, this.domain.length);
            this.domain = d2;
        }
        for (n = 0; n < num; ++n) {
            this.domain[n + this.fdvarnum] = this.createDomain(n + this.fdvarnum, domainSizes[n]);
            extravars += this.domain[n + this.fdvarnum].varNum();
        }
        int binoffset = this.firstbddvar;
        int bddvarnum = this.varNum();
        if (this.firstbddvar + extravars > bddvarnum) {
            this.setVarNum(this.firstbddvar + extravars);
        }
        int bn = 0;
        boolean more = true;
        while (more) {
            more = false;
            for (n = 0; n < num; ++n) {
                if (bn >= this.domain[n + this.fdvarnum].varNum()) continue;
                more = true;
                this.domain[n + this.fdvarnum].ivar[bn] = binoffset++;
            }
            ++bn;
        }
        for (n = 0; n < num; ++n) {
            this.domain[n + this.fdvarnum].var = this.makeSet(this.domain[n + this.fdvarnum].ivar);
        }
        this.fdvarnum += num;
        this.firstbddvar += extravars;
        BDDDomain[] r = new BDDDomain[num];
        System.arraycopy(this.domain, offset, r, 0, num);
        return r;
    }

    public BDDDomain overlapDomain(BDDDomain d1, BDDDomain d2) {
        int n;
        int fdvaralloc = this.domain.length;
        if (this.fdvarnum + 1 > fdvaralloc) {
            fdvaralloc += fdvaralloc;
            BDDDomain[] domain2 = new BDDDomain[fdvaralloc];
            System.arraycopy(this.domain, 0, domain2, 0, this.domain.length);
            this.domain = domain2;
        }
        BDDDomain d = this.domain[this.fdvarnum];
        d.realsize = d1.realsize.multiply(d2.realsize);
        d.ivar = new int[d1.varNum() + d2.varNum()];
        for (n = 0; n < d1.varNum(); ++n) {
            d.ivar[n] = d1.ivar[n];
        }
        for (n = 0; n < d2.varNum(); ++n) {
            d.ivar[d1.varNum() + n] = d2.ivar[n];
        }
        d.var = this.makeSet(d.ivar);
        ++this.fdvarnum;
        return d;
    }

    public BDD makeSet(BDDDomain[] v) {
        BDD res = this.one();
        for (int n = 0; n < v.length; ++n) {
            res.andWith(v[n].set());
        }
        return res;
    }

    public void clearAllDomains() {
        this.domain = null;
        this.fdvarnum = 0;
        this.firstbddvar = 0;
    }

    public int numberOfDomains() {
        return this.fdvarnum;
    }

    public BDDDomain getDomain(int i) {
        if (i < 0 || i >= this.fdvarnum) {
            throw new IndexOutOfBoundsException();
        }
        return this.domain[i];
    }

    public int[] makeVarOrdering(boolean reverseLocal, String ordering) {
        int i;
        int varnum = this.varNum();
        int nDomains = this.numberOfDomains();
        int[][] localOrders = new int[nDomains][];
        for (i = 0; i < localOrders.length; ++i) {
            localOrders[i] = new int[this.getDomain(i).varNum()];
        }
        for (i = 0; i < nDomains; ++i) {
            BDDDomain d = this.getDomain(i);
            int nVars = d.varNum();
            for (int j = 0; j < nVars; ++j) {
                localOrders[i][j] = reverseLocal ? nVars - j - 1 : j;
            }
        }
        BDDDomain[] doms = new BDDDomain[nDomains];
        int[] varorder = new int[varnum];
        StringTokenizer st = new StringTokenizer(ordering, "x_", true);
        int numberOfDomains = 0;
        int bitIndex = 0;
        boolean[] done = new boolean[nDomains];
        int i2 = 0;
        while (true) {
            BDDDomain d;
            String s = st.nextToken();
            int j = 0;
            while (true) {
                if (j == this.numberOfDomains()) {
                    throw new BDDException("bad domain: " + s);
                }
                d = this.getDomain(j);
                if (s.equals(d.getName())) break;
                ++j;
            }
            if (done[d.getIndex()]) {
                throw new BDDException("duplicate domain: " + s);
            }
            done[d.getIndex()] = true;
            doms[i2] = d;
            if (st.hasMoreTokens() && (s = st.nextToken()).equals("x")) {
                ++numberOfDomains;
            } else {
                bitIndex = BDDFactory.fillInVarIndices(doms, i2 - numberOfDomains, numberOfDomains + 1, localOrders, bitIndex, varorder);
                if (!st.hasMoreTokens()) break;
                if (s.equals("_")) {
                    numberOfDomains = 0;
                } else {
                    throw new BDDException("bad token: " + s);
                }
            }
            ++i2;
        }
        for (i2 = 0; i2 < doms.length; ++i2) {
            if (!done[i2]) {
                throw new BDDException("missing domain #" + i2 + ": " + this.getDomain(i2));
            }
            doms[i2] = this.getDomain(i2);
        }
        int[] test = new int[varorder.length];
        System.arraycopy(varorder, 0, test, 0, varorder.length);
        Arrays.sort(test);
        for (int i3 = 0; i3 < test.length; ++i3) {
            if (test[i3] == i3) continue;
            throw new BDDException(test[i3] + " != " + i3);
        }
        return varorder;
    }

    static int fillInVarIndices(BDDDomain[] doms, int domainIndex, int numDomains, int[][] localOrders, int bitIndex, int[] varorder) {
        int maxBits = 0;
        for (int i = 0; i < numDomains; ++i) {
            BDDDomain d = doms[domainIndex + i];
            maxBits = Math.max(maxBits, d.varNum());
        }
        for (int bitNumber = 0; bitNumber < maxBits; ++bitNumber) {
            for (int i = 0; i < numDomains; ++i) {
                BDDDomain d = doms[domainIndex + i];
                if (bitNumber >= d.varNum()) continue;
                int di = d.getIndex();
                int local = localOrders[di][bitNumber];
                if (local >= d.vars().length) {
                    System.out.println("bug!");
                }
                if (bitIndex >= varorder.length) {
                    System.out.println("bug2!");
                }
                varorder[bitIndex++] = d.vars()[local];
            }
        }
        return bitIndex;
    }

    protected abstract BDDBitVector createBitVector(int var1);

    public BDDBitVector buildVector(int bitnum, boolean b) {
        BDDBitVector v = this.createBitVector(bitnum);
        v.initialize(b);
        return v;
    }

    public BDDBitVector constantVector(int bitnum, long val) {
        BDDBitVector v = this.createBitVector(bitnum);
        v.initialize(val);
        return v;
    }

    public BDDBitVector constantVector(int bitnum, BigInteger val) {
        BDDBitVector v = this.createBitVector(bitnum);
        v.initialize(val);
        return v;
    }

    public BDDBitVector buildVector(int bitnum, int offset, int step) {
        BDDBitVector v = this.createBitVector(bitnum);
        v.initialize(offset, step);
        return v;
    }

    public BDDBitVector buildVector(BDDDomain d) {
        BDDBitVector v = this.createBitVector(d.varNum());
        v.initialize(d);
        return v;
    }

    public BDDBitVector buildVector(int[] var) {
        BDDBitVector v = this.createBitVector(var.length);
        v.initialize(var);
        return v;
    }

    public void registerGCCallback(Object o, Method m) {
        if (this.gc_callbacks == null) {
            this.gc_callbacks = new LinkedList();
        }
        this.registerCallback(this.gc_callbacks, o, m);
    }

    public void unregisterGCCallback(Object o, Method m) {
        if (this.gc_callbacks == null) {
            throw new BDDException();
        }
        if (!this.unregisterCallback(this.gc_callbacks, o, m)) {
            throw new BDDException();
        }
    }

    public void registerReorderCallback(Object o, Method m) {
        if (this.reorder_callbacks == null) {
            this.reorder_callbacks = new LinkedList();
        }
        this.registerCallback(this.reorder_callbacks, o, m);
    }

    public void unregisterReorderCallback(Object o, Method m) {
        if (this.reorder_callbacks == null) {
            throw new BDDException();
        }
        if (!this.unregisterCallback(this.reorder_callbacks, o, m)) {
            throw new BDDException();
        }
    }

    public void registerResizeCallback(Object o, Method m) {
        if (this.resize_callbacks == null) {
            this.resize_callbacks = new LinkedList();
        }
        this.registerCallback(this.resize_callbacks, o, m);
    }

    public void unregisterResizeCallback(Object o, Method m) {
        if (this.resize_callbacks == null) {
            throw new BDDException();
        }
        if (!this.unregisterCallback(this.resize_callbacks, o, m)) {
            throw new BDDException();
        }
    }

    protected void gbc_handler(boolean pre, GCStats s) {
        if (this.gc_callbacks == null) {
            BDDFactory.bdd_default_gbchandler(pre, s);
        } else {
            this.doCallbacks(this.gc_callbacks, new Integer(pre ? 1 : 0), s);
        }
    }

    protected static void bdd_default_gbchandler(boolean pre, GCStats s) {
        if (!pre) {
            System.err.println(s.toString());
        }
    }

    void reorder_handler(boolean b, ReorderStats s) {
        if (b) {
            s.usednum_before = this.getNodeNum();
            s.time = System.currentTimeMillis();
        } else {
            s.time = System.currentTimeMillis() - s.time;
            s.usednum_after = this.getNodeNum();
        }
        if (this.reorder_callbacks == null) {
            this.bdd_default_reohandler(b, s);
        } else {
            this.doCallbacks(this.reorder_callbacks, new Integer(b ? 1 : 0), s);
        }
    }

    protected void bdd_default_reohandler(boolean prestate, ReorderStats s) {
        int verbose = 1;
        if (verbose > 0) {
            if (prestate) {
                System.out.println("Start reordering");
                s.usednum_before = this.getNodeNum();
                s.time = System.currentTimeMillis();
            } else {
                s.time = System.currentTimeMillis() - s.time;
                s.usednum_after = this.getNodeNum();
                System.out.println("End reordering. " + s);
            }
        }
    }

    protected void resize_handler(int oldsize, int newsize) {
        if (this.resize_callbacks == null) {
            BDDFactory.bdd_default_reshandler(oldsize, newsize);
        } else {
            this.doCallbacks(this.resize_callbacks, new Integer(oldsize), new Integer(newsize));
        }
    }

    protected static void bdd_default_reshandler(int oldsize, int newsize) {
        int verbose = 1;
        if (verbose > 0) {
            System.out.println("Resizing node table from " + oldsize + " to " + newsize);
        }
    }

    protected void registerCallback(List callbacks, Object o, Method m) {
        if (!Modifier.isPublic(m.getModifiers()) && !m.isAccessible()) {
            throw new BDDException("Callback method not accessible");
        }
        if (!Modifier.isStatic(m.getModifiers())) {
            if (o == null) {
                throw new BDDException("Base object for callback method is null");
            }
            if (!m.getDeclaringClass().isAssignableFrom(o.getClass())) {
                throw new BDDException("Base object for callback method is the wrong type");
            }
        }
        callbacks.add(new Object[]{o, m});
    }

    protected boolean unregisterCallback(List callbacks, Object o, Method m) {
        if (callbacks != null) {
            Iterator i = callbacks.iterator();
            while (i.hasNext()) {
                Object[] cb = (Object[])i.next();
                if (o != cb[0] || !m.equals(cb[1])) continue;
                i.remove();
                return true;
            }
        }
        return false;
    }

    protected void doCallbacks(List callbacks, Object arg1, Object arg2) {
        if (callbacks != null) {
            Iterator i = callbacks.iterator();
            while (i.hasNext()) {
                Object[] cb = (Object[])i.next();
                Object o = cb[0];
                Method m = (Method)cb[1];
                try {
                    switch (m.getParameterTypes().length) {
                        case 0: {
                            m.invoke(o, new Object[0]);
                            break;
                        }
                        case 1: {
                            m.invoke(o, arg1);
                            break;
                        }
                        case 2: {
                            m.invoke(o, arg1, arg2);
                            break;
                        }
                        default: {
                            throw new BDDException("Wrong number of arguments for " + m);
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof RuntimeException) {
                        throw (RuntimeException)e.getTargetException();
                    }
                    if (e.getTargetException() instanceof Error) {
                        throw (Error)e.getTargetException();
                    }
                    e.printStackTrace();
                }
            }
        }
    }

    public static class CacheStats {
        public int uniqueAccess;
        public int uniqueChain;
        public int uniqueHit;
        public int uniqueMiss;
        public int opHit;
        public int opMiss;
        public int swapCount;

        protected CacheStats() {
        }

        void copyFrom(CacheStats that) {
            this.uniqueAccess = that.uniqueAccess;
            this.uniqueChain = that.uniqueChain;
            this.uniqueHit = that.uniqueHit;
            this.uniqueMiss = that.uniqueMiss;
            this.opHit = that.opHit;
            this.opMiss = that.opMiss;
            this.swapCount = that.swapCount;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            String newLine = BDDFactory.getProperty("line.separator", "\n");
            sb.append(newLine);
            sb.append("Cache statistics");
            sb.append(newLine);
            sb.append("----------------");
            sb.append(newLine);
            sb.append("Unique Access:  ");
            sb.append(this.uniqueAccess);
            sb.append(newLine);
            sb.append("Unique Chain:   ");
            sb.append(this.uniqueChain);
            sb.append(newLine);
            sb.append("Unique Hit:     ");
            sb.append(this.uniqueHit);
            sb.append(newLine);
            sb.append("Unique Miss:    ");
            sb.append(this.uniqueMiss);
            sb.append(newLine);
            sb.append("=> Hit rate =   ");
            if (this.uniqueHit + this.uniqueMiss > 0) {
                sb.append((float)this.uniqueHit / ((float)this.uniqueHit + (float)this.uniqueMiss));
            } else {
                sb.append(0.0f);
            }
            sb.append(newLine);
            sb.append("Operator Hits:  ");
            sb.append(this.opHit);
            sb.append(newLine);
            sb.append("Operator Miss:  ");
            sb.append(this.opMiss);
            sb.append(newLine);
            sb.append("=> Hit rate =   ");
            if (this.opHit + this.opMiss > 0) {
                sb.append((float)this.opHit / ((float)this.opHit + (float)this.opMiss));
            } else {
                sb.append(0.0f);
            }
            sb.append(newLine);
            sb.append("Swap count =    ");
            sb.append(this.swapCount);
            sb.append(newLine);
            return sb.toString();
        }
    }

    public static class ReorderStats {
        public long time;
        public int usednum_before;
        public int usednum_after;

        protected ReorderStats() {
        }

        public int gain() {
            if (this.usednum_before == 0) {
                return 0;
            }
            return 100 * (this.usednum_before - this.usednum_after) / this.usednum_before;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Went from ");
            sb.append(this.usednum_before);
            sb.append(" to ");
            sb.append(this.usednum_after);
            sb.append(" nodes, gain = ");
            sb.append(this.gain());
            sb.append("% (");
            sb.append((float)this.time / 1000.0f);
            sb.append(" sec)");
            return sb.toString();
        }
    }

    public static class GCStats {
        public int nodes;
        public int freenodes;
        public long time;
        public long sumtime;
        public int num;

        protected GCStats() {
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Garbage collection #");
            sb.append(this.num);
            sb.append(": ");
            sb.append(this.nodes);
            sb.append(" nodes / ");
            sb.append(this.freenodes);
            sb.append(" free");
            sb.append(" / ");
            sb.append((float)this.time / 1000.0f);
            sb.append("s / ");
            sb.append((float)this.sumtime / 1000.0f);
            sb.append("s total");
            return sb.toString();
        }
    }

    public static class ReorderMethod {
        final int id;
        final String name;

        private ReorderMethod(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    protected static class LoadHash {
        int key;
        BDD data;
        int first;
        int next;

        protected LoadHash() {
        }
    }

    public static class BDDOp {
        final int id;
        final String name;

        private BDDOp(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

