/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javabdd;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDBitVector;
import net.sf.javabdd.BDDDomain;
import net.sf.javabdd.BDDException;
import net.sf.javabdd.BDDFactory;
import net.sf.javabdd.BDDPairing;

public class BuDDyFactory
extends BDDFactory {
    private static BuDDyFactory INSTANCE;
    private static final boolean USE_FINALIZER = false;
    public static final String REVISION = "$Revision: 1.11 $";

    public static BDDFactory init(int nodenum, int cachesize) {
        BuDDyFactory f = new BuDDyFactory();
        f.initialize(nodenum, cachesize);
        return f;
    }

    private static void copyFile(File in, File out) throws IOException {
        FileInputStream fis = new FileInputStream(in);
        FileOutputStream fos = new FileOutputStream(out);
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }

    private static native void registerNatives();

    private BuDDyFactory() {
    }

    private static BuDDyBDD makeBDD(int id) {
        BuDDyBDD b = new BuDDyBDD(id);
        return b;
    }

    public BDD zero() {
        return BuDDyFactory.makeBDD(0);
    }

    public BDD one() {
        return BuDDyFactory.makeBDD(1);
    }

    private static int[] toBuDDyArray(Collection c) {
        int[] a = new int[c.size()];
        Iterator i = c.iterator();
        for (int k = 0; k < a.length; ++k) {
            BuDDyBDD b = (BuDDyBDD)i.next();
            a[k] = b._id;
        }
        return a;
    }

    public BDD buildCube(int value, List var) {
        int[] a = BuDDyFactory.toBuDDyArray(var);
        int id = BuDDyFactory.buildCube0(value, a);
        return BuDDyFactory.makeBDD(id);
    }

    private static native int buildCube0(int var0, int[] var1);

    public BDD buildCube(int value, int[] var) {
        int id = BuDDyFactory.buildCube1(value, var);
        return BuDDyFactory.makeBDD(id);
    }

    private static native int buildCube1(int var0, int[] var1);

    public BDD makeSet(int[] v) {
        int id = BuDDyFactory.makeSet0(v);
        return BuDDyFactory.makeBDD(id);
    }

    private static native int makeSet0(int[] var0);

    protected void initialize(int nodenum, int cachesize) {
        if (INSTANCE != null) {
            throw new InternalError("Error: BDDFactory already initialized.");
        }
        INSTANCE = this;
        BuDDyFactory.initialize0(nodenum, cachesize);
    }

    private static native void initialize0(int var0, int var1);

    public boolean isInitialized() {
        return BuDDyFactory.isInitialized0();
    }

    private static native boolean isInitialized0();

    public void done() {
        INSTANCE = null;
        BuDDyFactory.done0();
    }

    private static native void done0();

    public void reset() {
        super.reset();
    }

    public void setError(int code) {
        BuDDyFactory.setError0(code);
    }

    private static native void setError0(int var0);

    public void clearError() {
        BuDDyFactory.clearError0();
    }

    private static native void clearError0();

    public int setMaxNodeNum(int size) {
        return BuDDyFactory.setMaxNodeNum0(size);
    }

    private static native int setMaxNodeNum0(int var0);

    public double setMinFreeNodes(double x) {
        return (double)BuDDyFactory.setMinFreeNodes0((int)(x * 100.0)) / 100.0;
    }

    private static native int setMinFreeNodes0(int var0);

    public int setMaxIncrease(int x) {
        return BuDDyFactory.setMaxIncrease0(x);
    }

    private static native int setMaxIncrease0(int var0);

    public double setIncreaseFactor(double x) {
        return BuDDyFactory.setIncreaseFactor0(x);
    }

    private static native double setIncreaseFactor0(double var0);

    public double setCacheRatio(double x) {
        return (double)BuDDyFactory.setCacheRatio0((int)(x * 100.0)) / 100.0;
    }

    private static native int setCacheRatio0(int var0);

    public int setNodeTableSize(int x) {
        return BuDDyFactory.setNodeTableSize0(x);
    }

    private static native int setNodeTableSize0(int var0);

    public int setCacheSize(int x) {
        return BuDDyFactory.setCacheSize0(x);
    }

    private static native int setCacheSize0(int var0);

    public int varNum() {
        return BuDDyFactory.varNum0();
    }

    private static native int varNum0();

    public int setVarNum(int num) {
        return BuDDyFactory.setVarNum0(num);
    }

    private static native int setVarNum0(int var0);

    public int duplicateVar(int var) {
        return BuDDyFactory.duplicateVar0(var);
    }

    private static native int duplicateVar0(int var0);

    public int extVarNum(int num) {
        return BuDDyFactory.extVarNum0(num);
    }

    private static native int extVarNum0(int var0);

    public BDD ithVar(int var) {
        int id = BuDDyFactory.ithVar0(var);
        return BuDDyFactory.makeBDD(id);
    }

    private static native int ithVar0(int var0);

    public BDD nithVar(int var) {
        int id = BuDDyFactory.nithVar0(var);
        return BuDDyFactory.makeBDD(id);
    }

    private static native int nithVar0(int var0);

    public void swapVar(int v1, int v2) {
        BuDDyFactory.swapVar0(v1, v2);
    }

    private static native void swapVar0(int var0, int var1);

    public BDDPairing makePair() {
        long ptr = BuDDyFactory.makePair0();
        return new BuDDyBDDPairing(ptr);
    }

    private static native long makePair0();

    public void printAll() {
        BuDDyFactory.printAll0();
    }

    private static native void printAll0();

    public void printTable(BDD b) {
        BuDDyBDD bb = (BuDDyBDD)b;
        BuDDyFactory.printTable0(bb._id);
    }

    private static native void printTable0(int var0);

    public BDD load(String filename) {
        int id = BuDDyFactory.load0(filename);
        return BuDDyFactory.makeBDD(id);
    }

    private static native int load0(String var0);

    public void save(String filename, BDD b) {
        BuDDyBDD bb = (BuDDyBDD)b;
        BuDDyFactory.save0(filename, bb._id);
    }

    private static native void save0(String var0, int var1);

    public int level2Var(int level) {
        return BuDDyFactory.level2Var0(level);
    }

    private static native int level2Var0(int var0);

    public int var2Level(int var) {
        return BuDDyFactory.var2Level0(var);
    }

    private static native int var2Level0(int var0);

    public void reorder(BDDFactory.ReorderMethod method) {
        BuDDyFactory.reorder0(method.id);
    }

    private static native void reorder0(int var0);

    public void autoReorder(BDDFactory.ReorderMethod method) {
        BuDDyFactory.autoReorder0(method.id);
    }

    private static native void autoReorder0(int var0);

    public void autoReorder(BDDFactory.ReorderMethod method, int max) {
        BuDDyFactory.autoReorder1(method.id, max);
    }

    private static native void autoReorder1(int var0, int var1);

    public BDDFactory.ReorderMethod getReorderMethod() {
        int method = BuDDyFactory.getReorderMethod0();
        switch (method) {
            case 0: {
                return REORDER_NONE;
            }
            case 1: {
                return REORDER_WIN2;
            }
            case 2: {
                return REORDER_WIN2ITE;
            }
            case 3: {
                return REORDER_WIN3;
            }
            case 4: {
                return REORDER_WIN3ITE;
            }
            case 5: {
                return REORDER_SIFT;
            }
            case 6: {
                return REORDER_SIFTITE;
            }
            case 7: {
                return REORDER_RANDOM;
            }
        }
        throw new BDDException();
    }

    private static native int getReorderMethod0();

    public int getReorderTimes() {
        return BuDDyFactory.getReorderTimes0();
    }

    private static native int getReorderTimes0();

    public void disableReorder() {
        BuDDyFactory.disableReorder0();
    }

    private static native void disableReorder0();

    public void enableReorder() {
        BuDDyFactory.enableReorder0();
    }

    private static native void enableReorder0();

    public int reorderVerbose(int v) {
        return BuDDyFactory.reorderVerbose0(v);
    }

    private static native int reorderVerbose0(int var0);

    public void setVarOrder(int[] neworder) {
        BuDDyFactory.setVarOrder0(neworder);
    }

    private static native void setVarOrder0(int[] var0);

    public void addVarBlock(BDD var, boolean fixed) {
        BuDDyBDD bb = (BuDDyBDD)var;
        BuDDyFactory.addVarBlock0(bb._id, fixed);
    }

    private static native void addVarBlock0(int var0, boolean var1);

    public void addVarBlock(int first, int last, boolean fixed) {
        BuDDyFactory.addVarBlock1(first, last, fixed);
    }

    private static native void addVarBlock1(int var0, int var1, boolean var2);

    public void varBlockAll() {
        BuDDyFactory.varBlockAll0();
    }

    private static native void varBlockAll0();

    public void clearVarBlocks() {
        BuDDyFactory.clearVarBlocks0();
    }

    private static native void clearVarBlocks0();

    public void printOrder() {
        BuDDyFactory.printOrder0();
    }

    private static native void printOrder0();

    public int nodeCount(Collection r) {
        int[] a = BuDDyFactory.toBuDDyArray(r);
        return BuDDyFactory.nodeCount0(a);
    }

    private static native int nodeCount0(int[] var0);

    public int getNodeTableSize() {
        return BuDDyFactory.getAllocNum0();
    }

    private static native int getAllocNum0();

    public int getCacheSize() {
        return BuDDyFactory.getCacheSize0();
    }

    private static native int getCacheSize0();

    public int getNodeNum() {
        return BuDDyFactory.getNodeNum0();
    }

    private static native int getNodeNum0();

    public int reorderGain() {
        return BuDDyFactory.reorderGain0();
    }

    private static native int reorderGain0();

    public void printStat() {
        BuDDyFactory.printStat0();
    }

    private static native void printStat0();

    protected BDDDomain createDomain(int a, BigInteger b) {
        return new BuDDyBDDDomain(a, b);
    }

    protected BDDBitVector createBitVector(int a) {
        return new BuDDyBDDBitVector(a);
    }

    public String getVersion() {
        return BuDDyFactory.getVersion0() + " rev" + REVISION.substring(11, REVISION.length() - 2);
    }

    private static native String getVersion0();

    private static void gc_callback(int i) {
        INSTANCE.gbc_handler(i != 0, BuDDyFactory.INSTANCE.gcstats);
    }

    private static void reorder_callback(int i) {
        INSTANCE.reorder_handler(i != 0, BuDDyFactory.INSTANCE.reorderstats);
    }

    private static void resize_callback(int i, int j) {
        INSTANCE.resize_handler(i, j);
    }

    static {
        String libname = BuDDyFactory.getProperty("buddylib", "buddy");
        try {
            System.loadLibrary(libname);
        }
        catch (UnsatisfiedLinkError x) {
            libname = System.mapLibraryName(libname);
            String currentdir = BuDDyFactory.getProperty("user.dir", ".");
            String sep = BuDDyFactory.getProperty("file.separator", "/");
            String filename = currentdir + sep + libname;
            try {
                System.load(filename);
            }
            catch (UnsatisfiedLinkError y) {
                File f = new File(filename);
                if (!f.exists()) {
                    throw y;
                }
                try {
                    File f2 = File.createTempFile("buddy", ".dll");
                    BuDDyFactory.copyFile(f, f2);
                    f2.deleteOnExit();
                    System.out.println("buddy.dll is in use, linking temporary copy " + f2);
                    System.load(f2.getAbsolutePath());
                }
                catch (IOException z) {
                    throw y;
                }
            }
        }
        BuDDyFactory.registerNatives();
    }

    private static class BuDDyBDDBitVector
    extends BDDBitVector {
        private BuDDyBDDBitVector(int a) {
            super(a);
        }

        public BDDFactory getFactory() {
            return INSTANCE;
        }
    }

    private static class BuDDyBDDPairingWithFinalizer
    extends BuDDyBDDPairing {
        private BuDDyBDDPairingWithFinalizer(long ptr) {
            super(ptr);
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.free();
        }
    }

    private static class BuDDyBDDPairing
    extends BDDPairing {
        private long _ptr;

        private BuDDyBDDPairing(long ptr) {
            this._ptr = ptr;
        }

        public void set(int oldvar, int newvar) {
            BuDDyBDDPairing.set0(this._ptr, oldvar, newvar);
        }

        private static native void set0(long var0, int var2, int var3);

        public void set(int[] oldvar, int[] newvar) {
            BuDDyBDDPairing.set1(this._ptr, oldvar, newvar);
        }

        private static native void set1(long var0, int[] var2, int[] var3);

        public void set(int oldvar, BDD newvar) {
            BuDDyBDD c = (BuDDyBDD)newvar;
            BuDDyBDDPairing.set2(this._ptr, oldvar, c._id);
        }

        private static native void set2(long var0, int var2, int var3);

        public void set(int[] oldvar, BDD[] newvar) {
            int[] a = BuDDyFactory.toBuDDyArray(Arrays.asList(newvar));
            BuDDyBDDPairing.set3(this._ptr, oldvar, a);
        }

        private static native void set3(long var0, int[] var2, int[] var3);

        public void reset() {
            BuDDyBDDPairing.reset0(this._ptr);
        }

        private static native void reset0(long var0);

        public void free() {
            if (this._ptr != 0L) {
                BuDDyBDDPairing.free0(this._ptr);
            }
            this._ptr = 0L;
        }

        private static native void free0(long var0);
    }

    private static class BuDDyBDDDomain
    extends BDDDomain {
        private BuDDyBDDDomain(int a, BigInteger b) {
            super(a, b);
        }

        public BDDFactory getFactory() {
            return INSTANCE;
        }
    }

    private static class BuDDyBDDWithFinalizer
    extends BuDDyBDD {
        protected BuDDyBDDWithFinalizer(int id) {
            super(id);
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (this._id >= 0) {
                System.out.println("BDD not freed! " + System.identityHashCode(this) + " _id " + this._id + " nodes: " + this.nodeCount());
            }
        }
    }

    private static class BuDDyBDD
    extends BDD {
        protected int _id;
        static final int INVALID_BDD = -1;

        protected BuDDyBDD(int id) {
            this._id = id;
            BuDDyBDD.addRef(this._id);
        }

        public BDDFactory getFactory() {
            return INSTANCE;
        }

        public boolean isZero() {
            return this._id == 0;
        }

        public boolean isOne() {
            return this._id == 1;
        }

        public int var() {
            return BuDDyBDD.var0(this._id);
        }

        private static native int var0(int var0);

        public BDD high() {
            int b = BuDDyBDD.high0(this._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static native int high0(int var0);

        public BDD low() {
            int b = BuDDyBDD.low0(this._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static native int low0(int var0);

        public BDD id() {
            return BuDDyFactory.makeBDD(this._id);
        }

        public BDD not() {
            int b = BuDDyBDD.not0(this._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static native int not0(int var0);

        public BDD ite(BDD thenBDD, BDD elseBDD) {
            BuDDyBDD c = (BuDDyBDD)thenBDD;
            BuDDyBDD d = (BuDDyBDD)elseBDD;
            int b = BuDDyBDD.ite0(this._id, c._id, d._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static native int ite0(int var0, int var1, int var2);

        public BDD relprod(BDD that, BDD var) {
            BuDDyBDD c = (BuDDyBDD)that;
            BuDDyBDD d = (BuDDyBDD)var;
            int b = BuDDyBDD.relprod0(this._id, c._id, d._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static native int relprod0(int var0, int var1, int var2);

        public BDD compose(BDD that, int var) {
            BuDDyBDD c = (BuDDyBDD)that;
            int b = BuDDyBDD.compose0(this._id, c._id, var);
            return BuDDyFactory.makeBDD(b);
        }

        private static native int compose0(int var0, int var1, int var2);

        public BDD constrain(BDD that) {
            BuDDyBDD c = (BuDDyBDD)that;
            int b = BuDDyBDD.constrain0(this._id, c._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static native int constrain0(int var0, int var1);

        public BDD exist(BDD var) {
            BuDDyBDD c = (BuDDyBDD)var;
            int b = BuDDyBDD.exist0(this._id, c._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static native int exist0(int var0, int var1);

        public BDD forAll(BDD var) {
            BuDDyBDD c = (BuDDyBDD)var;
            int b = BuDDyBDD.forAll0(this._id, c._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static native int forAll0(int var0, int var1);

        public BDD unique(BDD var) {
            BuDDyBDD c = (BuDDyBDD)var;
            int b = BuDDyBDD.unique0(this._id, c._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static native int unique0(int var0, int var1);

        public BDD restrict(BDD var) {
            BuDDyBDD c = (BuDDyBDD)var;
            int b = BuDDyBDD.restrict0(this._id, c._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static native int restrict0(int var0, int var1);

        public BDD restrictWith(BDD var) {
            BuDDyBDD c = (BuDDyBDD)var;
            int b = BuDDyBDD.restrict0(this._id, c._id);
            BuDDyBDD.addRef(b);
            BuDDyBDD.delRef(this._id);
            if (this != c) {
                BuDDyBDD.delRef(c._id);
                c._id = -1;
            }
            this._id = b;
            return this;
        }

        public BDD simplify(BDD d) {
            BuDDyBDD c = (BuDDyBDD)d;
            int b = BuDDyBDD.simplify0(this._id, c._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static native int simplify0(int var0, int var1);

        public BDD support() {
            int b = BuDDyBDD.support0(this._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static native int support0(int var0);

        public BDD apply(BDD that, BDDFactory.BDDOp opr) {
            BuDDyBDD c = (BuDDyBDD)that;
            int b = BuDDyBDD.apply0(this._id, c._id, opr.id);
            return BuDDyFactory.makeBDD(b);
        }

        private static native int apply0(int var0, int var1, int var2);

        public BDD applyWith(BDD that, BDDFactory.BDDOp opr) {
            BuDDyBDD c = (BuDDyBDD)that;
            int b = BuDDyBDD.apply0(this._id, c._id, opr.id);
            BuDDyBDD.addRef(b);
            BuDDyBDD.delRef(this._id);
            if (this != c) {
                BuDDyBDD.delRef(c._id);
                c._id = -1;
            }
            this._id = b;
            return this;
        }

        public BDD applyAll(BDD that, BDDFactory.BDDOp opr, BDD var) {
            BuDDyBDD c = (BuDDyBDD)that;
            BuDDyBDD d = (BuDDyBDD)var;
            int b = BuDDyBDD.applyAll0(this._id, c._id, opr.id, d._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static native int applyAll0(int var0, int var1, int var2, int var3);

        public BDD applyEx(BDD that, BDDFactory.BDDOp opr, BDD var) {
            BuDDyBDD c = (BuDDyBDD)that;
            BuDDyBDD d = (BuDDyBDD)var;
            int b = BuDDyBDD.applyEx0(this._id, c._id, opr.id, d._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static native int applyEx0(int var0, int var1, int var2, int var3);

        public BDD applyUni(BDD that, BDDFactory.BDDOp opr, BDD var) {
            BuDDyBDD c = (BuDDyBDD)that;
            BuDDyBDD d = (BuDDyBDD)var;
            int b = BuDDyBDD.applyUni0(this._id, c._id, opr.id, d._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static native int applyUni0(int var0, int var1, int var2, int var3);

        public BDD satOne() {
            int b = BuDDyBDD.satOne0(this._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static native int satOne0(int var0);

        public BDD fullSatOne() {
            int b = BuDDyBDD.fullSatOne0(this._id);
            return BuDDyFactory.makeBDD(b);
        }

        private static native int fullSatOne0(int var0);

        public BDD satOne(BDD var, boolean pol) {
            BuDDyBDD c = (BuDDyBDD)var;
            int b = BuDDyBDD.satOne1(this._id, c._id, pol ? 1 : 0);
            return BuDDyFactory.makeBDD(b);
        }

        private static native int satOne1(int var0, int var1, int var2);

        public List allsat() {
            return Arrays.asList(BuDDyBDD.allsat0(this._id));
        }

        private static native byte[][] allsat0(int var0);

        public void printSet() {
            BuDDyBDD.printSet0(this._id);
        }

        private static native void printSet0(int var0);

        public void printDot() {
            BuDDyBDD.printDot0(this._id);
        }

        private static native void printDot0(int var0);

        public int nodeCount() {
            return BuDDyBDD.nodeCount0(this._id);
        }

        private static native int nodeCount0(int var0);

        public double pathCount() {
            return BuDDyBDD.pathCount0(this._id);
        }

        private static native double pathCount0(int var0);

        public double satCount() {
            return BuDDyBDD.satCount0(this._id);
        }

        private static native double satCount0(int var0);

        public double satCount(BDD varset) {
            BuDDyBDD c = (BuDDyBDD)varset;
            return BuDDyBDD.satCount1(this._id, c._id);
        }

        private static native double satCount1(int var0, int var1);

        public double logSatCount() {
            return BuDDyBDD.logSatCount0(this._id);
        }

        private static native double logSatCount0(int var0);

        public double logSatCount(BDD varset) {
            BuDDyBDD c = (BuDDyBDD)varset;
            return BuDDyBDD.logSatCount1(this._id, c._id);
        }

        private static native double logSatCount1(int var0, int var1);

        public int[] varProfile() {
            return BuDDyBDD.varProfile0(this._id);
        }

        private static native int[] varProfile0(int var0);

        private static native void addRef(int var0);

        private static native void delRef(int var0);

        public void free() {
            if (INSTANCE != null) {
                BuDDyBDD.delRef(this._id);
            }
            this._id = -1;
        }

        public BDD veccompose(BDDPairing pair) {
            BuDDyBDDPairing p = (BuDDyBDDPairing)pair;
            int b = BuDDyBDD.veccompose0(this._id, p._ptr);
            return BuDDyFactory.makeBDD(b);
        }

        private static native int veccompose0(int var0, long var1);

        public BDD replace(BDDPairing pair) {
            BuDDyBDDPairing p = (BuDDyBDDPairing)pair;
            int b = BuDDyBDD.replace0(this._id, p._ptr);
            return BuDDyFactory.makeBDD(b);
        }

        private static native int replace0(int var0, long var1);

        public BDD replaceWith(BDDPairing pair) {
            BuDDyBDDPairing p = (BuDDyBDDPairing)pair;
            int b = BuDDyBDD.replace0(this._id, p._ptr);
            BuDDyBDD.addRef(b);
            BuDDyBDD.delRef(this._id);
            this._id = b;
            return this;
        }

        public boolean equals(BDD that) {
            return this._id == ((BuDDyBDD)that)._id;
        }

        public int hashCode() {
            return this._id;
        }
    }

    private static class BuDDyFactoryWithFinalizer
    extends BuDDyFactory {
        private BuDDyFactoryWithFinalizer() {
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.done();
        }
    }
}

