/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javabdd;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDBitVector;
import net.sf.javabdd.BDDDomain;
import net.sf.javabdd.BDDFactory;
import net.sf.javabdd.BDDPairing;

public class TestBDDFactory
extends BDDFactory {
    BDDFactory f1;
    BDDFactory f2;
    public static final String REVISION = "$Revision: 1.7 $";

    public TestBDDFactory(BDDFactory a, BDDFactory b) {
        this.f1 = a;
        this.f2 = b;
    }

    public static BDDFactory init(int nodenum, int cachesize) {
        String bdd1 = TestBDDFactory.getProperty("bdd1", "j");
        String bdd2 = TestBDDFactory.getProperty("bdd2", "micro");
        BDDFactory a = BDDFactory.init(bdd1, nodenum, cachesize);
        BDDFactory b = BDDFactory.init(bdd2, nodenum, cachesize);
        return new TestBDDFactory(a, b);
    }

    public static final void assertSame(boolean b, String s) {
        if (!b) {
            throw new InternalError(s);
        }
    }

    public static final void assertSame(BDD b1, BDD b2, String s) {
        if (!b1.toString().equals(b2.toString())) {
            System.out.println("b1 = " + b1.nodeCount());
            System.out.println("b2 = " + b2.nodeCount());
            System.out.println("b1 = " + b1.toString());
            System.out.println("b2 = " + b2.toString());
            throw new InternalError(s);
        }
    }

    public static final void assertSame(boolean b, BDD b1, BDD b2, String s) {
        if (!b) {
            System.err.println("b1 = " + b1);
            System.err.println("b2 = " + b2);
            throw new InternalError(s);
        }
    }

    public BDD zero() {
        return new TestBDD(this.f1.zero(), this.f2.zero());
    }

    public BDD one() {
        return new TestBDD(this.f1.one(), this.f2.one());
    }

    protected void initialize(int nodenum, int cachesize) {
        this.f1.initialize(nodenum, cachesize);
        this.f2.initialize(nodenum, cachesize);
    }

    public boolean isInitialized() {
        boolean r2;
        boolean r1 = this.f1.isInitialized();
        TestBDDFactory.assertSame(r1 == (r2 = this.f2.isInitialized()), "isInitialized");
        return r1;
    }

    public void done() {
        this.f1.done();
        this.f2.done();
    }

    public void setError(int code) {
        this.f1.setError(code);
        this.f2.setError(code);
    }

    public void clearError() {
        this.f1.clearError();
        this.f2.clearError();
    }

    public int setMaxNodeNum(int size) {
        int r2;
        int r1 = this.f1.setMaxNodeNum(size);
        TestBDDFactory.assertSame(r1 == (r2 = this.f2.setMaxNodeNum(size)), "setMaxNodeNum");
        return r1;
    }

    public double setMinFreeNodes(double x) {
        double r2;
        double r1 = this.f1.setMinFreeNodes(x);
        TestBDDFactory.assertSame(r1 == (r2 = this.f2.setMinFreeNodes(x)), "setMinFreeNodes");
        return r1;
    }

    public double setIncreaseFactor(double x) {
        double r2;
        double r1 = this.f1.setIncreaseFactor(x);
        TestBDDFactory.assertSame(r1 == (r2 = this.f2.setIncreaseFactor(x)), "setIncreaseFactor");
        return r1;
    }

    public int setMaxIncrease(int x) {
        int r2;
        int r1 = this.f1.setMaxIncrease(x);
        TestBDDFactory.assertSame(r1 == (r2 = this.f2.setMaxIncrease(x)), "setMaxIncrease");
        return r1;
    }

    public double setCacheRatio(double x) {
        double r2;
        double r1 = this.f1.setCacheRatio(x);
        TestBDDFactory.assertSame(r1 == (r2 = this.f2.setCacheRatio(x)), "setCacheRatio");
        return r1;
    }

    public int setNodeTableSize(int size) {
        int r2;
        int r1 = this.f1.setNodeTableSize(size);
        TestBDDFactory.assertSame(r1 == (r2 = this.f2.setNodeTableSize(size)), "setNodeTableSize");
        return r1;
    }

    public int setCacheSize(int size) {
        int r2;
        int r1 = this.f1.setCacheSize(size);
        TestBDDFactory.assertSame(r1 == (r2 = this.f2.setCacheSize(size)), "setCacheSize");
        return r1;
    }

    public int varNum() {
        int r2;
        int r1 = this.f1.varNum();
        TestBDDFactory.assertSame(r1 == (r2 = this.f2.varNum()), "varNum");
        return r1;
    }

    public int setVarNum(int num) {
        int r1 = this.f1.setVarNum(num);
        int r2 = this.f2.setVarNum(num);
        return r1;
    }

    public int duplicateVar(int var) {
        int r2;
        int r1 = this.f1.duplicateVar(var);
        TestBDDFactory.assertSame(r1 == (r2 = this.f2.duplicateVar(var)), "duplicateVar");
        return r1;
    }

    public BDD ithVar(int var) {
        return new TestBDD(this.f1.ithVar(var), this.f2.ithVar(var));
    }

    public BDD nithVar(int var) {
        return new TestBDD(this.f1.nithVar(var), this.f2.nithVar(var));
    }

    public void printAll() {
        this.f1.printAll();
    }

    public void printTable(BDD b) {
        BDD b1 = ((TestBDD)b).b1;
        this.f1.printTable(b1);
    }

    public BDD load(String filename) throws IOException {
        return new TestBDD(this.f1.load(filename), this.f2.load(filename));
    }

    public void save(String filename, BDD var) throws IOException {
        BDD b1 = ((TestBDD)var).b1;
        this.f1.save(filename, b1);
    }

    public int level2Var(int level) {
        int r2;
        int r1 = this.f1.level2Var(level);
        TestBDDFactory.assertSame(r1 == (r2 = this.f2.level2Var(level)), "level2Var");
        return r1;
    }

    public int var2Level(int var) {
        int r2;
        int r1 = this.f1.var2Level(var);
        TestBDDFactory.assertSame(r1 == (r2 = this.f2.var2Level(var)), "var2Level");
        return r1;
    }

    public void reorder(BDDFactory.ReorderMethod m) {
        this.f1.reorder(m);
        this.f2.reorder(m);
    }

    public void autoReorder(BDDFactory.ReorderMethod method) {
        this.f1.autoReorder(method);
        this.f2.autoReorder(method);
    }

    public void autoReorder(BDDFactory.ReorderMethod method, int max) {
        this.f1.autoReorder(method, max);
        this.f2.autoReorder(method, max);
    }

    public BDDFactory.ReorderMethod getReorderMethod() {
        BDDFactory.ReorderMethod r1 = this.f1.getReorderMethod();
        BDDFactory.ReorderMethod r2 = this.f2.getReorderMethod();
        TestBDDFactory.assertSame(r1.equals(r2), "getReorderMethod");
        return r1;
    }

    public int getReorderTimes() {
        int r2;
        int r1 = this.f1.getReorderTimes();
        TestBDDFactory.assertSame(r1 == (r2 = this.f2.getReorderTimes()), "getReorderTimes");
        return r1;
    }

    public void disableReorder() {
        this.f1.disableReorder();
        this.f2.disableReorder();
    }

    public void enableReorder() {
        this.f1.enableReorder();
        this.f2.enableReorder();
    }

    public int reorderVerbose(int v) {
        int r2;
        int r1 = this.f1.reorderVerbose(v);
        TestBDDFactory.assertSame(r1 == (r2 = this.f2.reorderVerbose(v)), "reorderVerbose");
        return r1;
    }

    public void setVarOrder(int[] neworder) {
        this.f1.setVarOrder(neworder);
        this.f2.setVarOrder(neworder);
    }

    public void addVarBlock(BDD var, boolean fixed) {
        BDD c1 = ((TestBDD)var).b1;
        BDD c2 = ((TestBDD)var).b2;
        this.f1.addVarBlock(c1, fixed);
        this.f2.addVarBlock(c2, fixed);
    }

    public void addVarBlock(int first, int last, boolean fixed) {
        this.f1.addVarBlock(first, last, fixed);
        this.f2.addVarBlock(first, last, fixed);
    }

    public void varBlockAll() {
        this.f1.varBlockAll();
        this.f2.varBlockAll();
    }

    public void clearVarBlocks() {
        this.f1.clearVarBlocks();
        this.f2.clearVarBlocks();
    }

    public void printOrder() {
        this.f1.printOrder();
    }

    public int nodeCount(Collection r) {
        int r2;
        LinkedList<BDD> a1 = new LinkedList<BDD>();
        LinkedList<BDD> a2 = new LinkedList<BDD>();
        Iterator i = r.iterator();
        while (i.hasNext()) {
            TestBDD b = (TestBDD)i.next();
            a1.add(b.b1);
            a2.add(b.b2);
        }
        int r1 = this.f1.nodeCount(a1);
        TestBDDFactory.assertSame(r1 == (r2 = this.f2.nodeCount(a2)), "nodeCount");
        return r1;
    }

    public int getNodeTableSize() {
        int r2;
        int r1 = this.f1.getNodeTableSize();
        TestBDDFactory.assertSame(r1 == (r2 = this.f2.getNodeTableSize()), "getNodeTableSize");
        return r1;
    }

    public int getNodeNum() {
        int r2;
        int r1 = this.f1.getNodeNum();
        TestBDDFactory.assertSame(r1 == (r2 = this.f2.getNodeNum()), "getNodeNum");
        return r1;
    }

    public int getCacheSize() {
        int r2;
        int r1 = this.f1.getCacheSize();
        TestBDDFactory.assertSame(r1 == (r2 = this.f2.getCacheSize()), "getCacheSize");
        return r1;
    }

    public int reorderGain() {
        int r2;
        int r1 = this.f1.reorderGain();
        TestBDDFactory.assertSame(r1 == (r2 = this.f2.reorderGain()), "reorderGain");
        return r1;
    }

    public void printStat() {
        this.f1.printStat();
    }

    public BDDPairing makePair() {
        BDDPairing p1 = this.f1.makePair();
        BDDPairing p2 = this.f2.makePair();
        return new TestBDDPairing(p1, p2);
    }

    public void swapVar(int v1, int v2) {
        this.f1.swapVar(v1, v2);
        this.f2.swapVar(v1, v2);
    }

    protected BDDDomain createDomain(int a, BigInteger b) {
        return new TestBDDDomain(a, b);
    }

    protected BDDBitVector createBitVector(int a) {
        return new TestBDDBitVector(a);
    }

    public String getVersion() {
        return "TestBDD " + REVISION.substring(11, REVISION.length() - 2) + " of (" + this.f1.getVersion() + "," + this.f2.getVersion() + ")";
    }

    private class TestBDDBitVector
    extends BDDBitVector {
        TestBDDBitVector(int a) {
            super(a);
        }

        public BDDFactory getFactory() {
            return TestBDDFactory.this;
        }
    }

    private class TestBDDDomain
    extends BDDDomain {
        private TestBDDDomain(int a, BigInteger b) {
            super(a, b);
        }

        public BDDFactory getFactory() {
            return TestBDDFactory.this;
        }
    }

    private static class TestBDDPairing
    extends BDDPairing {
        BDDPairing b1;
        BDDPairing b2;

        TestBDDPairing(BDDPairing p1, BDDPairing p2) {
            this.b1 = p1;
            this.b2 = p2;
        }

        public void set(int oldvar, int newvar) {
            this.b1.set(oldvar, newvar);
            this.b2.set(oldvar, newvar);
        }

        public void set(int oldvar, BDD newvar) {
            this.b1.set(oldvar, newvar);
            this.b2.set(oldvar, newvar);
        }

        public void reset() {
            this.b1.reset();
            this.b2.reset();
        }
    }

    private class TestBDD
    extends BDD {
        BDD b1;
        BDD b2;

        TestBDD(BDD a, BDD b) {
            this.b1 = a;
            this.b2 = b;
            TestBDDFactory.assertSame(a, b, "constructor");
        }

        public BDDFactory getFactory() {
            return TestBDDFactory.this;
        }

        public boolean isZero() {
            boolean r2;
            boolean r1 = this.b1.isZero();
            TestBDDFactory.assertSame(r1 == (r2 = this.b2.isZero()), this.b1, this.b2, "isZero");
            return r1;
        }

        public boolean isOne() {
            boolean r2;
            boolean r1 = this.b1.isOne();
            TestBDDFactory.assertSame(r1 == (r2 = this.b2.isOne()), this.b1, this.b2, "isOne");
            return r1;
        }

        public int var() {
            int r2;
            int r1 = this.b1.var();
            TestBDDFactory.assertSame(r1 == (r2 = this.b2.var()), this.b1, this.b2, "var");
            return r1;
        }

        public BDD high() {
            BDD r1 = this.b1.high();
            BDD r2 = this.b2.high();
            return new TestBDD(r1, r2);
        }

        public BDD low() {
            BDD r1 = this.b1.low();
            BDD r2 = this.b2.low();
            return new TestBDD(r1, r2);
        }

        public BDD id() {
            BDD r1 = this.b1.id();
            BDD r2 = this.b2.id();
            return new TestBDD(r1, r2);
        }

        public BDD not() {
            BDD r1 = this.b1.not();
            BDD r2 = this.b2.not();
            return new TestBDD(r1, r2);
        }

        public BDD ite(BDD thenBDD, BDD elseBDD) {
            BDD c1 = ((TestBDD)thenBDD).b1;
            BDD c2 = ((TestBDD)thenBDD).b2;
            BDD d1 = ((TestBDD)elseBDD).b1;
            BDD d2 = ((TestBDD)elseBDD).b2;
            BDD r1 = this.b1.ite(c1, d1);
            BDD r2 = this.b2.ite(c2, d2);
            return new TestBDD(r1, r2);
        }

        public BDD relprod(BDD that, BDD var) {
            BDD c1 = ((TestBDD)that).b1;
            BDD c2 = ((TestBDD)that).b2;
            BDD d1 = ((TestBDD)var).b1;
            BDD d2 = ((TestBDD)var).b2;
            BDD r1 = this.b1.relprod(c1, d1);
            BDD r2 = this.b2.relprod(c2, d2);
            return new TestBDD(r1, r2);
        }

        public BDD compose(BDD g, int var) {
            BDD c1 = ((TestBDD)g).b1;
            BDD c2 = ((TestBDD)g).b2;
            BDD r1 = this.b1.compose(c1, var);
            BDD r2 = this.b2.compose(c2, var);
            return new TestBDD(r1, r2);
        }

        public BDD veccompose(BDDPairing pair) {
            BDDPairing c1 = ((TestBDDPairing)pair).b1;
            BDDPairing c2 = ((TestBDDPairing)pair).b2;
            BDD r1 = this.b1.veccompose(c1);
            BDD r2 = this.b2.veccompose(c2);
            return new TestBDD(r1, r2);
        }

        public BDD constrain(BDD that) {
            BDD c1 = ((TestBDD)that).b1;
            BDD c2 = ((TestBDD)that).b2;
            BDD r1 = this.b1.constrain(c1);
            BDD r2 = this.b2.constrain(c2);
            return new TestBDD(r1, r2);
        }

        public BDD exist(BDD var) {
            BDD c1 = ((TestBDD)var).b1;
            BDD c2 = ((TestBDD)var).b2;
            BDD r1 = this.b1.exist(c1);
            BDD r2 = this.b2.exist(c2);
            return new TestBDD(r1, r2);
        }

        public BDD forAll(BDD var) {
            BDD c1 = ((TestBDD)var).b1;
            BDD c2 = ((TestBDD)var).b2;
            BDD r1 = this.b1.forAll(c1);
            BDD r2 = this.b2.forAll(c2);
            return new TestBDD(r1, r2);
        }

        public BDD unique(BDD var) {
            BDD c1 = ((TestBDD)var).b1;
            BDD c2 = ((TestBDD)var).b2;
            BDD r1 = this.b1.unique(c1);
            BDD r2 = this.b2.unique(c2);
            return new TestBDD(r1, r2);
        }

        public BDD restrict(BDD var) {
            BDD c1 = ((TestBDD)var).b1;
            BDD c2 = ((TestBDD)var).b2;
            BDD r1 = this.b1.restrict(c1);
            BDD r2 = this.b2.restrict(c2);
            return new TestBDD(r1, r2);
        }

        public BDD restrictWith(BDD var) {
            BDD c1 = ((TestBDD)var).b1;
            BDD c2 = ((TestBDD)var).b2;
            this.b1.restrictWith(c1);
            this.b2.restrictWith(c2);
            TestBDDFactory.assertSame(this.b1, this.b2, "restrict");
            return this;
        }

        public BDD simplify(BDD d) {
            BDD c1 = ((TestBDD)d).b1;
            BDD c2 = ((TestBDD)d).b2;
            BDD r1 = this.b1.simplify(c1);
            BDD r2 = this.b2.simplify(c2);
            return new TestBDD(r1, r2);
        }

        public BDD support() {
            BDD r1 = this.b1.support();
            BDD r2 = this.b2.support();
            return new TestBDD(r1, r2);
        }

        public BDD apply(BDD that, BDDFactory.BDDOp opr) {
            BDD c1 = ((TestBDD)that).b1;
            BDD c2 = ((TestBDD)that).b2;
            BDD r1 = this.b1.apply(c1, opr);
            BDD r2 = this.b2.apply(c2, opr);
            return new TestBDD(r1, r2);
        }

        public BDD applyWith(BDD that, BDDFactory.BDDOp opr) {
            BDD c1 = ((TestBDD)that).b1;
            BDD c2 = ((TestBDD)that).b2;
            this.b1.applyWith(c1, opr);
            this.b2.applyWith(c2, opr);
            TestBDDFactory.assertSame(this.b1, this.b2, "applyWith " + opr);
            return this;
        }

        public BDD applyAll(BDD that, BDDFactory.BDDOp opr, BDD var) {
            BDD c1 = ((TestBDD)that).b1;
            BDD c2 = ((TestBDD)that).b2;
            BDD e1 = ((TestBDD)var).b1;
            BDD e2 = ((TestBDD)var).b2;
            BDD r1 = this.b1.applyAll(c1, opr, e1);
            BDD r2 = this.b2.applyAll(c2, opr, e2);
            return new TestBDD(r1, r2);
        }

        public BDD applyEx(BDD that, BDDFactory.BDDOp opr, BDD var) {
            BDD c1 = ((TestBDD)that).b1;
            BDD c2 = ((TestBDD)that).b2;
            BDD e1 = ((TestBDD)var).b1;
            BDD e2 = ((TestBDD)var).b2;
            BDD r1 = this.b1.applyEx(c1, opr, e1);
            BDD r2 = this.b2.applyEx(c2, opr, e2);
            return new TestBDD(r1, r2);
        }

        public BDD applyUni(BDD that, BDDFactory.BDDOp opr, BDD var) {
            BDD c1 = ((TestBDD)that).b1;
            BDD c2 = ((TestBDD)that).b2;
            BDD e1 = ((TestBDD)var).b1;
            BDD e2 = ((TestBDD)var).b2;
            BDD r1 = this.b1.applyUni(c1, opr, e1);
            BDD r2 = this.b2.applyUni(c2, opr, e2);
            return new TestBDD(r1, r2);
        }

        public BDD satOne() {
            BDD r1 = this.b1.satOne();
            BDD r2 = this.b2.satOne();
            return new TestBDD(r1, r2);
        }

        public BDD fullSatOne() {
            BDD r1 = this.b1.fullSatOne();
            BDD r2 = this.b2.fullSatOne();
            return new TestBDD(r1, r2);
        }

        public BDD satOne(BDD var, boolean pol) {
            BDD c1 = ((TestBDD)var).b1;
            BDD c2 = ((TestBDD)var).b2;
            BDD r1 = this.b1.satOne(c1, pol);
            BDD r2 = this.b2.satOne(c2, pol);
            return new TestBDD(r1, r2);
        }

        public List allsat() {
            List r1 = this.b1.allsat();
            List r2 = this.b2.allsat();
            TestBDDFactory.assertSame(r1.size() == r2.size(), this.b1, this.b2, "allsat");
            LinkedList<TestBDD> r = new LinkedList<TestBDD>();
            Iterator i = r1.iterator();
            Iterator j = r2.iterator();
            while (i.hasNext()) {
                BDD c1 = (BDD)i.next();
                BDD c2 = (BDD)j.next();
                r.add(new TestBDD(c1, c2));
            }
            return r;
        }

        public BDD replace(BDDPairing pair) {
            BDDPairing c1 = ((TestBDDPairing)pair).b1;
            BDDPairing c2 = ((TestBDDPairing)pair).b2;
            BDD r1 = this.b1.replace(c1);
            BDD r2 = this.b2.replace(c2);
            return new TestBDD(r1, r2);
        }

        public BDD replaceWith(BDDPairing pair) {
            BDDPairing c1 = ((TestBDDPairing)pair).b1;
            BDDPairing c2 = ((TestBDDPairing)pair).b2;
            this.b1.replaceWith(c1);
            this.b2.replaceWith(c2);
            TestBDDFactory.assertSame(this.b1, this.b2, "replaceWith");
            return this;
        }

        public void printDot() {
            this.b1.printDot();
        }

        public int nodeCount() {
            int r2;
            int r1 = this.b1.nodeCount();
            TestBDDFactory.assertSame(r1 == (r2 = this.b2.nodeCount()), this.b1, this.b2, "nodeCount");
            return r1;
        }

        public double pathCount() {
            double r2;
            double r1 = this.b1.pathCount();
            TestBDDFactory.assertSame(r1 == (r2 = this.b2.pathCount()), this.b1, this.b2, "pathCount");
            return r1;
        }

        public double satCount() {
            double r2;
            double r1 = this.b1.satCount();
            TestBDDFactory.assertSame(r1 == (r2 = this.b2.satCount()), this.b1, this.b2, "satCount");
            return r1;
        }

        public int[] varProfile() {
            int[] r2;
            int[] r1 = this.b1.varProfile();
            TestBDDFactory.assertSame(r1.length == (r2 = this.b2.varProfile()).length, "varProfile");
            for (int i = 0; i < r1.length; ++i) {
                TestBDDFactory.assertSame(r1[i] == r2[i], "varProfile");
            }
            return r1;
        }

        public boolean equals(BDD that) {
            boolean r2;
            BDD c1 = ((TestBDD)that).b1;
            BDD c2 = ((TestBDD)that).b2;
            boolean r1 = this.b1.equals(c1);
            TestBDDFactory.assertSame(r1 == (r2 = this.b2.equals(c2)), this.b1, this.b2, "equals");
            return r1;
        }

        public int hashCode() {
            this.b1.hashCode();
            return this.b2.hashCode();
        }

        public void free() {
            this.b1.free();
            this.b2.free();
        }
    }
}

