/*
 * Decompiled with CFR 0.152.
 */
package ap;

import ap.AbstractFileProver;
import ap.CmdlMain$NullStream$;
import ap.IntelliFileProver;
import ap.ParallelFileProver;
import ap.ParallelFileProver$;
import ap.Prover;
import ap.Prover$NoCounterModel$;
import ap.Prover$NoModel$;
import ap.Prover$TimeoutResult$;
import ap.SimpleAPI;
import ap.SimpleAPI$;
import ap.parameters.GlobalSettings;
import ap.parameters.GlobalSettings$;
import ap.parameters.Param$ASSERTIONS$;
import ap.parameters.Param$COMPUTE_UNSAT_CORE$;
import ap.parameters.Param$FULL_HELP$;
import ap.parameters.Param$GENERATE_TOTALITY_AXIOMS$;
import ap.parameters.Param$INCREMENTAL$;
import ap.parameters.Param$INPUT_FORMAT$;
import ap.parameters.Param$InputFormat$;
import ap.parameters.Param$LOGO$;
import ap.parameters.Param$MOST_GENERAL_CONSTRAINT$;
import ap.parameters.Param$NEG_SOLVING$;
import ap.parameters.Param$NegSolvingOptions$;
import ap.parameters.Param$PORTFOLIO$;
import ap.parameters.Param$PRINT_CERTIFICATE$;
import ap.parameters.Param$PRINT_DOT_CERTIFICATE_FILE$;
import ap.parameters.Param$PRINT_SMT_FILE$;
import ap.parameters.Param$PRINT_TPTP_FILE$;
import ap.parameters.Param$PRINT_TREE$;
import ap.parameters.Param$PROOF_CONSTRUCTION_GLOBAL$;
import ap.parameters.Param$PortfolioOptions$;
import ap.parameters.Param$ProofConstructionOptions$;
import ap.parameters.Param$QUIET$;
import ap.parameters.Param$RANDOM_SEED$;
import ap.parameters.Param$STDIN$;
import ap.parameters.Param$TIMEOUT$;
import ap.parameters.Param$TIMEOUT_PER$;
import ap.parameters.Param$VERSION$;
import ap.parser.IBinJunctor$;
import ap.parser.IExpression$;
import ap.parser.IExpression$Eq$;
import ap.parser.IFormula;
import ap.parser.IFunction;
import ap.parser.IInterpolantSpec;
import ap.parser.INamedPart;
import ap.parser.Internal2InputAbsy$;
import ap.parser.LineariseVisitor$;
import ap.parser.PartName;
import ap.parser.PartName$;
import ap.parser.PrincessLineariser$;
import ap.parser.SMTLineariser$;
import ap.parser.SMTParser2InputAbsy$;
import ap.parser.Simplifier;
import ap.parser.Simplifier$;
import ap.parser.TPTPLineariser$;
import ap.proof.certificates.CertFormula;
import ap.proof.certificates.CertFormula$;
import ap.proof.certificates.Certificate;
import ap.proof.certificates.CertificatePrettyPrinter;
import ap.proof.certificates.DagCertificateConverter$;
import ap.proof.certificates.DotLineariser$;
import ap.proof.tree.ProofTree;
import ap.proof.tree.QuantifiedTree$;
import ap.terfor.ConstantTerm;
import ap.terfor.conjunctions.Conjunction;
import ap.terfor.conjunctions.Quantifier;
import ap.terfor.conjunctions.Quantifier$EX$;
import ap.terfor.preds.Predicate;
import ap.util.Debug$;
import ap.util.Timeout$;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import scala.;
import scala.$less$colon$less$;
import scala.Console$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class CmdlMain$ {
    public static final CmdlMain$ MODULE$ = new CmdlMain$();
    private static final String version = "2022-07-01";
    private static boolean stackTraces = false;

    public String version() {
        return version;
    }

    public boolean stackTraces() {
        return stackTraces;
    }

    public void stackTraces_$eq(boolean x$1) {
        stackTraces = x$1;
    }

    public void printGreeting() {
        Predef$.MODULE$.println((Object)"________       _____");
        Predef$.MODULE$.println((Object)"___  __ \\_________(_)________________________________");
        Predef$.MODULE$.println((Object)"__  /_/ /_  ___/_  /__  __ \\  ___/  _ \\_  ___/_  ___/");
        Predef$.MODULE$.println((Object)"_  ____/_  /   _  / _  / / / /__ /  __/(__  )_(__  )");
        Predef$.MODULE$.println((Object)"/_/     /_/    /_/  /_/ /_/\\___/ \\___//____/ /____/");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"A Theorem Prover for First-Order Logic modulo Linear Integer Arithmetic");
        Predef$.MODULE$.println((Object)new StringBuilder(2).append("(").append(this.version()).append(")").toString());
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"(c) Philipp R\u00fcmmer, 2009-2022");
        Predef$.MODULE$.println((Object)"Contributors: Angelo Brillout, Peter Backeman, Peter Baumgartner, Zafer Esen.");
        Predef$.MODULE$.println((Object)"Free software under BSD-3-Clause.");
        Predef$.MODULE$.println((Object)"Bug reports to ph_r@gmx.net");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"For more information, visit http://www.philipp.ruemmer.org/princess.shtml");
    }

    public void printUsage() {
        Predef$.MODULE$.println((Object)"Usage: princess <option>* <inputfile>*");
        Predef$.MODULE$.println();
        this.printOptions();
    }

    public void printOptions() {
        Predef$.MODULE$.println((Object)"Standard options:");
        Predef$.MODULE$.println((Object)" [+-]logo                  Print logo and elapsed time              (default: +)");
        Predef$.MODULE$.println((Object)" [+-]fullHelp              Print detailed help and exit             (default: -)");
        Predef$.MODULE$.println((Object)" [+-]version               Print version and exit                   (default: -)");
        Predef$.MODULE$.println((Object)" [+-]quiet                 Suppress all output to stderr            (default: -)");
        Predef$.MODULE$.println((Object)" [+-]assert                Enable runtime assertions                (default: -)");
        Predef$.MODULE$.println((Object)" -inputFormat=val          Specify format of problem file:       (default: auto)");
        Predef$.MODULE$.println((Object)"                             auto, pri, smtlib, tptp");
        Predef$.MODULE$.println((Object)" [+-]stdin                 Read SMT-LIB 2 problems from stdin       (default: -)");
        Predef$.MODULE$.println((Object)" [+-]incremental           Incremental SMT-LIB 2 interpreter        (default: -)");
        Predef$.MODULE$.println((Object)"                             (+incremental implies -genTotalityAxioms)");
        Predef$.MODULE$.println((Object)" -timeout=val              Set a timeout in milliseconds        (default: infty)");
        Predef$.MODULE$.println((Object)" -timeoutPer=val           Set a timeout per SMT-LIB query (ms) (default: infty)");
        Predef$.MODULE$.println((Object)" [+-]model                 Compute models or countermodels          (default: -)");
        Predef$.MODULE$.println((Object)" [+-]unsatCore             Compute unsatisfiable cores              (default: -)");
        Predef$.MODULE$.println((Object)" [+-]printProof            Output the constructed proof             (default: -)");
        Predef$.MODULE$.println((Object)" [+-]mostGeneralConstraint Derive the most general constraint for this problem");
        Predef$.MODULE$.println((Object)"                           (quantifier elimination for PA formulae) (default: -)");
        Predef$.MODULE$.println((Object)" -clausifier=val           Choose the clausifier (none, simple)  (default: none)");
        Predef$.MODULE$.println((Object)" [+-]genTotalityAxioms     Generate totality axioms for functions   (default: +)");
    }

    public void printExoticOptions() {
        Predef$.MODULE$.println((Object)"Further general options");
        Predef$.MODULE$.println((Object)"-----------------------");
        Predef$.MODULE$.println((Object)" [+-]printTree             Output the internal constraint tree     (default: -)");
        Predef$.MODULE$.println((Object)" -printSMT=filename        Output the problem in SMT-LIB format    (default: \"\")");
        Predef$.MODULE$.println((Object)" -printTPTP=filename       Output the problem in TPTP format       (default: \"\")");
        Predef$.MODULE$.println((Object)" -printDOT=filename        Output the proof in GraphViz format     (default: \"\")");
        Predef$.MODULE$.println((Object)" -portfolio=val            Use a strategy portfolio              (default: none)");
        Predef$.MODULE$.println((Object)"                             none:   off");
        Predef$.MODULE$.println((Object)"                             casc:   Optimised for CASC/TPTP");
        Predef$.MODULE$.println((Object)"                             qf_lia: Optimised for quantifier-free LIA");
        Predef$.MODULE$.println((Object)"                             bv:     Optimised for quantified BV");
        Predef$.MODULE$.println((Object)" -formulaSign=val          Optionally negate input formula       (default: auto)");
        Predef$.MODULE$.println((Object)"                             positive: do not negate");
        Predef$.MODULE$.println((Object)"                             negative: negate");
        Predef$.MODULE$.println((Object)"                             auto:     choose automatically");
        Predef$.MODULE$.println((Object)" -randomSeed=val           Seed for randomisation");
        Predef$.MODULE$.println((Object)"                             <seed>: numeric seed             (default: 1234567)");
        Predef$.MODULE$.println((Object)"                             off:    disable randomisation");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"Proof/interpolation options");
        Predef$.MODULE$.println((Object)"---------------------------");
        Predef$.MODULE$.println((Object)" -constructProofs=val      Extract proofs");
        Predef$.MODULE$.println((Object)"                             never");
        Predef$.MODULE$.println((Object)"                             ifInterpolating: if \\interpolant occurs (default)");
        Predef$.MODULE$.println((Object)"                             always");
        Predef$.MODULE$.println((Object)" [+-]elimInterpolantQuants Eliminate quantifiers from interpolants  (default: +)");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"Quantifier/constraint options");
        Predef$.MODULE$.println((Object)"-----------------------------");
        Predef$.MODULE$.println((Object)" [+-]posUnitResolution     Resolution of clauses with literals in   (default: +)");
        Predef$.MODULE$.println((Object)"                           the antecedent");
        Predef$.MODULE$.println((Object)" [+-]useStrengthenTree     For quantified formulae with inequality  (default: -)");
        Predef$.MODULE$.println((Object)"                           side conditions, use the StrengthenTree");
        Predef$.MODULE$.println((Object)"                           constraint tree constructor");
        Predef$.MODULE$.println((Object)" -simplifyConstraints=val  How to simplify constraints:");
        Predef$.MODULE$.println((Object)"                             none:   not at all");
        Predef$.MODULE$.println((Object)"                             fair:   fair construction of a proof");
        Predef$.MODULE$.println((Object)"                             lemmas: proof construction with lemmas (default)");
        Predef$.MODULE$.println((Object)" [+-]traceConstraintSimplifier  Show constraint simplifications     (default: -)");
        Predef$.MODULE$.println((Object)" [+-]dnfConstraints        Turn ground constraints into DNF         (default: +)");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"Function options");
        Predef$.MODULE$.println((Object)"----------------");
        Predef$.MODULE$.println((Object)" -generateTriggers=val     Automatically choose triggers for quant. formulae");
        Predef$.MODULE$.println((Object)"                             none:  not at all");
        Predef$.MODULE$.println((Object)"                             total: for all total functions         (default)");
        Predef$.MODULE$.println((Object)"                             all:   for all functions");
        Predef$.MODULE$.println((Object)"                             complete, completeFrugal: in combination");
        Predef$.MODULE$.println((Object)"                               with -genTotalityAxioms, in such a way");
        Predef$.MODULE$.println((Object)"                               that completeness is not affected");
        Predef$.MODULE$.println((Object)" -triggerStrategy=val      How to choose triggers for quantified formulae");
        Predef$.MODULE$.println((Object)"                             allMinimal");
        Predef$.MODULE$.println((Object)"                             allMinimalAndEmpty");
        Predef$.MODULE$.println((Object)"                             allMaximal");
        Predef$.MODULE$.println((Object)"                             maximal                                (default)");
        Predef$.MODULE$.println((Object)"                             maximalOutermost");
        Predef$.MODULE$.println((Object)" -functionGC=val           Garbage-collect function terms");
        Predef$.MODULE$.println((Object)"                             none:  not at all");
        Predef$.MODULE$.println((Object)"                             total: for all total functions         (default)");
        Predef$.MODULE$.println((Object)"                             all:   for all functions");
        Predef$.MODULE$.println((Object)" [+-]tightFunctionScopes   Keep function application defs. local    (default: +)");
        Predef$.MODULE$.println((Object)" [+-]boolFunsAsPreds       In smtlib and tptp, encode               (default: -)");
        Predef$.MODULE$.println((Object)"                           Boolean functions as predicates");
        Predef$.MODULE$.println((Object)" [+-]reverseFunctionalityPropagation  Infer distinctness of         (default: -)");
        Predef$.MODULE$.println((Object)"                           arguments from distinctness of results");
        Predef$.MODULE$.println((Object)" [+-]useFunctionalConsistencyTheory  Use dummy theory to represent  (default: -)");
        Predef$.MODULE$.println((Object)"                           functional consistency axioms");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"Theory options");
        Predef$.MODULE$.println((Object)"--------------");
        Predef$.MODULE$.println((Object)" -mulProcedure=val         Handling of nonlinear integer formulae");
        Predef$.MODULE$.println((Object)"                             bitShift: shift-and-add axiom");
        Predef$.MODULE$.println((Object)"                             native:   built-in theory solver       (default)");
        Predef$.MODULE$.println((Object)" -mulSplitting=val         Splitting in nonlinear integer formulae");
        Predef$.MODULE$.println((Object)"                             sign:        +/-/interval splitting    (default)");
        Predef$.MODULE$.println((Object)"                             signMinimal: +/-/interval, minimal var set");
        Predef$.MODULE$.println((Object)" -adtMeasure=val           Measure to ensure acyclicity of ADTs");
        Predef$.MODULE$.println((Object)"                             relDepth: relative depth of terms");
        Predef$.MODULE$.println((Object)"                             size:     size of terms                (default)");
        Predef$.MODULE$.println((Object)" -stringSolver=val         Specify the used string solver");
        Predef$.MODULE$.println((Object)"                             (default: ap.theories.strings.SeqStringTheory)");
        Predef$.MODULE$.println((Object)" [+-]stringEscapes         Accept extended set of string escapes    (default: -)");
    }

    private void printSMT(AbstractFileProver prover, String filename, GlobalSettings settings) {
        Object object = Param$PRINT_SMT_FILE$.MODULE$.apply(settings);
        String string = "";
        if (object == null || !object.equals(string)) {
            Predef$.MODULE$.println();
            Object object2 = Param$PRINT_SMT_FILE$.MODULE$.apply(settings);
            String string2 = "-";
            if (object2 == null || !object2.equals(string2)) {
                Predef$.MODULE$.println((Object)new StringBuilder(28).append("Saving in SMT format to ").append(Param$PRINT_SMT_FILE$.MODULE$.apply(settings)).append(" ...").toString());
                FileOutputStream out = new FileOutputStream((String)Param$PRINT_SMT_FILE$.MODULE$.apply(settings));
                Console$.MODULE$.withOut((OutputStream)out, (Function0)(JFunction0.mcV.sp & Serializable)() -> CmdlMain$.linearise$1(prover, filename));
                out.close();
                return;
            }
            CmdlMain$.linearise$1(prover, filename);
        }
    }

    private void printTPTP(AbstractFileProver prover, String filename, GlobalSettings settings) {
        Object object = Param$PRINT_TPTP_FILE$.MODULE$.apply(settings);
        String string = "";
        if (object == null || !object.equals(string)) {
            Predef$.MODULE$.println();
            Object object2 = Param$PRINT_TPTP_FILE$.MODULE$.apply(settings);
            String string2 = "-";
            if (object2 == null || !object2.equals(string2)) {
                Predef$.MODULE$.println((Object)new StringBuilder(29).append("Saving in TPTP format to ").append(Param$PRINT_TPTP_FILE$.MODULE$.apply(settings)).append(" ...").toString());
                FileOutputStream out = new FileOutputStream((String)Param$PRINT_TPTP_FILE$.MODULE$.apply(settings));
                Console$.MODULE$.withOut((OutputStream)out, (Function0)(JFunction0.mcV.sp & Serializable)() -> CmdlMain$.linearise$2(prover, filename));
                out.close();
                return;
            }
            CmdlMain$.linearise$2(prover, filename);
        }
    }

    private void printCertificate(Certificate cert, GlobalSettings settings, Prover prover, Enumeration.Value format) {
        if (BoxesRunTime.unboxToBoolean((Object)Param$COMPUTE_UNSAT_CORE$.MODULE$.apply(settings))) {
            Console$.MODULE$.err().println();
            Console$.MODULE$.err().println("Unsatisfiable core:");
            Set<PartName> usedNames = prover.getAssumedFormulaParts(cert);
            Predef$.MODULE$.println((Object)new StringBuilder(2).append("{").append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps((Object[])((IterableOnceOps)usedNames.$minus((Object)PartName$.MODULE$.NO_NAME()).map((Function1 & Serializable)x$1 -> x$1.toString())).toArray(ClassTag$.MODULE$.apply(String.class))), (Ordering)Ordering.String$.MODULE$)).mkString(", ")).append("}").toString());
        }
        if (BoxesRunTime.unboxToBoolean((Object)Param$PRINT_CERTIFICATE$.MODULE$.apply(settings))) {
            this.printTextCertificate(cert, settings, prover, format);
        }
        Object object = Param$PRINT_DOT_CERTIFICATE_FILE$.MODULE$.apply(settings);
        String string = "";
        if (object == null || !object.equals(string)) {
            this.printDOTCertificate(cert, settings);
        }
    }

    private void printTextCertificate(Certificate cert, GlobalSettings settings, Prover prover, Enumeration.Value format) {
        Predef$.MODULE$.println();
        this.doPrintTextCertificate(cert, prover.getFormulaParts(), prover.getPredTranslation(), format);
    }

    public void doPrintTextCertificate(Certificate cert, Map<PartName, Conjunction> rawFormulaParts, Map<Predicate, IFunction> predTranslation, Enumeration.Value format) {
        block14: {
            block13: {
                Enumeration.Value value;
                Enumeration.Value value2;
                block12: {
                    CertificatePrettyPrinter.FormulaPrinter formulaPrinter;
                    Map formulaParts = rawFormulaParts.view().mapValues((Function1 & Serializable)f -> CertFormula$.MODULE$.apply(f.negate())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                    Seq<Certificate> dagCert = DagCertificateConverter$.MODULE$.apply(cert);
                    Enumeration.Value value3 = Param$InputFormat$.MODULE$.Princess();
                    if (!(value3 != null ? !value3.equals(format) : format != null)) {
                        formulaPrinter = new CertificatePrettyPrinter.PrincessFormulaPrinter(predTranslation);
                    } else {
                        Enumeration.Value value4 = Param$InputFormat$.MODULE$.TPTP();
                        if (!(value4 != null ? !value4.equals(format) : format != null)) {
                            formulaPrinter = new CertificatePrettyPrinter.TPTPFormulaPrinter(predTranslation);
                        } else {
                            Enumeration.Value value5 = Param$InputFormat$.MODULE$.SMTLIB();
                            if (!(value5 != null ? !value5.equals(format) : format != null)) {
                                formulaPrinter = new CertificatePrettyPrinter.SMTLIBFormulaPrinter(predTranslation);
                            } else {
                                throw new MatchError((Object)format);
                            }
                        }
                    }
                    CertificatePrettyPrinter printer = new CertificatePrettyPrinter(formulaPrinter);
                    Enumeration.Value value6 = format;
                    Enumeration.Value value7 = Param$InputFormat$.MODULE$.TPTP();
                    if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                        Predef$.MODULE$.println((Object)"% SZS output start Proof for theBenchmark");
                    }
                    printer.apply(dagCert, (Map<PartName, CertFormula>)formulaParts);
                    value2 = format;
                    value = Param$InputFormat$.MODULE$.TPTP();
                    if (value2 != null) break block12;
                    if (value != null) {
                        return;
                    }
                    break block13;
                }
                if (!value2.equals(value)) break block14;
            }
            Predef$.MODULE$.println((Object)"% SZS output end Proof for theBenchmark");
        }
    }

    private void printDOTCertificate(Certificate cert, GlobalSettings settings) {
        Console$.MODULE$.err().println();
        Object object = Param$PRINT_DOT_CERTIFICATE_FILE$.MODULE$.apply(settings);
        String string = "-";
        if (object == null || !object.equals(string)) {
            Console$.MODULE$.err().println(new StringBuilder(45).append("Saving certificate in GraphViz format to ").append(Param$PRINT_DOT_CERTIFICATE_FILE$.MODULE$.apply(settings)).append(" ...").toString());
            FileOutputStream out = new FileOutputStream((String)Param$PRINT_DOT_CERTIFICATE_FILE$.MODULE$.apply(settings));
            Console$.MODULE$.withOut((OutputStream)out, (Function0)(JFunction0.mcV.sp & Serializable)() -> DotLineariser$.MODULE$.apply(cert));
            out.close();
            return;
        }
        DotLineariser$.MODULE$.apply(cert);
    }

    public Enumeration.Value determineInputFormat(String filename, GlobalSettings settings) {
        Enumeration.Value value;
        Enumeration.Value value2 = (Enumeration.Value)Param$INPUT_FORMAT$.MODULE$.apply(settings);
        Enumeration.Value value3 = Param$InputFormat$.MODULE$.Auto();
        if (!(value3 != null ? !value3.equals(value2) : value2 != null)) {
            Enumeration.Value value4;
            if (filename.endsWith(".pri")) {
                value4 = Param$InputFormat$.MODULE$.Princess();
            } else if (filename.endsWith(".smt2")) {
                value4 = Param$InputFormat$.MODULE$.SMTLIB();
            } else if (filename.endsWith(".p")) {
                value4 = Param$InputFormat$.MODULE$.TPTP();
            } else {
                throw new Exception("could not figure out the input format (recognised types: .pri, .smt2, .p)");
            }
            value = value4;
        } else {
            value = value2;
        }
        return value;
    }

    private void printFormula(IFormula f, Enumeration.Value format) {
        Enumeration.Value value = Param$InputFormat$.MODULE$.SMTLIB();
        if (!(value != null ? !value.equals(format) : format != null)) {
            SMTLineariser$.MODULE$.apply(f);
            Predef$.MODULE$.println();
            return;
        }
        PrincessLineariser$.MODULE$.printExpression(f);
        Predef$.MODULE$.println();
    }

    private void printModel(IFormula model, Enumeration.Value format) {
        Enumeration.Value value = Param$InputFormat$.MODULE$.SMTLIB();
        if (!(value != null ? !value.equals(format) : format != null)) {
            SMTLineariser$.MODULE$.printModel(model);
            return;
        }
        this.printFormula(model, format);
    }

    private void printFormula(Conjunction c, Enumeration.Value format) {
        this.printFormula(new Simplifier(Simplifier$.MODULE$.$lessinit$greater$default$1(), Simplifier$.MODULE$.$lessinit$greater$default$2()).apply(Internal2InputAbsy$.MODULE$.apply(c)), format);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int existentialConstantNum(ProofTree p) {
        if (p == null) return BoxesRunTime.unboxToInt((Object)p.subtrees().iterator().map((Function1 & Serializable)st -> BoxesRunTime.boxToInteger((int)CmdlMain$.MODULE$.existentialConstantNum(st))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Option<Tuple3<Quantifier, Seq<ConstantTerm>, ProofTree>> option = QuantifiedTree$.MODULE$.unapply(p);
        if (option.isEmpty()) return BoxesRunTime.unboxToInt((Object)p.subtrees().iterator().map((Function1 & Serializable)st -> BoxesRunTime.boxToInteger((int)CmdlMain$.MODULE$.existentialConstantNum(st))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Quantifier quantifier = (Quantifier)((Tuple3)option.get())._1();
        Seq consts = (Seq)((Tuple3)option.get())._2();
        ProofTree subtree = (ProofTree)((Tuple3)option.get())._3();
        if (!Quantifier$EX$.MODULE$.equals(quantifier)) return BoxesRunTime.unboxToInt((Object)p.subtrees().iterator().map((Function1 & Serializable)st -> BoxesRunTime.boxToInteger((int)CmdlMain$.MODULE$.existentialConstantNum(st))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        return this.existentialConstantNum(subtree) + consts.size();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Option<Prover.Result> proveProblem(GlobalSettings settings, String name, Function0<Reader> reader, Function0<Object> userDefStoppingCond, Enumeration.Value format) {
        Debug$.MODULE$.enableAllAssertions(BoxesRunTime.unboxToBoolean((Object)Param$ASSERTIONS$.MODULE$.apply(settings)));
        try {
            block19: {
                block18: {
                    timeBefore = System.currentTimeMillis();
                    baseSettings = Param$INPUT_FORMAT$.MODULE$.set(settings, format);
                    v0 = Param$PORTFOLIO$.MODULE$.apply(settings);
                    var11_8 = Param$PortfolioOptions$.MODULE$.None();
                    if (!(v0 == null ? var11_8 != null : v0.equals(var11_8) == false)) break block18;
                    if (BoxesRunTime.unboxToBoolean((Object)Param$COMPUTE_UNSAT_CORE$.MODULE$.apply(settings)) || BoxesRunTime.unboxToBoolean((Object)Param$PRINT_CERTIFICATE$.MODULE$.apply(settings))) ** GOTO lbl-1000
                    v1 = Param$PRINT_DOT_CERTIFICATE_FILE$.MODULE$.apply(settings);
                    var13_9 = "";
                    if (v1 == null || !v1.equals(var13_9)) lbl-1000:
                    // 2 sources

                    {
                        v2 = true;
                    } else {
                        v2 = false;
                    }
                    needProof = v2;
                    var14_11 = (Enumeration.Value)Param$PORTFOLIO$.MODULE$.apply(settings);
                    v3 = Param$PortfolioOptions$.MODULE$.CASC();
                    if (!(v3 != null ? v3.equals(var14_11) == false : var14_11 != null)) {
                        var6_12 = ParallelFileProver$.MODULE$.apply(reader, BoxesRunTime.unboxToInt((Object)Param$TIMEOUT$.MODULE$.apply(settings)), true, userDefStoppingCond, baseSettings, (Seq<Tuple3<String, Object, Object>>)ParallelFileProver$.MODULE$.cascStrategies2016(), 1, 3, needProof, (Function1<Prover, BoxedUnit>)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$proveProblem$1$adapted(ap.CmdlMain$ ap.parameters.GlobalSettings scala.Enumeration$Value ap.Prover ), (Lap/Prover;)Ljava/lang/Object;)((CmdlMain$)this, (GlobalSettings)baseSettings, (Enumeration.Value)format));
                    } else {
                        v4 = Param$PortfolioOptions$.MODULE$.QF_LIA();
                        if (!(v4 != null ? v4.equals(var14_11) == false : var14_11 != null)) {
                            strategies = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ParallelFileProver.Configuration[]{new ParallelFileProver.Configuration(Param$PROOF_CONSTRUCTION_GLOBAL$.MODULE$.set(baseSettings, Param$ProofConstructionOptions$.MODULE$.Never()), "-constructProofs=never", 1000000000L, 2000L), new ParallelFileProver.Configuration(Param$PROOF_CONSTRUCTION_GLOBAL$.MODULE$.set(baseSettings, Param$ProofConstructionOptions$.MODULE$.Always()), "-constructProofs=always", 1000000000L, 2000L)}));
                            var6_12 = ParallelFileProver$.MODULE$.apply(reader, BoxesRunTime.unboxToInt((Object)Param$TIMEOUT$.MODULE$.apply(settings)), true, userDefStoppingCond, (Seq<ParallelFileProver.Configuration>)strategies, 1, 2, needProof, (Function1<Prover, BoxedUnit>)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$proveProblem$2$adapted(ap.CmdlMain$ ap.parameters.GlobalSettings scala.Enumeration$Value ap.Prover ), (Lap/Prover;)Ljava/lang/Object;)((CmdlMain$)this, (GlobalSettings)baseSettings, (Enumeration.Value)format));
                        } else {
                            v5 = Param$PortfolioOptions$.MODULE$.BV();
                            if (!(v5 != null ? v5.equals(var14_11) == false : var14_11 != null)) {
                                strategies = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ParallelFileProver.Configuration[]{new ParallelFileProver.Configuration(Param$NEG_SOLVING$.MODULE$.set(baseSettings, Param$NegSolvingOptions$.MODULE$.Positive()), "-formulaSign=positive", 1000000000L, 1000L), new ParallelFileProver.Configuration(Param$NEG_SOLVING$.MODULE$.set(baseSettings, Param$NegSolvingOptions$.MODULE$.Negative()), "-formulaSign=negative", 1000000000L, 1000L)}));
                                var6_12 = ParallelFileProver$.MODULE$.apply(reader, BoxesRunTime.unboxToInt((Object)Param$TIMEOUT$.MODULE$.apply(settings)), true, userDefStoppingCond, (Seq<ParallelFileProver.Configuration>)strategies, 1, 2, needProof, (Function1<Prover, BoxedUnit>)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$proveProblem$3$adapted(ap.CmdlMain$ ap.parameters.GlobalSettings scala.Enumeration$Value ap.Prover ), (Lap/Prover;)Ljava/lang/Object;)((CmdlMain$)this, (GlobalSettings)baseSettings, (Enumeration.Value)format));
                            } else {
                                throw new MatchError((Object)var14_11);
                            }
                        }
                    }
                    v6 /* !! */  = var6_12;
                    break block19;
                }
                v6 /* !! */  = new IntelliFileProver((Reader)reader.apply(), BoxesRunTime.unboxToInt((Object)Param$TIMEOUT$.MODULE$.apply(settings)), true, userDefStoppingCond, baseSettings);
            }
            prover = v6 /* !! */ ;
            Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)(JFunction0.mcV.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$proveProblem$4(), ()V)());
            this.printResult(prover, settings, format);
            timeAfter = System.currentTimeMillis();
            Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)(JFunction0.mcV.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$proveProblem$5(ap.parameters.GlobalSettings long long ), ()V)((GlobalSettings)settings, (long)timeAfter, (long)timeBefore));
            if (prover instanceof AbstractFileProver) {
                var19_17 = prover;
                this.printSMT(var19_17, name, settings);
                this.printTPTP(var19_17, name, settings);
            }
            return new Some((Object)prover.result());
        }
        catch (StackOverflowError v7) {
            v8 = format;
            var20_18 = Param$InputFormat$.MODULE$.SMTLIB();
            if (!(v8 != null ? v8.equals(var20_18) == false : var20_18 != null)) {
                Predef$.MODULE$.println((Object)"unknown");
            }
            Console$.MODULE$.err().println("Stack overflow, giving up");
            return None$.MODULE$;
        }
        catch (OutOfMemoryError v9) {
            v10 = format;
            var21_19 = Param$InputFormat$.MODULE$.SMTLIB();
            if (!(v10 != null ? v10.equals(var21_19) == false : var21_19 != null)) {
                Predef$.MODULE$.println((Object)"unknown");
            }
            Console$.MODULE$.err().println("Out of memory, giving up");
            System.gc();
            return None$.MODULE$;
        }
        catch (Throwable e) {
            v11 = format;
            var23_21 = Param$InputFormat$.MODULE$.SMTLIB();
            if (!(v11 != null ? v11.equals(var23_21) == false : var23_21 != null)) {
                Predef$.MODULE$.println((Object)new StringBuilder(10).append("(error \"").append(SMTLineariser$.MODULE$.escapeString(e.getMessage())).append("\")").toString());
            } else {
                Predef$.MODULE$.println((Object)new StringBuilder(7).append("ERROR: ").append(e.getMessage()).toString());
            }
            if (this.stackTraces()) {
                e.printStackTrace();
            }
            return None$.MODULE$;
        }
    }

    public void proveMultiSMT(GlobalSettings settings, Reader input, Function0<Object> userDefStoppingCond) {
        try {
            boolean assertions = BoxesRunTime.unboxToBoolean((Object)Param$ASSERTIONS$.MODULE$.apply(settings));
            Debug$.MODULE$.enableAllAssertions(assertions);
            boolean x$3 = BoxesRunTime.unboxToBoolean((Object)Param$GENERATE_TOTALITY_AXIOMS$.MODULE$.apply(settings));
            Option x$4 = (Option)Param$RANDOM_SEED$.MODULE$.apply(settings);
            boolean x$5 = SimpleAPI$.MODULE$.withProver$default$3();
            String x$6 = SimpleAPI$.MODULE$.withProver$default$4();
            boolean x$7 = SimpleAPI$.MODULE$.withProver$default$5();
            String x$8 = SimpleAPI$.MODULE$.withProver$default$6();
            File x$9 = SimpleAPI$.MODULE$.withProver$default$7();
            boolean x$10 = SimpleAPI$.MODULE$.withProver$default$8();
            Function1 & Serializable x$11 = (Function1 & Serializable)p -> {
                CmdlMain$.$anonfun$proveMultiSMT$1(settings, input, userDefStoppingCond, p);
                return BoxedUnit.UNIT;
            };
            SimpleAPI$.MODULE$.withProver(assertions, false, x$5, x$6, x$7, x$8, x$9, x$10, x$3, (Option<Object>)x$4, x$11);
            return;
        }
        catch (StackOverflowError stackOverflowError) {
            Predef$.MODULE$.println((Object)"unknown");
            Console$.MODULE$.err().println("Stack overflow, giving up");
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Predef$.MODULE$.println((Object)"unknown");
            Console$.MODULE$.err().println("Out of memory, giving up");
            System.gc();
            return;
        }
        catch (Throwable e) {
            Predef$.MODULE$.println((Object)"error");
            Console$.MODULE$.err().println(e.getMessage());
            if (this.stackTraces()) {
                e.printStackTrace();
                return;
            }
            return;
        }
    }

    public Object proveProblems(GlobalSettings settings, String name, Function0<Reader> input, Function0<Object> userDefStoppingCond, Enumeration.Value format) {
        BoxedUnit boxedUnit;
        Console$.MODULE$.err().println(new StringBuilder(12).append("Loading ").append(name).append(" ...").toString());
        Enumeration.Value value = Param$InputFormat$.MODULE$.SMTLIB();
        if (!(value != null ? !value.equals(format) : format != null) && BoxesRunTime.unboxToBoolean((Object)Param$INCREMENTAL$.MODULE$.apply(settings))) {
            this.proveMultiSMT(settings, (Reader)input.apply(), userDefStoppingCond);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = this.proveProblem(settings, name, input, userDefStoppingCond, format);
        }
        return boxedUnit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void printResult(Prover prover, GlobalSettings settings, Enumeration.Value format) {
        Enumeration.Value value = Param$InputFormat$.MODULE$.SMTLIB();
        if (!(value != null ? !value.equals(format) : format != null)) {
            Prover.Result result = prover.result();
            if (result instanceof Prover.Proof) {
                ProofTree tree = ((Prover.Proof)result).tree();
                Predef$.MODULE$.println((Object)"unsat");
                if (!BoxesRunTime.unboxToBoolean((Object)Param$PRINT_TREE$.MODULE$.apply(settings))) return;
                BoxedUnit cfr_ignored_0 = (BoxedUnit)Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    Predef$.MODULE$.println();
                    Predef$.MODULE$.println((Object)"Proof tree:");
                    Predef$.MODULE$.println((Object)tree);
                });
                return;
            }
            if (result instanceof Prover.ProofWithModel) {
                ProofTree tree = ((Prover.ProofWithModel)result).tree();
                Predef$.MODULE$.println((Object)"unsat");
                if (!BoxesRunTime.unboxToBoolean((Object)Param$PRINT_TREE$.MODULE$.apply(settings))) return;
                BoxedUnit cfr_ignored_1 = (BoxedUnit)Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    Predef$.MODULE$.println();
                    Predef$.MODULE$.println((Object)"Proof tree:");
                    Predef$.MODULE$.println((Object)tree);
                });
                return;
            }
            if (result instanceof Prover.NoProof) {
                Predef$.MODULE$.println((Object)"unknown");
                return;
            }
            if (result instanceof Prover.Invalid) {
                Predef$.MODULE$.println((Object)"sat");
                return;
            }
            if (result instanceof Prover.CounterModel) {
                Option<IFormula> optModel = ((Prover.CounterModel)result).counterModel();
                Predef$.MODULE$.println((Object)"sat");
                optModel.foreach((Function1 & Serializable)model -> {
                    CmdlMain$.MODULE$.printModel(model, format);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (result instanceof Prover.MaybeCounterModel) {
                Option<IFormula> optModel = ((Prover.MaybeCounterModel)result).counterModel();
                Predef$.MODULE$.println((Object)"unknown");
                optModel.foreach((Function1 & Serializable)model -> {
                    CmdlMain$.MODULE$.printModel(model, format);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (Prover$NoCounterModel$.MODULE$.equals(result)) {
                Predef$.MODULE$.println((Object)"unsat");
                return;
            }
            if (result instanceof Prover.NoCounterModelCert) {
                Certificate cert = ((Prover.NoCounterModelCert)result).certificate();
                Predef$.MODULE$.println((Object)"unsat");
                this.printCertificate(cert, settings, prover, format);
                return;
            }
            if (result instanceof Prover.NoCounterModelCertInter) {
                Prover.NoCounterModelCertInter noCounterModelCertInter = (Prover.NoCounterModelCertInter)result;
                Certificate cert = noCounterModelCertInter.certificate();
                Iterator<IFormula> inters = noCounterModelCertInter.interpolants();
                Predef$.MODULE$.println((Object)"unsat");
                this.printCertificate(cert, settings, prover, format);
                Predef$.MODULE$.println((Object)"(");
                inters.foreach((Function1 & Serializable)i -> {
                    CmdlMain$.$anonfun$printResult$5(format, i);
                    return BoxedUnit.UNIT;
                });
                Predef$.MODULE$.println((Object)")");
                return;
            }
            if (result instanceof Prover.Model) {
                Predef$.MODULE$.println((Object)"unsat");
                return;
            }
            if (result instanceof Prover.AllModels) {
                Predef$.MODULE$.println((Object)"unsat");
                return;
            }
            if (Prover$NoModel$.MODULE$.equals(result)) {
                Predef$.MODULE$.println((Object)"sat");
                return;
            }
            if (result instanceof Prover.TimeoutProof) {
                ProofTree tree = ((Prover.TimeoutProof)result).unfinishedTree();
                Predef$.MODULE$.println((Object)"unknown");
                Console$.MODULE$.err().println("Cancelled or timeout");
                if (!BoxesRunTime.unboxToBoolean((Object)Param$PRINT_TREE$.MODULE$.apply(settings))) return;
                BoxedUnit cfr_ignored_2 = (BoxedUnit)Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    Predef$.MODULE$.println();
                    Predef$.MODULE$.println((Object)"Proof tree:");
                    Predef$.MODULE$.println((Object)tree);
                });
                return;
            }
            if (result == null || !Prover$TimeoutResult$.MODULE$.unapply(result)) throw new MatchError((Object)result);
            Predef$.MODULE$.println((Object)"unknown");
            Console$.MODULE$.err().println("Cancelled or timeout");
            return;
        }
        Prover.Result result = prover.result();
        if (result instanceof Prover.Proof) {
            Prover.Proof proof = (Prover.Proof)result;
            ProofTree tree = proof.tree();
            IFormula constraint = proof.constraint();
            Predef$.MODULE$.println((Object)"VALID");
            if (!constraint.isTrue() || BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) {
                Predef$.MODULE$.println();
                Predef$.MODULE$.println((Object)new StringBuilder(21).append("Under the ").append((Object)(BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings)) ? "most-general " : "")).append("constraint:").toString());
                this.printFormula(constraint, format);
            }
            if (!BoxesRunTime.unboxToBoolean((Object)Param$PRINT_TREE$.MODULE$.apply(settings))) return;
            Predef$.MODULE$.println();
            Predef$.MODULE$.println((Object)"Proof tree:");
            Predef$.MODULE$.println((Object)tree);
            return;
        }
        if (result instanceof Prover.ProofWithModel) {
            Prover.ProofWithModel proofWithModel = (Prover.ProofWithModel)result;
            ProofTree tree = proofWithModel.tree();
            IFormula constraint = proofWithModel.constraint();
            IFormula model2 = proofWithModel.model();
            Predef$.MODULE$.println((Object)"VALID");
            if (!constraint.isTrue() || BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) {
                Predef$.MODULE$.println();
                Predef$.MODULE$.println((Object)new StringBuilder(21).append("Under the ").append((Object)(BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings)) ? "most-general " : "")).append("constraint:").toString());
                this.printFormula(constraint, format);
            }
            if (!LineariseVisitor$.MODULE$.apply(constraint, IBinJunctor$.MODULE$.And()).forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = x0$1 != null && !IExpression$Eq$.MODULE$.unapply(x0$1).isEmpty())))) {
                Predef$.MODULE$.println();
                Predef$.MODULE$.println((Object)"Concrete witness:");
                this.printModel(model2, format);
            }
            if (!BoxesRunTime.unboxToBoolean((Object)Param$PRINT_TREE$.MODULE$.apply(settings))) return;
            Predef$.MODULE$.println();
            Predef$.MODULE$.println((Object)"Proof tree:");
            Predef$.MODULE$.println((Object)tree);
            return;
        }
        if (result instanceof Prover.NoProof) {
            Predef$.MODULE$.println((Object)"UNKNOWN");
            if (!BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) return;
            Predef$.MODULE$.println();
            Predef$.MODULE$.println((Object)"Most-general constraint:");
            Predef$.MODULE$.println((Object)"false");
            return;
        }
        if (result instanceof Prover.Invalid) {
            Predef$.MODULE$.println((Object)"INVALID");
            if (!BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) return;
            Predef$.MODULE$.println();
            Predef$.MODULE$.println((Object)"Most-general constraint:");
            Predef$.MODULE$.println((Object)"false");
            return;
        }
        if (result instanceof Prover.CounterModel) {
            Option<IFormula> optModel = ((Prover.CounterModel)result).counterModel();
            Predef$.MODULE$.println((Object)"INVALID");
            if (!None$.MODULE$.equals(optModel)) {
                if (!(optModel instanceof Some)) throw new MatchError(optModel);
                IFormula model3 = (IFormula)((Some)optModel).value();
                Predef$.MODULE$.println();
                Predef$.MODULE$.println((Object)"Countermodel:");
                this.printModel(model3, format);
            }
            if (!BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) return;
            Predef$.MODULE$.println();
            Predef$.MODULE$.println((Object)"Most-general constraint:");
            Predef$.MODULE$.println((Object)"false");
            return;
        }
        if (result instanceof Prover.MaybeCounterModel) {
            Option<IFormula> optModel = ((Prover.MaybeCounterModel)result).counterModel();
            Predef$.MODULE$.println((Object)"UNKNOWN");
            if (!None$.MODULE$.equals(optModel)) {
                if (!(optModel instanceof Some)) throw new MatchError(optModel);
                IFormula model4 = (IFormula)((Some)optModel).value();
                Predef$.MODULE$.println();
                Predef$.MODULE$.println((Object)"Possible countermodel:");
                this.printModel(model4, format);
            }
            if (!BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) return;
            Predef$.MODULE$.println();
            Predef$.MODULE$.println((Object)"Most-general constraint:");
            Predef$.MODULE$.println((Object)"false");
            return;
        }
        if (Prover$NoCounterModel$.MODULE$.equals(result)) {
            Predef$.MODULE$.println((Object)"VALID");
            if (!BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) return;
            Predef$.MODULE$.println();
            Predef$.MODULE$.println((Object)"Most-general constraint:");
            Predef$.MODULE$.println((Object)"true");
            return;
        }
        if (result instanceof Prover.NoCounterModelCert) {
            Certificate cert = ((Prover.NoCounterModelCert)result).certificate();
            Predef$.MODULE$.println((Object)"VALID");
            if (BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) {
                Predef$.MODULE$.println();
                Predef$.MODULE$.println((Object)"Most-general constraint:");
                Predef$.MODULE$.println((Object)"true");
            }
            this.printCertificate(cert, settings, prover, format);
            return;
        }
        if (result instanceof Prover.NoCounterModelCertInter) {
            Prover.NoCounterModelCertInter noCounterModelCertInter = (Prover.NoCounterModelCertInter)result;
            Certificate cert = noCounterModelCertInter.certificate();
            Iterator<IFormula> inters = noCounterModelCertInter.interpolants();
            Predef$.MODULE$.println((Object)"VALID");
            if (BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) {
                Predef$.MODULE$.println();
                Predef$.MODULE$.println((Object)"Most-general constraint:");
                Predef$.MODULE$.println((Object)"true");
            }
            Predef$.MODULE$.println();
            Predef$.MODULE$.println((Object)"Interpolants:");
            inters.foreach((Function1 & Serializable)i -> {
                CmdlMain$.MODULE$.printFormula(i, format);
                return BoxedUnit.UNIT;
            });
            this.printCertificate(cert, settings, prover, format);
            return;
        }
        if (result instanceof Prover.Model) {
            Option<IFormula> optModel = ((Prover.Model)result).model();
            Predef$.MODULE$.println((Object)"VALID");
            optModel.foreach((Function1 & Serializable)model -> {
                CmdlMain$.$anonfun$printResult$9(format, model);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (result instanceof Prover.AllModels) {
            Prover.AllModels allModels = (Prover.AllModels)result;
            IFormula constraint = allModels.constraint();
            Option<IFormula> optModel = allModels.model();
            Predef$.MODULE$.println((Object)"VALID");
            if (BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) {
                Predef$.MODULE$.println();
                Predef$.MODULE$.println((Object)"Equivalent constraint:");
                this.printFormula(constraint, format);
            }
            optModel.foreach((Function1 & Serializable)model -> {
                CmdlMain$.$anonfun$printResult$10(format, model);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (Prover$NoModel$.MODULE$.equals(result)) {
            Predef$.MODULE$.println((Object)"INVALID");
            if (!BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) return;
            Predef$.MODULE$.println();
            Predef$.MODULE$.println((Object)"Equivalent constraint:");
            Predef$.MODULE$.println((Object)"false");
            return;
        }
        if (result instanceof Prover.TimeoutProof) {
            ProofTree tree = ((Prover.TimeoutProof)result).unfinishedTree();
            Predef$.MODULE$.println((Object)"CANCELLED/TIMEOUT");
            if (BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) {
                Predef$.MODULE$.println();
                Predef$.MODULE$.println((Object)"Current constraint:");
                Timeout$.MODULE$.withTimeoutMillis(1000L, (JFunction0.mcV.sp & Serializable)() -> MODULE$.printFormula(tree.closingConstraint(), format), (JFunction0.mcV.sp & Serializable)() -> Predef$.MODULE$.println((Object)"(timeout)"));
            }
            if (!BoxesRunTime.unboxToBoolean((Object)Param$PRINT_TREE$.MODULE$.apply(settings))) return;
            Predef$.MODULE$.println();
            Predef$.MODULE$.println((Object)"Proof tree:");
            Predef$.MODULE$.println((Object)tree);
            return;
        }
        if (result == null || !Prover$TimeoutResult$.MODULE$.unapply(result)) throw new MatchError((Object)result);
        Predef$.MODULE$.println((Object)"CANCELLED/TIMEOUT");
        if (!BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) return;
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"Current constraint:");
        Predef$.MODULE$.println((Object)"false");
    }

    public void main(String[] args) {
        this.doMain(args, (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> false);
    }

    /*
     * WARNING - void declaration
     */
    public void doMain(String[] args, Function0<Object> userDefStoppingCond) {
        Object object = new Object();
        try {
            void var6_6;
            void var5_5;
            Tuple2 tuple2 = this.liftedTree1$1(args, object);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            GlobalSettings settings = (GlobalSettings)tuple2._1();
            Seq inputs = (Seq)tuple2._2();
            if (BoxesRunTime.unboxToBoolean((Object)Param$VERSION$.MODULE$.apply(var5_5))) {
                Predef$.MODULE$.println((Object)this.version());
                return;
            }
            if (BoxesRunTime.unboxToBoolean((Object)Param$FULL_HELP$.MODULE$.apply(var5_5))) {
                Predef$.MODULE$.println((Object)this.version());
                Predef$.MODULE$.println();
                this.printUsage();
                Predef$.MODULE$.println();
                Predef$.MODULE$.println();
                this.printExoticOptions();
                Predef$.MODULE$.println();
                return;
            }
            Console$.MODULE$.withErr(BoxesRunTime.unboxToBoolean((Object)Param$QUIET$.MODULE$.apply(var5_5)) ? CmdlMain$NullStream$.MODULE$ : Console$.MODULE$.err(), (Function0)((JFunction0.mcV.sp & Serializable)() -> CmdlMain$.$anonfun$doMain$2((GlobalSettings)var5_5, (Seq)var6_6, object, userDefStoppingCond)));
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$printSMT$2(PartName name$1, INamedPart x0$1) {
        if (x0$1 == null) return false;
        PartName partName = x0$1.name();
        PartName partName2 = name$1;
        if (partName2 != null) {
            if (!partName2.equals(partName)) return false;
            return true;
        }
        if (partName == null) return true;
        return false;
    }

    private static final IFormula formula$1(PartName name, AbstractFileProver prover$1) {
        return IExpression$.MODULE$.removePartName((IFormula)prover$1.inputFormulas().find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CmdlMain$.$anonfun$printSMT$2(name, x0$1))).getOrElse((Function0 & Serializable)() -> IExpression$.MODULE$.Boolean2IFormula(false)));
    }

    private static final void linearise$1(AbstractFileProver prover$1, String filename$1) {
        IInterpolantSpec iInterpolantSpec;
        SeqOps seqOps;
        List<IInterpolantSpec> list = prover$1.interpolantSpecs();
        if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.List().unapplySeq(list))) {
            new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0) == 0) {
                if (prover$1.signature().existentialConstants().isEmpty() && prover$1.signature().universalConstants().isEmpty()) {
                    SMTLineariser$.MODULE$.apply((Seq<IFormula>)((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IFormula[]{prover$1.rawInputFormula()}))), prover$1.rawSignature(), filename$1);
                    return;
                }
                List formulas = prover$1.inputFormulas().map((Function1 & Serializable)f -> IExpression$.MODULE$.removePartName((IFormula)f));
                SMTLineariser$.MODULE$.apply((Seq<IFormula>)formulas, prover$1.signature(), filename$1);
                return;
            }
        }
        if (list instanceof .colon.colon && (iInterpolantSpec = (IInterpolantSpec)((.colon.colon)list).head()) != null) {
            List<PartName> left = iInterpolantSpec.left();
            List<PartName> right = iInterpolantSpec.right();
            IFormula common = CmdlMain$.formula$1(PartName$.MODULE$.NO_NAME(), prover$1);
            List formulas = ((List)left.$plus$plus(right)).map((Function1 & Serializable)part -> common.$bar$bar$bar(CmdlMain$.formula$1(part, prover$1)));
            SMTLineariser$.MODULE$.apply((Seq<IFormula>)formulas, prover$1.signature(), filename$1);
            return;
        }
        throw new MatchError(list);
    }

    private static final void linearise$2(AbstractFileProver prover$2, String filename$2) {
        TPTPLineariser$.MODULE$.apply(prover$2.rawInputFormula(), filename$2);
    }

    private final void prelPrinter$1(Prover p, GlobalSettings baseSettings$1, Enumeration.Value format$1) {
        Console$.MODULE$.err().println();
        this.printResult(p, baseSettings$1, format$1);
        Console$.MODULE$.err().println();
    }

    public static final /* synthetic */ void $anonfun$proveProblem$4() {
        Predef$.MODULE$.println();
    }

    public static final /* synthetic */ void $anonfun$proveProblem$5(GlobalSettings settings$1, long timeAfter$1, long timeBefore$1) {
        Predef$.MODULE$.println();
        if (BoxesRunTime.unboxToBoolean((Object)Param$LOGO$.MODULE$.apply(settings$1))) {
            Predef$.MODULE$.println((Object)new StringBuilder(2).append(timeAfter$1 - timeBefore$1).append("ms").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$proveMultiSMT$1(GlobalSettings settings$2, Reader input$1, Function0 userDefStoppingCond$1, SimpleAPI p) {
        SMTParser2InputAbsy$.MODULE$.apply(settings$2.toParserSettings(), p).processIncrementally(input$1, BoxesRunTime.unboxToInt((Object)Param$TIMEOUT$.MODULE$.apply(settings$2)), BoxesRunTime.unboxToInt((Object)Param$TIMEOUT_PER$.MODULE$.apply(settings$2)), (Function0<Object>)userDefStoppingCond$1);
    }

    public static final /* synthetic */ void $anonfun$printResult$5(Enumeration.Value format$2, IFormula i) {
        Predef$.MODULE$.print((Object)"  ");
        MODULE$.printFormula(i, format$2);
    }

    public static final /* synthetic */ void $anonfun$printResult$9(Enumeration.Value format$2, IFormula model) {
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"Under the assignment:");
        MODULE$.printModel(model, format$2);
    }

    public static final /* synthetic */ void $anonfun$printResult$10(Enumeration.Value format$2, IFormula model) {
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"Concrete witness:");
        MODULE$.printModel(model, format$2);
    }

    private final /* synthetic */ Tuple2 liftedTree1$1(String[] args$1, Object nonLocalReturnKey1$1) {
        try {
            return GlobalSettings$.MODULE$.fromArguments((Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)args$1), GlobalSettings$.MODULE$.DEFAULT());
        }
        catch (Throwable e) {
            Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                MODULE$.printGreeting();
                Predef$.MODULE$.println();
            });
            Predef$.MODULE$.println((Object)e.getMessage());
            Predef$.MODULE$.println();
            this.printUsage();
            Predef$.MODULE$.println();
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
    }

    public static final /* synthetic */ void $anonfun$doMain$2(GlobalSettings settings$3, Seq inputs$1, Object nonLocalReturnKey1$1, Function0 userDefStoppingCond$2) {
        if (BoxesRunTime.unboxToBoolean((Object)Param$LOGO$.MODULE$.apply(settings$3))) {
            Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                MODULE$.printGreeting();
                Predef$.MODULE$.println();
            });
        }
        if (inputs$1.isEmpty() && !BoxesRunTime.unboxToBoolean((Object)Param$STDIN$.MODULE$.apply(settings$3))) {
            Console$.MODULE$.err().println("No inputs given, exiting");
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
        inputs$1.foreach((Function1 & Serializable)filename -> {
            try {
                Enumeration.Value format = MODULE$.determineInputFormat((String)filename, settings$3);
                return MODULE$.proveProblems(settings$3, (String)filename, (Function0<Reader>)(Function0 & Serializable)() -> new BufferedReader(new FileReader(new File((String)filename))), (Function0<Object>)userDefStoppingCond$2, format);
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)new StringBuilder(7).append("ERROR: ").append(e.getMessage()).toString());
                if (MODULE$.stackTraces()) {
                    e.printStackTrace();
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            }
        });
        if (BoxesRunTime.unboxToBoolean((Object)Param$STDIN$.MODULE$.apply(settings$3))) {
            Console$.MODULE$.err().println("Reading SMT-LIB 2 input from stdin ...");
            MODULE$.proveMultiSMT(settings$3, Console$.MODULE$.in(), (Function0<Object>)userDefStoppingCond$2);
        }
    }

    private CmdlMain$() {
    }

    public static final /* synthetic */ Object $anonfun$proveProblem$1$adapted(CmdlMain$ $this, GlobalSettings baseSettings$1, Enumeration.Value format$1, Prover p) {
        $this.prelPrinter$1(p, baseSettings$1, format$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$proveProblem$2$adapted(CmdlMain$ $this, GlobalSettings baseSettings$1, Enumeration.Value format$1, Prover p) {
        $this.prelPrinter$1(p, baseSettings$1, format$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$proveProblem$3$adapted(CmdlMain$ $this, GlobalSettings baseSettings$1, Enumeration.Value format$1, Prover p) {
        $this.prelPrinter$1(p, baseSettings$1, format$1);
        return BoxedUnit.UNIT;
    }
}

