/*
 * Decompiled with CFR 0.152.
 */
package ap.basetypes;

import ap.basetypes.HeapCollector;
import ap.basetypes.LeftistHeap;
import ap.basetypes.LeftistHeap$;
import ap.util.APTestCase;
import ap.util.Debug$;
import ap.util.Logic$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.SetOps;
import scala.collection.StrictOptimizedLinearSeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Mc\u0001\u0002\r\u001a\u0001yA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\u0006g\u0001!\t\u0001\u000e\u0005\u0006q\u0001!\t!\u000f\u0005\b}\u0001\u0011\r\u0011\"\u0003@\u0011\u0019Y\u0005\u0001)A\u0005\u0001\"9A\n\u0001b\u0001\n\u0013y\u0004BB'\u0001A\u0003%\u0001\tC\u0003O\u0001\u0011\u0005\u0011\bC\u0003P\u0001\u0011%\u0001\u000bC\u0003n\u0001\u0011%a\u000eC\u0004\u0002\u0002\u0001!I!a\u0001\t\r\u0005m\u0001\u0001\"\u0001:\u0011\u0019\ti\u0002\u0001C\u0001s!1\u0011q\u0004\u0001\u0005\u0002eBa!!\t\u0001\t\u0003IdABA\u0012\u0001\u0011\t)\u0003\u0003\u0006\u00024A\u0011)\u0019!C\u0001\u0003kA!\"!\u0010\u0011\u0005\u0003\u0005\u000b\u0011BA\u001c\u0011\u0019\u0019\u0004\u0003\"\u0001\u0002@!9\u00111\t\t\u0005\u0002\u0005\u0015\u0003BBA'\u0001\u0011\u0005\u0011\b\u0003\u0004\u0002P\u0001!\t!\u000f\u0005\u0007\u0003#\u0002A\u0011A\u001d\u0003\u001fQ+7\u000f\u001e'fMRL7\u000f\u001e%fCBT!AG\u000e\u0002\u0013\t\f7/\u001a;za\u0016\u001c(\"\u0001\u000f\u0002\u0005\u0005\u00048\u0001A\n\u0003\u0001}\u0001\"\u0001I\u0012\u000e\u0003\u0005R!AI\u000e\u0002\tU$\u0018\u000e\\\u0005\u0003I\u0005\u0012!\"\u0011)UKN$8)Y:f\u0003\u0005q\u0007CA\u00141\u001d\tAc\u0006\u0005\u0002*Y5\t!F\u0003\u0002,;\u00051AH]8pizR\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\na\u0001\u0015:fI\u00164\u0017BA\u00193\u0005\u0019\u0019FO]5oO*\u0011q\u0006L\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005U:\u0004C\u0001\u001c\u0001\u001b\u0005I\u0002\"B\u0013\u0003\u0001\u00041\u0013a\u0002:v]R+7\u000f^\u000b\u0002uA\u00111\bP\u0007\u0002Y%\u0011Q\b\f\u0002\u0005+:LG/A\u0001b+\u0005\u0001\u0005cA!G\u00116\t!I\u0003\u0002D\t\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003\u000b2\n!bY8mY\u0016\u001cG/[8o\u0013\t9%I\u0001\u0003MSN$\bCA\u001eJ\u0013\tQEFA\u0002J]R\f!!\u0019\u0011\u0002\u0003\t\f!A\u0019\u0011\u0002%Q,7\u000f^%og\u0016\u0014H/\u00127f[\u0016tGo]\u0001\rg\u0006lW-\u00127f[\u0016tGo]\u000b\u0003#\n$2AU+l!\tY4+\u0003\u0002UY\t9!i\\8mK\u0006t\u0007\"\u0002,\n\u0001\u00049\u0016A\u0001;1!\rAV\f\u0019\b\u00033ns!!\u000b.\n\u00035J!\u0001\u0018\u0017\u0002\u000fA\f7m[1hK&\u0011al\u0018\u0002\t\u0013R,'/\u0019;pe*\u0011A\f\f\t\u0003C\nd\u0001\u0001B\u0003d\u0013\t\u0007AMA\u0001U#\t)\u0007\u000e\u0005\u0002<M&\u0011q\r\f\u0002\b\u001d>$\b.\u001b8h!\tY\u0014.\u0003\u0002kY\t\u0019\u0011I\\=\t\u000b1L\u0001\u0019A,\u0002\u0005Q\f\u0014!C2iK\u000e\\\u0007*Z1q+\ty'\u0010F\u0002;aRDQ!\u001d\u0006A\u0002I\f\u0001\"\u001a7f[\u0016tGo\u001d\t\u00041ND\u0015BA$`\u0011\u0015)(\u00021\u0001w\u0003\u0005A\u0007\u0003\u0002\u001cx\u0011fL!\u0001_\r\u0003\u00171+g\r^5ti\"+\u0017\r\u001d\t\u0003Cj$Qa\u001f\u0006C\u0002q\u0014!\u0001S\"\u0012\u0005\u0015l\b\u0003\u0002\u001c\u007f\u0011fL!a`\r\u0003\u001b!+\u0017\r]\"pY2,7\r^8s\u0003%\u0011X-\\8wK\u0006cG.\u0006\u0004\u0002\u0006\u0005-\u0011q\u0002\u000b\u0007\u0003\u000f\t)\"a\u0006\u0011\rY:\u0018\u0011BA\u0007!\r\t\u00171\u0002\u0003\u0006G.\u0011\r\u0001\u001a\t\u0004C\u0006=AAB>\f\u0005\u0004\t\t\"E\u0002f\u0003'\u0001bA\u000e@\u0002\n\u00055\u0001BB;\f\u0001\u0004\t9\u0001\u0003\u0004r\u0017\u0001\u0007\u0011\u0011\u0004\t\u00051v\u000bI!\u0001\nuKN$\u0018J\\:feRLE/\u001a:bi>\u0014\u0018A\u0004;fgRLen]3si\"+\u0017\r]\u0001\u000ei\u0016\u001cHOU3n_Z,\u0017\t\u001c7\u0002\u001bQ,7\u000f\u001e'be\u001e,\u0007*Z1q\u00051\u0019V\r^\"pY2,7\r^8s'\u0015\u0001\u0012qEA\u0017!\rY\u0014\u0011F\u0005\u0004\u0003Wa#AB!osJ+g\rE\u00037}\"\u000by\u0003E\u0002\u00022Ai\u0011\u0001A\u0001\u0006G>tGo]\u000b\u0003\u0003o\u0001BaJA\u001d\u0011&\u0019\u00111\b\u001a\u0003\u0007M+G/\u0001\u0004d_:$8\u000f\t\u000b\u0005\u0003_\t\t\u0005C\u0004\u00024M\u0001\r!a\u000e\u0002\u000b\u0011\u0002H.^:\u0015\r\u0005=\u0012qIA%\u0011\u0015)C\u00031\u0001I\u0011\u001d\tY\u0005\u0006a\u0001\u0003_\t!\u0001[2\u0002#Q,7\u000f\u001e%fCB\u001cu\u000e\u001c7fGR|'/A\u0006uKN$h\t\\1u\u001b\u0006\u0004\u0018\u0001\u0004;fgR4E.\u0019;NCB\u0014\u0004")
public class TestLeftistHeap
extends APTestCase {
    private final String n;
    private final List<Object> a;
    private final List<Object> b;

    @Override
    public void runTest() {
        String string = this.n;
        switch (string == null ? 0 : string.hashCode()) {
            case -1954935775: {
                if (!"testFlatMap2".equals(string)) break;
                this.testFlatMap2();
                return;
            }
            case -1845202801: {
                if (!"testHeapCollector".equals(string)) break;
                this.testHeapCollector();
                return;
            }
            case -1171441103: {
                if (!"testFlatMap".equals(string)) break;
                this.testFlatMap();
                return;
            }
            case 62310402: {
                if (!"testInsertElements".equals(string)) break;
                this.testInsertElements();
                return;
            }
            case 251794039: {
                if (!"testInsertHeap".equals(string)) break;
                this.testInsertHeap();
                return;
            }
            case 1253183353: {
                if (!"testInsertIterator".equals(string)) break;
                this.testInsertIterator();
                return;
            }
            case 1427556181: {
                if (!"testLargeHeap".equals(string)) break;
                this.testLargeHeap();
                return;
            }
            case 1952049675: {
                if (!"testRemoveAll".equals(string)) break;
                this.testRemoveAll();
                return;
            }
        }
        throw new MatchError((Object)string);
    }

    private List<Object> a() {
        return this.a;
    }

    private List<Object> b() {
        return this.b;
    }

    public void testInsertElements() {
        LeftistHeap<Object, HeapCollector.None<Object>> h = LeftistHeap$.MODULE$.EMPTY_HEAP(Ordering.Int$.MODULE$);
        this.assertTrue("Empty heap should be empty", h.isEmpty() && h.size() == 0);
        h.insert(BoxesRunTime.boxToInteger((int)1));
        this.assertTrue("Empty heap should be empty", h.isEmpty() && h.size() == 0);
        h = h.insert(BoxesRunTime.boxToInteger((int)1));
        this.assertTrue("Heap should contain one element", !h.isEmpty() && h.size() == 1 && BoxesRunTime.unboxToInt((Object)h.findMin()) == 1);
        h = h.deleteMin();
        this.assertTrue("Empty heap should be empty", h.isEmpty() && h.size() == 0);
        h = h.insert(BoxesRunTime.boxToInteger((int)1)).insert(BoxesRunTime.boxToInteger((int)2));
        this.assertTrue("Heap should contain two elements", !h.isEmpty() && h.size() == 2 && BoxesRunTime.unboxToInt((Object)h.findMin()) == 1);
        h = h.deleteMin();
        this.assertTrue("Heap should contain one element", !h.isEmpty() && h.size() == 1 && BoxesRunTime.unboxToInt((Object)h.findMin()) == 2);
        h = h.deleteMin();
        this.assertTrue("Empty heap should be empty", h.isEmpty() && h.size() == 0);
    }

    private <T> boolean sameElements(Iterator<T> t0, Iterator<T> t1) {
        SetOps setOps = Predef$.MODULE$.Set().empty().$plus$plus(t0);
        SetOps setOps2 = Predef$.MODULE$.Set().empty().$plus$plus(t1);
        return !(setOps != null ? !setOps.equals(setOps2) : setOps2 != null);
    }

    private <HC extends HeapCollector<Object, HC>> void checkHeap(List<Object> elements, LeftistHeap<Object, HC> h) {
        this.assertTrue("Heap has incorrect size", h.size() == elements.size() && h.size() == 0 == h.isEmpty());
        this.assertTrue("Unsorted heap iterator does not return the right elements", this.sameElements(h.unsortedIterator(), elements.iterator()));
        int[] sortedEls = (int[])h.sortedIterator().toList().toArray((ClassTag)ClassTag$.MODULE$.Int());
        this.assertTrue("Elements returned by sorted iterator should be sorted", Logic$.MODULE$.forall(0, ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.intArrayOps(sortedEls)) - 1, (Function1<Object, Object>)(JFunction1.mcZI.sp & Serializable)i -> sortedEls[i] <= sortedEls[i + 1]));
        this.assertTrue("Sorted heap iterator does not return the right elements", this.sameElements(h.sortedIterator(), elements.iterator()));
        List list = (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$);
        LeftistHeap<Object, HC> hv = h;
        while (!hv.isEmpty()) {
            int n = BoxesRunTime.unboxToInt((Object)hv.findMin());
            list = list.$colon$colon((Object)BoxesRunTime.boxToInteger((int)n));
            hv = hv.deleteMin();
        }
        int[] sortedEls2 = (int[])list.toArray((ClassTag)ClassTag$.MODULE$.Int());
        this.assertTrue("Elements returned by findMin should be sorted", Logic$.MODULE$.forall(0, ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.intArrayOps(sortedEls2)) - 1, (Function1<Object, Object>)(JFunction1.mcZI.sp & Serializable)i -> sortedEls2[i] >= sortedEls2[i + 1]));
        this.assertTrue("findMin does not return the right elements", this.sameElements(list.iterator(), elements.iterator()));
    }

    private <T, HC extends HeapCollector<T, HC>> LeftistHeap<T, HC> removeAll(LeftistHeap<T, HC> h, Iterator<T> elements) {
        ObjectRef res = ObjectRef.create(h);
        elements.foreach((Function1 & Serializable)el -> {
            res.elem = ((LeftistHeap)res.elem).removeAll(el);
            return BoxedUnit.UNIT;
        });
        return (LeftistHeap)res.elem;
    }

    public void testInsertIterator() {
        LeftistHeap h = LeftistHeap$.MODULE$.EMPTY_HEAP(Ordering.Int$.MODULE$);
        h = h.insertIt(((StrictOptimizedLinearSeqOps)package$.MODULE$.List().apply((Seq)Nil$.MODULE$)).iterator());
        this.checkHeap((List<Object>)((List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$)), h);
        this.assertTrue("Empty heap should be empty", h.isEmpty() && h.size() == 0);
        h = h.insertIt(this.a().iterator());
        this.checkHeap(this.a(), h);
        h = h.insertIt(this.a().iterator());
        List<Object> list = this.a();
        this.checkHeap((List<Object>)this.a().$colon$colon$colon(list), h);
        h = h.insertIt(((StrictOptimizedLinearSeqOps)package$.MODULE$.List().apply((Seq)Nil$.MODULE$)).iterator());
        List<Object> list2 = this.a();
        this.checkHeap((List<Object>)this.a().$colon$colon$colon(list2), h);
        h = h.insertIt(h.unsortedIterator());
        List<Object> list3 = this.a();
        List<Object> list4 = this.a();
        List<Object> list5 = this.a();
        this.checkHeap((List<Object>)this.a().$colon$colon$colon(list5).$colon$colon$colon(list4).$colon$colon$colon(list3), h);
        h = h.insertIt(h.sortedIterator());
        List<Object> list6 = this.a();
        List<Object> list7 = this.a();
        List<Object> list8 = this.a();
        List<Object> list9 = this.a();
        List<Object> list10 = this.a();
        List<Object> list11 = this.a();
        List<Object> list12 = this.a();
        this.checkHeap((List<Object>)this.a().$colon$colon$colon(list12).$colon$colon$colon(list11).$colon$colon$colon(list10).$colon$colon$colon(list9).$colon$colon$colon(list8).$colon$colon$colon(list7).$colon$colon$colon(list6), h);
    }

    public void testInsertHeap() {
        LeftistHeap h = LeftistHeap$.MODULE$.EMPTY_HEAP(Ordering.Int$.MODULE$);
        h = h.insertIt(this.a().iterator());
        this.checkHeap(this.a(), h);
        h = h.insertHeap(LeftistHeap$.MODULE$.EMPTY_HEAP(Ordering.Int$.MODULE$));
        this.checkHeap(this.a(), h);
        h = h.insertHeap(h);
        List<Object> list = this.a();
        this.checkHeap((List<Object>)this.a().$colon$colon$colon(list), h);
        h = h.insertHeap(LeftistHeap$.MODULE$.EMPTY_HEAP(Ordering.Int$.MODULE$).insert(BoxesRunTime.boxToInteger((int)123)));
        List<Object> list2 = this.a();
        this.checkHeap((List<Object>)this.a().$colon$colon$colon(list2).$colon$colon((Object)BoxesRunTime.boxToInteger((int)123)), h);
    }

    public void testRemoveAll() {
        LeftistHeap<Object, HeapCollector.None<Object>> h = LeftistHeap$.MODULE$.EMPTY_HEAP(Ordering.Int$.MODULE$);
        this.checkHeap((List<Object>)((List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$)), this.removeAll(h, this.a().iterator()));
        h = h.insertIt(this.a().iterator());
        this.checkHeap(this.a(), h);
        this.checkHeap((List<Object>)this.a().filterNot((Function1)(JFunction1.mcZI.sp & Serializable)i -> i == BoxesRunTime.unboxToInt((Object)this.a().head())), h.removeAll(this.a().head()));
        this.checkHeap((List<Object>)((List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$)), this.removeAll(h, this.a().iterator()));
        this.assertEquals("Heap should not be different", h, this.removeAll(h, this.b().iterator()));
    }

    public void testLargeHeap() {
        LeftistHeap h = LeftistHeap$.MODULE$.EMPTY_HEAP(Ordering.Int$.MODULE$);
        List l = Debug$.MODULE$.randoms(0, 1000000).take(1000).toList();
        h = h.insertIt(l.iterator());
        this.checkHeap((List<Object>)l, h);
    }

    public void testHeapCollector() {
        LeftistHeap empty = LeftistHeap$.MODULE$.EMPTY_HEAP(new SetCollector(this, (Set<Object>)Predef$.MODULE$.Set().empty()), Ordering.Int$.MODULE$);
        List elements = Debug$.MODULE$.randoms(0, 100).take(100).toList();
        LeftistHeap filled = empty.$plus$plus(elements);
        this.checkHeap((List<Object>)elements, filled);
        Predef$.MODULE$.assert(this.sameElements(filled.collector().conts().iterator(), elements.iterator()));
        LeftistHeap emptied = filled;
        while (!emptied.isEmpty()) {
            emptied = emptied.deleteMin();
            Predef$.MODULE$.assert(this.sameElements(emptied.collector().conts().iterator(), emptied.unsortedIterator()));
        }
    }

    public void testFlatMap() {
        LeftistHeap h2 = LeftistHeap$.MODULE$.EMPTY_HEAP(Ordering.Int$.MODULE$);
        List l = Debug$.MODULE$.randoms(0, 1000000).take(1000).toList();
        h2 = h2.insertIt(l.iterator());
        LeftistHeap h3 = h2.flatItMapIter((Function1 & Serializable)i -> TestLeftistHeap.$anonfun$testFlatMap$1(BoxesRunTime.unboxToInt((Object)i)), (Function1 & Serializable)h -> BoxesRunTime.boxToBoolean((boolean)TestLeftistHeap.$anonfun$testFlatMap$2(h))).flatItMapIter((Function1 & Serializable)i -> TestLeftistHeap.$anonfun$testFlatMap$3(BoxesRunTime.unboxToInt((Object)i)), (Function1 & Serializable)h -> BoxesRunTime.boxToBoolean((boolean)TestLeftistHeap.$anonfun$testFlatMap$4(h)));
        this.checkHeap((List<Object>)l, h3);
    }

    public void testFlatMap2() {
        LeftistHeap h2 = LeftistHeap$.MODULE$.EMPTY_HEAP(Ordering.Int$.MODULE$);
        List l = Debug$.MODULE$.randoms(0, 1000000).take(1000).toList();
        h2 = h2.insertIt(l.iterator());
        LeftistHeap h3 = h2.flatItMapRec((Function1 & Serializable)i -> TestLeftistHeap.$anonfun$testFlatMap2$1(BoxesRunTime.unboxToInt((Object)i)), (Function1 & Serializable)h -> BoxesRunTime.boxToBoolean((boolean)TestLeftistHeap.$anonfun$testFlatMap2$2(h))).flatItMapRec((Function1 & Serializable)i -> TestLeftistHeap.$anonfun$testFlatMap2$3(BoxesRunTime.unboxToInt((Object)i)), (Function1 & Serializable)h -> BoxesRunTime.boxToBoolean((boolean)TestLeftistHeap.$anonfun$testFlatMap2$4(h)));
        this.checkHeap((List<Object>)l, h3);
    }

    public static final /* synthetic */ Iterator $anonfun$testFlatMap$1(int i) {
        return package$.MODULE$.Iterator().single((Object)BoxesRunTime.boxToInteger((int)(i + 1)));
    }

    public static final /* synthetic */ boolean $anonfun$testFlatMap$2(LeftistHeap h) {
        return false;
    }

    public static final /* synthetic */ Iterator $anonfun$testFlatMap$3(int i) {
        return package$.MODULE$.Iterator().single((Object)BoxesRunTime.boxToInteger((int)(i - 1)));
    }

    public static final /* synthetic */ boolean $anonfun$testFlatMap$4(LeftistHeap h) {
        return false;
    }

    public static final /* synthetic */ Iterator $anonfun$testFlatMap2$1(int i) {
        return package$.MODULE$.Iterator().single((Object)BoxesRunTime.boxToInteger((int)(i + 1)));
    }

    public static final /* synthetic */ boolean $anonfun$testFlatMap2$2(LeftistHeap h) {
        return false;
    }

    public static final /* synthetic */ Iterator $anonfun$testFlatMap2$3(int i) {
        return package$.MODULE$.Iterator().single((Object)BoxesRunTime.boxToInteger((int)(i - 1)));
    }

    public static final /* synthetic */ boolean $anonfun$testFlatMap2$4(LeftistHeap h) {
        return false;
    }

    public TestLeftistHeap(String n) {
        this.n = n;
        super(n);
        this.a = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-34, 20, 60, 16, 7, 5, 20, 13}));
        this.b = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{8, 1000, -1000}));
    }

    private class SetCollector
    implements HeapCollector<Object, SetCollector> {
        private final Set<Object> conts;
        public final /* synthetic */ TestLeftistHeap $outer;

        public Set<Object> conts() {
            return this.conts;
        }

        @Override
        public SetCollector $plus(int n, SetCollector hc) {
            return new SetCollector(this.ap$basetypes$TestLeftistHeap$SetCollector$$$outer(), (Set<Object>)((Set)this.conts().$plus((Object)BoxesRunTime.boxToInteger((int)n)).$plus$plus(hc.conts())));
        }

        public /* synthetic */ TestLeftistHeap ap$basetypes$TestLeftistHeap$SetCollector$$$outer() {
            return this.$outer;
        }

        public SetCollector(TestLeftistHeap $outer, Set<Object> conts) {
            this.conts = conts;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

