/*
 * Decompiled with CFR 0.152.
 */
package ap.proof;

import ap.parameters.GoalSettings;
import ap.parameters.GoalSettings$;
import ap.parameters.Param$CONSTRAINT_SIMPLIFIER$;
import ap.parameters.Param$FULL_SPLITTING$;
import ap.proof.ConstraintSimplifier;
import ap.proof.ConstraintSimplifier$;
import ap.proof.Vocabulary$;
import ap.proof.goal.BetaFormulaTask;
import ap.proof.goal.EliminateFactsTask$;
import ap.proof.goal.Goal;
import ap.proof.goal.Goal$;
import ap.proof.goal.OmegaTask$;
import ap.proof.goal.Task;
import ap.proof.goal.WrappedFormulaTask;
import ap.proof.tree.AndTree;
import ap.proof.tree.ProofTree;
import ap.proof.tree.QuantifiedTree$;
import ap.proof.tree.SimpleProofTreeFactory;
import ap.proof.tree.SimpleProofTreeFactory$;
import ap.proof.tree.WeakenTree$;
import ap.terfor.ConstantTerm;
import ap.terfor.Formula;
import ap.terfor.TermOrder;
import ap.terfor.conjunctions.Conjunction;
import ap.terfor.conjunctions.Conjunction$;
import ap.terfor.conjunctions.Quantifier;
import ap.terfor.conjunctions.Quantifier$ALL$;
import ap.terfor.conjunctions.ReduceWithConjunction$;
import ap.util.Debug$;
import ap.util.Debug$AC_PROVER$;
import ap.util.Seqs$;
import ap.util.Timeout$;
import java.io.Serializable;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class QuantifierElimProver$ {
    public static final QuantifierElimProver$ MODULE$ = new QuantifierElimProver$();
    private static final Debug$AC_PROVER$ AC = Debug$AC_PROVER$.MODULE$;
    private static final ConstraintSimplifier simplifier = ConstraintSimplifier$.MODULE$.NO_SIMPLIFIER();
    private static final SimpleProofTreeFactory ptf = new SimpleProofTreeFactory(true, MODULE$.simplifier(), SimpleProofTreeFactory$.MODULE$.$lessinit$greater$default$3());
    private static final GoalSettings basicSettings = Param$CONSTRAINT_SIMPLIFIER$.MODULE$.set(GoalSettings$.MODULE$.DEFAULT(), MODULE$.simplifier());
    private static final GoalSettings completeCNFSettings = Param$FULL_SPLITTING$.MODULE$.set(MODULE$.basicSettings(), BoxesRunTime.boxToBoolean((boolean)true));
    private static final GoalSettings nonCompleteCNFSettings = Param$FULL_SPLITTING$.MODULE$.set(MODULE$.basicSettings(), BoxesRunTime.boxToBoolean((boolean)false));

    private Debug$AC_PROVER$ AC() {
        return AC;
    }

    private ConstraintSimplifier simplifier() {
        return simplifier;
    }

    private SimpleProofTreeFactory ptf() {
        return ptf;
    }

    private GoalSettings basicSettings() {
        return basicSettings;
    }

    private GoalSettings completeCNFSettings() {
        return completeCNFSettings;
    }

    private GoalSettings nonCompleteCNFSettings() {
        return nonCompleteCNFSettings;
    }

    public Conjunction apply(Formula inputFor, boolean completeCNF, TermOrder order) {
        Debug$.MODULE$.assertPre(this.AC(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> Conjunction$.MODULE$.collectQuantifiers(inputFor).subsetOf((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Quantifier[]{Quantifier$ALL$.MODULE$}))) && order.isSortingOf(inputFor));
        GoalSettings settings = completeCNF ? this.completeCNFSettings() : this.nonCompleteCNFSettings();
        Goal goal = Goal$.MODULE$.apply((Seq<Conjunction>)((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Conjunction[]{Conjunction$.MODULE$.conj(inputFor, order)}))), (scala.collection.immutable.Set<ConstantTerm>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)), Vocabulary$.MODULE$.apply(order), settings);
        return this.expandProof(goal, Conjunction$.MODULE$.FALSE(), 0);
    }

    private boolean checkPruning(Goal goal) {
        boolean bl;
        Task task = goal.tasks().max();
        if (task instanceof WrappedFormulaTask) {
            Predef$.MODULE$.assert(false);
            bl = true;
        } else {
            bl = task instanceof BetaFormulaTask ? !((BetaFormulaTask)task).addToQFClauses() : (OmegaTask$.MODULE$.equals(task) ? OmegaTask$.MODULE$.splittingNecessary(goal) : EliminateFactsTask$.MODULE$.equals(task));
        }
        return bl;
    }

    private Conjunction reduceConstraint(Conjunction c, TermOrder order) {
        if (c.isTrue() || c.isFalse()) {
            return c;
        }
        return ReduceWithConjunction$.MODULE$.apply(Conjunction$.MODULE$.TRUE(), order, ReduceWithConjunction$.MODULE$.apply$default$3()).apply(c);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Conjunction expandProof(ProofTree tree, Conjunction pruningFor, int depth) {
        Option<Tuple3<Quantifier, Seq<ConstantTerm>, ProofTree>> option;
        while (true) {
            Timeout$.MODULE$.check();
            if (!tree.stepPossible()) {
                return tree.closingConstraint();
            }
            if (!(tree instanceof Goal)) break;
            Goal goal = (Goal)tree;
            if (this.checkPruning(goal)) {
                Debug$.MODULE$.assertInt(this.AC(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> {
                    Conjunction conjunction = goal.definedSyms().apply(pruningFor);
                    return !(conjunction != null ? !((Object)conjunction).equals(pruningFor) : pruningFor != null);
                });
                Conjunction newPruningFor = goal.definedSyms().apply(goal.reduceWithFacts().tentativeReduce(pruningFor));
                if (newPruningFor.isTrue()) return Conjunction$.MODULE$.TRUE();
                pruningFor = newPruningFor;
                tree = goal.step(this.ptf());
                continue;
            }
            tree = goal.step(this.ptf());
        }
        Option<Tuple2<Conjunction, ProofTree>> option2 = WeakenTree$.MODULE$.unapply(tree);
        if (!option2.isEmpty()) {
            Conjunction disjunct = (Conjunction)((Tuple2)option2.get())._1();
            ProofTree subtree = (ProofTree)((Tuple2)option2.get())._2();
            return this.reduceConstraint(Conjunction$.MODULE$.disj((Iterable<Conjunction>)Predef$.MODULE$.wrapRefArray((Object[])new Conjunction[]{this.expandProof(subtree, pruningFor, depth), disjunct}), tree.order()), tree.order());
        }
        if (tree != null && !(option = QuantifiedTree$.MODULE$.unapply(tree)).isEmpty()) {
            Quantifier quantifier = (Quantifier)((Tuple3)option.get())._1();
            Seq consts = (Seq)((Tuple3)option.get())._2();
            ProofTree subtree = (ProofTree)((Tuple3)option.get())._3();
            if (Quantifier$ALL$.MODULE$.equals(quantifier)) {
                Conjunction res = this.expandProof(subtree, pruningFor, depth);
                Debug$.MODULE$.assertPre(this.AC(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> Seqs$.MODULE$.disjointSeq(res.constants(), consts));
                return res;
            }
        }
        if (!(tree instanceof AndTree)) throw new MatchError((Object)tree);
        AndTree andTree = (AndTree)tree;
        Conjunction leftRes = this.expandProof(andTree.left(), pruningFor, depth + 1);
        Conjunction resAndPruningFor = Conjunction$.MODULE$.disj((Iterable<Conjunction>)Predef$.MODULE$.wrapRefArray((Object[])new Conjunction[]{pruningFor, leftRes.negate()}), andTree.order());
        Conjunction rightRes = this.expandProof(andTree.right(), resAndPruningFor, depth + 1);
        return this.reduceConstraint(Conjunction$.MODULE$.conj((Iterable<Formula>)Predef$.MODULE$.wrapRefArray((Object[])new Conjunction[]{leftRes, rightRes}), andTree.order()), andTree.order());
    }

    private QuantifierElimProver$() {
    }
}

