/*
 * Decompiled with CFR 0.152.
 */
package ap.terfor.arithconj;

import ap.terfor.ComputationLogger;
import ap.terfor.ComputationLogger$;
import ap.terfor.Formula;
import ap.terfor.TermOrder;
import ap.terfor.TermOrder$;
import ap.terfor.arithconj.ArithConj;
import ap.terfor.equations.EquationConj;
import ap.terfor.equations.EquationConj$;
import ap.terfor.equations.NegEquationConj;
import ap.terfor.equations.NegEquationConj$;
import ap.terfor.inequalities.InEqConj;
import ap.terfor.inequalities.InEqConj$;
import ap.util.Debug$;
import ap.util.Debug$AC_PROP_CONNECTIVES$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class ArithConj$ {
    public static final ArithConj$ MODULE$ = new ArithConj$();
    private static final Debug$AC_PROP_CONNECTIVES$ AC = Debug$AC_PROP_CONNECTIVES$.MODULE$;
    private static final ArithConj TRUE = new ArithConj(EquationConj$.MODULE$.TRUE(), NegEquationConj$.MODULE$.TRUE(), InEqConj$.MODULE$.TRUE(), TermOrder$.MODULE$.EMPTY());
    private static final ArithConj FALSE = new ArithConj(EquationConj$.MODULE$.FALSE(), NegEquationConj$.MODULE$.TRUE(), InEqConj$.MODULE$.TRUE(), TermOrder$.MODULE$.EMPTY());

    public Debug$AC_PROP_CONNECTIVES$ AC() {
        return AC;
    }

    public ArithConj apply(EquationConj positiveEqs, NegEquationConj negativeEqs, InEqConj inEqs, TermOrder order) {
        if (positiveEqs.isFalse() || negativeEqs.isFalse() || inEqs.isFalse()) {
            return this.FALSE();
        }
        if (positiveEqs.isTrue() && negativeEqs.isTrue() && inEqs.isTrue()) {
            return this.TRUE();
        }
        return new ArithConj(positiveEqs, negativeEqs, inEqs, order);
    }

    public Option<Tuple3<EquationConj, NegEquationConj, InEqConj>> unapply(ArithConj conj) {
        return new Some((Object)new Tuple3((Object)conj.positiveEqs(), (Object)conj.negativeEqs(), (Object)conj.inEqs()));
    }

    public ArithConj TRUE() {
        return TRUE;
    }

    public ArithConj FALSE() {
        return FALSE;
    }

    public ArithConj conj(Iterator<Formula> conjs, ComputationLogger logger, TermOrder order) {
        ArrayBuffer posEqs = new ArrayBuffer();
        ArrayBuffer negEqs = new ArrayBuffer();
        ArrayBuffer inEqs = new ArrayBuffer();
        conjs.foreach((Function1 & Serializable)conj -> {
            ArrayBuffer arrayBuffer;
            Debug$.MODULE$.assertPre(MODULE$.AC(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> order.isSortingOf(conj));
            if (conj instanceof EquationConj) {
                EquationConj equationConj = (EquationConj)conj;
                arrayBuffer = (ArrayBuffer)posEqs.$plus$eq((Object)equationConj);
            } else if (conj instanceof NegEquationConj) {
                NegEquationConj negEquationConj = (NegEquationConj)conj;
                arrayBuffer = (ArrayBuffer)negEqs.$plus$eq((Object)negEquationConj);
            } else if (conj instanceof InEqConj) {
                InEqConj inEqConj = (InEqConj)conj;
                arrayBuffer = (ArrayBuffer)inEqs.$plus$eq((Object)inEqConj);
            } else if (conj instanceof ArithConj) {
                ArithConj arithConj = (ArithConj)conj;
                posEqs.$plus$eq((Object)arithConj.positiveEqs());
                negEqs.$plus$eq((Object)arithConj.negativeEqs());
                arrayBuffer = (ArrayBuffer)inEqs.$plus$eq((Object)arithConj.inEqs());
            } else {
                throw new MatchError(conj);
            }
            return arrayBuffer;
        });
        return this.apply(EquationConj$.MODULE$.conj((Iterable<EquationConj>)posEqs, logger, order), NegEquationConj$.MODULE$.conj((Iterable<NegEquationConj>)negEqs, order), InEqConj$.MODULE$.conj((Iterator<InEqConj>)inEqs.iterator(), logger, order), order);
    }

    public ArithConj conj(Iterator<Formula> conjs, TermOrder order) {
        return this.conj(conjs, ComputationLogger$.MODULE$.NonLogger(), order);
    }

    public ArithConj conj(Iterable<Formula> conjs, TermOrder order) {
        return this.conj((Iterator<Formula>)conjs.iterator(), order);
    }

    public ArithConj conj(Formula f, TermOrder order) {
        return this.conj((Iterable<Formula>)((Iterable)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Formula[]{f}))), order);
    }

    private ArithConj$() {
    }
}

