/*
 * Decompiled with CFR 0.152.
 */
package ap.util;

public final class RuntimeStatistics$ {
    public static final RuntimeStatistics$ MODULE$ = new RuntimeStatistics$();
    private static final long firstLoadExtraTime = 2000L;
    private static final double initialSlowdown = 5.0;
    private static final long slowdownHalftime = 4000L;
    private static final long calculationSamplingPeriod = 1000L;
    private static int loadCount = 0;
    private static long totalProofTime = 0L;

    public long firstLoadExtraTime() {
        return firstLoadExtraTime;
    }

    public double initialSlowdown() {
        return initialSlowdown;
    }

    public long slowdownHalftime() {
        return slowdownHalftime;
    }

    public long calculationSamplingPeriod() {
        return calculationSamplingPeriod;
    }

    private int loadCount() {
        return loadCount;
    }

    private void loadCount_$eq(int x$1) {
        loadCount = x$1;
    }

    private long totalProofTime() {
        return totalProofTime;
    }

    private void totalProofTime_$eq(long x$1) {
        totalProofTime = x$1;
    }

    private long loadExtraTime() {
        return this.firstLoadExtraTime() / (long)(1 + this.loadCount());
    }

    private double warmupSlowdown(long proofTime) {
        if (this.longRunning()) {
            return 1.0;
        }
        return (this.initialSlowdown() - 1.0) * (double)this.slowdownHalftime() / (double)(this.slowdownHalftime() + proofTime) + 1.0;
    }

    private boolean longRunning() {
        return (double)this.totalProofTime() > (double)this.slowdownHalftime() * 30.0;
    }

    public synchronized long recommendInitialProofRuntime(long regularInitial) {
        long leftTodo = regularInitial;
        long allocated = 0L;
        while (leftTodo > 0L) {
            double slowdown = this.warmupSlowdown(this.totalProofTime() + allocated);
            long effectivePeriod = (long)((double)this.calculationSamplingPeriod() / slowdown);
            if (effectivePeriod <= leftTodo) {
                allocated += this.calculationSamplingPeriod();
                leftTodo -= effectivePeriod;
                continue;
            }
            allocated += (long)((double)leftTodo * slowdown);
            leftTodo = 0L;
        }
        return allocated + this.loadExtraTime();
    }

    public synchronized long recordInitialProofRuntime(long runtime) {
        long l;
        if (this.longRunning()) {
            this.totalProofTime_$eq(this.totalProofTime() + runtime);
            this.loadCount_$eq(this.loadCount() + 1);
            return 0L;
        }
        long loadExtra = this.loadExtraTime();
        if (loadExtra <= runtime) {
            long b = this.recordProofRuntime(runtime - loadExtra);
            this.totalProofTime_$eq(this.totalProofTime() + loadExtra);
            l = b + loadExtra;
        } else {
            l = this.recordProofRuntime(runtime);
        }
        long bonus = l;
        this.loadCount_$eq(this.loadCount() + 1);
        return bonus;
    }

    public synchronized long recordProofRuntime(long runtime) {
        if (this.longRunning()) {
            this.totalProofTime_$eq(this.totalProofTime() + runtime);
            return 0L;
        }
        long leftTime = runtime;
        long effectiveTime = 0L;
        while (leftTime > 0L) {
            double slowdown = this.warmupSlowdown(this.totalProofTime());
            if (this.calculationSamplingPeriod() <= leftTime) {
                leftTime -= this.calculationSamplingPeriod();
                this.totalProofTime_$eq(this.totalProofTime() + this.calculationSamplingPeriod());
                effectiveTime += (long)((double)this.calculationSamplingPeriod() / slowdown);
                continue;
            }
            this.totalProofTime_$eq(this.totalProofTime() + leftTime);
            effectiveTime += (long)((double)leftTime / slowdown);
            leftTime = 0L;
        }
        return runtime - effectiveTime;
    }

    private RuntimeStatistics$() {
    }
}

