/*
 * Decompiled with CFR 0.152.
 */
package jpl;

import java.util.Hashtable;
import java.util.Map;
import jpl.Atom;
import jpl.Compound;
import jpl.Float;
import jpl.Integer;
import jpl.JPLException;
import jpl.Variable;
import jpl.fli.DoubleHolder;
import jpl.fli.Int64Holder;
import jpl.fli.IntHolder;
import jpl.fli.Prolog;
import jpl.fli.StringHolder;
import jpl.fli.term_t;

public abstract class Term {
    protected Term() {
    }

    public abstract Term arg(int var1);

    public abstract Term[] args();

    public abstract boolean hasFunctor(String var1, int var2);

    public abstract boolean hasFunctor(int var1, int var2);

    public abstract boolean hasFunctor(double var1, int var3);

    public String name() {
        throw new JPLException("jpl." + this.typeName() + ".name() is undefined");
    }

    public int arity() {
        throw new JPLException("jpl." + this.typeName() + ".arity() is undefined");
    }

    public int intValue() {
        throw new JPLException("jpl." + this.typeName() + ".intValue() is undefined");
    }

    public long longValue() {
        throw new JPLException("jpl." + this.typeName() + ".longValue() is undefined");
    }

    public float floatValue() {
        throw new JPLException("jpl." + this.typeName() + ".floatValue() is undefined");
    }

    public double doubleValue() {
        throw new JPLException("jpl." + this.typeName() + ".doubleValue() is undefined");
    }

    public abstract int type();

    public abstract String typeName();

    public boolean isAtom() {
        return this instanceof Atom;
    }

    public boolean isCompound() {
        return this instanceof Compound;
    }

    public boolean isFloat() {
        return this instanceof Float;
    }

    public boolean isInteger() {
        return this instanceof Integer;
    }

    public boolean isVariable() {
        return this instanceof Variable;
    }

    public boolean isJFalse() {
        return false;
    }

    public boolean isJTrue() {
        return false;
    }

    public boolean isJNull() {
        return false;
    }

    public boolean isJVoid() {
        return false;
    }

    public boolean isJObject() {
        return false;
    }

    public boolean isJRef() {
        return false;
    }

    public abstract Object jrefToObject();

    public static Term objectToJRef(Object object) {
        return new Compound("@", new Term[]{new Atom(Prolog.object_to_tag(object))});
    }

    public Term putParams(Term[] termArray) {
        IntHolder intHolder = new IntHolder();
        intHolder.value = 0;
        Term term = this.putParams1(intHolder, termArray);
        if (intHolder.value != termArray.length) {
            throw new JPLException("Term.putParams: more actual params than formal");
        }
        return term;
    }

    public Term putParams(Term term) {
        Term[] termArray = term.toTermArray();
        return this.putParams(termArray);
    }

    protected Term putParams1(IntHolder intHolder, Term[] termArray) {
        switch (this.type()) {
            case 6: {
                return new Compound(this.name(), Term.putParams2(this.args(), intHolder, termArray));
            }
            case 2: {
                if (!this.name().equals("?")) break;
                if (intHolder.value >= termArray.length) {
                    throw new JPLException("Term.putParams: fewer actual params than formal params");
                }
                return termArray[intHolder.value++];
            }
        }
        return this;
    }

    protected static Term[] putParams2(Term[] termArray, IntHolder intHolder, Term[] termArray2) {
        int n = termArray.length;
        Term[] termArray3 = new Term[n];
        for (int i = 0; i < n; ++i) {
            termArray3[i] = termArray[i].putParams1(intHolder, termArray2);
        }
        return termArray3;
    }

    public int listLength() {
        if (this.hasFunctor(".", 2)) {
            return 1 + this.arg(2).listLength();
        }
        if (this.hasFunctor("[]", 0)) {
            return 0;
        }
        throw new JPLException("Term.listLength: term is not a list");
    }

    public Term[] toTermArray() {
        try {
            int n = this.listLength();
            Term[] termArray = new Term[n];
            Term term = this;
            for (int i = 0; i < n; ++i) {
                termArray[i] = term.arg(1);
                term = term.arg(2);
            }
            return termArray;
        }
        catch (JPLException jPLException) {
            throw new JPLException("Term.toTermArray: term is not a proper list");
        }
    }

    public abstract String debugString();

    public static String debugString(Term[] termArray) {
        String string = "[";
        for (int i = 0; i < termArray.length; ++i) {
            string = string + termArray[i].debugString();
            if (i == termArray.length - 1) continue;
            string = string + ", ";
        }
        return string + "]";
    }

    public void put(term_t term_t2) {
        this.put(new Hashtable(), term_t2);
    }

    protected abstract void put(Map var1, term_t var2);

    protected static term_t putTerms(Map map, Term[] termArray) {
        term_t term_t2 = Prolog.new_term_refs(termArray.length);
        long l = term_t2.value;
        for (int i = 0; i < termArray.length; ++i) {
            term_t term_t3 = new term_t();
            term_t3.value = l++;
            termArray[i].put(map, term_t3);
        }
        return term_t2;
    }

    public static void putTerm(Object object, term_t term_t2) {
        if (!(object instanceof Term)) {
            throw new JPLException("not a Term");
        }
        ((Term)object).put(term_t2);
    }

    protected static Term getTerm1(Map map, term_t term_t2) {
        int n = Prolog.term_type(term_t2);
        switch (n) {
            case 1: {
                return Variable.getTerm(map, term_t2);
            }
            case 2: {
                return Atom.getTerm(map, term_t2);
            }
            case 5: {
                return Atom.getString(map, term_t2);
            }
            case 3: {
                return Integer.getTerm(map, term_t2);
            }
            case 4: {
                return Float.getTerm(map, term_t2);
            }
            case 6: {
                return Compound.getTerm(map, term_t2);
            }
        }
        throw new JPLException("Term.from_term_t: unknown term type=" + n);
    }

    protected static Term getTerm(Map map, term_t term_t2) {
        switch (Prolog.term_type(term_t2)) {
            case 1: {
                Object object = map.keySet().iterator();
                while (object.hasNext()) {
                    term_t term_t3 = (term_t)object.next();
                    if (Prolog.compare(term_t3, term_t2) != 0) continue;
                    return (Term)map.get(term_t3);
                }
                object = new Variable();
                ((Variable)object).term_ = term_t2;
                map.put(term_t2, object);
                return object;
            }
            case 2: {
                StringHolder stringHolder = new StringHolder();
                Prolog.get_atom_chars(term_t2, stringHolder);
                return new Atom(stringHolder.value);
            }
            case 5: {
                StringHolder stringHolder = new StringHolder();
                Prolog.get_string_chars(term_t2, stringHolder);
                return new Atom(stringHolder.value);
            }
            case 3: {
                Int64Holder int64Holder = new Int64Holder();
                Prolog.get_integer(term_t2, int64Holder);
                return new Integer(int64Holder.value);
            }
            case 4: {
                DoubleHolder doubleHolder = new DoubleHolder();
                Prolog.get_float(term_t2, doubleHolder);
                return new Float(doubleHolder.value);
            }
            case 6: {
                StringHolder stringHolder = new StringHolder();
                IntHolder intHolder = new IntHolder();
                Prolog.get_name_arity(term_t2, stringHolder, intHolder);
                Term[] termArray = new Term[intHolder.value];
                for (int i = 1; i <= intHolder.value; ++i) {
                    term_t term_t4 = Prolog.new_term_ref();
                    Prolog.get_arg(i, term_t2, term_t4);
                    termArray[i - 1] = Term.getTerm(map, term_t4);
                }
                return new Compound(stringHolder.value, termArray);
            }
        }
        throw new JPLException("Term.from_term_t: unknown term type=" + Prolog.term_type(term_t2));
    }

    protected static Term getTerm(term_t term_t2) {
        return Term.getTerm(new Hashtable(), term_t2);
    }

    protected abstract void getSubst(Map var1, Map var2);

    protected static void getSubsts(Map map, Map map2, Term[] termArray) {
        for (int i = 0; i < termArray.length; ++i) {
            termArray[i].getSubst(map, map2);
        }
    }

    protected static boolean terms_equals(Term[] termArray, Term[] termArray2) {
        if (termArray.length != termArray2.length) {
            return false;
        }
        for (int i = 0; i < termArray.length; ++i) {
            if (termArray[i].equals(termArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static String toString(Term[] termArray) {
        String string = "";
        for (int i = 0; i < termArray.length; ++i) {
            string = string + termArray[i].toString();
            if (i == termArray.length - 1) continue;
            string = string + ", ";
        }
        return string;
    }
}

