/*
 * Decompiled with CFR 0.152.
 */
package com.github.jhoenicke.javacup.runtime;

import com.github.jhoenicke.javacup.runtime.Symbol;
import com.github.jhoenicke.javacup.runtime.SymbolFactory;

public class SimpleSymbolFactory
implements SymbolFactory {
    public Symbol newSymbol(String string, int n, int n2, int n3, int n4, int n5, Object object) {
        return new LineColumnSymbol(string, n, n2, n3, n4, n5, object);
    }

    public Symbol newSymbol(String string, int n, int n2, int n3, int n4, int n5) {
        return new LineColumnSymbol(string, n, n2, n3, n4, n5, null);
    }

    @Override
    public Symbol newSymbol(String string, int n, Symbol symbol, Symbol symbol2, Object object) {
        return new LineColumnSymbol(string, n, symbol, symbol2, object);
    }

    @Override
    public Symbol newSymbol(String string, int n, Symbol symbol, Symbol symbol2) {
        return new LineColumnSymbol(string, n, symbol, symbol2, null);
    }

    @Override
    public Symbol newSymbol(String string, int n) {
        return new LineColumnSymbol(string, n, -1, -1, -1, -1, null);
    }

    @Override
    public Symbol newSymbol(String string, int n, Object object) {
        return new LineColumnSymbol(string, n, -1, -1, -1, -1, object);
    }

    @Override
    public Symbol startSymbol(String string, int n, int n2) {
        return new LineColumnSymbol(string, n, n2);
    }

    public static final class LineColumnSymbol
    extends Symbol {
        private final String mName;
        private final int mLcolumn;
        private final int mRcolumn;

        public LineColumnSymbol(String string, int n, int n2) {
            super(n);
            this.parse_state = n2;
            this.mName = string;
            this.mLcolumn = -1;
            this.mRcolumn = -1;
        }

        public LineColumnSymbol(String string, int n, int n2, int n3, int n4, int n5, Object object) {
            super(n, n2, n4, object);
            this.mName = string;
            this.mLcolumn = n3;
            this.mRcolumn = n5;
        }

        public LineColumnSymbol(String string, int n, Symbol symbol, Symbol symbol2, Object object) {
            super(n, symbol, symbol2, object);
            this.mName = string;
            this.mLcolumn = symbol instanceof LineColumnSymbol ? ((LineColumnSymbol)symbol).mLcolumn : 0;
            this.mRcolumn = symbol2 instanceof LineColumnSymbol ? ((LineColumnSymbol)symbol).mRcolumn : 0;
        }

        public String getLocation() {
            if (this.mLcolumn >= 0) {
                return this.left + ":" + this.mLcolumn;
            }
            return Integer.toString(this.left);
        }

        public String getName() {
            return this.mName;
        }

        @Override
        public String toString() {
            return "(" + this.mName + " " + this.left + ":" + this.mLcolumn + "-" + this.right + ":" + this.mRcolumn + ")";
        }
    }
}

